/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hbase;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HBaseUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "HBASEUI";
    public static final String SERVICE_TYPE = "HBASE";
    public static final String ROLE_TYPE = "MASTER";
    static final String SSL_ENABLED = "hbase_hadoop_ssl_enabled";
    static final String MASTER_INFO_PORT = "hbase_master_info_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, MASTER_INFO_PORT);
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addServiceProperty(SSL_ENABLED, this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), MASTER_INFO_PORT, this.getRoleConfigValue(roleConfig, MASTER_INFO_PORT));
        return model;
    }
}

