/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used to install CDP a Private Cloud Control Plane")
public class ApiInstallControlPlaneArgs {
    @SerializedName(value="kubernetesType")
    private String kubernetesType = null;
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;
    @SerializedName(value="valuesYaml")
    private String valuesYaml = null;
    @SerializedName(value="kubeConfig")
    private String kubeConfig = null;
    @SerializedName(value="namespace")
    private String namespace = null;
    @SerializedName(value="dockerRegistry")
    private String dockerRegistry = null;
    @SerializedName(value="isOverrideAllowed")
    private Boolean isOverrideAllowed = null;

    public ApiInstallControlPlaneArgs kubernetesType(String kubernetesType) {
        this.kubernetesType = kubernetesType;
        return this;
    }

    @ApiModelProperty(value="The kubernetes type (e.g. \"openshift\") that the control plane will run on")
    public String getKubernetesType() {
        return this.kubernetesType;
    }

    public void setKubernetesType(String kubernetesType) {
        this.kubernetesType = kubernetesType;
    }

    public ApiInstallControlPlaneArgs remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the remote repository where the private cloud artifacts to install are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public ApiInstallControlPlaneArgs valuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
        return this;
    }

    @ApiModelProperty(value="A yaml file containing configuration parameters for the installation. To see sample values.yaml files, read the documentation <a target=\"_blank\"  href=https://docs.cloudera.com/r/cdp-pvc-install-values-yaml>here</a>.")
    public String getValuesYaml() {
        return this.valuesYaml;
    }

    public void setValuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
    }

    public ApiInstallControlPlaneArgs kubeConfig(String kubeConfig) {
        this.kubeConfig = kubeConfig;
        return this;
    }

    @ApiModelProperty(value="The content of the kubeconfig file of the kubernetes environment on which the install will be performed Simplified example:<br> <br> apiVersion: v1<br> clusters:<br> - cluster:<br> &emsp;&emsp;certificate-authority-data: abc123<br> &emsp;&emsp;server: https://example-server.domain.com:6443<br> &emsp;name: example-cluster.domain.com:6443<br> contexts:<br> - context:<br> &emsp;&emsp;cluster: ocp-cluster1<br> &emsp;&emsp;user: admin<br> &emsp;name: admin<br> current-context: admin<br> kind: Config<br> preferences: {}<br> users:<br> - name: admin<br> &emsp;user:<br> &emsp;&emsp;client-certificate-data: abc123<br> &emsp;&emsp;client-key-data: xyz987<br> <br> For more information on the kubeconfig file, read the documentation <a target=\"_blank\" href=https://docs.cloudera.com/r/cdp-pvc-kubernetes>here</a>.")
    public String getKubeConfig() {
        return this.kubeConfig;
    }

    public void setKubeConfig(String kubeConfig) {
        this.kubeConfig = kubeConfig;
    }

    public ApiInstallControlPlaneArgs namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="A unique namespace where the control plane will be installed")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ApiInstallControlPlaneArgs dockerRegistry(String dockerRegistry) {
        this.dockerRegistry = dockerRegistry;
        return this;
    }

    @ApiModelProperty(value="The url of the Docker Registry where images required for install are hosted. This fields is deprecated. The docker registry should be provided within the values.yaml configuration file.")
    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public void setDockerRegistry(String dockerRegistry) {
        this.dockerRegistry = dockerRegistry;
    }

    public ApiInstallControlPlaneArgs isOverrideAllowed(Boolean isOverrideAllowed) {
        this.isOverrideAllowed = isOverrideAllowed;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsOverrideAllowed() {
        return this.isOverrideAllowed;
    }

    public void setIsOverrideAllowed(Boolean isOverrideAllowed) {
        this.isOverrideAllowed = isOverrideAllowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiInstallControlPlaneArgs apiInstallControlPlaneArgs = (ApiInstallControlPlaneArgs)o;
        return Objects.equals(this.kubernetesType, apiInstallControlPlaneArgs.kubernetesType) && Objects.equals(this.remoteRepoUrl, apiInstallControlPlaneArgs.remoteRepoUrl) && Objects.equals(this.valuesYaml, apiInstallControlPlaneArgs.valuesYaml) && Objects.equals(this.kubeConfig, apiInstallControlPlaneArgs.kubeConfig) && Objects.equals(this.namespace, apiInstallControlPlaneArgs.namespace) && Objects.equals(this.dockerRegistry, apiInstallControlPlaneArgs.dockerRegistry) && Objects.equals(this.isOverrideAllowed, apiInstallControlPlaneArgs.isOverrideAllowed);
    }

    public int hashCode() {
        return Objects.hash(this.kubernetesType, this.remoteRepoUrl, this.valuesYaml, this.kubeConfig, this.namespace, this.dockerRegistry, this.isOverrideAllowed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiInstallControlPlaneArgs {\n");
        sb.append("    kubernetesType: ").append(this.toIndentedString(this.kubernetesType)).append("\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("    valuesYaml: ").append(this.toIndentedString(this.valuesYaml)).append("\n");
        sb.append("    kubeConfig: ").append(this.toIndentedString(this.kubeConfig)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    dockerRegistry: ").append(this.toIndentedString(this.dockerRegistry)).append("\n");
        sb.append("    isOverrideAllowed: ").append(this.toIndentedString(this.isOverrideAllowed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

