/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BufferHandler {
    private FileChannel channel;
    private ByteBuffer buffer;

    public BufferHandler(byte[] buffer) {
        this.buffer = ByteBuffer.allocate(buffer.length);
        this.buffer.put(buffer);
        this.buffer.flip();
    }

    public BufferHandler(FileChannel channel, ByteBuffer buffer) {
        this.channel = channel;
        this.buffer = buffer;
        try {
            channel.read(buffer);
            buffer.flip();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getBuffer() {
        byte[] bytes = new byte[this.buffer.capacity()];
        this.buffer.get(bytes);
        return bytes;
    }

    public byte[] read(int len) throws IOException {
        int nbRemainingRead;
        byte[] result = new byte[len];
        if (len <= this.buffer.remaining()) {
            this.buffer.get(result);
            return result;
        }
        int position = 0;
        for (int requested = len; requested != 0; requested -= nbRemainingRead) {
            nbRemainingRead = this.buffer.limit() - this.buffer.position();
            if (nbRemainingRead > requested) {
                this.buffer.get(result, position, requested);
                break;
            }
            System.arraycopy(this.buffer.array(), this.buffer.position(), result, position, nbRemainingRead);
            position += nbRemainingRead;
            this.buffer.clear();
            if (this.channel != null) {
                int nbReads = this.channel.read(this.buffer);
                this.buffer.flip();
                if (nbReads > 0) continue;
                throw new EOFException();
            }
            throw new IOException("Not enough bytes in the buffer");
        }
        return result;
    }
}

