/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableCall;

class KnoxShellTableCallHistory {
    private static final KnoxShellTableCallHistory INSTANCE = new KnoxShellTableCallHistory();
    private final Map<Long, List<KnoxShellTableCall>> callHistory = new ConcurrentHashMap<Long, List<KnoxShellTableCall>>();

    private KnoxShellTableCallHistory() {
    }

    static KnoxShellTableCallHistory getInstance() {
        return INSTANCE;
    }

    void saveCall(long id, KnoxShellTableCall call) {
        this.saveCalls(id, Collections.singletonList(call));
    }

    void saveCalls(long id, List<KnoxShellTableCall> calls) {
        if (!this.callHistory.containsKey(id)) {
            this.callHistory.put(id, new LinkedList());
        }
        this.callHistory.get(id).addAll(calls);
    }

    void removeCallsById(long id) {
        this.callHistory.remove(id);
    }

    public List<KnoxShellTableCall> getCallHistory(long id) {
        return this.callHistory.containsKey(id) ? Collections.unmodifiableList(this.callHistory.get(id)) : Collections.emptyList();
    }

    KnoxShellTable rollback(long id) {
        AtomicInteger counter = new AtomicInteger(1);
        ArrayList validSteps = new ArrayList();
        this.getCallHistory(id).forEach(call -> {
            int step = counter.getAndIncrement();
            if (call.isBuilderMethod()) {
                validSteps.add(step);
            }
        });
        if (validSteps.size() <= 1) {
            throw new IllegalArgumentException("There is no valid step to be rollback to");
        }
        return this.replay(id, (Integer)validSteps.get(validSteps.size() - 2));
    }

    KnoxShellTable replay(long id, int step) {
        List<KnoxShellTableCall> callHistory = this.getCallHistory(id);
        this.validateReplayStep(step, callHistory);
        Object callResult = KnoxShellTable.builder();
        for (int counter = 0; counter < step; ++counter) {
            callResult = this.invokeCall(callResult, callHistory.get(counter));
        }
        return (KnoxShellTable)callResult;
    }

    private void validateReplayStep(int step, List<KnoxShellTableCall> callHistory) {
        AtomicInteger counter = new AtomicInteger(1);
        callHistory.forEach(call -> {
            if (counter.getAndIncrement() == step && !call.isBuilderMethod()) {
                throw new IllegalArgumentException(String.format(Locale.getDefault(), "It is not allowed to replay up to step %d as this step does not produce an intance of KnoxShellTable", step));
            }
        });
    }

    private Object invokeCall(Object callResult, KnoxShellTableCall call) {
        try {
            Class<?> invokerClass = Class.forName(call.getInvokerClass());
            Class<?>[] parameterTypes = call.getParameterTypes();
            Method method = invokerClass.getMethod(call.getMethod(), parameterTypes);
            Object[] params = new Object[call.getParams().size()];
            AtomicInteger index = new AtomicInteger(0);
            for (Map.Entry<Object, Class<?>> param : call.getParams().entrySet()) {
                params[index.getAndIncrement()] = param.getValue().cast(param.getKey());
            }
            return method.invoke(callResult, params);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while processing " + call, e);
        }
    }
}

