/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.client.ApiException;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.topology.discovery.cm")
public interface ClouderaManagerServiceDiscoveryMessages {
    @Message(level=MessageLevel.INFO, text="Discovering cluster: {0} ({1})")
    public void discoveringCluster(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Discovered cluster: {0} ({1})")
    public void discoveredCluster(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Performing cluster discovery for \"{0}\"")
    public void discoveringCluster(String var1);

    @Message(level=MessageLevel.INFO, text="Discovering service: {0} ({1}) ...")
    public void discoveringService(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Discovered service: {0} ({1})")
    public void discoveredService(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Skipping service discovery: {0} ({1})")
    public void skipServiceDiscovery(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Discovering service role: {0} ({1}) ...")
    public void discoveringServiceRole(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Discovered service role: {0} ({1})")
    public void discoveredServiceRole(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Service role {0} has configuration issues: {1}")
    public void serviceRoleHasConfigurationIssues(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Attempting to authenticate Knox using {0} ...")
    public void attemptingKerberosLogin(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed Kerberos login {0} ({1}): {2}")
    public void failedKerberosLogin(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Using JAAS configuration file implementation: {0}")
    public void usingJAASConfigurationFileImplementation(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to load JAAS configuration file implementation {0}: {1}")
    public void failedToLoadJAASConfigurationFileImplementation(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to instantiate JAAS configuration file implementation {0}: {1}")
    public void failedToInstantiateJAASConfigurationFileImplementation(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="No JAAS configuration file implementation found.")
    public void noJAASConfigurationFileImplementation();

    @Message(level=MessageLevel.ERROR, text="Encountered an error during cluster ({0}) discovery: {1}")
    public void clusterDiscoveryError(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Sleeping {0} second(s) before retrying Cloudera Manager service discovery for the {1}. time")
    public void retryDiscovery(long var1, int var3);

    @Message(level=MessageLevel.ERROR, text="Failed to access the service configurations for cluster ({0}) discovery: {1}")
    public void failedToAccessServiceConfigs(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to access the service role configurations ({0} / {1}) for cluster ({2}) discovery: {3}")
    public void failedToAccessServiceRoleConfigs(String var1, String var2, String var3, @StackTrace(level=MessageLevel.DEBUG) Exception var4);

    @Message(level=MessageLevel.ERROR, text="No address for Cloudera Manager service discovery has been configured.")
    public void missingDiscoveryAddress();

    @Message(level=MessageLevel.ERROR, text="No cluster for Cloudera Manager service discovery has been configured.")
    public void missingDiscoveryCluster();

    @Message(level=MessageLevel.ERROR, text="Encountered an error attempting to determine the user for alias {0} : {1}")
    public void aliasServiceUserError(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Encountered an error attempting to determine the password for alias {0} : {1}")
    public void aliasServicePasswordError(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="No user configured for Cloudera Manager service discovery.")
    public void aliasServiceUserNotFound();

    @Message(level=MessageLevel.ERROR, text="No password configured for Cloudera Manager service discovery.")
    public void aliasServicePasswordNotFound();

    @Message(level=MessageLevel.INFO, text="The value of the qualifying parameter {1} for service {0} does not match: Expected={2}, Actual={3}")
    public void qualifyingServiceParamMismatch(String var1, String var2, String var3, String var4);

    @Message(level=MessageLevel.ERROR, text="Unable to access the ClouderaManager Configuration Change Monitor: {0}")
    public void errorAccessingConfigurationChangeMonitor(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Starting ClouderaManager cluster configuration monitor")
    public void startingClouderaManagerConfigMonitor();

    @Message(level=MessageLevel.INFO, text="Started ClouderaManager cluster configuration monitor (checking every {0} seconds)")
    public void startedClouderaManagerConfigMonitor(long var1);

    @Message(level=MessageLevel.INFO, text="Stopping ClouderaManager cluster configuration monitor")
    public void stoppingClouderaManagerConfigMonitor();

    @Message(level=MessageLevel.INFO, text="Stopped ClouderaManager cluster configuration monitor")
    public void stoppedClouderaManagerConfigMonitor();

    @Message(level=MessageLevel.INFO, text="Terminating monitoring of {1} @ {0} for configuration changes because there are no referencing descriptors.")
    public void stoppingConfigMonitoring(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Missing property in previously saved service discovery configuration {0}")
    public void missingServiceDiscoveryConfigProperty(String var1);

    @Message(level=MessageLevel.DEBUG, text="There is no cluster configuration for {0} @ {1} to check yet.")
    public void noClusterConfiguration(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Checking {0} @ {1} for configuration changes...")
    public void checkingClusterConfiguration(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Error while monitoring ClouderaManager configuration changes: {0}")
    public void clouderaManagerConfigurationChangesMonitoringError(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Error getting service configuration details from ClouderaManager: {0}")
    public void clouderaManagerConfigurationAPIError(@StackTrace(level=MessageLevel.DEBUG) ApiException var1);

    @Message(level=MessageLevel.ERROR, text="Error querying restart events from ClouderaManager: {0}")
    public void clouderaManagerEventsAPIError(@StackTrace(level=MessageLevel.DEBUG) ApiException var1);

    @Message(level=MessageLevel.ERROR, text="Failed to persist data for cluster configuration monitor {0} {1}: {2}")
    public void failedToPersistClusterMonitorData(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted service discovery configuration for cluster monitor {0} : {1}")
    public void failedToLoadClusterMonitorServiceDiscoveryConfig(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted service configuration data for cluster monitor {0} : {1}")
    public void failedToLoadClusterMonitorServiceConfigurations(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove persisted data for cluster configuration monitor {0} {1}")
    public void failedToRemovPersistedClusterMonitorData(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Getting current configuration for {0} from {1} @ {2}")
    public void gettingCurrentClusterConfiguration(String var1, String var2, String var3);

    @Message(level=MessageLevel.DEBUG, text="Querying configuration activation events from {0} @ {1} since {2}")
    public void queryingConfigActivationEventsFromCluster(String var1, String var2, String var3);

    @Message(level=MessageLevel.DEBUG, text="There is no any activation event found within the given time period")
    public void noActivationEventFound();

    @Message(level=MessageLevel.DEBUG, text="Activation event relevance: {0} = {1}")
    public void activationEventRelevance(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Activation event - {0} - has already been processed, skipping ...")
    public void activationEventAlreadyProcessed(String var1);

    @Message(level=MessageLevel.DEBUG, text="Analyzing current {0} configuration for changes...")
    public void analyzingCurrentServiceConfiguration(String var1);

    @Message(level=MessageLevel.ERROR, text="Error analyzing current {0} configuration for changes: {1}")
    public void errorAnalyzingCurrentServiceConfiguration(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Service property {0} value has changed from {1} to {2}")
    public void serviceConfigurationPropertyHasChanged(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="Role property {0} value has changed from {1} to {2}")
    public void roleConfigurationPropertyHasChanged(String var1, String var2, String var3);

    @Message(level=MessageLevel.INFO, text="The {0} service configuration has changed, such that it has been enabled for proxying.")
    public void serviceEnabled(String var1);

    @Message(level=MessageLevel.INFO, text="Role type {0} has been removed.")
    public void roleTypeRemoved(String var1);

    @Message(level=MessageLevel.WARN, text="Failed to create persistence directory {0}")
    public void failedToCreatePersistenceDirectory(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to configure truststore")
    public void failedToConfigureTruststore();

    @Message(level=MessageLevel.DEBUG, text="Looking up cluster services from service discovery repository...")
    public void lookupClusterServicesFromRepository();

    @Message(level=MessageLevel.DEBUG, text="Looking up service configuration from service discovery repository...")
    public void lookupServiceConfigsFromRepository();

    @Message(level=MessageLevel.DEBUG, text="Looking up roles from service discovery repository...")
    public void lookupRolesFromRepository();

    @Message(level=MessageLevel.DEBUG, text="Looking up role configuration from service discovery repository...")
    public void lookupRoleConfigsFromRepository();

    @Message(level=MessageLevel.DEBUG, text="Looking up cluster services from the configured Cloudera Manager discovery endpoint...")
    public void lookupClusterServicesFromCM();

    @Message(level=MessageLevel.DEBUG, text="Looking up service configuration from the configured Cloudera Manager discovery endpoint...")
    public void lookupServiceConfigsFromCM();

    @Message(level=MessageLevel.DEBUG, text="Looking up roles from the configured Cloudera Manager discovery endpoint...")
    public void lookupRolesFromCM();

    @Message(level=MessageLevel.DEBUG, text="Looking up role configuration from the configured Cloudera Manager discovery endpoint...")
    public void lookupRoleConfigsFromCM();

    @Message(level=MessageLevel.DEBUG, text="Clearing service discovery repository...")
    public void clearServiceDiscoveryRepository();

    @Message(level=MessageLevel.WARN, text="The configured maximum retry attempts of {0} may overlap with the configured polling interval settings; using {1} retry attempts")
    public void updateMaxRetryAttempts(int var1, int var2);
}

