/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.MessageLogger;
import org.apache.knox.gateway.i18n.messages.MessageLoggerFactory;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;
import org.apache.knox.gateway.i18n.resources.ResourcesInvoker;

public class MessagesInvoker
extends ResourcesInvoker
implements InvocationHandler {
    private String codes;
    private MessageLogger logger;
    private String bundle;

    public MessagesInvoker(Class<?> clazz, MessageLoggerFactory loggers) {
        super(clazz);
        Messages anno = clazz.getAnnotation(Messages.class);
        this.codes = MessagesInvoker.calcCodePattern(clazz, anno);
        this.bundle = MessagesInvoker.calcBundleName(clazz, anno);
        this.logger = MessagesInvoker.getLogger(clazz, anno, loggers);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String message = null;
        MessageLevel level = MessagesInvoker.getLevel(method);
        if (this.logger.isLoggable(level)) {
            message = this.getText(method, args);
            String code = this.getCode(method);
            Throwable throwable = MessagesInvoker.findLoggableThrowable(this.logger, method, args);
            StackTraceElement caller = new Throwable().getStackTrace()[2];
            this.logger.log(caller, level, code, message, throwable);
        }
        return message;
    }

    private String getCode(Method method) {
        int num;
        String code = null;
        Message anno = method.getAnnotation(Message.class);
        if (anno != null && -1 != (num = anno.code())) {
            MessageFormat messageFormat = new MessageFormat(this.codes, Locale.ROOT);
            code = messageFormat.format(new Object[]{num});
        }
        return code;
    }

    private static StackTrace getStackTraceAnno(Method method, int param) {
        Annotation[] annos;
        for (Annotation anno : annos = method.getParameterAnnotations()[param]) {
            if (!(anno instanceof StackTrace)) continue;
            return (StackTrace)anno;
        }
        return null;
    }

    private static Throwable findLoggableThrowable(MessageLogger logger, Method method, Object[] args) {
        Throwable throwable = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                StackTrace anno;
                Object arg = args[i];
                if (!(arg instanceof Throwable) || (anno = MessagesInvoker.getStackTraceAnno(method, i)) == null || !logger.isLoggable(anno.level())) continue;
                throwable = (Throwable)arg;
                break;
            }
        }
        return throwable;
    }

    @Override
    protected String getAnnotationPattern(Method method) {
        String pattern = null;
        Message anno = method.getAnnotation(Message.class);
        if (anno != null) {
            pattern = anno.text();
        }
        return pattern;
    }

    private static MessageLevel getLevel(Method method) {
        Message anno = method.getAnnotation(Message.class);
        MessageLevel level = anno == null ? MessageLevel.INFO : anno.level();
        return level;
    }

    private static String calcCodePattern(Class<?> clazz, Messages anno) {
        String pattern = anno.codes();
        if ("{0}".equals(pattern)) {
            pattern = clazz.getCanonicalName().replace('.', '/');
        }
        return pattern;
    }

    private static String calcBundleName(Class<?> clazz, Messages anno) {
        String bundle = null;
        if (anno != null && "".equals(bundle = anno.bundle())) {
            bundle = null;
        }
        if (bundle == null) {
            bundle = clazz.getCanonicalName().replace('.', '/');
        }
        return bundle;
    }

    private static String calcLoggerName(Class<?> clazz, Messages anno) {
        String logger = null;
        if (anno != null && "".equals(logger = anno.logger())) {
            logger = null;
        }
        if (logger == null) {
            logger = clazz.getCanonicalName();
        }
        return logger;
    }

    @Override
    protected String getBundleName() {
        return this.bundle;
    }

    private static MessageLogger getLogger(Class<?> clazz, Messages anno, MessageLoggerFactory loggers) {
        return loggers.getLogger(MessagesInvoker.calcLoggerName(clazz, anno));
    }

    public String toString() {
        return "MessageInvoker[" + this.bundle + "]";
    }
}

