/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.http.protocol;

import java.io.IOException;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpException;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpRequest;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpRequestInterceptor;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpVersion;
import org.apache.kylin.jdbc.shaded.org.apache.http.ProtocolVersion;
import org.apache.kylin.jdbc.shaded.org.apache.http.annotation.Immutable;
import org.apache.kylin.jdbc.shaded.org.apache.http.params.HttpProtocolParams;
import org.apache.kylin.jdbc.shaded.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

