/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.engine.spark.utils.Repartitioner;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BuildUtils$
implements Logging {
    public static BuildUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BuildUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean findCountDistinctMeasure(LayoutEntity layout) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layout.getOrderedMeasures().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)function -> BoxesRunTime.boxToBoolean((boolean)BuildUtils$.$anonfun$findCountDistinctMeasure$1(function)));
    }

    public int repartitionIfNeed(LayoutEntity layout, NSparkCubingEngine.NSparkCubingStorage storage, String path, String tempPath, KylinConfig config, SparkSession sparkSession) throws IOException {
        long repartitionThresholdSize;
        ContentSummary summary;
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(tempPath))) {
            summary = HadoopUtil.getContentSummary(fs, new Path(tempPath));
            repartitionThresholdSize = config.getParquetStorageShardSizeRowCount();
            if (this.findCountDistinctMeasure(layout)) {
                repartitionThresholdSize = config.getParquetStorageCountDistinctShardSizeRowCount();
            }
        } else {
            throw new RuntimeException(String.format(Locale.ROOT, "Temp path does not exist before repartition. Temp path: %s.", tempPath));
        }
        List<Integer> shardByColumns = layout.getShardByColumns();
        Repartitioner repartitioner = new Repartitioner(config.getParquetStorageShardSizeMB(), config.getParquetStorageRepartitionThresholdSize(), layout, repartitionThresholdSize, summary, shardByColumns);
        Column[] sortCols = NSparkCubingUtil.getColumns(layout.getOrderedDimensions().keySet());
        int repartitionNum = repartitioner.getRepartitionNumByStorage();
        repartitioner.doRepartition(storage, path, repartitionNum, sortCols, sparkSession);
        return repartitionNum;
    }

    public void fillCuboidInfo(LayoutEntity cuboid, String strPath) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(strPath)) && cuboid.getRows() > 0L) {
            ContentSummary cs = HadoopUtil.getContentSummary(fs, new Path(strPath));
            cuboid.setFileCount(cs.getFileCount());
            cuboid.setByteSize(cs.getLength());
        } else {
            cuboid.setFileCount(0L);
            cuboid.setByteSize(0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public YarnConfiguration getCurrentYarnConfiguration() {
        void var1_1;
        YarnConfiguration conf = new YarnConfiguration();
        ((IterableLike)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().entrySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuildUtils$.$anonfun$getCurrentYarnConfiguration$1(x$1)))).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)((String)entry.getKey()).substring("spark.hadoop.".length()), (Object)((String)entry.getValue())), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            conf.set((String)tp._1(), (String)tp._2());
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public Map<String, String> getColumnIndexMap(SegmentInfo segInfo) {
        return ((TraversableOnce)segInfo.allColumns().map((Function1 & Serializable & scala.Serializable)column -> new Tuple2((Object)Integer.toString(column.id()), (Object)column.columnName()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$findCountDistinctMeasure$1(FunctionDesc function) {
        return function.returnType().dataType().equalsIgnoreCase("bitmap");
    }

    public static final /* synthetic */ boolean $anonfun$getCurrentYarnConfiguration$1(Map.Entry x$1) {
        return ((String)x$1.getKey()).startsWith("spark.hadoop.");
    }

    private BuildUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

