/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repartitioner {
    private static String tempDirSuffix = "_temp";
    protected static final Logger logger = LoggerFactory.getLogger(Repartitioner.class);
    private int MB = 0x100000;
    private int shardSize;
    private int fileLengthThreshold;
    private long totalRowCount;
    private long rowCountThreshold;
    private long cuboid;
    private ContentSummary contentSummary;
    private List<Integer> shardByColumns = new ArrayList<Integer>();

    public Repartitioner(int shardSize, int fileLengthThreshold, LayoutEntity layoutEntity, long rowCountThreshold, ContentSummary contentSummary, List<Integer> shardByColumns) {
        this.shardSize = shardSize;
        this.fileLengthThreshold = fileLengthThreshold;
        this.totalRowCount = layoutEntity.getRows();
        this.cuboid = layoutEntity.getId();
        this.rowCountThreshold = rowCountThreshold;
        this.contentSummary = contentSummary;
        if (shardByColumns != null) {
            this.shardByColumns = shardByColumns;
        }
    }

    boolean needRepartitionForFileSize() {
        return (double)this.contentSummary.getLength() * 1.0 / (double)this.MB / (double)this.contentSummary.getFileCount() < (double)this.fileLengthThreshold && this.contentSummary.getFileCount() > 1L;
    }

    boolean needRepartitionForShardByColumns() {
        return this.shardByColumns != null && !this.shardByColumns.isEmpty();
    }

    private boolean needRepartitionForRowCount() {
        return (double)this.contentSummary.getFileCount() < (double)this.totalRowCount / (double)this.rowCountThreshold * 0.75;
    }

    @VisibleForTesting
    public boolean needRepartition() {
        boolean needRepartition;
        if (this.needRepartitionForShardByColumns()) {
            return true;
        }
        boolean bl = needRepartition = this.needRepartitionForFileSize() || this.needRepartitionForRowCount();
        if (needRepartition && (long)this.getRepartitionNumByStorage() == this.contentSummary.getFileCount()) {
            needRepartition = false;
        }
        return needRepartition;
    }

    public int getShardSize() {
        return this.shardSize;
    }

    public int getFileLengthThreshold() {
        return this.fileLengthThreshold;
    }

    public ContentSummary getContentSummary() {
        return this.contentSummary;
    }

    private List<Integer> getShardByColumns() {
        return this.shardByColumns;
    }

    private int getFileLengthRepartitionNum() {
        return (int)Math.ceil((double)this.contentSummary.getLength() * 1.0 / (double)this.MB / (double)this.shardSize);
    }

    private int getRowCountRepartitionNum() {
        return (int)Math.ceil(1.0 * (double)this.totalRowCount / (double)this.rowCountThreshold);
    }

    public int getRepartitionNumByStorage() {
        int fileLengthRepartitionNum = this.getFileLengthRepartitionNum();
        int rowCountRepartitionNum = this.getRowCountRepartitionNum();
        int partitionSize = (int)Math.ceil(1.0 * (double)(fileLengthRepartitionNum + rowCountRepartitionNum) / 2.0);
        logger.info("Before repartition, cuboid[{}] has {} row, {} bytes and {} files. Partition count calculated by file size is {}, calculated by row count is {}, final is {}.", this.cuboid, this.totalRowCount, this.contentSummary.getLength(), this.contentSummary.getFileCount(), fileLengthRepartitionNum, rowCountRepartitionNum, partitionSize);
        return partitionSize;
    }

    public void setShardSize(int shardSize) {
        this.shardSize = shardSize;
    }

    public void setFileLengthThreshold(int fileLengthThreshold) {
        this.fileLengthThreshold = fileLengthThreshold;
    }

    public void setContentSummary(ContentSummary contentSummary) {
        this.contentSummary = contentSummary;
    }

    public void doRepartition(NSparkCubingEngine.NSparkCubingStorage storage, String path, int repartitionNum, Column[] sortCols, SparkSession ss) throws IOException {
        String tempPath = path + tempDirSuffix;
        Path tempResourcePath = new Path(tempPath);
        FileSystem readFileSystem = HadoopUtil.getWorkingFileSystem();
        if (this.needRepartition()) {
            Dataset data;
            logger.info("Start repartition and rewrite");
            long start = System.currentTimeMillis();
            if (this.needRepartitionForShardByColumns()) {
                logger.info("Cuboid[{}] repartition by column {} to {}", this.cuboid, NSparkCubingUtil.getColumns(this.getShardByColumns())[0], repartitionNum);
                data = storage.getFrom(tempPath, ss).repartition(repartitionNum, NSparkCubingUtil.getColumns(this.getShardByColumns())).sortWithinPartitions(sortCols);
            } else {
                logger.info("Cuboid[{}] repartition to {}", (Object)this.cuboid, (Object)repartitionNum);
                data = storage.getFrom(tempPath, ss).repartition(repartitionNum).sortWithinPartitions(sortCols);
            }
            storage.saveTo(path, (Dataset<Row>)data, ss);
            if (readFileSystem.delete(tempResourcePath, true)) {
                logger.info("Delete temp cuboid path successful. Temp path: {}.", (Object)tempPath);
            } else {
                logger.error("Delete temp cuboid path wrong, leave garbage. Temp path: {}.", (Object)tempPath);
            }
            long end = System.currentTimeMillis();
            logger.info("Repartition and rewrite ends. Cost: {} ms.", (Object)(end - start));
        } else {
            Path goalPath = new Path(path);
            if (readFileSystem.exists(goalPath)) {
                logger.info("Path {} is exists, delete it.", (Object)goalPath);
                readFileSystem.delete(goalPath, true);
            }
            if (readFileSystem.rename(new Path(tempPath), goalPath)) {
                logger.info("Rename temp path to target path successfully. Temp path: {}, target path: {}.", (Object)tempPath, (Object)path);
            } else {
                throw new RuntimeException(String.format(Locale.ROOT, "Rename temp path to target path wrong. Temp path: %s, target path: %s.", tempPath, path));
            }
        }
    }
}

