/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.jdbc.hive.ClosedOrCancelledException;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiArrowQueryResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiQueryResultSet;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.adapter.SQLStatement;
import org.apache.kyuubi.jdbc.hive.cli.FetchType;
import org.apache.kyuubi.jdbc.hive.cli.RowSet;
import org.apache.kyuubi.jdbc.hive.cli.RowSetFactory;
import org.apache.kyuubi.jdbc.hive.logs.InPlaceUpdateStream;
import org.apache.kyuubi.jdbc.hive.logs.KyuubiLoggable;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumnDesc;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchOrientation;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetQueryIdReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOperationHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TSessionHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTableSchema;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.shaded.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyuubiStatement
implements SQLStatement,
KyuubiLoggable {
    public static final Logger LOG = LoggerFactory.getLogger((String)KyuubiStatement.class.getName());
    public static final int DEFAULT_FETCH_SIZE = 1000;
    public static final String DEFAULT_RESULT_FORMAT = "thrift";
    public static final String DEFAULT_ARROW_TIMESTAMP_AS_STRING = "false";
    private final KyuubiConnection connection;
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle = null;
    private final TSessionHandle sessHandle;
    Map<String, String> sessConf = new HashMap<String, String>();
    private int fetchSize = 1000;
    private boolean isScrollableResultset = false;
    private boolean isOperationComplete = false;
    private Map<String, String> properties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private boolean isQueryClosed = false;
    private boolean isLogBeingGenerated = true;
    private boolean isExecuteStatementFailed = false;
    private int queryTimeout = 0;
    private InPlaceUpdateStream inPlaceUpdateStream = InPlaceUpdateStream.NO_OP;

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this(connection, client, sessHandle, false, 1000);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, int fetchSize) {
        this(connection, client, sessHandle, false, fetchSize);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset) {
        this(connection, client, sessHandle, isScrollableResultset, 1000);
    }

    public KyuubiStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset, int fetchSize) {
        this.connection = connection;
        this.client = client;
        this.sessHandle = sessHandle;
        this.isScrollableResultset = isScrollableResultset;
        this.fetchSize = fetchSize;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.stmtHandle != null) {
                TCancelOperationReq cancelReq = new TCancelOperationReq(this.stmtHandle);
                TCancelOperationResp cancelResp = this.client.CancelOperation(cancelReq);
                Utils.verifySuccessWithInfo(cancelResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KyuubiSQLException(e.toString(), "08S01", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    private void closeStatementIfNeeded() throws SQLException {
        try {
            if (this.stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq(this.stmtHandle);
                TCloseOperationResp closeResp = this.client.CloseOperation(closeReq);
                Utils.verifySuccessWithInfo(closeResp.getStatus());
                this.stmtHandle = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KyuubiSQLException(e.toString(), "08S01", e);
        }
    }

    void closeClientOperation() throws SQLException {
        this.closeStatementIfNeeded();
        this.isQueryClosed = true;
        this.isExecuteStatementFailed = false;
        this.stmtHandle = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        this.closeResultSet();
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeWithConfOverlay(sql, null);
    }

    private boolean executeWithConfOverlay(String sql, Map<String, String> confOverlay) throws SQLException {
        this.runAsyncOnServer(sql, confOverlay);
        TGetOperationStatusResp status = this.waitForOperationToComplete();
        if (!status.isHasResultSet() && !this.stmtHandle.isHasResultSet()) {
            return false;
        }
        TGetResultSetMetadataResp metadata = this.getResultSetMetadata();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TTypeId> columnTypes = new ArrayList<TTypeId>();
        ArrayList<JdbcColumnAttributes> columnAttributes = new ArrayList<JdbcColumnAttributes>();
        this.parseMetadata(metadata, columnNames, columnTypes, columnAttributes);
        String resultFormat = this.properties.getOrDefault("__kyuubi_operation_result_format__", DEFAULT_RESULT_FORMAT);
        LOG.debug("kyuubi.operation.result.format: {}", (Object)resultFormat);
        switch (resultFormat) {
            case "arrow": {
                boolean timestampAsString = Boolean.parseBoolean(this.properties.getOrDefault("__kyuubi_operation_result_arrow_timestampAsString__", DEFAULT_ARROW_TIMESTAMP_AS_STRING));
                this.resultSet = new KyuubiArrowQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).setSchema(columnNames, columnTypes, columnAttributes).setTimestampAsString(timestampAsString).build();
                break;
            }
            default: {
                this.resultSet = new KyuubiQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).setSchema(columnNames, columnTypes, columnAttributes).build();
            }
        }
        return true;
    }

    public boolean executeAsync(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        TGetOperationStatusResp status = this.waitForResultSetStatus();
        if (!status.isHasResultSet()) {
            return false;
        }
        TGetResultSetMetadataResp metadata = this.getResultSetMetadata();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TTypeId> columnTypes = new ArrayList<TTypeId>();
        ArrayList<JdbcColumnAttributes> columnAttributes = new ArrayList<JdbcColumnAttributes>();
        this.parseMetadata(metadata, columnNames, columnTypes, columnAttributes);
        String resultFormat = this.properties.getOrDefault("__kyuubi_operation_result_format__", DEFAULT_RESULT_FORMAT);
        LOG.debug("kyuubi.operation.result.format: {}", (Object)resultFormat);
        switch (resultFormat) {
            case "arrow": {
                boolean timestampAsString = Boolean.parseBoolean(this.properties.getOrDefault("__kyuubi_operation_result_arrow_timestampAsString__", DEFAULT_ARROW_TIMESTAMP_AS_STRING));
                this.resultSet = new KyuubiArrowQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).setSchema(columnNames, columnTypes, columnAttributes).setTimestampAsString(timestampAsString).build();
                break;
            }
            default: {
                this.resultSet = new KyuubiQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).setSchema(columnNames, columnTypes, columnAttributes).build();
            }
        }
        return true;
    }

    private void runAsyncOnServer(String sql) throws SQLException {
        this.runAsyncOnServer(sql, null);
    }

    private void runAsyncOnServer(String sql, Map<String, String> confOneTime) throws SQLException {
        this.checkConnection("execute");
        this.reInitState();
        TExecuteStatementReq execReq = new TExecuteStatementReq(this.sessHandle, sql);
        execReq.setRunAsync(true);
        if (confOneTime != null) {
            HashMap<String, String> confOverlay = new HashMap<String, String>(this.sessConf);
            confOverlay.putAll(confOneTime);
            execReq.setConfOverlay(confOverlay);
        } else {
            execReq.setConfOverlay(this.sessConf);
        }
        execReq.setQueryTimeout((long)this.queryTimeout);
        try {
            TExecuteStatementResp execResp = this.client.ExecuteStatement(execReq);
            Utils.verifySuccessWithInfo(execResp.getStatus());
            this.stmtHandle = execResp.getOperationHandle();
            this.isExecuteStatementFailed = false;
        }
        catch (SQLException eS) {
            this.isExecuteStatementFailed = true;
            this.isLogBeingGenerated = false;
            throw eS;
        }
        catch (Exception ex) {
            this.isExecuteStatementFailed = true;
            this.isLogBeingGenerated = false;
            throw new KyuubiSQLException(ex.toString(), "08S01", ex);
        }
    }

    private TGetOperationStatusResp waitForResultSetStatus() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
        TGetOperationStatusResp statusResp = null;
        while (statusResp == null || !statusResp.isSetHasResultSet()) {
            try {
                statusResp = this.client.GetOperationStatus(statusReq);
            }
            catch (TException e) {
                this.isLogBeingGenerated = false;
                throw new KyuubiSQLException(e.toString(), "08S01", e);
            }
        }
        return statusResp;
    }

    TGetOperationStatusResp waitForOperationToComplete() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
        boolean shouldGetProgressUpdate = this.inPlaceUpdateStream != InPlaceUpdateStream.NO_OP;
        statusReq.setGetProgressUpdate(shouldGetProgressUpdate);
        if (!shouldGetProgressUpdate) {
            this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
        }
        TGetOperationStatusResp statusResp = null;
        do {
            try {
                statusResp = this.client.GetOperationStatus(statusReq);
                this.inPlaceUpdateStream.update(statusResp.getProgressUpdateResponse());
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case CLOSED_STATE: 
                    case FINISHED_STATE: {
                        this.isOperationComplete = true;
                        this.isLogBeingGenerated = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        String errMsg = statusResp.getErrorMessage();
                        if (errMsg != null && !errMsg.isEmpty()) {
                            throw new KyuubiSQLException("Query was cancelled. " + errMsg, "01000");
                        }
                        throw new KyuubiSQLException("Query was cancelled", "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Query timed out after " + this.queryTimeout + " seconds");
                    }
                    case ERROR_STATE: {
                        throw new KyuubiSQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new KyuubiSQLException("Unknown query", "HY000");
                    }
                }
            }
            catch (SQLException e) {
                this.isLogBeingGenerated = false;
                throw e;
            }
            catch (Exception e) {
                this.isLogBeingGenerated = false;
                throw new KyuubiSQLException(e.toString(), "08S01", e);
            }
        } while (!this.isOperationComplete);
        this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
        return statusResp;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new KyuubiSQLException("Can't " + action + " after statement has been closed");
        }
    }

    private void reInitState() throws SQLException {
        this.closeStatementIfNeeded();
        this.isCancelled = false;
        this.isQueryClosed = false;
        this.isLogBeingGenerated = true;
        this.isExecuteStatementFailed = false;
        this.isOperationComplete = false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public ResultSet executeScala(String code) throws SQLException {
        if (!this.executeWithConfOverlay(code, Collections.singletonMap("kyuubi.operation.language", "SCALA"))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public ResultSet executePython(String code) throws SQLException {
        if (!this.executeWithConfOverlay(code, Collections.singletonMap("kyuubi.operation.language", "PYTHON"))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public void executeSetCurrentCatalog(String sql, String catalog) throws SQLException {
        if (this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.set.current.catalog", catalog))) {
            this.closeResultSet();
        }
    }

    public ResultSet executeGetCurrentCatalog(String sql) throws SQLException {
        if (!this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.get.current.catalog", ""))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    public void executeSetCurrentDatabase(String sql, String database) throws SQLException {
        if (this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.set.current.database", database))) {
            this.closeResultSet();
        }
    }

    public ResultSet executeGetCurrentDatabase(String sql) throws SQLException {
        if (!this.executeWithConfOverlay(sql, Collections.singletonMap("kyuubi.operation.get.current.database", ""))) {
            throw new KyuubiSQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1) {
            this.closeResultSet();
            return false;
        }
        if (current != 2 && current != 3) {
            throw new SQLException("Invalid argument: " + current);
        }
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkConnection("getUpdateCount");
        long numModifiedRows = -1L;
        TGetOperationStatusResp resp = this.waitForOperationToComplete();
        if (resp != null && resp.isSetNumModifiedRows()) {
            numModifiedRows = resp.getNumModifiedRows();
        }
        if (numModifiedRows == -1L || numModifiedRows > Integer.MAX_VALUE) {
            LOG.warn("Invalid number of updated rows: {}", (Object)numModifiedRows);
            return -1;
        }
        return (int)numModifiedRows;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new KyuubiSQLException("Not supported direction " + direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows == 0) {
            this.fetchSize = 1000;
        } else {
            throw new KyuubiSQLException("Fetch size must be greater or equal to 0");
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new KyuubiSQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new KyuubiSQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean hasMoreLogs() {
        return this.isLogBeingGenerated;
    }

    @Override
    public List<String> getExecLog() throws SQLException, ClosedOrCancelledException {
        return this.getQueryLog(true, this.fetchSize);
    }

    public List<String> getQueryLog(boolean incremental, int fetchSize) throws SQLException, ClosedOrCancelledException {
        this.checkConnection("getQueryLog");
        if (this.isCancelled) {
            throw new ClosedOrCancelledException("Method getQueryLog() failed. The statement has been closed or cancelled.");
        }
        ArrayList<String> logs = new ArrayList<String>();
        TFetchResultsResp tFetchResultsResp = null;
        try {
            if (this.stmtHandle == null) {
                if (this.isQueryClosed) {
                    throw new ClosedOrCancelledException("Method getQueryLog() failed. The statement has been closed or cancelled.");
                }
                return logs;
            }
            TFetchResultsReq tFetchResultsReq = new TFetchResultsReq(this.stmtHandle, this.getFetchOrientation(incremental), (long)fetchSize);
            tFetchResultsReq.setFetchType(FetchType.LOG.toTFetchType());
            tFetchResultsResp = this.client.FetchResults(tFetchResultsReq);
            Utils.verifySuccessWithInfo(tFetchResultsResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error when getting query log: " + (Object)((Object)e), e);
        }
        catch (Exception e) {
            throw new KyuubiSQLException("Error when getting query log: " + e, e);
        }
        try {
            RowSet rowSet = RowSetFactory.create(tFetchResultsResp.getResults(), this.connection.getProtocol());
            for (Object[] row : rowSet) {
                logs.add(String.valueOf(row[0]));
            }
        }
        catch (TException e) {
            throw new KyuubiSQLException("Error building result set for query log: " + (Object)((Object)e), e);
        }
        return logs;
    }

    private TFetchOrientation getFetchOrientation(boolean incremental) {
        if (incremental) {
            return TFetchOrientation.FETCH_NEXT;
        }
        return TFetchOrientation.FETCH_FIRST;
    }

    public String getYarnATSGuid() {
        if (this.stmtHandle != null) {
            String guid64 = Base64.getUrlEncoder().encodeToString(this.stmtHandle.getOperationId().getGuid()).trim();
            return guid64;
        }
        return null;
    }

    @VisibleForTesting
    public String getQueryId() throws SQLException {
        if (this.stmtHandle == null) {
            return null;
        }
        try {
            String queryId = this.client.GetQueryId(new TGetQueryIdReq(this.stmtHandle)).getQueryId();
            return StringUtils.isBlank((CharSequence)queryId) ? null : queryId;
        }
        catch (TException e) {
            throw new KyuubiSQLException(e);
        }
    }

    public void setInPlaceUpdateStream(InPlaceUpdateStream stream) {
        this.inPlaceUpdateStream = stream;
    }

    private TGetResultSetMetadataResp getResultSetMetadata() throws SQLException {
        try {
            TGetResultSetMetadataReq metadataReq = new TGetResultSetMetadataReq(this.stmtHandle);
            TGetResultSetMetadataResp metadataResp = this.client.GetResultSetMetadata(metadataReq);
            Utils.verifySuccess(metadataResp.getStatus());
            return metadataResp;
        }
        catch (SQLException eS) {
            throw eS;
        }
        catch (Exception ex) {
            throw new KyuubiSQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
    }

    private void parseMetadata(TGetResultSetMetadataResp metadataResp, List<String> columnNames, List<TTypeId> columnTypes, List<JdbcColumnAttributes> columnAttributes) throws KyuubiSQLException {
        TTableSchema schema = metadataResp.getSchema();
        if (schema == null || !schema.isSetColumns()) {
            throw new KyuubiSQLException("the result set schema is null");
        }
        List infoMessages = metadataResp.getStatus().getInfoMessages();
        if (infoMessages != null) {
            metadataResp.getStatus().getInfoMessages().stream().filter(hint -> Utils.isKyuubiOperationHint(hint)).forEach(line -> {
                String[] keyValue = line.toLowerCase(Locale.ROOT).split("=");
                assert (keyValue.length == 2) : "Illegal Kyuubi operation hint found!";
                String key = keyValue[0];
                String value = keyValue[1];
                this.properties.put(key, value);
            });
        }
        List columns = schema.getColumns();
        for (int pos = 0; pos < schema.getColumnsSize(); ++pos) {
            String columnName = ((TColumnDesc)columns.get(pos)).getColumnName();
            columnNames.add(columnName);
            TPrimitiveTypeEntry primitiveTypeEntry = ((TTypeEntry)((TColumnDesc)columns.get(pos)).getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
            columnTypes.add(primitiveTypeEntry.getType());
            columnAttributes.add(KyuubiArrowQueryResultSet.getColumnAttributes(primitiveTypeEntry));
        }
    }

    private void closeResultSet() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }
}

