/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ControlledJob {
    private static final Logger LOG = LoggerFactory.getLogger(ControlledJob.class);
    public static final String CREATE_DIR = "mapreduce.jobcontrol.createdir.ifnotexist";
    private State state;
    private String controlID;
    private Job job;
    private String message;
    private List<ControlledJob> dependingJobs;

    public ControlledJob(Job job, List<ControlledJob> dependingJobs) throws IOException {
        this.job = job;
        this.dependingJobs = dependingJobs;
        this.state = State.WAITING;
        this.controlID = "unassigned";
        this.message = "just initialized";
    }

    public ControlledJob(Configuration conf) throws IOException {
        this(Job.getInstance(conf), null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("job name:\t").append(this.job.getJobName()).append("\n");
        sb.append("job id:\t").append(this.controlID).append("\n");
        sb.append("job state:\t").append((Object)this.state).append("\n");
        sb.append("job mapred id:\t").append(this.job.getJobID()).append("\n");
        sb.append("job message:\t").append(this.message).append("\n");
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            sb.append("job has no depending job:\t").append("\n");
        } else {
            sb.append("job has ").append(this.dependingJobs.size()).append(" dependeng jobs:\n");
            for (int i = 0; i < this.dependingJobs.size(); ++i) {
                sb.append("\t depending job ").append(i).append(":\t");
                sb.append(this.dependingJobs.get(i).getJobName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String getJobName() {
        return this.job.getJobName();
    }

    public void setJobName(String jobName) {
        this.job.setJobName(jobName);
    }

    public String getJobID() {
        return this.controlID;
    }

    public void setJobID(String id) {
        this.controlID = id;
    }

    public synchronized JobID getMapredJobId() {
        return this.job.getJobID();
    }

    public synchronized Job getJob() {
        return this.job;
    }

    public synchronized void setJob(Job job) {
        this.job = job;
    }

    public synchronized State getJobState() {
        return this.state;
    }

    protected synchronized void setJobState(State state) {
        this.state = state;
    }

    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized void setMessage(String message) {
        this.message = message;
    }

    public List<ControlledJob> getDependentJobs() {
        return this.dependingJobs;
    }

    public synchronized boolean addDependingJob(ControlledJob dependingJob) {
        if (this.state == State.WAITING) {
            if (this.dependingJobs == null) {
                this.dependingJobs = new ArrayList<ControlledJob>();
            }
            return this.dependingJobs.add(dependingJob);
        }
        return false;
    }

    public synchronized boolean isCompleted() {
        return this.state == State.FAILED || this.state == State.DEPENDENT_FAILED || this.state == State.SUCCESS;
    }

    public synchronized boolean isReady() {
        return this.state == State.READY;
    }

    public void killJob() throws IOException, InterruptedException {
        this.job.killJob();
    }

    public synchronized void failJob(String message) throws IOException, InterruptedException {
        try {
            if (this.job != null && this.state == State.RUNNING) {
                this.job.killJob();
            }
        }
        finally {
            this.state = State.FAILED;
            this.message = message;
        }
    }

    private void checkRunningState() throws IOException, InterruptedException {
        try {
            if (this.job.isComplete()) {
                if (this.job.isSuccessful()) {
                    this.state = State.SUCCESS;
                } else {
                    this.state = State.FAILED;
                    this.message = "Job failed!";
                }
            }
        }
        catch (IOException ioe) {
            this.state = State.FAILED;
            this.message = StringUtils.stringifyException(ioe);
            try {
                if (this.job != null) {
                    this.job.killJob();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    synchronized State checkState() throws IOException, InterruptedException {
        State s;
        if (this.state == State.RUNNING) {
            this.checkRunningState();
        }
        if (this.state != State.WAITING) {
            return this.state;
        }
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            this.state = State.READY;
            return this.state;
        }
        ControlledJob pred = null;
        int n = this.dependingJobs.size();
        for (int i = 0; i < n && (s = (pred = this.dependingJobs.get(i)).checkState()) != State.WAITING && s != State.READY && s != State.RUNNING; ++i) {
            if (s == State.FAILED || s == State.DEPENDENT_FAILED) {
                this.state = State.DEPENDENT_FAILED;
                this.message = "depending job " + i + " with jobID " + pred.getJobID() + " failed. " + pred.getMessage();
                break;
            }
            if (i != n - 1) continue;
            this.state = State.READY;
        }
        return this.state;
    }

    protected synchronized void submit() {
        try {
            Configuration conf = this.job.getConfiguration();
            if (conf.getBoolean(CREATE_DIR, false)) {
                FileSystem fs = FileSystem.get(conf);
                Path[] inputPaths = FileInputFormat.getInputPaths(this.job);
                for (int i = 0; i < inputPaths.length; ++i) {
                    if (fs.exists(inputPaths[i])) continue;
                    try {
                        fs.mkdirs(inputPaths[i]);
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.job.submit();
            this.state = State.RUNNING;
        }
        catch (Exception ioe) {
            LOG.info(this.getJobName() + " got an error while submitting ", (Throwable)ioe);
            this.state = State.FAILED;
            this.message = StringUtils.stringifyException(ioe);
        }
    }

    public static enum State {
        SUCCESS,
        WAITING,
        RUNNING,
        READY,
        FAILED,
        DEPENDENT_FAILED;

    }
}

