/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.SQLCompleter;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;

class DatabaseConnection {
    private static final String HIVE_VAR_PREFIX = "hivevar:";
    private static final String HIVE_CONF_PREFIX = "hiveconf:";
    private final BeeLine beeLine;
    private Connection connection;
    private DatabaseMetaData meta;
    private final String driver;
    private final String url;
    private final Properties info;
    private Schema schema = null;
    private Completer sqlCompleter = null;

    public boolean isClosed() {
        return null == this.connection;
    }

    public DatabaseConnection(BeeLine beeLine, String driver, String url, Properties info) throws SQLException {
        this.beeLine = beeLine;
        this.driver = driver;
        this.url = url;
        this.info = info;
    }

    public String toString() {
        return this.getUrl() + "";
    }

    void setCompletions(boolean skipmeta) throws SQLException, IOException {
        final String extraNameCharacters = this.getDatabaseMetaData() == null || this.getDatabaseMetaData().getExtraNameCharacters() == null ? "" : this.getDatabaseMetaData().getExtraNameCharacters();
        this.sqlCompleter = new ArgumentCompleter((ArgumentCompleter.ArgumentDelimiter)new ArgumentCompleter.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                if (Character.isWhitespace(c)) {
                    return true;
                }
                return !Character.isLetterOrDigit(c) && c != '_' && extraNameCharacters.indexOf(c) == -1;
            }
        }, new Completer[]{new SQLCompleter(SQLCompleter.getSQLCompleters(this.beeLine, skipmeta))});
        ((ArgumentCompleter)this.sqlCompleter).setStrict(false);
    }

    boolean connect() throws SQLException {
        Map<String, String> hiveConfVars;
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.beeLine.error(cnfe);
        }
        boolean isDriverRegistered = false;
        try {
            isDriverRegistered = DriverManager.getDriver(this.getUrl()) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        Map<String, String> hiveVars = this.beeLine.getOpts().getHiveVariables();
        if (hiveVars != null) {
            for (Map.Entry<String, String> entry : hiveVars.entrySet()) {
                this.info.put(HIVE_VAR_PREFIX + entry.getKey(), entry.getValue());
            }
        }
        if ((hiveConfVars = this.beeLine.getOpts().getHiveConfVariables()) != null) {
            for (Map.Entry<String, String> entry : hiveConfVars.entrySet()) {
                this.info.put(HIVE_CONF_PREFIX + entry.getKey(), entry.getValue());
            }
        }
        if (isDriverRegistered) {
            this.setConnection(DriverManager.getConnection(this.getUrl(), this.info));
        } else {
            this.beeLine.debug("Use the driver from local added jar file.");
            this.setConnection(this.getConnectionFromLocalDriver(this.getUrl(), this.info));
        }
        this.setDatabaseMetaData(this.getConnection().getMetaData());
        try {
            this.beeLine.info(this.beeLine.loc("connected", new Object[]{this.getDatabaseMetaData().getDatabaseProductName(), this.getDatabaseMetaData().getDatabaseProductVersion()}));
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        try {
            this.beeLine.info(this.beeLine.loc("driver", new Object[]{this.getDatabaseMetaData().getDriverName(), this.getDatabaseMetaData().getDriverVersion()}));
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        try {
            this.getConnection().setAutoCommit(this.beeLine.getOpts().getAutoCommit());
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        try {
            this.beeLine.getCommands().isolation("isolation: " + this.beeLine.getOpts().getIsolation());
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        return true;
    }

    public Connection getConnectionFromLocalDriver(String url, Properties properties) {
        Collection<Driver> drivers = this.beeLine.getDrivers();
        for (Driver d : drivers) {
            try {
                if (!d.acceptsURL(url) || !this.beeLine.isSupportedLocalDriver(d)) continue;
                String clazzName = d.getClass().getName();
                this.beeLine.debug("Driver name is " + clazzName);
                Driver driver = (Driver)Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                return driver.connect(url, properties);
            }
            catch (Exception e) {
                this.beeLine.error("Fail to connect with a local driver due to the exception:" + e);
                this.beeLine.error(e);
            }
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        return this.connection;
    }

    public Connection getCurrentConnection() {
        return this.connection;
    }

    public void reconnect() throws Exception {
        this.close();
        this.getConnection();
    }

    public void close() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.beeLine.output(this.beeLine.loc("closing", this.connection));
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.beeLine.handleException(e);
            }
        }
        finally {
            this.setConnection(null);
            this.setDatabaseMetaData(null);
        }
    }

    public String[] getTableNames(boolean force) {
        Schema.Table[] t = this.getSchema().getTables();
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; t != null && i < t.length; ++i) {
            names.add(t[i].getName());
        }
        return names.toArray(new String[names.size()]);
    }

    Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.meta;
    }

    void setDatabaseMetaData(DatabaseMetaData meta) {
        this.meta = meta;
    }

    String getUrl() {
        return this.url;
    }

    public String getConnectedUrl() {
        if (this.connection instanceof KyuubiConnection) {
            return ((KyuubiConnection)this.connection).getConnectedUrl();
        }
        return this.getUrl();
    }

    Completer getSQLCompleter() {
        return this.sqlCompleter;
    }

    class Schema {
        private Table[] tables = null;

        Schema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Table[] getTables() {
            if (this.tables != null) {
                return this.tables;
            }
            LinkedList<Table> tnames = new LinkedList<Table>();
            try {
                ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
                try {
                    while (rs.next()) {
                        tnames.add(new Table(rs.getString("TABLE_NAME")));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tables = tnames.toArray(new Table[0]);
            return this.tables;
        }

        Table getTable(String name) {
            Table[] t = this.getTables();
            for (int i = 0; t != null && i < t.length; ++i) {
                if (!name.equalsIgnoreCase(t[i].getName())) continue;
                return t[i];
            }
            return null;
        }

        class Table {
            final String name;
            Column[] columns;

            public Table(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            class Column {
                final String name;
                boolean isPrimaryKey;

                public Column(String name) {
                    this.name = name;
                }
            }
        }
    }
}

