/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ctl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.client.KyuubiRestClient;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.ctl.CtlConf$;
import org.apache.kyuubi.ctl.opt.CliConfig;
import org.apache.kyuubi.ctl.opt.CommonOpts;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RestClientFactory$ {
    public static RestClientFactory$ MODULE$;

    static {
        new RestClientFactory$();
    }

    public <T> T withKyuubiRestClient(CliConfig cliConfig, Map<String, Object> map, KyuubiConf conf, Function1<KyuubiRestClient, T> f) {
        Object object;
        try (KyuubiRestClient kyuubiRestClient = this.getKyuubiRestClient(cliConfig, map, conf);){
            object = f.apply((Object)kyuubiRestClient);
        }
        return (T)object;
    }

    public void withKyuubiInstanceRestClient(KyuubiRestClient kyuubiRestClient, String kyuubiInstance, Function1<KyuubiRestClient, BoxedUnit> f) {
        KyuubiRestClient kyuubiInstanceRestClient = kyuubiRestClient.clone();
        Seq hostUrls = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)kyuubiInstance).map((Function1 & Serializable & scala.Serializable)instance -> new StringBuilder(7).append("http://").append((String)instance).toString())).toSeq().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(kyuubiRestClient.getHostUrls()).asScala(), Seq$.MODULE$.canBuildFrom());
        kyuubiInstanceRestClient.setHostUrls((List)JavaConverters$.MODULE$.seqAsJavaListConverter(hostUrls).asJava());
        try {
            f.apply((Object)kyuubiInstanceRestClient);
        }
        finally {
            kyuubiInstanceRestClient.close();
        }
    }

    private KyuubiRestClient getKyuubiRestClient(CliConfig cliConfig, Map<String, Object> map, KyuubiConf conf) {
        String version = this.getApiVersion(map);
        String hostUrl = this.getRestConfig("hostUrl", (String)((Option)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_BASE_URL())).orNull(Predef$.MODULE$.$conforms()), cliConfig, map);
        String authSchema = this.getRestConfig("authSchema", (String)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_AUTH_SCHEMA()), cliConfig, map);
        int maxAttempts = BoxesRunTime.unboxToInt((Object)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_REQUEST_MAX_ATTEMPTS()));
        int attemptWaitTime = (int)BoxesRunTime.unboxToLong((Object)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_REQUEST_ATTEMPT_WAIT()));
        int connectionTimeout = (int)BoxesRunTime.unboxToLong((Object)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_CONNECT_TIMEOUT()));
        int socketTimeout = (int)BoxesRunTime.unboxToLong((Object)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_SOCKET_TIMEOUT()));
        KyuubiRestClient kyuubiRestClient = null;
        String string = authSchema.toLowerCase();
        if ("basic".equals(string)) {
            String username = this.getRestConfig("username", null, cliConfig, map);
            String password = cliConfig.commonOpts().password();
            kyuubiRestClient = KyuubiRestClient.builder((String)hostUrl).apiVersion(KyuubiRestClient.ApiVersion.valueOf((String)version)).authHeaderMethod(KyuubiRestClient.AuthHeaderMethod.BASIC).username(username).password(password).connectionTimeout(connectionTimeout).socketTimeout(socketTimeout).maxAttempts(maxAttempts).attemptWaitTime(attemptWaitTime).build();
        } else if ("spnego".equals(string)) {
            String spnegoHost = this.getRestConfig("spnegoHost", (String)((Option)conf.get(CtlConf$.MODULE$.CTL_REST_CLIENT_SPNEGO_HOST())).orNull(Predef$.MODULE$.$conforms()), cliConfig, map);
            kyuubiRestClient = KyuubiRestClient.builder((String)hostUrl).apiVersion(KyuubiRestClient.ApiVersion.valueOf((String)version)).authHeaderMethod(KyuubiRestClient.AuthHeaderMethod.SPNEGO).spnegoHost(spnegoHost).connectionTimeout(connectionTimeout).socketTimeout(socketTimeout).maxAttempts(maxAttempts).attemptWaitTime(attemptWaitTime).build();
        } else {
            throw new KyuubiException(new StringBuilder(25).append("Unsupported auth schema: ").append(authSchema).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return kyuubiRestClient;
    }

    private String getApiVersion(Map<String, Object> map) {
        String version;
        block0: {
            String configuredVersion;
            version = "V1";
            if (map == null || !StringUtils.isNotBlank((CharSequence)(configuredVersion = ((String)map.get("apiVersion")).toUpperCase()))) break block0;
            version = configuredVersion;
        }
        return version;
    }

    private String getRestConfig(String key, String defaultValue, CliConfig cliConfig, Map<String, Object> map) {
        String configValue;
        block1: {
            CommonOpts commonOpts = cliConfig.commonOpts();
            String string = key;
            String string2 = "hostUrl".equals(string) ? commonOpts.hostUrl() : ("authSchema".equals(string) ? commonOpts.authSchema() : ("username".equals(string) ? commonOpts.username() : (configValue = "spnegoHost".equals(string) ? commonOpts.spnegoHost() : null)));
            if (StringUtils.isBlank((CharSequence)configValue) && map != null) {
                configValue = (String)map.get(key);
            }
            if (!StringUtils.isBlank((CharSequence)configValue)) break block1;
            configValue = defaultValue;
        }
        return configValue;
    }

    private RestClientFactory$() {
        MODULE$ = this;
    }
}

