/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Driver;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.KyuubiCommands;

public class KyuubiBeeLine
extends BeeLine {
    public static final String KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.kyuubi.jdbc.KyuubiHiveDriver";
    protected KyuubiCommands commands = new KyuubiCommands(this);
    private Driver defaultDriver = null;

    public KyuubiBeeLine() {
        this(true);
    }

    public KyuubiBeeLine(boolean isBeeLine) {
        super(isBeeLine);
        try {
            Field commandsField = BeeLine.class.getDeclaredField("commands");
            commandsField.setAccessible(true);
            commandsField.set((Object)this, (Object)this.commands);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Failed to inject kyuubi commands");
        }
        try {
            this.defaultDriver = (Driver)Class.forName(KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("org.apache.kyuubi.jdbc.KyuubiHiveDriver-missing");
        }
    }

    public static void main(String[] args) throws IOException {
        KyuubiBeeLine.mainWithInputRedirection(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        try (KyuubiBeeLine beeLine = new KyuubiBeeLine();){
            int status = beeLine.begin(args, inputStream);
            if (!Boolean.getBoolean("beeline.system.exit")) {
                System.exit(status);
            }
        }
    }

    protected Driver getDefaultDriver() {
        return this.defaultDriver;
    }

    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Kyuubi (Incubating)"});
    }
}

