/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.config;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kyuubi.config.ConfigBuilder;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$FrontendProtocols$;
import org.apache.kyuubi.config.KyuubiConf$OperationModes$;
import org.apache.kyuubi.config.OptionalConfigEntry;
import org.apache.kyuubi.config.TypedConfigBuilder;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.SaslQOP$;
import org.apache.kyuubi.util.NettyUtils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class KyuubiConf$
implements scala.Serializable {
    public static KyuubiConf$ MODULE$;
    private final Map<String, ConfigEntry<?>> kyuubiConfEntries;
    private final OptionalConfigEntry<String> SERVER_PRINCIPAL;
    private final OptionalConfigEntry<String> SERVER_KEYTAB;
    private final ConfigEntry<Object> KINIT_INTERVAL;
    private final ConfigEntry<Object> KINIT_MAX_ATTEMPTS;
    private final ConfigEntry<Object> OPERATION_IDLE_TIMEOUT;
    private final ConfigEntry<Object> CREDENTIALS_RENEWAL_INTERVAL;
    private final ConfigEntry<Object> CREDENTIALS_RENEWAL_RETRY_WAIT;
    private final ConfigEntry<Object> CREDENTIALS_HADOOP_FS_ENABLED;
    private final ConfigEntry<Seq<String>> CREDENTIALS_HADOOP_FS_URIS;
    private final ConfigEntry<Object> CREDENTIALS_HIVE_ENABLED;
    private final ConfigEntry<Seq<String>> FRONTEND_PROTOCOLS;
    private final OptionalConfigEntry<String> FRONTEND_BIND_HOST;
    private final ConfigEntry<Option<String>> FRONTEND_THRIFT_BINARY_BIND_HOST;
    private final ConfigEntry<Object> FRONTEND_BIND_PORT;
    private final ConfigEntry<Object> FRONTEND_THRIFT_BINARY_BIND_PORT;
    private final ConfigEntry<Object> FRONTEND_MIN_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_THRIFT_MIN_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_MAX_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_THRIFT_MAX_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_WORKER_KEEPALIVE_TIME;
    private final ConfigEntry<Object> FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME;
    private final ConfigEntry<Object> FRONTEND_MAX_MESSAGE_SIZE;
    private final ConfigEntry<Object> FRONTEND_THRIFT_MAX_MESSAGE_SIZE;
    private final ConfigEntry<Object> FRONTEND_LOGIN_TIMEOUT;
    private final ConfigEntry<Object> FRONTEND_THRIFT_LOGIN_TIMEOUT;
    private final ConfigEntry<Object> FRONTEND_LOGIN_BACKOFF_SLOT_LENGTH;
    private final ConfigEntry<Object> FRONTEND_THRIFT_LOGIN_BACKOFF_SLOT_LENGTH;
    private final ConfigEntry<Seq<String>> AUTHENTICATION_METHOD;
    private final OptionalConfigEntry<String> AUTHENTICATION_CUSTOM_CLASS;
    private final OptionalConfigEntry<String> AUTHENTICATION_LDAP_URL;
    private final OptionalConfigEntry<String> AUTHENTICATION_LDAP_BASEDN;
    private final OptionalConfigEntry<String> AUTHENTICATION_LDAP_DOMAIN;
    private final ConfigEntry<String> AUTHENTICATION_LDAP_GUIDKEY;
    private final ConfigEntry<Object> DELEGATION_KEY_UPDATE_INTERVAL;
    private final ConfigEntry<Object> DELEGATION_TOKEN_MAX_LIFETIME;
    private final ConfigEntry<Object> DELEGATION_TOKEN_GC_INTERVAL;
    private final ConfigEntry<Object> DELEGATION_TOKEN_RENEW_INTERVAL;
    private final ConfigEntry<String> SASL_QOP;
    private final ConfigEntry<Option<String>> FRONTEND_REST_BIND_HOST;
    private final ConfigEntry<Object> FRONTEND_REST_BIND_PORT;
    private final ConfigEntry<Option<String>> FRONTEND_MYSQL_BIND_HOST;
    private final ConfigEntry<Object> FRONTEND_MYSQL_BIND_PORT;
    private final OptionalConfigEntry<Object> FRONTEND_MYSQL_NETTY_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_MYSQL_MIN_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_MYSQL_MAX_WORKER_THREADS;
    private final ConfigEntry<Object> FRONTEND_MYSQL_WORKER_KEEPALIVE_TIME;
    private final ConfigEntry<Object> ENGINE_ERROR_MAX_SIZE;
    private final ConfigEntry<Object> ENGINE_LOG_TIMEOUT;
    private final OptionalConfigEntry<String> ENGINE_SPARK_MAIN_RESOURCE;
    private final ConfigEntry<Object> ENGINE_LOGIN_TIMEOUT;
    private final ConfigEntry<Object> ENGINE_REQUEST_TIMEOUT;
    private final ConfigEntry<Object> ENGINE_INIT_TIMEOUT;
    private final ConfigEntry<Object> SESSION_CHECK_INTERVAL;
    private final ConfigEntry<Object> SESSION_TIMEOUT;
    private final ConfigEntry<Object> SESSION_IDLE_TIMEOUT;
    private final ConfigEntry<Object> ENGINE_CHECK_INTERVAL;
    private final ConfigEntry<Object> ENGINE_IDLE_TIMEOUT;
    private final ConfigEntry<Seq<String>> SESSION_CONF_IGNORE_LIST;
    private final ConfigEntry<Seq<String>> SESSION_CONF_RESTRICT_LIST;
    private final ConfigEntry<Object> SESSION_ENGINE_STARTUP_MAX_LOG_LINES;
    private final ConfigEntry<Object> SESSION_ENGINE_LAUNCH_ASYNC;
    private final ConfigEntry<Object> SERVER_EXEC_POOL_SIZE;
    private final ConfigEntry<Object> ENGINE_EXEC_POOL_SIZE;
    private final ConfigEntry<Object> SERVER_EXEC_WAIT_QUEUE_SIZE;
    private final ConfigEntry<Object> ENGINE_EXEC_WAIT_QUEUE_SIZE;
    private final ConfigEntry<Object> SERVER_EXEC_KEEPALIVE_TIME;
    private final ConfigEntry<Object> ENGINE_EXEC_KEEPALIVE_TIME;
    private final ConfigEntry<Object> SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT;
    private final ConfigEntry<Object> ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT;
    private final ConfigEntry<Object> OPERATION_STATUS_POLLING_TIMEOUT;
    private final ConfigEntry<Object> OPERATION_STATUS_POLLING_MAX_ATTEMPTS;
    private final ConfigEntry<Object> OPERATION_FORCE_CANCEL;
    private final OptionalConfigEntry<Object> OPERATION_QUERY_TIMEOUT;
    private final ConfigEntry<Object> OPERATION_INCREMENTAL_COLLECT;
    private final ConfigEntry<String> SERVER_OPERATION_LOG_DIR_ROOT;
    private final ConfigEntry<String> LEGACY_ENGINE_SHARE_LEVEL;
    private final Pattern validEngineSubdomain;
    private final ConfigEntry<Option<String>> ENGINE_SHARE_LEVEL_SUB_DOMAIN;
    private final ConfigEntry<Option<String>> ENGINE_SHARE_LEVEL_SUBDOMAIN;
    private final ConfigEntry<Object> ENGINE_CONNECTION_URL_USE_HOSTNAME;
    private final ConfigEntry<String> ENGINE_SHARE_LEVEL;
    private final ConfigEntry<String> ENGINE_TYPE;
    private final ConfigEntry<Object> ENGINE_POOL_SIZE_THRESHOLD;
    private final ConfigEntry<Object> ENGINE_POOL_SIZE;
    private final ConfigEntry<Seq<String>> ENGINE_INITIALIZE_SQL;
    private final ConfigEntry<Seq<String>> ENGINE_SESSION_INITIALIZE_SQL;
    private final ConfigEntry<Seq<String>> ENGINE_DEREGISTER_EXCEPTION_CLASSES;
    private final ConfigEntry<Seq<String>> ENGINE_DEREGISTER_EXCEPTION_MESSAGES;
    private final ConfigEntry<Object> ENGINE_DEREGISTER_JOB_MAX_FAILURES;
    private final ConfigEntry<Object> ENGINE_DEREGISTER_EXCEPTION_TTL;
    private final OptionalConfigEntry<String> OPERATION_SCHEDULER_POOL;
    private final ConfigEntry<Object> ENGINE_SINGLE_SPARK_SESSION;
    private final ConfigEntry<String> SERVER_EVENT_JSON_LOG_PATH;
    private final ConfigEntry<String> ENGINE_EVENT_JSON_LOG_PATH;
    private final ConfigEntry<Seq<String>> SERVER_EVENT_LOGGERS;
    private final ConfigEntry<Seq<String>> ENGINE_EVENT_LOGGERS;
    private final ConfigEntry<Object> ENGINE_UI_STOP_ENABLED;
    private final ConfigEntry<Object> ENGINE_UI_SESSION_LIMIT;
    private final ConfigEntry<Object> ENGINE_UI_STATEMENT_LIMIT;
    private final ConfigEntry<String> ENGINE_OPERATION_LOG_DIR_ROOT;
    private final OptionalConfigEntry<String> SESSION_NAME;
    private final ConfigEntry<String> OPERATION_PLAN_ONLY;

    static {
        new KyuubiConf$();
    }

    public boolean $lessinit$greater$default$1() {
        return true;
    }

    public final String KYUUBI_CONF_DIR() {
        return "KYUUBI_CONF_DIR";
    }

    public final String KYUUBI_CONF_FILE_NAME() {
        return "kyuubi-defaults.conf";
    }

    public final String KYUUBI_HOME() {
        return "KYUUBI_HOME";
    }

    public final String KYUUBI_ENGINE_ENV_PREFIX() {
        return "kyuubi.engineEnv";
    }

    public Map<String, ConfigEntry<?>> kyuubiConfEntries() {
        return this.kyuubiConfEntries;
    }

    private void register(ConfigEntry<?> entry) {
        Map<String, ConfigEntry<?>> map = this.kyuubiConfEntries();
        synchronized (map) {
            Predef$.MODULE$.require(!this.kyuubiConfEntries().containsKey(entry.key()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Duplicate SQLConfigEntry. ").append(entry.key()).append(" has been registered").toString());
            this.kyuubiConfEntries().put(entry.key(), entry);
        }
    }

    public ConfigBuilder buildConf(String key) {
        return new ConfigBuilder(new StringBuilder(7).append("kyuubi.").append(key).toString()).onCreate((Function1 & Serializable & scala.Serializable)entry -> {
            KyuubiConf$.MODULE$.register(entry);
            return BoxedUnit.UNIT;
        });
    }

    public OptionalConfigEntry<String> SERVER_PRINCIPAL() {
        return this.SERVER_PRINCIPAL;
    }

    public OptionalConfigEntry<String> SERVER_KEYTAB() {
        return this.SERVER_KEYTAB;
    }

    public ConfigEntry<Object> KINIT_INTERVAL() {
        return this.KINIT_INTERVAL;
    }

    public ConfigEntry<Object> KINIT_MAX_ATTEMPTS() {
        return this.KINIT_MAX_ATTEMPTS;
    }

    public ConfigEntry<Object> OPERATION_IDLE_TIMEOUT() {
        return this.OPERATION_IDLE_TIMEOUT;
    }

    public ConfigEntry<Object> CREDENTIALS_RENEWAL_INTERVAL() {
        return this.CREDENTIALS_RENEWAL_INTERVAL;
    }

    public ConfigEntry<Object> CREDENTIALS_RENEWAL_RETRY_WAIT() {
        return this.CREDENTIALS_RENEWAL_RETRY_WAIT;
    }

    public ConfigEntry<Object> CREDENTIALS_HADOOP_FS_ENABLED() {
        return this.CREDENTIALS_HADOOP_FS_ENABLED;
    }

    public ConfigEntry<Seq<String>> CREDENTIALS_HADOOP_FS_URIS() {
        return this.CREDENTIALS_HADOOP_FS_URIS;
    }

    public ConfigEntry<Object> CREDENTIALS_HIVE_ENABLED() {
        return this.CREDENTIALS_HIVE_ENABLED;
    }

    public ConfigEntry<Seq<String>> FRONTEND_PROTOCOLS() {
        return this.FRONTEND_PROTOCOLS;
    }

    public OptionalConfigEntry<String> FRONTEND_BIND_HOST() {
        return this.FRONTEND_BIND_HOST;
    }

    public ConfigEntry<Option<String>> FRONTEND_THRIFT_BINARY_BIND_HOST() {
        return this.FRONTEND_THRIFT_BINARY_BIND_HOST;
    }

    public ConfigEntry<Object> FRONTEND_BIND_PORT() {
        return this.FRONTEND_BIND_PORT;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_BINARY_BIND_PORT() {
        return this.FRONTEND_THRIFT_BINARY_BIND_PORT;
    }

    public ConfigEntry<Object> FRONTEND_MIN_WORKER_THREADS() {
        return this.FRONTEND_MIN_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_MIN_WORKER_THREADS() {
        return this.FRONTEND_THRIFT_MIN_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_MAX_WORKER_THREADS() {
        return this.FRONTEND_MAX_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_MAX_WORKER_THREADS() {
        return this.FRONTEND_THRIFT_MAX_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_WORKER_KEEPALIVE_TIME() {
        return this.FRONTEND_WORKER_KEEPALIVE_TIME;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME() {
        return this.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME;
    }

    public ConfigEntry<Object> FRONTEND_MAX_MESSAGE_SIZE() {
        return this.FRONTEND_MAX_MESSAGE_SIZE;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_MAX_MESSAGE_SIZE() {
        return this.FRONTEND_THRIFT_MAX_MESSAGE_SIZE;
    }

    public ConfigEntry<Object> FRONTEND_LOGIN_TIMEOUT() {
        return this.FRONTEND_LOGIN_TIMEOUT;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_LOGIN_TIMEOUT() {
        return this.FRONTEND_THRIFT_LOGIN_TIMEOUT;
    }

    public ConfigEntry<Object> FRONTEND_LOGIN_BACKOFF_SLOT_LENGTH() {
        return this.FRONTEND_LOGIN_BACKOFF_SLOT_LENGTH;
    }

    public ConfigEntry<Object> FRONTEND_THRIFT_LOGIN_BACKOFF_SLOT_LENGTH() {
        return this.FRONTEND_THRIFT_LOGIN_BACKOFF_SLOT_LENGTH;
    }

    public ConfigEntry<Seq<String>> AUTHENTICATION_METHOD() {
        return this.AUTHENTICATION_METHOD;
    }

    public OptionalConfigEntry<String> AUTHENTICATION_CUSTOM_CLASS() {
        return this.AUTHENTICATION_CUSTOM_CLASS;
    }

    public OptionalConfigEntry<String> AUTHENTICATION_LDAP_URL() {
        return this.AUTHENTICATION_LDAP_URL;
    }

    public OptionalConfigEntry<String> AUTHENTICATION_LDAP_BASEDN() {
        return this.AUTHENTICATION_LDAP_BASEDN;
    }

    public OptionalConfigEntry<String> AUTHENTICATION_LDAP_DOMAIN() {
        return this.AUTHENTICATION_LDAP_DOMAIN;
    }

    public ConfigEntry<String> AUTHENTICATION_LDAP_GUIDKEY() {
        return this.AUTHENTICATION_LDAP_GUIDKEY;
    }

    public ConfigEntry<Object> DELEGATION_KEY_UPDATE_INTERVAL() {
        return this.DELEGATION_KEY_UPDATE_INTERVAL;
    }

    public ConfigEntry<Object> DELEGATION_TOKEN_MAX_LIFETIME() {
        return this.DELEGATION_TOKEN_MAX_LIFETIME;
    }

    public ConfigEntry<Object> DELEGATION_TOKEN_GC_INTERVAL() {
        return this.DELEGATION_TOKEN_GC_INTERVAL;
    }

    public ConfigEntry<Object> DELEGATION_TOKEN_RENEW_INTERVAL() {
        return this.DELEGATION_TOKEN_RENEW_INTERVAL;
    }

    public ConfigEntry<String> SASL_QOP() {
        return this.SASL_QOP;
    }

    public ConfigEntry<Option<String>> FRONTEND_REST_BIND_HOST() {
        return this.FRONTEND_REST_BIND_HOST;
    }

    public ConfigEntry<Object> FRONTEND_REST_BIND_PORT() {
        return this.FRONTEND_REST_BIND_PORT;
    }

    public ConfigEntry<Option<String>> FRONTEND_MYSQL_BIND_HOST() {
        return this.FRONTEND_MYSQL_BIND_HOST;
    }

    public ConfigEntry<Object> FRONTEND_MYSQL_BIND_PORT() {
        return this.FRONTEND_MYSQL_BIND_PORT;
    }

    public OptionalConfigEntry<Object> FRONTEND_MYSQL_NETTY_WORKER_THREADS() {
        return this.FRONTEND_MYSQL_NETTY_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_MYSQL_MIN_WORKER_THREADS() {
        return this.FRONTEND_MYSQL_MIN_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_MYSQL_MAX_WORKER_THREADS() {
        return this.FRONTEND_MYSQL_MAX_WORKER_THREADS;
    }

    public ConfigEntry<Object> FRONTEND_MYSQL_WORKER_KEEPALIVE_TIME() {
        return this.FRONTEND_MYSQL_WORKER_KEEPALIVE_TIME;
    }

    public ConfigEntry<Object> ENGINE_ERROR_MAX_SIZE() {
        return this.ENGINE_ERROR_MAX_SIZE;
    }

    public ConfigEntry<Object> ENGINE_LOG_TIMEOUT() {
        return this.ENGINE_LOG_TIMEOUT;
    }

    public OptionalConfigEntry<String> ENGINE_SPARK_MAIN_RESOURCE() {
        return this.ENGINE_SPARK_MAIN_RESOURCE;
    }

    public ConfigEntry<Object> ENGINE_LOGIN_TIMEOUT() {
        return this.ENGINE_LOGIN_TIMEOUT;
    }

    public ConfigEntry<Object> ENGINE_REQUEST_TIMEOUT() {
        return this.ENGINE_REQUEST_TIMEOUT;
    }

    public ConfigEntry<Object> ENGINE_INIT_TIMEOUT() {
        return this.ENGINE_INIT_TIMEOUT;
    }

    public ConfigEntry<Object> SESSION_CHECK_INTERVAL() {
        return this.SESSION_CHECK_INTERVAL;
    }

    public ConfigEntry<Object> SESSION_TIMEOUT() {
        return this.SESSION_TIMEOUT;
    }

    public ConfigEntry<Object> SESSION_IDLE_TIMEOUT() {
        return this.SESSION_IDLE_TIMEOUT;
    }

    public ConfigEntry<Object> ENGINE_CHECK_INTERVAL() {
        return this.ENGINE_CHECK_INTERVAL;
    }

    public ConfigEntry<Object> ENGINE_IDLE_TIMEOUT() {
        return this.ENGINE_IDLE_TIMEOUT;
    }

    public ConfigEntry<Seq<String>> SESSION_CONF_IGNORE_LIST() {
        return this.SESSION_CONF_IGNORE_LIST;
    }

    public ConfigEntry<Seq<String>> SESSION_CONF_RESTRICT_LIST() {
        return this.SESSION_CONF_RESTRICT_LIST;
    }

    public ConfigEntry<Object> SESSION_ENGINE_STARTUP_MAX_LOG_LINES() {
        return this.SESSION_ENGINE_STARTUP_MAX_LOG_LINES;
    }

    public ConfigEntry<Object> SESSION_ENGINE_LAUNCH_ASYNC() {
        return this.SESSION_ENGINE_LAUNCH_ASYNC;
    }

    public ConfigEntry<Object> SERVER_EXEC_POOL_SIZE() {
        return this.SERVER_EXEC_POOL_SIZE;
    }

    public ConfigEntry<Object> ENGINE_EXEC_POOL_SIZE() {
        return this.ENGINE_EXEC_POOL_SIZE;
    }

    public ConfigEntry<Object> SERVER_EXEC_WAIT_QUEUE_SIZE() {
        return this.SERVER_EXEC_WAIT_QUEUE_SIZE;
    }

    public ConfigEntry<Object> ENGINE_EXEC_WAIT_QUEUE_SIZE() {
        return this.ENGINE_EXEC_WAIT_QUEUE_SIZE;
    }

    public ConfigEntry<Object> SERVER_EXEC_KEEPALIVE_TIME() {
        return this.SERVER_EXEC_KEEPALIVE_TIME;
    }

    public ConfigEntry<Object> ENGINE_EXEC_KEEPALIVE_TIME() {
        return this.ENGINE_EXEC_KEEPALIVE_TIME;
    }

    public ConfigEntry<Object> SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT() {
        return this.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT;
    }

    public ConfigEntry<Object> ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT() {
        return this.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT;
    }

    public ConfigEntry<Object> OPERATION_STATUS_POLLING_TIMEOUT() {
        return this.OPERATION_STATUS_POLLING_TIMEOUT;
    }

    public ConfigEntry<Object> OPERATION_STATUS_POLLING_MAX_ATTEMPTS() {
        return this.OPERATION_STATUS_POLLING_MAX_ATTEMPTS;
    }

    public ConfigEntry<Object> OPERATION_FORCE_CANCEL() {
        return this.OPERATION_FORCE_CANCEL;
    }

    public OptionalConfigEntry<Object> OPERATION_QUERY_TIMEOUT() {
        return this.OPERATION_QUERY_TIMEOUT;
    }

    public ConfigEntry<Object> OPERATION_INCREMENTAL_COLLECT() {
        return this.OPERATION_INCREMENTAL_COLLECT;
    }

    public ConfigEntry<String> SERVER_OPERATION_LOG_DIR_ROOT() {
        return this.SERVER_OPERATION_LOG_DIR_ROOT;
    }

    public ConfigEntry<String> LEGACY_ENGINE_SHARE_LEVEL() {
        return this.LEGACY_ENGINE_SHARE_LEVEL;
    }

    private Pattern validEngineSubdomain() {
        return this.validEngineSubdomain;
    }

    public ConfigEntry<Option<String>> ENGINE_SHARE_LEVEL_SUB_DOMAIN() {
        return this.ENGINE_SHARE_LEVEL_SUB_DOMAIN;
    }

    public ConfigEntry<Option<String>> ENGINE_SHARE_LEVEL_SUBDOMAIN() {
        return this.ENGINE_SHARE_LEVEL_SUBDOMAIN;
    }

    public ConfigEntry<Object> ENGINE_CONNECTION_URL_USE_HOSTNAME() {
        return this.ENGINE_CONNECTION_URL_USE_HOSTNAME;
    }

    public ConfigEntry<String> ENGINE_SHARE_LEVEL() {
        return this.ENGINE_SHARE_LEVEL;
    }

    public ConfigEntry<String> ENGINE_TYPE() {
        return this.ENGINE_TYPE;
    }

    public ConfigEntry<Object> ENGINE_POOL_SIZE_THRESHOLD() {
        return this.ENGINE_POOL_SIZE_THRESHOLD;
    }

    public ConfigEntry<Object> ENGINE_POOL_SIZE() {
        return this.ENGINE_POOL_SIZE;
    }

    public ConfigEntry<Seq<String>> ENGINE_INITIALIZE_SQL() {
        return this.ENGINE_INITIALIZE_SQL;
    }

    public ConfigEntry<Seq<String>> ENGINE_SESSION_INITIALIZE_SQL() {
        return this.ENGINE_SESSION_INITIALIZE_SQL;
    }

    public ConfigEntry<Seq<String>> ENGINE_DEREGISTER_EXCEPTION_CLASSES() {
        return this.ENGINE_DEREGISTER_EXCEPTION_CLASSES;
    }

    public ConfigEntry<Seq<String>> ENGINE_DEREGISTER_EXCEPTION_MESSAGES() {
        return this.ENGINE_DEREGISTER_EXCEPTION_MESSAGES;
    }

    public ConfigEntry<Object> ENGINE_DEREGISTER_JOB_MAX_FAILURES() {
        return this.ENGINE_DEREGISTER_JOB_MAX_FAILURES;
    }

    public ConfigEntry<Object> ENGINE_DEREGISTER_EXCEPTION_TTL() {
        return this.ENGINE_DEREGISTER_EXCEPTION_TTL;
    }

    public OptionalConfigEntry<String> OPERATION_SCHEDULER_POOL() {
        return this.OPERATION_SCHEDULER_POOL;
    }

    public ConfigEntry<Object> ENGINE_SINGLE_SPARK_SESSION() {
        return this.ENGINE_SINGLE_SPARK_SESSION;
    }

    public ConfigEntry<String> SERVER_EVENT_JSON_LOG_PATH() {
        return this.SERVER_EVENT_JSON_LOG_PATH;
    }

    public ConfigEntry<String> ENGINE_EVENT_JSON_LOG_PATH() {
        return this.ENGINE_EVENT_JSON_LOG_PATH;
    }

    public ConfigEntry<Seq<String>> SERVER_EVENT_LOGGERS() {
        return this.SERVER_EVENT_LOGGERS;
    }

    public ConfigEntry<Seq<String>> ENGINE_EVENT_LOGGERS() {
        return this.ENGINE_EVENT_LOGGERS;
    }

    public ConfigEntry<Object> ENGINE_UI_STOP_ENABLED() {
        return this.ENGINE_UI_STOP_ENABLED;
    }

    public ConfigEntry<Object> ENGINE_UI_SESSION_LIMIT() {
        return this.ENGINE_UI_SESSION_LIMIT;
    }

    public ConfigEntry<Object> ENGINE_UI_STATEMENT_LIMIT() {
        return this.ENGINE_UI_STATEMENT_LIMIT;
    }

    public ConfigEntry<String> ENGINE_OPERATION_LOG_DIR_ROOT() {
        return this.ENGINE_OPERATION_LOG_DIR_ROOT;
    }

    public OptionalConfigEntry<String> SESSION_NAME() {
        return this.SESSION_NAME;
    }

    public ConfigEntry<String> OPERATION_PLAN_ONLY() {
        return this.OPERATION_PLAN_ONLY;
    }

    public KyuubiConf apply(boolean loadSysDefault) {
        return new KyuubiConf(loadSysDefault);
    }

    public boolean apply$default$1() {
        return true;
    }

    public Option<Object> unapply(KyuubiConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean((boolean)x$0.loadSysDefault()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$FRONTEND_PROTOCOLS$3(Seq x$6) {
        SortedSet sortedSet = (SortedSet)KyuubiConf$FrontendProtocols$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$));
        return x$6.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)sortedSet.contains((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$AUTHENTICATION_METHOD$3(Seq x$10) {
        SortedSet sortedSet = (SortedSet)AuthTypes$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$));
        return x$10.forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)sortedSet.contains((Object)elem)));
    }

    public static final /* synthetic */ boolean $anonfun$ENGINE_SHARE_LEVEL_SUB_DOMAIN$2(String x$23) {
        return MODULE$.validEngineSubdomain().matcher(x$23).matches();
    }

    public static final /* synthetic */ boolean $anonfun$SERVER_EVENT_LOGGERS$2(Seq x$29) {
        return x$29.toSet().subsetOf((GenSet)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JSON", "JDBC", "CUSTOM"})));
    }

    public static final /* synthetic */ boolean $anonfun$ENGINE_EVENT_LOGGERS$2(Seq x$31) {
        return x$31.toSet().subsetOf((GenSet)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK", "JSON", "JDBC", "CUSTOM"})));
    }

    private KyuubiConf$() {
        MODULE$ = this;
        this.kyuubiConfEntries = Collections.synchronizedMap(new HashMap());
        this.SERVER_PRINCIPAL = this.buildConf("kinit.principal").doc("Name of the Kerberos principal.").version("1.0.0").stringConf().createOptional();
        this.SERVER_KEYTAB = this.buildConf("kinit.keytab").doc("Location of Kyuubi server's keytab.").version("1.0.0").stringConf().createOptional();
        this.KINIT_INTERVAL = this.buildConf("kinit.interval").doc("How often will Kyuubi server run `kinit -kt [keytab] [principal]` to renew the local Kerberos credentials cache").version("1.0.0").timeConf().createWithDefaultString("PT1H");
        this.KINIT_MAX_ATTEMPTS = this.buildConf("kinit.max.attempts").doc("How many times will `kinit` process retry").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)10));
        this.OPERATION_IDLE_TIMEOUT = this.buildConf("operation.idle.timeout").doc("Operation will be closed when it's not accessed for this duration of time").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofHours(3L).toMillis()));
        this.CREDENTIALS_RENEWAL_INTERVAL = this.buildConf("credentials.renewal.interval").doc("How often Kyuubi renews one user's delegation tokens").version("1.4.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofHours(1L).toMillis()));
        this.CREDENTIALS_RENEWAL_RETRY_WAIT = this.buildConf("credentials.renewal.retry.wait").doc("How long to wait before retrying to fetch new credentials after a failure.").version("1.4.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)t -> t > 0L, "must be positive integer").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMinutes(1L).toMillis()));
        this.CREDENTIALS_HADOOP_FS_ENABLED = this.buildConf("credentials.hadoopfs.enabled").doc("Whether to renew Hadoop filesystem delegation tokens").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        TypedConfigBuilder<String> qual$1 = this.buildConf("credentials.hadoopfs.uris").doc("Extra Hadoop filesystem URIs for which to request delegation tokens. The filesystem that hosts fs.defaultFS does not need to be listed here.").version("1.4.0").stringConf();
        String x$1 = qual$1.toSequence$default$1();
        this.CREDENTIALS_HADOOP_FS_URIS = qual$1.toSequence(x$1).createWithDefault((Seq<String>)Nil$.MODULE$);
        this.CREDENTIALS_HIVE_ENABLED = this.buildConf("credentials.hive.enabled").doc("Whether to renew Hive metastore delegation token").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        TypedConfigBuilder<String> qual$2 = this.buildConf("frontend.protocols").doc("A comma separated list for all frontend protocols <ul> <li>THRIFT_BINARY - HiveServer2 compatible thrift binary protocol.</li> <li>REST - Kyuubi defined REST API(experimental).</li>  <li>MYSQL - MySQL compatible text protocol(experimental).</li> </ul>").version("1.4.0").stringConf();
        String x$2 = qual$2.toSequence$default$1();
        this.FRONTEND_PROTOCOLS = qual$2.toSequence(x$2).transform((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toUpperCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom())).checkValue((Function1<Seq<String>, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiConf$.$anonfun$FRONTEND_PROTOCOLS$3(x$6)), new StringBuilder(47).append("the frontend protocol should be one or more of ").append(KyuubiConf$FrontendProtocols$.MODULE$.values().mkString(",")).toString()).createWithDefault((Seq<String>)new .colon.colon((Object)KyuubiConf$FrontendProtocols$.MODULE$.THRIFT_BINARY().toString(), (List)Nil$.MODULE$));
        this.FRONTEND_BIND_HOST = this.buildConf("frontend.bind.host").doc("(deprecated) Hostname or IP of the machine on which to run the thrift frontend service via binary protocol.").version("1.0.0").stringConf().createOptional();
        this.FRONTEND_THRIFT_BINARY_BIND_HOST = this.buildConf("frontend.thrift.binary.bind.host").doc("Hostname or IP of the machine on which to run the thrift frontend service via binary protocol.").version("1.4.0").fallbackConf(this.FRONTEND_BIND_HOST());
        this.FRONTEND_BIND_PORT = this.buildConf("frontend.bind.port").doc("(deprecated) Port of the machine on which to run the thrift frontend service via binary protocol.").version("1.0.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> p == 0 || p > 1024 && p < 65535, "Invalid Port number").createWithDefault(BoxesRunTime.boxToInteger((int)10009));
        this.FRONTEND_THRIFT_BINARY_BIND_PORT = this.buildConf("frontend.thrift.binary.bind.port").doc("Port of the machine on which to run the thrift frontend service via binary protocol.").version("1.4.0").fallbackConf(this.FRONTEND_BIND_PORT());
        this.FRONTEND_MIN_WORKER_THREADS = this.buildConf("frontend.min.worker.threads").doc("(deprecated) Minimum number of threads in the of frontend worker thread pool for the thrift frontend service").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)9));
        this.FRONTEND_THRIFT_MIN_WORKER_THREADS = this.buildConf("frontend.thrift.min.worker.threads").doc("Minimum number of threads in the of frontend worker thread pool for the thrift frontend service").version("1.4.0").fallbackConf(this.FRONTEND_MIN_WORKER_THREADS());
        this.FRONTEND_MAX_WORKER_THREADS = this.buildConf("frontend.max.worker.threads").doc("(deprecated) Maximum number of threads in the of frontend worker thread pool for the thrift frontend service").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)999));
        this.FRONTEND_THRIFT_MAX_WORKER_THREADS = this.buildConf("frontend.thrift.max.worker.threads").doc("Maximum number of threads in the of frontend worker thread pool for the thrift frontend service").version("1.4.0").fallbackConf(this.FRONTEND_MAX_WORKER_THREADS());
        this.FRONTEND_WORKER_KEEPALIVE_TIME = this.buildConf("frontend.worker.keepalive.time").doc("(deprecated) Keep-alive time (in milliseconds) for an idle worker thread").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(60L).toMillis()));
        this.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME = this.buildConf("frontend.thrift.worker.keepalive.time").doc("Keep-alive time (in milliseconds) for an idle worker thread").version("1.4.0").fallbackConf(this.FRONTEND_WORKER_KEEPALIVE_TIME());
        this.FRONTEND_MAX_MESSAGE_SIZE = this.buildConf("frontend.max.message.size").doc("(deprecated) Maximum message size in bytes a Kyuubi server will accept.").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)0x6400000));
        this.FRONTEND_THRIFT_MAX_MESSAGE_SIZE = this.buildConf("frontend.thrift.max.message.size").doc("Maximum message size in bytes a Kyuubi server will accept.").version("1.4.0").fallbackConf(this.FRONTEND_MAX_MESSAGE_SIZE());
        this.FRONTEND_LOGIN_TIMEOUT = this.buildConf("frontend.login.timeout").doc("(deprecated) Timeout for Thrift clients during login to the thrift frontend service.").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(20L).toMillis()));
        this.FRONTEND_THRIFT_LOGIN_TIMEOUT = this.buildConf("frontend.thrift.login.timeout").doc("Timeout for Thrift clients during login to the thrift frontend service.").version("1.4.0").fallbackConf(this.FRONTEND_LOGIN_TIMEOUT());
        this.FRONTEND_LOGIN_BACKOFF_SLOT_LENGTH = this.buildConf("frontend.backoff.slot.length").doc("(deprecated) Time to back off during login to the thrift frontend service.").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMillis(100L).toMillis()));
        this.FRONTEND_THRIFT_LOGIN_BACKOFF_SLOT_LENGTH = this.buildConf("frontend.thrift.backoff.slot.length").doc("Time to back off during login to the thrift frontend service.").version("1.4.0").fallbackConf(this.FRONTEND_LOGIN_BACKOFF_SLOT_LENGTH());
        TypedConfigBuilder<String> qual$3 = this.buildConf("authentication").doc("A comma separated list of client authentication types.<ul> <li>NOSASL: raw transport.</li> <li>NONE: no authentication check.</li> <li>KERBEROS: Kerberos/GSSAPI authentication.</li> <li>CUSTOM: User-defined authentication.</li> <li>LDAP: Lightweight Directory Access Protocol authentication.</li></ul> Note that: For KERBEROS, it is SASL/GSSAPI mechanism, and for NONE, CUSTOM and LDAP, they are all SASL/PLAIN mechanism. If only NOSASL is specified, the authentication will be NOSASL. For SASL authentication, KERBEROS and PLAIN auth type are supported at the same time, and only the first specified PLAIN auth type is valid.").version("1.0.0").stringConf();
        String x$3 = qual$3.toSequence$default$1();
        this.AUTHENTICATION_METHOD = qual$3.toSequence(x$3).transform((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toUpperCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom())).checkValue((Function1<Seq<String>, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KyuubiConf$.$anonfun$AUTHENTICATION_METHOD$3(x$10)), new StringBuilder(49).append("the authentication type should be one or more of ").append(AuthTypes$.MODULE$.values().mkString(",")).toString()).createWithDefault((Seq<String>)new .colon.colon((Object)AuthTypes$.MODULE$.NONE().toString(), (List)Nil$.MODULE$));
        this.AUTHENTICATION_CUSTOM_CLASS = this.buildConf("authentication.custom.class").doc("User-defined authentication implementation of org.apache.kyuubi.service.authentication.PasswdAuthenticationProvider").version("1.3.0").stringConf().createOptional();
        this.AUTHENTICATION_LDAP_URL = this.buildConf("authentication.ldap.url").doc("SPACE character separated LDAP connection URL(s).").version("1.0.0").stringConf().createOptional();
        this.AUTHENTICATION_LDAP_BASEDN = this.buildConf("authentication.ldap.base.dn").doc("LDAP base DN.").version("1.0.0").stringConf().createOptional();
        this.AUTHENTICATION_LDAP_DOMAIN = this.buildConf("authentication.ldap.domain").doc("LDAP domain.").version("1.0.0").stringConf().createOptional();
        this.AUTHENTICATION_LDAP_GUIDKEY = this.buildConf("authentication.ldap.guidKey").doc("LDAP attribute name whose values are unique in this LDAP server.For example:uid or cn.").version("1.2.0").stringConf().createWithDefault("uid");
        this.DELEGATION_KEY_UPDATE_INTERVAL = this.buildConf("delegation.key.update.interval").doc("unused yet").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofDays(1L).toMillis()));
        this.DELEGATION_TOKEN_MAX_LIFETIME = this.buildConf("delegation.token.max.lifetime").doc("unused yet").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofDays(7L).toMillis()));
        this.DELEGATION_TOKEN_GC_INTERVAL = this.buildConf("delegation.token.gc.interval").doc("unused yet").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofHours(1L).toMillis()));
        this.DELEGATION_TOKEN_RENEW_INTERVAL = this.buildConf("delegation.token.renew.interval").doc("unused yet").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofDays(7L).toMillis()));
        this.SASL_QOP = this.buildConf("authentication.sasl.qop").doc("Sasl QOP enable higher levels of protection for Kyuubi communication with clients.<ul> <li>auth - authentication only (default)</li> <li>auth-int - authentication plus integrity protection</li> <li>auth-conf - authentication plus integrity and confidentiality protection. This is applicable only if Kyuubi is configured to use Kerberos authentication.</li> </ul>").version("1.0.0").stringConf().checkValues((Set<String>)((Set)SaslQOP$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$13 -> x$13.toLowerCase(Locale.ROOT)).createWithDefault(SaslQOP$.MODULE$.AUTH().toString());
        this.FRONTEND_REST_BIND_HOST = this.buildConf("frontend.rest.bind.host").doc("Hostname or IP of the machine on which to run the REST frontend service.").version("1.4.0").fallbackConf(this.FRONTEND_BIND_HOST());
        this.FRONTEND_REST_BIND_PORT = this.buildConf("frontend.rest.bind.port").doc("Port of the machine on which to run the REST frontend service.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> p == 0 || p > 1024 && p < 65535, "Invalid Port number").createWithDefault(BoxesRunTime.boxToInteger((int)10099));
        this.FRONTEND_MYSQL_BIND_HOST = this.buildConf("frontend.mysql.bind.host").doc("Hostname or IP of the machine on which to run the MySQL frontend service.").version("1.4.0").fallbackConf(this.FRONTEND_BIND_HOST());
        this.FRONTEND_MYSQL_BIND_PORT = this.buildConf("frontend.mysql.bind.port").doc("Port of the machine on which to run the MySQL frontend service.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> p == 0 || p > 1024 && p < 65535, "Invalid Port number").createWithDefault(BoxesRunTime.boxToInteger((int)3309));
        this.FRONTEND_MYSQL_NETTY_WORKER_THREADS = this.buildConf("frontend.mysql.netty.worker.threads").doc(new StringBuilder(107).append("Number of thread in the netty worker event loop of MySQL frontend service. ").append("Use min(cpu_cores, ").append(NettyUtils$.MODULE$.MAX_NETTY_THREADS()).append(") in default.").toString()).version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)n -> n > 0 && n <= NettyUtils$.MODULE$.MAX_NETTY_THREADS(), new StringBuilder(36).append("Invalid thread number, must in (0, ").append(NettyUtils$.MODULE$.MAX_NETTY_THREADS()).append("]").toString()).createOptional();
        this.FRONTEND_MYSQL_MIN_WORKER_THREADS = this.buildConf("frontend.mysql.min.worker.threads").doc("Minimum number of threads in the command execution thread pool for the MySQL frontend service").version("1.4.0").fallbackConf(this.FRONTEND_MIN_WORKER_THREADS());
        this.FRONTEND_MYSQL_MAX_WORKER_THREADS = this.buildConf("frontend.mysql.max.worker.threads").doc("Maximum number of threads in the command execution thread pool for the MySQL frontend service").version("1.4.0").fallbackConf(this.FRONTEND_MAX_WORKER_THREADS());
        this.FRONTEND_MYSQL_WORKER_KEEPALIVE_TIME = this.buildConf("frontend.mysql.worker.keepalive.time").doc("Time(ms) that an idle async thread of the command execution thread pool will wait for a new task to arrive before terminating in MySQL frontend service").version("1.4.0").fallbackConf(this.FRONTEND_WORKER_KEEPALIVE_TIME());
        this.ENGINE_ERROR_MAX_SIZE = this.buildConf("session.engine.startup.error.max.size").doc("During engine bootstrapping, if error occurs, using this config to limit the length error message(characters).").version("1.1.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)v -> v >= 200 && v <= 8192, "must in [200, 8192]").createWithDefault(BoxesRunTime.boxToInteger((int)8192));
        this.ENGINE_LOG_TIMEOUT = this.buildConf("session.engine.log.timeout").doc("If we use Spark as the engine then the session submit log is the console output of spark-submit. We will retain the session submit log until over the config value.").version("1.1.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$14 -> x$14 > 0L, "must be positive number").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofDays(1L).toMillis()));
        this.ENGINE_SPARK_MAIN_RESOURCE = this.buildConf("session.engine.spark.main.resource").doc("The package used to create Spark SQL engine remote application. If it is undefined, Kyuubi will use the default").version("1.0.0").stringConf().createOptional();
        this.ENGINE_LOGIN_TIMEOUT = this.buildConf("session.engine.login.timeout").doc("The timeout of creating the connection to remote sql query engine").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(15L).toMillis()));
        this.ENGINE_REQUEST_TIMEOUT = this.buildConf("session.engine.request.timeout").doc("The timeout of awaiting response after sending request to remote sql query engine").version("1.4.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(60L).toMillis()));
        this.ENGINE_INIT_TIMEOUT = this.buildConf("session.engine.initialize.timeout").doc("Timeout for starting the background engine, e.g. SparkSQLEngine.").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(180L).toMillis()));
        this.SESSION_CHECK_INTERVAL = this.buildConf("session.check.interval").doc("The check interval for session timeout.").version("1.0.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$15 -> x$15 > Duration.ofSeconds(3L).toMillis(), "Minimum 3 seconds").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMinutes(5L).toMillis()));
        this.SESSION_TIMEOUT = this.buildConf("session.timeout").doc("(deprecated)session timeout, it will be closed when it's not accessed for this duration").version("1.0.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$16 -> x$16 >= Duration.ofSeconds(3L).toMillis(), "Minimum 3 seconds").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofHours(6L).toMillis()));
        this.SESSION_IDLE_TIMEOUT = this.buildConf("session.idle.timeout").doc("session idle timeout, it will be closed when it's not accessed for this duration").version("1.2.0").fallbackConf(this.SESSION_TIMEOUT());
        this.ENGINE_CHECK_INTERVAL = this.buildConf("session.engine.check.interval").doc("The check interval for engine timeout").version("1.0.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$17 -> x$17 >= Duration.ofSeconds(3L).toMillis(), "Minimum 3 seconds").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMinutes(5L).toMillis()));
        this.ENGINE_IDLE_TIMEOUT = this.buildConf("session.engine.idle.timeout").doc("engine timeout, the engine will self-terminate when it's not accessed for this duration").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMinutes(30L).toMillis()));
        TypedConfigBuilder<String> qual$4 = this.buildConf("session.conf.ignore.list").doc("A comma separated list of ignored keys. If the client connection contains any of them, the key and the corresponding value will be removed silently during engine bootstrap and connection setup. Note that this rule is for server-side protection defined via administrators to prevent some essential configs from tampering but will not forbid users to set dynamic configurations via SET syntax.").version("1.2.0").stringConf();
        String x$42 = qual$4.toSequence$default$1();
        this.SESSION_CONF_IGNORE_LIST = qual$4.toSequence(x$42).createWithDefault((Seq<String>)Nil$.MODULE$);
        TypedConfigBuilder<String> qual$5 = this.buildConf("session.conf.restrict.list").doc("A comma separated list of restricted keys. If the client connection contains any of them, the connection will be rejected explicitly during engine bootstrap and connection setup. Note that this rule is for server-side protection defined via administrators to prevent some essential configs from tampering but will not forbid users to set dynamic configurations via SET syntax.").version("1.2.0").stringConf();
        String x$5 = qual$5.toSequence$default$1();
        this.SESSION_CONF_RESTRICT_LIST = qual$5.toSequence(x$5).createWithDefault((Seq<String>)Nil$.MODULE$);
        this.SESSION_ENGINE_STARTUP_MAX_LOG_LINES = this.buildConf("session.engine.startup.maxLogLines").doc("The maximum number of engine log lines when errors occur during engine startup phase. Note that this max lines is for client-side to help track engine startup issue.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$18 -> x$18 > 0, "the maximum must be positive integer.").createWithDefault(BoxesRunTime.boxToInteger((int)10));
        this.SESSION_ENGINE_LAUNCH_ASYNC = this.buildConf("session.engine.launch.async").doc("When opening kyuubi session, whether to launch backend engine asynchronously. When true, the Kyuubi server will set up the connection with the client without delay as the backend engine will be created asynchronously.").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SERVER_EXEC_POOL_SIZE = this.buildConf("backend.server.exec.pool.size").doc("Number of threads in the operation execution thread pool of Kyuubi server").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)100));
        this.ENGINE_EXEC_POOL_SIZE = this.buildConf("backend.engine.exec.pool.size").doc("Number of threads in the operation execution thread pool of SQL engine applications").version("1.0.0").fallbackConf(this.SERVER_EXEC_POOL_SIZE());
        this.SERVER_EXEC_WAIT_QUEUE_SIZE = this.buildConf("backend.server.exec.pool.wait.queue.size").doc("Size of the wait queue for the operation execution thread pool of Kyuubi server").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)100));
        this.ENGINE_EXEC_WAIT_QUEUE_SIZE = this.buildConf("backend.engine.exec.pool.wait.queue.size").doc("Size of the wait queue for the operation execution thread pool in SQL engine applications").version("1.0.0").fallbackConf(this.SERVER_EXEC_WAIT_QUEUE_SIZE());
        this.SERVER_EXEC_KEEPALIVE_TIME = this.buildConf("backend.server.exec.pool.keepalive.time").doc("Time(ms) that an idle async thread of the operation execution thread pool will wait for a new task to arrive before terminating in Kyuubi server").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(60L).toMillis()));
        this.ENGINE_EXEC_KEEPALIVE_TIME = this.buildConf("backend.engine.exec.pool.keepalive.time").doc("Time(ms) that an idle async thread of the operation execution thread pool will wait for a new task to arrive before terminating in SQL engine applications").version("1.0.0").fallbackConf(this.SERVER_EXEC_KEEPALIVE_TIME());
        this.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT = this.buildConf("backend.server.exec.pool.shutdown.timeout").doc("Timeout(ms) for the operation execution thread pool to terminate in Kyuubi server").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(10L).toMillis()));
        this.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT = this.buildConf("backend.engine.exec.pool.shutdown.timeout").doc("Timeout(ms) for the operation execution thread pool to terminate in SQL engine applications").version("1.0.0").fallbackConf(this.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT());
        this.OPERATION_STATUS_POLLING_TIMEOUT = this.buildConf("operation.status.polling.timeout").doc("Timeout(ms) for long polling asynchronous running sql query's status").version("1.0.0").timeConf().createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()));
        this.OPERATION_STATUS_POLLING_MAX_ATTEMPTS = this.buildConf("operation.status.polling.max.attempts").doc("Max attempts for long polling asynchronous running sql query's status on raw transport failures, e.g. TTransportException").version("1.4.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)5));
        this.OPERATION_FORCE_CANCEL = this.buildConf("operation.interrupt.on.cancel").doc("When true, all running tasks will be interrupted if one cancels a query. When false, all running tasks will remain until finished.").version("1.2.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.OPERATION_QUERY_TIMEOUT = this.buildConf("operation.query.timeout").doc(new StringBuilder(443).append("Timeout for query executions at server-side, take affect with client-side timeout(`java.sql.Statement.setQueryTimeout`) together, a running query will be cancelled automatically if timeout. It's off by default, which means only client-side take fully control whether the query should timeout or not. If set, client-side timeout capped at this point. To cancel the queries right away without waiting task to finish, consider").append(" enabling ").append(this.OPERATION_FORCE_CANCEL().key()).append(" together.").toString()).version("1.2.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$19 -> x$19 >= 1000L, "must >= 1s if set").createOptional();
        this.OPERATION_INCREMENTAL_COLLECT = this.buildConf("operation.incremental.collect").internal().doc("When true, the executor side result will be sequentially calculated and returned to the Spark driver side.").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SERVER_OPERATION_LOG_DIR_ROOT = this.buildConf("operation.log.dir.root").doc("Root directory for query operation log at server-side.").version("1.4.0").stringConf().createWithDefault("server_operation_logs");
        this.LEGACY_ENGINE_SHARE_LEVEL = this.buildConf("session.engine.share.level").doc("(deprecated) - Using kyuubi.engine.share.level instead").version("1.0.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$20 -> x$20.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)ShareLevel$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(ShareLevel$.MODULE$.USER().toString());
        this.validEngineSubdomain = new StringOps(Predef$.MODULE$.augmentString("(?!^[\\u002e]{1,2}$)(^[\\u0020-\\u002e\\u0030-\\u007e\\u00a0-\\ud7ff\\uf900-\\uffef]{1,}$)")).r().pattern();
        this.ENGINE_SHARE_LEVEL_SUB_DOMAIN = this.buildConf("engine.share.level.sub.domain").doc("(deprecated) - Using kyuubi.engine.share.level.subdomain instead").version("1.2.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$22 -> x$22.toLowerCase(Locale.ROOT)).checkValue((Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)KyuubiConf$.$anonfun$ENGINE_SHARE_LEVEL_SUB_DOMAIN$2(x$23)), "must be valid zookeeper sub path.").createOptional();
        this.ENGINE_SHARE_LEVEL_SUBDOMAIN = this.buildConf("engine.share.level.subdomain").doc("Allow end-users to create a subdomain for the share level of an engine. A subdomain is a case-insensitive string values that must be a valid zookeeper sub path. For example, for `USER` share level, an end-user can share a certain engine within a subdomain, not for all of its clients. End-users are free to create multiple engines in the `USER` share level. When disable engine pool, use 'default' if absent.").version("1.4.0").fallbackConf(this.ENGINE_SHARE_LEVEL_SUB_DOMAIN());
        this.ENGINE_CONNECTION_URL_USE_HOSTNAME = this.buildConf("engine.connection.url.use.hostname").doc("When true, engine register with hostname to zookeeper. When spark run on k8s with cluster mode, set to false to ensure that server can connect to engine").version("1.3.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENGINE_SHARE_LEVEL = this.buildConf("engine.share.level").doc(new StringBuilder(770).append("Engines will be shared in different levels, available configs are: <ul> <li>CONNECTION: engine will not be shared but only used by the current client connection</li> <li>USER: engine will be shared by all sessions created by a unique username,").append(" see also ").append(this.ENGINE_SHARE_LEVEL_SUBDOMAIN().key()).append("</li>").append(" <li>GROUP: engine will be shared by all sessions created by all users belong to the same").append(" primary group name. The engine will be launched by the group name as the effective").append(" username, so here the group name is kind of special user who is able to visit the").append(" compute resources/data of a team. It follows the").append(" [Hadoop GroupsMapping](https://reurl.cc/xE61Y5) to map user to a primary group. If the").append(" primary group is not found, it fallback to the USER level.").append(" <li>SERVER: the App will be shared by Kyuubi servers</li></ul>").toString()).version("1.2.0").fallbackConf(this.LEGACY_ENGINE_SHARE_LEVEL());
        this.ENGINE_TYPE = this.buildConf("engine.type").doc("Specify the detailed engine that supported by the Kyuubi. The engine type bindings to SESSION scope. This configuration is experimental. Currently, available configs are: <ul> <li>SPARK_SQL: specify this engine type will launch a Spark engine which can provide all the capacity of the Apache Spark. Note, it's a default engine type.</li> <li>FLINK_SQL: specify this engine type will launch a Flink engine which can provide all the capacity of the Apache Flink.</li></ul>").version("1.4.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$24 -> x$24.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)EngineType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(EngineType$.MODULE$.SPARK_SQL().toString());
        this.ENGINE_POOL_SIZE_THRESHOLD = this.buildConf("engine.pool.size.threshold").doc("This parameter is introduced as a server-side parameter, and controls the upper limit of the engine pool.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)s -> s > 0 && s < 33, "Invalid engine pool threshold, it should be in [1, 32]").createWithDefault(BoxesRunTime.boxToInteger((int)9));
        this.ENGINE_POOL_SIZE = this.buildConf("engine.pool.size").doc(new StringBuilder(160).append("The size of engine pool. Note that, if the size is less than 1, the engine pool will not be enabled; otherwise, the size of the engine pool will be ").append("min(this, ").append(this.ENGINE_POOL_SIZE_THRESHOLD().key()).append(").").toString()).version("1.4.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)-1));
        this.ENGINE_INITIALIZE_SQL = this.buildConf("engine.initialize.sql").doc("SemiColon-separated list of SQL statements to be initialized in the newly created engine before queries. i.e. use `SHOW DATABASES` to eagerly active HiveClient. This configuration can not be used in JDBC url due to the limitation of Beeline/JDBC driver.").version("1.2.0").stringConf().toSequence(";").createWithDefaultString("SHOW DATABASES");
        this.ENGINE_SESSION_INITIALIZE_SQL = this.buildConf("engine.session.initialize.sql").doc("SemiColon-separated list of SQL statements to be initialized in the newly created engine session before queries. This configuration can not be used in JDBC url due to the limitation of Beeline/JDBC driver.").version("1.3.0").stringConf().toSequence(";").createWithDefault((Seq<String>)Nil$.MODULE$);
        TypedConfigBuilder<String> qual$6 = this.buildConf("engine.deregister.exception.classes").doc("A comma separated list of exception classes. If there is any exception thrown, whose class matches the specified classes, the engine would deregister itself.").version("1.2.0").stringConf();
        String x$62 = qual$6.toSequence$default$1();
        this.ENGINE_DEREGISTER_EXCEPTION_CLASSES = qual$6.toSequence(x$62).createWithDefault((Seq<String>)Nil$.MODULE$);
        TypedConfigBuilder<String> qual$7 = this.buildConf("engine.deregister.exception.messages").doc("A comma separated list of exception messages. If there is any exception thrown, whose message or stacktrace matches the specified message list, the engine would deregister itself.").version("1.2.0").stringConf();
        String x$7 = qual$7.toSequence$default$1();
        this.ENGINE_DEREGISTER_EXCEPTION_MESSAGES = qual$7.toSequence(x$7).createWithDefault((Seq<String>)Nil$.MODULE$);
        this.ENGINE_DEREGISTER_JOB_MAX_FAILURES = this.buildConf("engine.deregister.job.max.failures").doc("Number of failures of job before deregistering the engine.").version("1.2.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$26 -> x$26 > 0, "must be positive number").createWithDefault(BoxesRunTime.boxToInteger((int)4));
        this.ENGINE_DEREGISTER_EXCEPTION_TTL = this.buildConf("engine.deregister.exception.ttl").doc(new StringBuilder(275).append("Time to live(TTL) for exceptions pattern specified in").append(" ").append(this.ENGINE_DEREGISTER_EXCEPTION_CLASSES().key()).append(" and").append(" ").append(this.ENGINE_DEREGISTER_EXCEPTION_MESSAGES().key()).append(" to deregister engines. Once the total").append(" error count hits the ").append(this.ENGINE_DEREGISTER_JOB_MAX_FAILURES().key()).append(" within the TTL, an").append(" engine will deregister itself and wait for self-terminated. Otherwise, we suppose").append(" that the engine has recovered from temporary failures.").toString()).version("1.2.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$27 -> x$27 > 0L, "must be positive number").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofMinutes(30L).toMillis()));
        this.OPERATION_SCHEDULER_POOL = this.buildConf("operation.scheduler.pool").doc("The scheduler pool of job. Note that, this config should be used after change Spark config spark.scheduler.mode=FAIR.").version("1.1.1").stringConf().createOptional();
        this.ENGINE_SINGLE_SPARK_SESSION = this.buildConf("engine.single.spark.session").doc("When set to true, this engine is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").version("1.3.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SERVER_EVENT_JSON_LOG_PATH = this.buildConf("backend.server.event.json.log.path").doc("The location of server events go for the builtin JSON logger").version("1.4.0").stringConf().createWithDefault("file:///tmp/kyuubi/events");
        this.ENGINE_EVENT_JSON_LOG_PATH = this.buildConf("engine.event.json.log.path").doc("The location of all the engine events go for the builtin JSON logger.<ul><li>Local Path: start with 'file://'</li><li>HDFS Path: start with 'hdfs://'</li></ul>").version("1.3.0").stringConf().createWithDefault("file:///tmp/kyuubi/events");
        TypedConfigBuilder<String> qual$8 = this.buildConf("backend.server.event.loggers").doc(new StringBuilder(214).append("A comma separated list of server history loggers, where session/operation etc events go.<ul>").append(" <li>JSON: the events will be written to the location of").append(" ").append(this.SERVER_EVENT_JSON_LOG_PATH().key()).append("</li>").append(" <li>JDBC: to be done</li>").append(" <li>CUSTOM: to be done.</li></ul>").toString()).version("1.4.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$28 -> x$28.toUpperCase(Locale.ROOT));
        String x$82 = qual$8.toSequence$default$1();
        this.SERVER_EVENT_LOGGERS = qual$8.toSequence(x$82).checkValue((Function1<Seq<String>, Object>)(Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)KyuubiConf$.$anonfun$SERVER_EVENT_LOGGERS$2(x$29)), "Unsupported event loggers").createWithDefault((Seq<String>)Nil$.MODULE$);
        TypedConfigBuilder<String> qual$9 = this.buildConf("engine.event.loggers").doc(new StringBuilder(323).append("A comma separated list of engine history loggers, where engine/session/operation etc events go. We use spark logger by default.<ul> <li>SPARK: the events will be written to the spark listener bus.</li>").append(" <li>JSON: the events will be written to the location of").append(" ").append(this.ENGINE_EVENT_JSON_LOG_PATH().key()).append("</li>").append(" <li>JDBC: to be done</li>").append(" <li>CUSTOM: to be done.</li></ul>").toString()).version("1.3.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$30 -> x$30.toUpperCase(Locale.ROOT));
        String x$9 = qual$9.toSequence$default$1();
        this.ENGINE_EVENT_LOGGERS = qual$9.toSequence(x$9).checkValue((Function1<Seq<String>, Object>)(Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)KyuubiConf$.$anonfun$ENGINE_EVENT_LOGGERS$2(x$31)), "Unsupported event loggers").createWithDefault((Seq<String>)new .colon.colon((Object)"SPARK", (List)Nil$.MODULE$));
        this.ENGINE_UI_STOP_ENABLED = this.buildConf("engine.ui.stop.enabled").doc("When true, allows Kyuubi engine to be killed from the Spark Web UI.").version("1.3.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENGINE_UI_SESSION_LIMIT = this.buildConf("engine.ui.retainedSessions").doc("The number of SQL client sessions kept in the Kyuubi Query Engine web UI.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$32 -> x$32 > 0, "retained sessions must be positive.").createWithDefault(BoxesRunTime.boxToInteger((int)200));
        this.ENGINE_UI_STATEMENT_LIMIT = this.buildConf("engine.ui.retainedStatements").doc("The number of statements kept in the Kyuubi Query Engine web UI.").version("1.4.0").intConf().checkValue((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$33 -> x$33 > 0, "retained statements must be positive.").createWithDefault(BoxesRunTime.boxToInteger((int)200));
        this.ENGINE_OPERATION_LOG_DIR_ROOT = this.buildConf("engine.operation.log.dir.root").doc("Root directory for query operation log at engine-side.").version("1.4.0").stringConf().createWithDefault("engine_operation_logs");
        this.SESSION_NAME = this.buildConf("session.name").doc("A human readable name of session and we use empty string by default. This name will be recorded in event. Note that, we only apply this value from session conf.").version("1.4.0").stringConf().createOptional();
        this.OPERATION_PLAN_ONLY = this.buildConf("operation.plan.only.mode").doc("Whether to perform the statement in a PARSE, ANALYZE, OPTIMIZE only way without executing the query. When it is NONE, the statement will be fully executed").version("1.4.0").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$34 -> x$34.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)KyuubiConf$OperationModes$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(KyuubiConf$OperationModes$.MODULE$.NONE().toString());
    }
}

