/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.kyuubi.shade.org.apache.hive.service.Service;
import org.apache.kyuubi.shade.org.apache.hive.service.ServiceOperations;
import org.apache.kyuubi.shade.org.apache.hive.service.ServiceStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private Service.STATE state = Service.STATE.NOTINITED;
    private final String name;
    private long startTime;
    protected HiveConf hiveConf;
    private final List<ServiceStateChangeListener> listeners = new ArrayList<ServiceStateChangeListener>();

    public AbstractService(String name) {
        this.name = name;
    }

    @Override
    public synchronized Service.STATE getServiceState() {
        return this.state;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.ensureCurrentState(Service.STATE.NOTINITED);
        this.hiveConf = hiveConf;
        this.changeState(Service.STATE.INITED);
        LOG.info("Service:" + this.getName() + " is inited.");
    }

    @Override
    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
        this.ensureCurrentState(Service.STATE.INITED);
        this.changeState(Service.STATE.STARTED);
        LOG.info("Service:" + this.getName() + " is started.");
    }

    @Override
    public synchronized void stop() {
        if (this.state == Service.STATE.STOPPED || this.state == Service.STATE.INITED || this.state == Service.STATE.NOTINITED) {
            return;
        }
        this.ensureCurrentState(Service.STATE.STARTED);
        this.changeState(Service.STATE.STOPPED);
        LOG.info("Service:" + this.getName() + " is stopped.");
    }

    @Override
    public synchronized void register(ServiceStateChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void unregister(ServiceStateChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized HiveConf getHiveConf() {
        return this.hiveConf;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    private void ensureCurrentState(Service.STATE currentState) {
        ServiceOperations.ensureCurrentState(this.state, currentState);
    }

    private void changeState(Service.STATE newState) {
        this.state = newState;
        for (ServiceStateChangeListener l : this.listeners) {
            l.stateChanged(this);
        }
    }
}

