/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation;

import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.TOperationState;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.events.KyuubiStatementEvent$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationType$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.server.EventLoggingService$;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionManager;
import org.apache.thrift.TException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\f\u0018\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tW\u0001\u0011)\u0019!C!Y!A!\b\u0001B\u0001B\u0003%Q\u0006\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0011=\u0011!\t\u0005A!A!\u0002\u0013i\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u0019\u0003A\u0011A$\t\u000f5\u0003!\u0019!C\u0007\u001d\"1Q\u000b\u0001Q\u0001\u000e=CqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0017\u0005\u00069\u0002!\t%\u0018\u0005\u0006C\u0002!\tE\u0019\u0005\u0006M\u0002!\tF\u0019\u0005\u0006O\u0002!IA\u0019\u0005\u0006Q\u0002!IA\u0019\u0005\u0006S\u0002!IA\u0019\u0005\u0006U\u0002!IA\u0019\u0005\u0006W\u0002!\tF\u0019\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006\u007f\u0002!\tE\u0019\u0002\u0011\u000bb,7-\u001e;f'R\fG/Z7f]RT!\u0001G\r\u0002\u0013=\u0004XM]1uS>t'B\u0001\u000e\u001c\u0003\u0019Y\u00170^;cS*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t\u001aS\"A\f\n\u0005\u0011:\"aD&zkV\u0014\u0017n\u00149fe\u0006$\u0018n\u001c8\u0002\u000fM,7o]5p]B\u0011q%K\u0007\u0002Q)\u0011Q%G\u0005\u0003U!\u0012qaU3tg&|g.A\u0005ti\u0006$X-\\3oiV\tQ\u0006\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003e}\ta\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u0015M$\u0018\r^3nK:$\b%\u0001\btQ>,H\u000e\u001a*v]\u0006\u001b\u0018P\\2\u0016\u0003u\u0002\"AP \u000e\u0003MJ!\u0001Q\u001a\u0003\u000f\t{w\u000e\\3b]\u0006y1\u000f[8vY\u0012\u0014VO\\!ts:\u001c\u0007%\u0001\u0007rk\u0016\u0014\u0018\u0010V5nK>,H\u000f\u0005\u0002?\t&\u0011Qi\r\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011&S5\n\u0014\t\u0003E\u0001AQ!J\u0004A\u0002\u0019BQaK\u0004A\u00025BQaO\u0004A\u0002uBQAQ\u0004A\u0002\r\u000bQbX8qKJ\fG/[8o\u0019><W#A(\u0011\u0005A\u001bV\"A)\u000b\u0005I;\u0012a\u00017pO&\u0011A+\u0015\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\u000f?>\u0004XM]1uS>tGj\\4!\u0003Yi\u0017\r_*uCR,8\u000fU8mY>sg)Y5mkJ,W#\u0001-\u0011\u0005yJ\u0016B\u0001.4\u0005\rIe\u000e^\u0001\u0018[\u0006D8\u000b^1ukN\u0004v\u000e\u001c7P]\u001a\u000b\u0017\u000e\\;sK\u0002\nqbZ3u\u001fB,'/\u0019;j_:dunZ\u000b\u0002=B\u0019ahX(\n\u0005\u0001\u001c$AB(qi&|g.A\u0005cK\u001a|'/\u001a*v]R\t1\r\u0005\u0002?I&\u0011Qm\r\u0002\u0005+:LG/\u0001\u0005bMR,'OU;o\u0003A)\u00070Z2vi\u0016\u001cF/\u0019;f[\u0016tG/A\u000bxC&$8\u000b^1uK6,g\u000e^\"p[BdW\r^3\u0002/M,g\u000eZ\"sK\u0012,g\u000e^5bYNLeMT3fI\u0016$\u0017!\u00044fi\u000eD\u0017+^3ss2{w-A\u0006sk:Le\u000e^3s]\u0006d\u0017\u0001C:fiN#\u0018\r^3\u0015\u0005\rt\u0007\"B8\u0015\u0001\u0004\u0001\u0018\u0001\u00038foN#\u0018\r^3\u0011\u0005EdhB\u0001:{\u001d\t\u0019\u0018P\u0004\u0002uq:\u0011Qo\u001e\b\u0003aYL\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012BA>\u0018\u00039y\u0005/\u001a:bi&|gn\u0015;bi\u0016L!! @\u0003\u001d=\u0003XM]1uS>t7\u000b^1uK*\u00111pF\u0001\u0006G2|7/\u001a")
public class ExecuteStatement
extends KyuubiOperation {
    private final Session session;
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final OperationLog _operationLog;
    private final int maxStatusPollOnFailure;

    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private final OperationLog _operationLog() {
        return this._operationLog;
    }

    private int maxStatusPollOnFailure() {
        return this.maxStatusPollOnFailure;
    }

    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this._operationLog());
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this._operationLog());
        this.setHasResultSet(true);
        this.setState(OperationState$.MODULE$.PENDING());
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    private void executeStatement() {
        try {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                ExecuteStatement.$anonfun$executeStatement$1(ms);
                return BoxedUnit.UNIT;
            });
            this._remoteOpHandle_$eq(this.client().executeStatement(this.statement(), true, this.queryTimeout));
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
    }

    private void waitStatementComplete() {
        try {
            this.setState(OperationState$.MODULE$.RUNNING());
            ObjectRef statusResp = ObjectRef.create(null);
            IntRef currentAttempts = IntRef.create((int)0);
            while ((TGetOperationStatusResp)statusResp.elem == null) {
                this.fetchOperationStatusWithRetry$1(statusResp, currentAttempts);
            }
            boolean isComplete = false;
            while (!isComplete) {
                BoxedUnit boxedUnit;
                this.fetchQueryLog();
                this.verifyTStatus(((TGetOperationStatusResp)statusResp.elem).getStatus());
                TOperationState remoteState = ((TGetOperationStatusResp)statusResp.elem).getOperationState();
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Query[").append(this.statementId()).append("] in ").append(remoteState.name()).toString());
                isComplete = true;
                TOperationState tOperationState = remoteState;
                boolean bl = TOperationState.INITIALIZED_STATE.equals(tOperationState) ? true : (TOperationState.PENDING_STATE.equals(tOperationState) ? true : TOperationState.RUNNING_STATE.equals(tOperationState));
                if (bl) {
                    isComplete = false;
                    this.fetchOperationStatusWithRetry$1(statusResp, currentAttempts);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (TOperationState.FINISHED_STATE.equals(tOperationState)) {
                    this.setState(OperationState$.MODULE$.FINISHED());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (TOperationState.CLOSED_STATE.equals(tOperationState)) {
                    this.setState(OperationState$.MODULE$.CLOSED());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (TOperationState.CANCELED_STATE.equals(tOperationState)) {
                    this.setState(OperationState$.MODULE$.CANCELED());
                    boxedUnit = BoxedUnit.UNIT;
                } else if (TOperationState.TIMEDOUT_STATE.equals(tOperationState)) {
                    this.setState(OperationState$.MODULE$.TIMEOUT());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (TOperationState.ERROR_STATE.equals(tOperationState)) {
                        throw KyuubiSQLException$.MODULE$.apply(((TGetOperationStatusResp)statusResp.elem).getErrorMessage(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    if (TOperationState.UKNOWN_STATE.equals(tOperationState)) {
                        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(18).append("UNKNOWN STATE for ").append(this.statement()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                    }
                    throw new MatchError((Object)tOperationState);
                }
                this.sendCredentialsIfNeeded();
            }
            this.fetchQueryLog();
        }
        catch (Throwable x$2) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$2 = this.onError(this.onError$default$1());
            if (catchExpr$2.isDefinedAt((Object)x$2)) {
                catchExpr$2.apply((Object)x$2);
            }
            throw x$2;
        }
    }

    private void sendCredentialsIfNeeded() {
        String appUser = ((KyuubiSessionImpl)this.session).engine().appUser();
        KyuubiSessionManager sessionManager = (KyuubiSessionManager)this.session.sessionManager();
        sessionManager.credentialsManager().sendCredentialsIfNeeded(this.session.handle().identifier().toString(), appUser, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)encodedCredentials -> {
            ExecuteStatement.$anonfun$sendCredentialsIfNeeded$1(this, encodedCredentials);
            return BoxedUnit.UNIT;
        });
    }

    private void fetchQueryLog() {
        this.getOperationLog().foreach((Function1 & Serializable & scala.Serializable)logger -> {
            ExecuteStatement.$anonfun$fetchQueryLog$1(this, logger);
            return BoxedUnit.UNIT;
        });
    }

    public void runInternal() {
        block3: {
            Object object;
            this.executeStatement();
            SessionManager sessionManager = this.session.sessionManager();
            Runnable asyncOperation = () -> this.waitStatementComplete();
            try {
                Future opHandle = sessionManager.submitBackgroundOperation(asyncOperation);
                this.setBackgroundHandle(opHandle);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable x$3) {
                PartialFunction<Throwable, BoxedUnit> catchExpr$3 = this.onError("submitting query in background, query rejected");
                if (catchExpr$3.isDefinedAt((Object)x$3)) {
                    object = catchExpr$3.apply((Object)x$3);
                }
                throw x$3;
            }
            if (this.shouldRunAsync()) break block3;
            this.getBackgroundHandle().get();
        }
    }

    public void setState(Enumeration.Value newState) {
        super.setState(newState);
        EventLoggingService$.MODULE$.onEvent(KyuubiStatementEvent$.MODULE$.apply(this));
    }

    @Override
    public void close() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.decCount(MetricsConstants$.MODULE$.STATEMENT_OPEN());
            return BoxedUnit.UNIT;
        });
        super.close();
    }

    public static final /* synthetic */ void $anonfun$executeStatement$1(MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.STATEMENT_OPEN());
        ms.incCount(MetricsConstants$.MODULE$.STATEMENT_TOTAL());
    }

    private final void fetchOperationStatusWithRetry$1(ObjectRef statusResp$1, IntRef currentAttempts$1) {
        try {
            statusResp$1.elem = this.client().getOperationStatus(this._remoteOpHandle());
            currentAttempts$1.elem = 0;
        }
        catch (TException tException) {
            if (currentAttempts$1.elem >= this.maxStatusPollOnFailure()) {
                this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Failed to get ").append($this.session.user()).append("'s query[").append(this.getHandle()).append("] status after").append(" ").append(this.maxStatusPollOnFailure()).append(" times, aborting").toString(), tException);
                throw tException;
            }
            ++currentAttempts$1.elem;
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed to get ").append($this.session.user()).append("'s query[").append(this.getHandle()).append("] status").append(" (").append(currentAttempts$1.elem).append(" / ").append(this.maxStatusPollOnFailure()).append(")").toString(), tException);
            Thread.sleep(100L);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$sendCredentialsIfNeeded$1(ExecuteStatement $this, String encodedCredentials) {
        $this.client().sendCredentials(encodedCredentials);
    }

    public static final /* synthetic */ void $anonfun$fetchQueryLog$1(ExecuteStatement $this, OperationLog logger) {
        try {
            TRowSet ret = $this.client().fetchResults($this._remoteOpHandle(), FetchOrientation$.MODULE$.FETCH_NEXT(), 1000, true);
            Buffer logs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((TColumn)ret.getColumns().get(0)).getStringVal().getValues()).asScala();
            logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
                logger.write(new StringBuilder(1).append(log).append("\n").toString());
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {}
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout) {
        this.session = session;
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        super(OperationType$.MODULE$.EXECUTE_STATEMENT(), session);
        EventLoggingService$.MODULE$.onEvent(KyuubiStatementEvent$.MODULE$.apply(this));
        this._operationLog = shouldRunAsync ? OperationLog$.MODULE$.createOperationLog(session, this.getHandle()) : null;
        this.maxStatusPollOnFailure = BoxesRunTime.unboxToInt((Object)session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_STATUS_POLLING_MAX_ATTEMPTS()));
    }
}

