/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.ZooKeeperClientProvider$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.server.EventLoggingService$;
import org.apache.kyuubi.service.authentication.PlainSASLHelper$;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0016,\u0001QB\u0011\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f$\t\u0013\u001d\u0003!\u0011!Q\u0001\n!+\u0006\"\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002%X\u0011%A\u0006A!A!\u0002\u0013A\u0015\fC\u0005[\u0001\t\u0005\t\u0015!\u0003\\=\"Aq\f\u0001BC\u0002\u0013\u0005\u0003\rC\u0005e\u0001\t\u0005\t\u0015!\u0003bK\"Aa\r\u0001B\u0001B\u0003%q\rC\u0003n\u0001\u0011\u0005a\u000eC\u0004x\u0001\t\u0007I\u0011\u0001=\t\ry\u0004\u0001\u0015!\u0003z\u0011!y\bA1A\u0005\u0002\u0005\u0005\u0001\u0002CA\u0006\u0001\u0001\u0006I!a\u0001\t\u0015\u00055\u0001A1A\u0005\u00025\ny\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011%\ty\u0002\u0001a\u0001\n\u0003\t\t\u0001C\u0005\u0002\"\u0001\u0001\r\u0011\"\u0001\u0002$!A\u0011q\u0006\u0001!B\u0013\t\u0019\u0001C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011\u0011\n\u0001!\u0002\u0013\ti\u0004C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\n\u00055\u0003bCA.\u0001\u0001\u0007\t\u0019!C\u0005\u0003;B1\"!\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002P!Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011BA3\u0011-\t\u0019\b\u0001a\u0001\u0002\u0004%I!!\u001e\t\u0017\u0005e\u0004\u00011A\u0001B\u0003&\u0011q\r\u0005\b\u0003[\u0002A\u0011AA3\u0011%\tY\b\u0001b\u0001\n\u0003\ni\b\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA@\u0011-\t9\t\u0001a\u0001\u0002\u0004%I!! \t\u0017\u0005%\u0005\u00011AA\u0002\u0013%\u00111\u0012\u0005\f\u0003\u001f\u0003\u0001\u0019!A!B\u0013\ty\bC\u0004\u0002\u0012\u0002!\t%a%\t\u0011\u0005U\u0005\u0001\"\u0001.\u0003/C!\"a,\u0001#\u0003%\t!LAY\u0011\u001d\t9\r\u0001C)\u0003\u0013Dq!a5\u0001\t\u0013\t\u0019\nC\u0004\u0002V\u0002!\t%a%\t\u001b\u0005]\u0007\u0001%A\u0002\u0002\u0003%I!!7V\u00115\tY\u000e\u0001I\u0001\u0004\u0003\u0005I\u0011BAm/\"i\u0011Q\u001c\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002`\u001a\u0013\u0011cS=vk\nL7+Z:tS>t\u0017*\u001c9m\u0015\taS&A\u0004tKN\u001c\u0018n\u001c8\u000b\u00059z\u0013AB6zkV\u0014\u0017N\u0003\u00021c\u00051\u0011\r]1dQ\u0016T\u0011AM\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0002\"AN\u001c\u000e\u0003-J!\u0001O\u0016\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u001cVm]:j_:\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003w\u0011k\u0011\u0001\u0010\u0006\u0003{y\na\u0001\u001e5sS\u001a$(BA A\u0003\r\u0011\bo\u0019\u0006\u0003\u0003\n\u000bqa]3sm&\u001cWM\u0003\u0002D_\u0005!\u0001.\u001b<f\u0013\t)EH\u0001\tU!J|Go\\2pYZ+'o]5p]&\u0011\u0011hN\u0001\u0005kN,'\u000f\u0005\u0002J%:\u0011!\n\u0015\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\na\u0001\u0010:p_Rt$\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es\u0015A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015(\n\u0005\u001d;\u0014\u0001\u00039bgN<xN\u001d3\n\u0005Y;\u0014!C5q\u0003\u0012$'/Z:t\u0013\tAv'\u0001\u0003d_:4\u0007\u0003B%]\u0011\"K!!\u0018+\u0003\u00075\u000b\u0007/\u0003\u0002[o\u0005q1/Z:tS>tW*\u00198bO\u0016\u0014X#A1\u0011\u0005Y\u0012\u0017BA2,\u0005QY\u00150^;cSN+7o]5p]6\u000bg.Y4fe\u0006y1/Z:tS>tW*\u00198bO\u0016\u0014\b%\u0003\u0002`o\u0005Y1/Z:tS>t7i\u001c8g!\tA7.D\u0001j\u0015\tQW&\u0001\u0004d_:4\u0017nZ\u0005\u0003Y&\u0014!bS=vk\nL7i\u001c8g\u0003\u0019a\u0014N\\5u}QAq\u000e]9sgR,h\u000f\u0005\u00027\u0001!)\u0011(\u0003a\u0001u!)q)\u0003a\u0001\u0011\")a+\u0003a\u0001\u0011\")\u0001,\u0003a\u0001\u0011\")!,\u0003a\u00017\")q,\u0003a\u0001C\")a-\u0003a\u0001O\u00061QM\\4j]\u0016,\u0012!\u001f\t\u0003url\u0011a\u001f\u0006\u0003o6J!!`>\u0003\u0013\u0015sw-\u001b8f%\u00164\u0017aB3oO&tW\rI\u0001\u0012Y\u0006,hn\u00195F]\u001eLg.Z!ts:\u001cWCAA\u0002!\u0011\t)!a\u0002\u000e\u00039K1!!\u0003O\u0005\u001d\u0011un\u001c7fC:\f!\u0003\\1v]\u000eDWI\\4j]\u0016\f5/\u001f8dA\u0005qA.Y;oG\",enZ5oK>\u0003XCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f[\u0005Iq\u000e]3sCRLwN\\\u0005\u0005\u00037\t)BA\u0005Pa\u0016\u0014\u0018\r^5p]\u0006yA.Y;oG\",enZ5oK>\u0003\b%\u0001\bf]\u001eLg.\u001a'bk:\u001c\u0007.\u001a3\u0002%\u0015tw-\u001b8f\u0019\u0006,hn\u00195fI~#S-\u001d\u000b\u0005\u0003K\tY\u0003\u0005\u0003\u0002\u0006\u0005\u001d\u0012bAA\u0015\u001d\n!QK\\5u\u0011%\ti#EA\u0001\u0002\u0004\t\u0019!A\u0002yIE\nq\"\u001a8hS:,G*Y;oG\",G\r\t\u0015\u0004%\u0005M\u0002\u0003BA\u0003\u0003kI1!a\u000eO\u0005!1x\u000e\\1uS2,\u0017\u0001D:fgNLwN\\#wK:$XCAA\u001f!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"[\u00051QM^3oiNLA!a\u0012\u0002B\t\u00112*_;vE&\u001cVm]:j_:,e/\u001a8u\u00035\u0019Xm]:j_:,e/\u001a8uA\u0005IAO]1ogB|'\u000f^\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0005\u0003\u0017\n)F\u0003\u0002>_%!\u0011\u0011LA*\u0005)!FK]1ogB|'\u000f^\u0001\u000eiJ\fgn\u001d9peR|F%Z9\u0015\t\u0005\u0015\u0012q\f\u0005\n\u0003[1\u0012\u0011!a\u0001\u0003\u001f\n!\u0002\u001e:b]N\u0004xN\u001d;!\u0003\u001dy6\r\\5f]R,\"!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c.\u0003\u0019\u0019G.[3oi&!\u0011\u0011OA6\u0005YY\u00150^;cSNKhn\u0019+ie&4Go\u00117jK:$\u0018aC0dY&,g\u000e^0%KF$B!!\n\u0002x!I\u0011QF\r\u0002\u0002\u0003\u0007\u0011qM\u0001\t?\u000ed\u0017.\u001a8uA\u00051\u0001.\u00198eY\u0016,\"!a \u0011\u0007Y\n\t)C\u0002\u0002\u0004.\u0012QbU3tg&|g\u000eS1oI2,\u0017a\u00025b]\u0012dW\rI\u0001\u0015?\u0016tw-\u001b8f'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u00021}+gnZ5oKN+7o]5p]\"\u000bg\u000e\u001a7f?\u0012*\u0017\u000f\u0006\u0003\u0002&\u00055\u0005\"CA\u0017?\u0005\u0005\t\u0019AA@\u0003UyVM\\4j]\u0016\u001cVm]:j_:D\u0015M\u001c3mK\u0002\nAa\u001c9f]R\u0011\u0011QE\u0001\u0012_B,g.\u00128hS:,7+Z:tS>tG\u0003BA\u0013\u00033C\u0011\"a'#!\u0003\u0005\r!!(\u0002\u001d\u0015DHO]1F]\u001eLg.\u001a'pOB1\u0011QAAP\u0003GK1!!)O\u0005\u0019y\u0005\u000f^5p]B!\u0011QUAV\u001b\t\t9K\u0003\u0003\u0002*\u0006U\u0011a\u00017pO&!\u0011QVAT\u00051y\u0005/\u001a:bi&|g\u000eT8h\u0003my\u0007/\u001a8F]\u001eLg.Z*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0017\u0016\u0005\u0003;\u000b)l\u000b\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016!C;oG\",7m[3e\u0015\r\t\tMT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003w\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00031\u0011XO\\(qKJ\fG/[8o)\u0011\tY-!5\u0011\t\u0005M\u0011QZ\u0005\u0005\u0003\u001f\f)BA\bPa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f\u0011\u001d\t9\u0002\na\u0001\u0003#\tQc^1ji\u001a{'/\u00128hS:,G*Y;oG\",G-A\u0003dY>\u001cX-\u0001\u0006tkB,'\u000fJ;tKJ,\u0012\u0001S\u0001\u000fgV\u0004XM\u001d\u0013qCN\u001cxo\u001c:e\u00039\u0019X\u000f]3sIA\u0014x\u000e^8d_2,\u0012A\u000f")
public class KyuubiSessionImpl
extends AbstractSession {
    private final KyuubiConf sessionConf;
    private final EngineRef engine;
    private final boolean launchEngineAsync;
    private final Operation launchEngineOp;
    private volatile boolean engineLaunched;
    private final KyuubiSessionEvent sessionEvent;
    private TTransport transport;
    private KyuubiSyncThriftClient _client;
    private final SessionHandle handle;
    private SessionHandle _engineSessionHandle;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)super.sessionManager();
    }

    public EngineRef engine() {
        return this.engine;
    }

    public boolean launchEngineAsync() {
        return this.launchEngineAsync;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    public boolean engineLaunched() {
        return this.engineLaunched;
    }

    public void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    private TTransport transport() {
        return this.transport;
    }

    private void transport_$eq(TTransport x$1) {
        this.transport = x$1;
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    public SessionHandle handle() {
        return this.handle;
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    public void open() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionImpl.$anonfun$open$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.open();
        this.runOperation(this.launchEngineOp());
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        ZooKeeperClientProvider$.MODULE$.withZkClient(this.sessionConf, (Function1 & Serializable & scala.Serializable)zkClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$1(this, extraEngineLog, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block0: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block0;
            this.waitForEngineLaunched();
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private void waitForEngineLaunched() {
        block0: {
            if (this.engineLaunched()) break block0;
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void close() {
        if (!this.launchEngineOp().isTimedOut()) {
            this.closeOperation(this.launchEngineOp().getHandle());
        }
        super.close();
        this.sessionManager().credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            try {
                if (this._client() != null) {
                    this._client().closeSession();
                }
            }
            catch (TException e) {
                throw KyuubiSQLException$.MODULE$.apply("Error while cleaning up the engine resources", (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
        }
        finally {
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventLoggingService$.MODULE$.onEvent(this.sessionEvent());
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.decCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_OPEN(), (String[])new String[]{this.super$user()}));
                return BoxedUnit.UNIT;
            });
            if (this.transport() != null && this.transport().isOpen()) {
                this.transport().close();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$open$1(KyuubiSessionImpl $this, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_TOTAL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_OPEN(), (String[])new String[]{$this.super$user()}));
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$1(KyuubiSessionImpl $this, Option extraEngineLog$1, CuratorFramework zkClient) {
        Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(zkClient, (Option<OperationLog>)extraEngineLog$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        Tuple2 tuple23 = tuple22;
        String host2 = (String)tuple23._1();
        int port2 = tuple23._2$mcI$sp();
        String passwd = (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$2(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        int loginTimeout = (int)BoxesRunTime.unboxToLong((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_LOGIN_TIMEOUT()));
        int requestTimeout = (int)BoxesRunTime.unboxToLong((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_REQUEST_TIMEOUT()));
        $this.transport_$eq(PlainSASLHelper$.MODULE$.getPlainTransport($this.super$user(), passwd, (TTransport)new TSocket(host2, port2, requestTimeout, loginTimeout)));
        if (!$this.transport().isOpen()) {
            $this.transport().open();
            $this.logSessionInfo(new StringBuilder(23).append("Connected to engine [").append(host2).append(":").append(port2).append("]").toString());
        }
        $this._client_$eq(new KyuubiSyncThriftClient((TProtocol)new TBinaryProtocol($this.transport())));
        $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (Map<String, String>)$this.normalizedConf()));
        $this.logSessionInfo(new StringBuilder(23).append("Opened engine session[").append($this._engineSessionHandle()).append("]").toString());
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().sessionId_$eq($this.handle().identifier().toString());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this.sessionEvent().clientVersion_$eq($this.handle().protocol().getValue());
        EventLoggingService$.MODULE$.onEvent($this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(37).append("Failed to launch engine for session[").append($this.handle()).append("]").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf) {
        this.sessionConf = sessionConf;
        super(protocol, user, password, ipAddress, conf, (SessionManager)sessionManager);
        this.normalizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            BoxedUnit boxedUnit;
            String string2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && "use:database".equals(string2 = (String)tuple2._1())) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (tuple2 != null && "kyuubi.engine.pool.size.threshold".equals(string = (String)tuple2._1())) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                boxedUnit = $this.sessionConf.set(key, value);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return boxedUnit;
        });
        this.engine = new EngineRef(sessionConf, super.user(), EngineRef$.MODULE$.$lessinit$greater$default$3());
        this.launchEngineAsync = BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC()));
        this.launchEngineOp = sessionManager.operationManager().newLaunchEngineOperation(this, this.launchEngineAsync());
        this.engineLaunched = false;
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventLoggingService$.MODULE$.onEvent(this.sessionEvent());
        this.handle = SessionHandle$.MODULE$.apply(super.protocol());
    }
}

