/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.BeeLineOpts;
import org.apache.hive.beeline.KyuubiCommands;

public class KyuubiBeeLine
extends BeeLine {
    public static final String KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.kyuubi.jdbc.KyuubiHiveDriver";
    protected KyuubiCommands commands = new KyuubiCommands(this);
    private Driver defaultDriver = null;

    public KyuubiBeeLine() {
        this(true);
    }

    public KyuubiBeeLine(boolean isBeeLine) {
        super(isBeeLine);
        try {
            Field commandsField = BeeLine.class.getDeclaredField("commands");
            commandsField.setAccessible(true);
            commandsField.set((Object)this, (Object)this.commands);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Failed to inject kyuubi commands");
        }
        try {
            this.defaultDriver = (Driver)Class.forName(KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("org.apache.kyuubi.jdbc.KyuubiHiveDriver-missing");
        }
    }

    public static void main(String[] args) throws IOException {
        KyuubiBeeLine.mainWithInputRedirection(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        try (KyuubiBeeLine beeLine = new KyuubiBeeLine();){
            int status = beeLine.begin(args, inputStream);
            if (!Boolean.getBoolean("beeline.system.exit")) {
                System.exit(status);
            }
        }
    }

    protected Driver getDefaultDriver() {
        return this.defaultDriver;
    }

    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Kyuubi (Incubating)"});
    }

    int initArgs(String[] args) {
        boolean exit;
        Field exitField;
        boolean connSuccessful;
        CommandLine cl;
        List<Object> commands = Collections.emptyList();
        try {
            Field optionsField = BeeLine.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            Options options = (Options)optionsField.get((Object)this);
            BeeLine.BeelineParser beelineParser = new BeeLine.BeelineParser((BeeLine)this);
            cl = beelineParser.parse(options, args);
            Method connectUsingArgsMethod = BeeLine.class.getDeclaredMethod("connectUsingArgs", BeeLine.BeelineParser.class, CommandLine.class);
            connectUsingArgsMethod.setAccessible(true);
            connSuccessful = (Boolean)connectUsingArgsMethod.invoke((Object)this, beelineParser, cl);
            exitField = BeeLine.class.getDeclaredField("exit");
            exitField.setAccessible(true);
            exit = (Boolean)exitField.get((Object)this);
        }
        catch (ParseException e1) {
            this.output(e1.getMessage());
            this.usage();
            return -1;
        }
        catch (Exception t) {
            this.error(t.getMessage());
            return 1;
        }
        if (!connSuccessful && !exit) {
            try {
                Method defaultBeelineConnectMethod = BeeLine.class.getDeclaredMethod("defaultBeelineConnect", new Class[0]);
                defaultBeelineConnectMethod.setAccessible(true);
                connSuccessful = (Boolean)defaultBeelineConnectMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception t) {
                this.error(t.getMessage());
                return 1;
            }
        }
        int code = 0;
        if (cl.getOptionValues('e') != null) {
            commands = Arrays.asList(cl.getOptionValues('e'));
            try {
                Field optsField = BeeLine.class.getDeclaredField("opts");
                optsField.setAccessible(true);
                BeeLineOpts opts = (BeeLineOpts)optsField.get((Object)this);
                opts.setAllowMultiLineCommand(false);
            }
            catch (Exception t) {
                this.error(t.getMessage());
                return 1;
            }
        }
        if (!commands.isEmpty() && this.getOpts().getScriptFile() != null) {
            this.error("The '-e' and '-f' options cannot be specified simultaneously");
            return 1;
        }
        if (!commands.isEmpty() && !connSuccessful) {
            this.error("Cannot run commands specified using -e. No current connection");
            return 1;
        }
        if (!commands.isEmpty()) {
            Iterator<Object> i = commands.iterator();
            while (i.hasNext()) {
                String command = ((String)i.next()).toString();
                this.debug(this.loc("executing-command", command));
                if (this.dispatch(command)) continue;
                ++code;
            }
            try {
                exit = true;
                exitField.set((Object)this, exit);
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return 1;
            }
        }
        return code;
    }
}

