/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementStats;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.engine.trino.ProgressFormatUtils;
import org.apache.kyuubi.engine.trino.TrinoConsoleProgressBar;
import org.apache.kyuubi.operation.log.OperationLog;
import scala.Predef;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class TrinoStatusPrinter$ {
    public static TrinoStatusPrinter$ MODULE$;

    static {
        new TrinoStatusPrinter$();
    }

    public void printFinalInfo(StatementClient client, OperationLog operationLog, boolean debug) {
        TrinoConsoleProgressBar out = new TrinoConsoleProgressBar(operationLog);
        QueryStatusInfo results = client.finalStatusInfo();
        StatementStats stats = results.getStats();
        Duration wallTime = Duration.succinctDuration((double)stats.getElapsedTimeMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        int nodes = stats.getNodes();
        if (nodes == 0 || stats.getTotalSplits() == 0) {
            return;
        }
        String querySummary = new StringBuilder(11).append("Query ").append(results.getId()).append(", ").append(stats.getState()).append(",").append(" ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)nodes)), "%,d")).append(" ").append(ProgressFormatUtils.pluralize("node", nodes)).toString();
        out.printLine(querySummary);
        if (debug) {
            out.printLine(results.getInfoUri().toString());
        }
        String splitsSummary = new StringBuilder(25).append("Splits: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)stats.getTotalSplits())), "%,d")).append(" total,").append(" ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)stats.getCompletedSplits())), "%,d")).append(" done (").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)stats.getProgressPercentage().orElse(0.0))), "%.2f")).append("%)").toString();
        out.printLine(splitsSummary);
        if (debug) {
            Duration cpuTime = new Duration((double)stats.getCpuTimeMillis(), TimeUnit.MILLISECONDS);
            String cpuTimeSummary = new StringBuilder(38).append("CPU Time: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)cpuTime.getValue(TimeUnit.SECONDS))), "%.1f")).append("s total, ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)ProgressFormatUtils.formatCountRate(stats.getProcessedRows(), cpuTime, false)), "%5s")).append(" rows/s, ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)ProgressFormatUtils.formatDataRate(DataSize.ofBytes((long)stats.getProcessedBytes()), cpuTime, true)), "%8s")).append(", ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)this.percentage(stats.getCpuTimeMillis(), stats.getWallTimeMillis()))), "%d")).append("% active").toString();
            out.printLine(cpuTimeSummary);
            double parallelism = cpuTime.getValue(TimeUnit.MILLISECONDS) / wallTime.getValue(TimeUnit.MILLISECONDS);
            String perNodeSummary = new StringBuilder(33).append("Per Node: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(parallelism / (double)nodes))), "%.1f")).append(" parallelism, ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)ProgressFormatUtils.formatCountRate((double)stats.getProcessedRows() / (double)nodes, wallTime, false)), "%5s")).append(" rows/s, ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)ProgressFormatUtils.formatDataRate(DataSize.ofBytes((long)(stats.getProcessedBytes() / (long)nodes)), wallTime, true)), "%8s")).toString();
            out.reprintLine(perNodeSummary);
            out.printLine(new StringBuilder(13).append("Parallelism: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)parallelism)), "%.1f")).toString());
            out.reprintLine(new StringBuilder(13).append("Peak Memory: ").append(ProgressFormatUtils.formatDataSize(DataSize.ofBytes((long)stats.getPeakMemoryBytes()), true)).toString());
            if (stats.getSpilledBytes() > 0L) {
                out.reprintLine(new StringBuilder(9).append("Spilled: ").append(ProgressFormatUtils.formatDataSize(DataSize.ofBytes((long)stats.getSpilledBytes()), true)).toString());
            }
        }
        String statsLine = new StringBuilder(22).append(ProgressFormatUtils.formatFinalTime(wallTime)).append(" ").append("[").append(ProgressFormatUtils.formatCount(stats.getProcessedRows())).append(" rows, ").append(ProgressFormatUtils.formatDataSize(DataSize.ofBytes((long)stats.getProcessedBytes()), true)).append("] ").append("[").append(ProgressFormatUtils.formatCountRate(stats.getProcessedRows(), wallTime, false)).append(" rows/s, ").append(ProgressFormatUtils.formatDataRate(DataSize.ofBytes((long)stats.getProcessedBytes()), wallTime, true)).append("]").toString();
        out.printLine(statsLine);
    }

    public boolean printFinalInfo$default$3() {
        return false;
    }

    public int percentage(double count, double total) {
        return total == 0.0 ? 0 : (int)Math.min(100.0, count * 100.0 / total);
    }

    private TrinoStatusPrinter$() {
        MODULE$ = this;
    }
}

