/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.support;

import io.grpc.stub.StreamObserver;
import java.util.function.Consumer;

public final class Observers {
    private Observers() {
    }

    public static <V> StreamObserver<V> observer(final Consumer<V> onNext) {
        return new StreamObserver<V>(){

            @Override
            public void onNext(V value) {
                onNext.accept(value);
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onCompleted() {
            }
        };
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<V> {
        private Consumer<V> onNext;
        private Consumer<Throwable> onError;
        private Runnable onCompleted;

        public Builder<V> onNext(Consumer<V> onNext) {
            this.onNext = onNext;
            return this;
        }

        public Builder<V> onError(Consumer<Throwable> onError2) {
            this.onError = onError2;
            return this;
        }

        public Builder<V> onCompleted(Runnable onCompleted) {
            this.onCompleted = onCompleted;
            return this;
        }

        public StreamObserver<V> build() {
            final Consumer<V> doOnNext = this.onNext;
            final Consumer<Throwable> doOnnError = this.onError;
            final Runnable doOnnCompleted = this.onCompleted;
            return new StreamObserver<V>(){

                @Override
                public void onNext(V value) {
                    if (onNext != null) {
                        doOnNext.accept(value);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    if (doOnnError != null) {
                        doOnnError.accept(throwable);
                    }
                }

                @Override
                public void onCompleted() {
                    if (doOnnCompleted != null) {
                        doOnnCompleted.run();
                    }
                }
            };
        }
    }
}

