/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.Endpoint;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.EndpointProvider;

public class ConnectionManager<K, C> {
    private final EndpointProvider<K, C> endpointProvider;
    private final Map<K, Endpoint<C>> endpointMap = new ConcurrentHashMap<K, Endpoint<C>>();

    public ConnectionManager(EndpointProvider<K, C> endpointProvider) {
        this.endpointProvider = endpointProvider;
    }

    public void forEach(Consumer<Endpoint<C>> consumer) {
        this.endpointMap.values().forEach(consumer);
    }

    public void getConnection(ContextInternal ctx, K key, Handler<AsyncResult<C>> handler) {
        this.getConnection(ctx, key, 0L, handler);
    }

    public void getConnection(ContextInternal ctx, K key, long timeout, Handler<AsyncResult<C>> handler) {
        Endpoint endpoint;
        Runnable dispose = () -> this.endpointMap.remove(key);
        while (!(endpoint = this.endpointMap.computeIfAbsent(key, k -> this.endpointProvider.create(key, ctx, dispose))).getConnection(ctx, timeout, handler)) {
        }
    }

    public void close() {
        for (Endpoint<C> conn : this.endpointMap.values()) {
            conn.close();
        }
    }
}

