/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.protocol.HttpContext;

public abstract class HttpRequestInterceptorBase
implements HttpRequestInterceptor {
    CookieStore cookieStore;
    boolean isCookieEnabled;
    String cookieName;
    boolean isSSL;
    Map<String, String> additionalHeaders;
    Map<String, String> customCookies;

    protected abstract void addHttpAuthHeader(HttpRequest var1, HttpContext var2) throws Exception;

    public HttpRequestInterceptorBase(CookieStore cs, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        this.cookieStore = cs;
        this.isCookieEnabled = cs != null;
        this.cookieName = cn;
        this.isSSL = isSSL;
        this.additionalHeaders = additionalHeaders;
        this.customCookies = customCookies;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        try {
            if (this.isCookieEnabled) {
                httpContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
            }
            if (!this.isCookieEnabled || httpContext.getAttribute("hive.server2.retryserver") == null && (this.cookieStore == null || this.needToSendCredentials(this.cookieStore, this.cookieName, this.isSSL)) || httpContext.getAttribute("hive.server2.retryserver") != null && httpContext.getAttribute("hive.server2.retryserver").equals("true")) {
                this.addHttpAuthHeader(httpRequest, httpContext);
            }
            if (this.isCookieEnabled) {
                httpContext.setAttribute("hive.server2.retryserver", (Object)"false");
            }
            if (this.additionalHeaders != null) {
                for (Map.Entry<String, String> entry : this.additionalHeaders.entrySet()) {
                    httpRequest.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (this.customCookies != null) {
                StringBuilder cookieHeaderKeyValues = new StringBuilder();
                Header cookieHeaderServer = httpRequest.getFirstHeader("Cookie");
                if (cookieHeaderServer != null && cookieHeaderServer.getValue() != null) {
                    cookieHeaderKeyValues = new StringBuilder(cookieHeaderServer.getValue());
                }
                for (Map.Entry<String, String> entry : this.customCookies.entrySet()) {
                    cookieHeaderKeyValues.append(";").append(entry.getKey()).append("=").append(entry.getValue());
                }
                if (cookieHeaderKeyValues.toString().startsWith(";")) {
                    cookieHeaderKeyValues = new StringBuilder(cookieHeaderKeyValues.substring(1));
                }
                httpRequest.addHeader("Cookie", cookieHeaderKeyValues.toString());
            }
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean needToSendCredentials(CookieStore cookieStore, String cookieName, boolean isSSL) {
        if (cookieName == null || cookieStore == null) {
            return true;
        }
        List cookies = cookieStore.getCookies();
        for (Cookie c : cookies) {
            if (c.isSecure() && !isSSL || !c.getName().equals(cookieName)) continue;
            return false;
        }
        return true;
    }
}

