/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.operation;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.concurrent.Future;
import org.apache.kyuubi.engine.jdbc.operation.JdbcOperation;
import org.apache.kyuubi.engine.jdbc.schema.Column;
import org.apache.kyuubi.engine.jdbc.schema.Row;
import org.apache.kyuubi.engine.jdbc.schema.Schema;
import org.apache.kyuubi.engine.jdbc.schema.Schema$;
import org.apache.kyuubi.engine.jdbc.session.JdbcSessionImpl;
import org.apache.kyuubi.engine.jdbc.util.ResultSetWrapper;
import org.apache.kyuubi.operation.ArrayFetchIterator;
import org.apache.kyuubi.operation.FetchIterator;
import org.apache.kyuubi.operation.IterableFetchIterator;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionManager;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00114AAD\b\u00019!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0011-\u0011!Q\u0004A!A!\u0002\u0013i\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\t\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\nuB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005{!)q\t\u0001C\u0001\u0011\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u0002-\u0001A\u0003%\u0011\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003_\u0001\u0011Es\fC\u0003d\u0001\u0011%qL\u0001\tFq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oi*\u0011\u0001#E\u0001\n_B,'/\u0019;j_:T!AE\n\u0002\t)$'m\u0019\u0006\u0003)U\ta!\u001a8hS:,'B\u0001\f\u0018\u0003\u0019Y\u00170^;cS*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000f\"!\tqr$D\u0001\u0010\u0013\t\u0001sBA\u0007KI\n\u001cw\n]3sCRLwN\u001c\t\u0003E\rj\u0011!F\u0005\u0003IU\u0011q\u0001T8hO&tw-A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\u001dJS\"\u0001\u0015\u000b\u0005\u0015*\u0012B\u0001\u0016)\u0005\u001d\u0019Vm]:j_:\f\u0011b\u001d;bi\u0016lWM\u001c;\u0016\u00035\u0002\"AL\u001c\u000f\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u001c\u0003\u0019a$o\\8u})\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t14'\u0001\u0006ti\u0006$X-\\3oi\u0002\nab\u001d5pk2$'+\u001e8Bgft7-F\u0001>!\tqt(D\u00014\u0013\t\u00015GA\u0004C_>dW-\u00198\u0002\u001fMDw.\u001e7e%Vt\u0017i]=oG\u0002\nA\"];fef$\u0016.\\3pkR\u0004\"A\u0010#\n\u0005\u0015\u001b$\u0001\u0002'p]\u001e\f!#\u001b8de\u0016lWM\u001c;bY\u000e{G\u000e\\3di\u00061A(\u001b8jiz\"b!\u0013&L\u00196s\u0005C\u0001\u0010\u0001\u0011\u0015)\u0003\u00021\u0001'\u0011\u0015Y\u0003\u00021\u0001.\u0011\u0015Y\u0004\u00021\u0001>\u0011\u0015\u0011\u0005\u00021\u0001D\u0011\u00151\u0005\u00021\u0001>\u00031y\u0007/\u001a:bi&|g\u000eT8h+\u0005\t\u0006C\u0001*W\u001b\u0005\u0019&B\u0001+V\u0003\rawn\u001a\u0006\u0003!UI!aV*\u0003\u0019=\u0003XM]1uS>tGj\\4\u0002\u001b=\u0004XM]1uS>tGj\\4!\u0003=9W\r^(qKJ\fG/[8o\u0019><W#A.\u0011\u0007yb\u0016+\u0003\u0002^g\t1q\n\u001d;j_:\f1B];o\u0013:$XM\u001d8bYR\t\u0001\r\u0005\u0002?C&\u0011!m\r\u0002\u0005+:LG/\u0001\tfq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oi\u0002")
public class ExecuteStatement
extends JdbcOperation {
    private final Session session;
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final boolean incrementalCollect;
    private final OperationLog operationLog;

    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    public void runInternal() {
        this.addTimeoutMonitor(this.queryTimeout);
        if (this.shouldRunAsync()) {
            Runnable asyncOperation = new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    this.$outer.org$apache$kyuubi$engine$jdbc$operation$ExecuteStatement$$executeStatement();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            SessionManager jdbcSessionManager = this.session.sessionManager();
            Future backgroundHandle = jdbcSessionManager.submitBackgroundOperation(asyncOperation);
            this.setBackgroundHandle(backgroundHandle);
            return;
        }
        this.org$apache$kyuubi$engine$jdbc$operation$ExecuteStatement$$executeStatement();
    }

    public void org$apache$kyuubi$engine$jdbc$operation$ExecuteStatement$$executeStatement() {
        block11: {
            this.setState(OperationState$.MODULE$.RUNNING());
            Statement jdbcStatement = null;
            try {
                try {
                    Connection connection = ((JdbcSessionImpl)this.session).sessionConnection();
                    jdbcStatement = this.dialect().createStatement(connection, this.dialect().createStatement$default$2());
                    boolean hasResult = jdbcStatement.execute(this.statement());
                    if (hasResult) {
                        IterableFetchIterator iterableFetchIterator;
                        ResultSetWrapper resultSetWrapper = new ResultSetWrapper(jdbcStatement);
                        ResultSetMetaData metadata = resultSetWrapper.getMetadata();
                        this.schema_$eq(Schema$.MODULE$.apply(metadata));
                        if (this.incrementalCollect) {
                            this.info((Function0 & Serializable & scala.Serializable)() -> "Execute in incremental collect mode");
                            iterableFetchIterator = new IterableFetchIterator(resultSetWrapper.toIterable());
                        } else {
                            this.warn((Function0 & Serializable & scala.Serializable)() -> "Execute in full collect mode");
                            iterableFetchIterator = new ArrayFetchIterator((Object)resultSetWrapper.toArray());
                        }
                        this.iter_$eq((FetchIterator<Row>)iterableFetchIterator);
                    } else {
                        this.schema_$eq(new Schema((List<Column>)new .colon.colon((Object)new Column("result", "INT", 4, 20, 0, "result", 20), (List)Nil$.MODULE$)));
                        this.iter_$eq((FetchIterator<Row>)new ArrayFetchIterator((Object)new Row[]{new Row((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{jdbcStatement.getUpdateCount()})))}));
                    }
                    this.setState(OperationState$.MODULE$.FINISHED());
                }
                catch (Throwable x$1) {
                    PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                    if (catchExpr$1.isDefinedAt((Object)x$1)) {
                        catchExpr$1.apply((Object)x$1);
                        break block11;
                    }
                    throw x$1;
                }
            }
            finally {
                if (jdbcStatement != null) {
                    jdbcStatement.closeOnCompletion();
                }
                this.shutdownTimeoutMonitor();
            }
        }
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout, boolean incrementalCollect) {
        this.session = session;
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.incrementalCollect = incrementalCollect;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
    }
}

