/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\u000f\u001e\u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tE\f\u0005\te\u0001\u0011\t\u0011)A\u0005_!)1\u0007\u0001C\u0001i!Ia\u0004\u0001a\u0001\u0002\u0004%I\u0001\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\n\u0001C\u0011\"\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u001d\t\u000f)\u0003!\u0019!C\u0005\u0017\"1\u0001\f\u0001Q\u0001\n1CQ!\u0017\u0001\u0005\niCaa\u0019\u0001\u0005\u0002}!\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007c\u0002\u0001\u000b\u0011B7\t\u0011I\u0004\u0001R1A\u0005\u0002MDaa \u0001\u0005B\u0005\u0005\u0001BBA\t\u0001\u0011\u00053\u000fC\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u0016!A\u0011\u0011\u0004\u0001\u0005\u0002}\t)\u0002C\u0004\u00026\u0001!\t%!\u0006\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\u0016!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003{\u0001A\u0011AA#\u0011\u0019\t\t\u0006\u0001C\u0001g\"9\u00111\u000b\u0001\u0005\n\u0005U\u0003\"CA1\u0001\t\u0007I\u0011IA2\u0011!\t\t\b\u0001Q\u0001\n\u0005\u0015$!G&zkV\u0014\u0017NU3ti\u001a\u0013xN\u001c;f]\u0012\u001cVM\u001d<jG\u0016T!AH\u0010\u0002\rM,'O^3s\u0015\t\u0001\u0013%\u0001\u0004lsV,(-\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016 \u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001L\u0015\u0003/\u0005\u00137\u000f\u001e:bGR4%o\u001c8uK:$7+\u001a:wS\u000e,\u0017AC:feZ,'/\u00192mKV\tq\u0006\u0005\u0002)a%\u0011\u0011'\u000b\u0002\u000b'\u0016\u0014h/\u001a:bE2,\u0017aC:feZ,'/\u00192mK\u0002\na\u0001P5oSRtDCA\u001b8!\t1\u0004!D\u0001\u001e\u0011\u0015i3\u00011\u00010+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u001e\u0003\t)\u0018.\u0003\u0002?w\tY!*\u001a;usN+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003\u0003\u001e\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013A!\u00168ji\"9\u0001*BA\u0001\u0002\u0004I\u0014a\u0001=%c\u000591/\u001a:wKJ\u0004\u0013!C5t'R\f'\u000f^3e+\u0005a\u0005CA'W\u001b\u0005q%BA(Q\u0003\u0019\tGo\\7jG*\u0011\u0011KU\u0001\u000bG>t7-\u001e:sK:$(BA*U\u0003\u0011)H/\u001b7\u000b\u0003U\u000bAA[1wC&\u0011qK\u0014\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c8\u000b^1si\u0016$\u0007%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000bAaY8oM*\u0011\u0001-I\u0001\u0007Q\u0006$wn\u001c9\n\u0005\tl&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\btKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u0010\u0002\u000fM,7o]5p]&\u0011!n\u001a\u0002\u0015\u0017f,XOY5TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\u0019\t\fGo\u00195DQ\u0016\u001c7.\u001a:\u0016\u00035\u0004\"A\\8\u000e\u0003AK!\u0001\u001d)\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\u0007cCR\u001c\u0007n\u00115fG.,'\u000fI\u0001\u0005Q>\u001cH/F\u0001u!\t)HP\u0004\u0002wuB\u0011qoQ\u0007\u0002q*\u0011\u00110J\u0001\u0007yI|w\u000e\u001e \n\u0005m\u001c\u0015A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a_\"\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002B\u0003\u0007AaA\u0018\bA\u0002\u0005\u0015\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-q$\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u001f\tIA\u0001\u0006LsV,(-[\"p]\u001a\fQbY8o]\u0016\u001cG/[8o+Jd\u0017!D:uCJ$\u0018J\u001c;fe:\fG\u000eF\u0001B\u0003E\u0019H/\u0019:u\u0005\u0006$8\r[\"iK\u000e\\WM]\u0001\u0015e\u0016\u001cwN^3s\u0005\u0006$8\r[*fgNLwN\\:)\u0007I\ti\u0002\u0005\u0003\u0002 \u0005ERBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0003O\tI#\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003W\ti#\u0001\u0004h_><G.\u001a\u0006\u0003\u0003_\t1aY8n\u0013\u0011\t\u0019$!\t\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\u0018aC4fiJ+\u0017\r\\+tKJ$\u0012\u0001^\u0001\u000fO\u0016$8+Z:tS>tWk]3s)\r!\u0018\u0011\t\u0005\u0007\u0003\u00072\u0002\u0019\u0001;\u0002\u0019!\u001c(\u0007\u0015:pqf,6/\u001a:\u0015\u0007Q\f9\u0005C\u0004\u0002J]\u0001\r!a\u0013\u0002\u0017M,7o]5p]\u000e{gN\u001a\t\u0006k\u00065C\u000f^\u0005\u0004\u0003\u001fr(aA'ba\u0006aq-\u001a;Ja\u0006#GM]3tg\u0006aq-\u001a;Qe>D\u00180V:feR9A/a\u0016\u0002Z\u0005u\u0003bBA%3\u0001\u0007\u00111\n\u0005\u0007\u00037J\u0002\u0019\u0001;\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bBBA03\u0001\u0007A/\u0001\u0005sK\u0006dWk]3s\u0003A!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW-\u0006\u0002\u0002fA)!)a\u001a\u0002l%\u0019\u0011\u0011N\"\u0003\r=\u0003H/[8o!\rA\u0013QN\u0005\u0004\u0003_J#aB*feZL7-Z\u0001\u0012I&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016\u0004\u0003")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private String host;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile boolean bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if (!this.bitmap$0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
                    }
                    return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = true;
            }
        }
        return this.host;
    }

    public String host() {
        if (!this.bitmap$0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT())), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        return this.server().getServerUri();
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        this.server().addStaticHandler("org/apache/kyuubi/ui/static", "/static/");
        this.server().addRedirectHandler("/", "/static/");
        this.server().addRedirectHandler("/static", "/static/");
        this.server().addStaticHandler("META-INF/resources/webjars/swagger-ui/4.9.1/", "/swagger-static/");
        this.server().addStaticHandler("org/apache/kyuubi/ui/swagger", "/swagger/");
        this.server().addRedirectHandler("/docs", "/swagger/");
        this.server().addRedirectHandler("/docs/", "/swagger/");
        this.server().addRedirectHandler("/swagger", "/swagger/");
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSessionImpl x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    Option$.MODULE$.apply((Object)((Object)$this.$outer.sessionManager().getBatchSessionImpl(sessionHandle))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSessionImpl ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        this.batchChecker().scheduleWithFixedDelay(task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSessionImpl> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.recoverBatchSessions();
                this.isStarted().set(true);
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getName()).append(" has started at ").append(this.server().getServerUri()).toString());
                this.startBatchChecker();
                this.startInternal();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String hs2ProxyUser) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)hs2ProxyUser).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.METHOD_NOT_ALLOWED);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        if (sessionConf == null) {
            return realUser;
        }
        return (String)sessionConf.get((Object)KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER()).map((Function1 & Serializable & scala.Serializable)proxyUser -> {
            KyuubiAuthenticationFactory$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
            return proxyUser;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> realUser);
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

