/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.jdbc.hive.JdbcColumnAttributes;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalDayTime;
import org.apache.kyuubi.jdbc.hive.common.HiveIntervalYearMonth;
import org.apache.kyuubi.jdbc.hive.common.TimestampTZ;

public class JdbcColumn {
    private final String columnName;
    private final String tableName;
    private final String tableCatalog;
    private final String type;
    private final String comment;
    private final int ordinalPos;

    JdbcColumn(String columnName, String tableName, String tableCatalog, String type, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableCatalog = tableCatalog;
        this.type = type;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }

    public Integer getNumPrecRadix() {
        if (this.type.equalsIgnoreCase("tinyint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("smallint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("int")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("bigint")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("float")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("double")) {
            return 10;
        }
        if (this.type.equalsIgnoreCase("decimal")) {
            return 10;
        }
        return null;
    }

    static String columnClassName(TTypeId tType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.convertTTypeIdToSqlType(tType);
        switch (columnType) {
            case 0: {
                return "null";
            }
            case 16: {
                return Boolean.class.getName();
            }
            case 1: 
            case 12: {
                return String.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2014: {
                return TimestampTZ.class.getName();
            }
            case 3: {
                return BigInteger.class.getName();
            }
            case -2: {
                return byte[].class.getName();
            }
            case 1111: 
            case 2000: {
                switch (tType) {
                    case INTERVAL_YEAR_MONTH_TYPE: {
                        return HiveIntervalYearMonth.class.getName();
                    }
                    case INTERVAL_DAY_TIME_TYPE: {
                        return HiveIntervalDayTime.class.getName();
                    }
                }
                return String.class.getName();
            }
            case 2002: 
            case 2003: {
                return String.class.getName();
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + columnType);
    }

    public static int convertTTypeIdToSqlType(TTypeId type) throws SQLException {
        switch (type) {
            case STRING_TYPE: 
            case VARCHAR_TYPE: {
                return 12;
            }
            case CHAR_TYPE: {
                return 1;
            }
            case FLOAT_TYPE: {
                return 6;
            }
            case DOUBLE_TYPE: {
                return 8;
            }
            case BOOLEAN_TYPE: {
                return 16;
            }
            case TINYINT_TYPE: {
                return -6;
            }
            case SMALLINT_TYPE: {
                return 5;
            }
            case INT_TYPE: {
                return 4;
            }
            case BIGINT_TYPE: {
                return -5;
            }
            case DATE_TYPE: {
                return 91;
            }
            case TIMESTAMP_TYPE: {
                return 93;
            }
            case INTERVAL_YEAR_MONTH_TYPE: 
            case INTERVAL_DAY_TIME_TYPE: 
            case TIMESTAMPLOCALTZ_TYPE: 
            case UNION_TYPE: {
                return 1111;
            }
            case DECIMAL_TYPE: {
                return 3;
            }
            case BINARY_TYPE: {
                return -2;
            }
            case MAP_TYPE: {
                return 2000;
            }
            case ARRAY_TYPE: {
                return 2003;
            }
            case STRUCT_TYPE: {
                return 2002;
            }
            case NULL_TYPE: {
                return 0;
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + type);
    }

    static String getColumnTypeName(TTypeId type) throws SQLException {
        switch (type) {
            case STRING_TYPE: {
                return "string";
            }
            case VARCHAR_TYPE: {
                return "varchar";
            }
            case CHAR_TYPE: {
                return "char";
            }
            case FLOAT_TYPE: {
                return "float";
            }
            case DOUBLE_TYPE: {
                return "double";
            }
            case BOOLEAN_TYPE: {
                return "boolean";
            }
            case TINYINT_TYPE: {
                return "tinyint";
            }
            case SMALLINT_TYPE: {
                return "smallint";
            }
            case INT_TYPE: {
                return "int";
            }
            case BIGINT_TYPE: {
                return "bigint";
            }
            case DATE_TYPE: {
                return "date";
            }
            case TIMESTAMP_TYPE: {
                return "timestamp";
            }
            case TIMESTAMPLOCALTZ_TYPE: {
                return "timestamp with local time zone";
            }
            case INTERVAL_YEAR_MONTH_TYPE: {
                return "interval_year_month";
            }
            case INTERVAL_DAY_TIME_TYPE: {
                return "interval_day_time";
            }
            case DECIMAL_TYPE: {
                return "decimal";
            }
            case BINARY_TYPE: {
                return "binary";
            }
            case MAP_TYPE: {
                return "map";
            }
            case ARRAY_TYPE: {
                return "array";
            }
            case STRUCT_TYPE: {
                return "struct";
            }
            case NULL_TYPE: {
                return "void";
            }
            case UNION_TYPE: {
                return "uniontype";
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + type);
    }

    static int columnDisplaySize(TTypeId tType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.convertTTypeIdToSqlType(tType);
        switch (columnType) {
            case 0: {
                return 4;
            }
            case 16: {
                return JdbcColumn.columnPrecision(tType, columnAttributes);
            }
            case 1: 
            case 12: {
                return JdbcColumn.columnPrecision(tType, columnAttributes);
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JdbcColumn.columnPrecision(tType, columnAttributes) + 1;
            }
            case 91: {
                return 10;
            }
            case 93: 
            case 2014: {
                return JdbcColumn.columnPrecision(tType, columnAttributes);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return JdbcColumn.columnPrecision(tType, columnAttributes) + 2;
            }
            case 1111: 
            case 2000: {
                return JdbcColumn.columnPrecision(tType, columnAttributes);
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + columnType);
    }

    static int columnPrecision(TTypeId tType, JdbcColumnAttributes columnAttributes) throws SQLException {
        int columnType = JdbcColumn.convertTTypeIdToSqlType(tType);
        switch (columnType) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 1: 
            case 12: {
                if (columnAttributes != null) {
                    return columnAttributes.precision;
                }
                return Integer.MAX_VALUE;
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 29;
            }
            case 2014: {
                return 31;
            }
            case 3: {
                return columnAttributes.precision;
            }
            case 1111: 
            case 2000: {
                switch (tType) {
                    case INTERVAL_YEAR_MONTH_TYPE: {
                        return 11;
                    }
                    case INTERVAL_DAY_TIME_TYPE: {
                        return 29;
                    }
                }
                return Integer.MAX_VALUE;
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + columnType);
    }

    static int columnScale(int columnType, JdbcColumnAttributes columnAttributes) throws SQLException {
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: 
            case 2014: {
                return 9;
            }
            case 3: {
                return columnAttributes.scale;
            }
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
        }
        throw new KyuubiSQLException("Invalid column type: " + columnType);
    }
}

