/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.KyuubiCommands;
import org.apache.hive.common.util.HiveStringUtils;

public class KyuubiBeeLine
extends BeeLine {
    public static final String KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER = "org.apache.kyuubi.jdbc.KyuubiHiveDriver";
    protected KyuubiCommands commands = new KyuubiCommands(this);
    private Driver defaultDriver = null;
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_ARGS = 1;
    private static final int ERRNO_OTHER = 2;
    private static final String PYTHON_MODE_PREFIX = "--python-mode";
    private boolean pythonMode = false;

    public KyuubiBeeLine() {
        this(true);
    }

    public KyuubiBeeLine(boolean isBeeLine) {
        super(isBeeLine);
        try {
            Field commandsField = BeeLine.class.getDeclaredField("commands");
            commandsField.setAccessible(true);
            commandsField.set((Object)this, (Object)this.commands);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Failed to inject kyuubi commands");
        }
        try {
            this.defaultDriver = (Driver)Class.forName(KYUUBI_BEELINE_DEFAULT_JDBC_DRIVER, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("org.apache.kyuubi.jdbc.KyuubiHiveDriver-missing");
        }
    }

    void usage() {
        super.usage();
        this.output("Usage: java " + KyuubiBeeLine.class.getCanonicalName());
        this.output("   --python-mode                   Execute python code/script.");
    }

    public boolean isPythonMode() {
        return this.pythonMode;
    }

    public void setPythonMode(boolean pythonMode) {
        this.pythonMode = pythonMode;
    }

    public static void main(String[] args) throws IOException {
        KyuubiBeeLine.mainWithInputRedirection(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mainWithInputRedirection(String[] args, InputStream inputStream) throws IOException {
        try (KyuubiBeeLine beeLine = new KyuubiBeeLine();){
            int status = beeLine.begin(args, inputStream);
            if (!Boolean.getBoolean("beeline.system.exit")) {
                System.exit(status);
            }
        }
    }

    protected Driver getDefaultDriver() {
        return this.defaultDriver;
    }

    String getApplicationTitle() {
        Package pack = BeeLine.class.getPackage();
        return this.loc("app-introduction", new Object[]{"Beeline", pack.getImplementationVersion() == null ? "???" : pack.getImplementationVersion(), "Apache Kyuubi"});
    }

    int initArgs(String[] args) {
        boolean exit;
        Field exitField;
        boolean connSuccessful;
        CommandLine cl;
        List<Object> commands = Collections.emptyList();
        try {
            Field optionsField = BeeLine.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            Options options = (Options)optionsField.get((Object)this);
            BeeLine.BeelineParser beelineParser = new BeeLine.BeelineParser(){

                protected void processOption(String arg, ListIterator iter) throws ParseException {
                    if (KyuubiBeeLine.PYTHON_MODE_PREFIX.equals(arg)) {
                        KyuubiBeeLine.this.pythonMode = true;
                    } else {
                        super.processOption(arg, iter);
                    }
                }
            };
            cl = beelineParser.parse(options, args);
            Method connectUsingArgsMethod = BeeLine.class.getDeclaredMethod("connectUsingArgs", BeeLine.BeelineParser.class, CommandLine.class);
            connectUsingArgsMethod.setAccessible(true);
            connSuccessful = (Boolean)connectUsingArgsMethod.invoke((Object)this, beelineParser, cl);
            exitField = BeeLine.class.getDeclaredField("exit");
            exitField.setAccessible(true);
            exit = (Boolean)exitField.get((Object)this);
        }
        catch (ParseException e1) {
            this.output(e1.getMessage());
            this.usage();
            return -1;
        }
        catch (Exception t) {
            this.error(t.getMessage());
            return 1;
        }
        if (!connSuccessful && !exit) {
            try {
                Method defaultBeelineConnectMethod = BeeLine.class.getDeclaredMethod("defaultBeelineConnect", CommandLine.class);
                defaultBeelineConnectMethod.setAccessible(true);
                connSuccessful = (Boolean)defaultBeelineConnectMethod.invoke((Object)this, cl);
            }
            catch (Exception t) {
                this.error(t.getMessage());
                return 1;
            }
        }
        if (exit) {
            return 1;
        }
        int code = 0;
        if (cl.getOptionValues('e') != null) {
            commands = Arrays.asList(cl.getOptionValues('e'));
            this.getOpts().setAllowMultiLineCommand(false);
        }
        if (!commands.isEmpty() && this.getOpts().getScriptFile() != null) {
            this.error("The '-e' and '-f' options cannot be specified simultaneously");
            return 1;
        }
        if (!commands.isEmpty() && !connSuccessful) {
            this.error("Cannot run commands specified using -e. No current connection");
            return 1;
        }
        if (!commands.isEmpty()) {
            Iterator<Object> i = commands.iterator();
            while (i.hasNext()) {
                String command = ((String)i.next()).toString();
                this.debug(this.loc("executing-command", command));
                if (this.dispatch(command)) continue;
                ++code;
            }
            try {
                exit = true;
                exitField.set((Object)this, exit);
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return 1;
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runInit() {
        String[] initFiles = this.getOpts().getInitFiles();
        int executionResult = 0;
        boolean exitOnError = !this.getOpts().getForce();
        Field exitField = null;
        if (initFiles != null && initFiles.length != 0) {
            for (String initFile : initFiles) {
                block12: {
                    boolean exit;
                    int t2;
                    this.info("Running init script " + initFile);
                    try {
                        int currentResult;
                        try {
                            Method executeFileMethod = BeeLine.class.getDeclaredMethod("executeFile", String.class);
                            executeFileMethod.setAccessible(true);
                            currentResult = (Integer)executeFileMethod.invoke(null, initFile);
                            exitField = BeeLine.class.getDeclaredField("exit");
                            exitField.setAccessible(true);
                        }
                        catch (Exception t2) {
                            this.error(t2.getMessage());
                            currentResult = 2;
                        }
                        if (currentResult == 0) break block12;
                        executionResult = currentResult;
                        if (!exitOnError) break block12;
                        t2 = executionResult;
                        exit = exitOnError && executionResult != 0;
                    }
                    catch (Throwable throwable) {
                        boolean exit2 = exitOnError && executionResult != 0;
                        try {
                            exitField.set((Object)this, exit2);
                        }
                        catch (Exception t3) {
                            this.error(t3.getMessage());
                            return 2;
                        }
                        throw throwable;
                    }
                    try {
                        exitField.set((Object)this, exit);
                    }
                    catch (Exception t4) {
                        this.error(t4.getMessage());
                        return 2;
                    }
                    return t2;
                }
                boolean exit = exitOnError && executionResult != 0;
                try {
                    exitField.set((Object)this, exit);
                }
                catch (Exception t) {
                    this.error(t.getMessage());
                    return 2;
                }
            }
        }
        return executionResult;
    }

    boolean dispatch(String line) {
        return super.dispatch(this.isPythonMode() ? line : HiveStringUtils.removeComments((String)line));
    }

    static {
        try {
            Class<?> bridgeClass = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            bridgeClass.getMethod("removeHandlersForRootLogger", new Class[0]).invoke(null, new Object[0]);
            boolean installed = (Boolean)bridgeClass.getMethod("isInstalled", new Class[0]).invoke(null, new Object[0]);
            if (!installed) {
                bridgeClass.getMethod("install", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

