/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import scala.Tuple2;

public final class SignUtils$ {
    public static SignUtils$ MODULE$;
    private KeyPairGenerator ecKeyPairGenerator;
    private final String KEYPAIR_ALGORITHM_EC;
    private volatile boolean bitmap$0;

    static {
        new SignUtils$();
    }

    public String KEYPAIR_ALGORITHM_EC() {
        return this.KEYPAIR_ALGORITHM_EC;
    }

    /*
     * WARNING - void declaration
     */
    private KeyPairGenerator ecKeyPairGenerator$lzycompute() {
        SignUtils$ signUtils$ = this;
        synchronized (signUtils$) {
            if (!this.bitmap$0) {
                void var2_2;
                KeyPairGenerator g = KeyPairGenerator.getInstance(this.KEYPAIR_ALGORITHM_EC());
                g.initialize(new ECGenParameterSpec("secp256k1"), new SecureRandom());
                this.ecKeyPairGenerator = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.ecKeyPairGenerator;
    }

    private KeyPairGenerator ecKeyPairGenerator() {
        if (!this.bitmap$0) {
            return this.ecKeyPairGenerator$lzycompute();
        }
        return this.ecKeyPairGenerator;
    }

    public Tuple2<PrivateKey, PublicKey> generateKeyPair(String algorithm) {
        String string = algorithm.toUpperCase();
        if (!"EC".equals(string)) {
            throw new InvalidParameterException(new StringBuilder(48).append("algorithm ").append(algorithm).append(" not supported for key pair generation").toString());
        }
        KeyPairGenerator generator = this.ecKeyPairGenerator();
        KeyPair keyPair = generator.generateKeyPair();
        return new Tuple2((Object)keyPair.getPrivate(), (Object)keyPair.getPublic());
    }

    public String generateKeyPair$default$1() {
        return "EC";
    }

    public String signWithPrivateKey(String plainText, PrivateKey privateKey, String algorithm) {
        Signature privateSignature = Signature.getInstance(algorithm);
        privateSignature.initSign(privateKey);
        privateSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = privateSignature.sign();
        return Base64.getEncoder().encodeToString(signatureBytes);
    }

    public String signWithPrivateKey$default$3() {
        return "SHA256withECDSA";
    }

    public boolean verifySignWithECDSA(String plainText, String signatureBase64, String publicKeyBase64) {
        boolean bl;
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyBase64);
            ECPublicKey publicKey = (ECPublicKey)KeyFactory.getInstance(this.KEYPAIR_ALGORITHM_EC()).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
            Signature publicSignature = Signature.getInstance("SHA256withECDSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
            bl = publicSignature.verify(signatureBytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(77).append("signature verification failed: publicKeyBase64:").append(publicKeyBase64).append(", signatureBase64:").append(signatureBase64).append(", plainText:").append(plainText).toString(), e);
        }
        return bl;
    }

    private SignUtils$() {
        MODULE$ = this;
        this.KEYPAIR_ALGORITHM_EC = "EC";
    }
}

