/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.immutable.Set;

public final class KyuubiAuthenticationFactory$
implements Logging {
    public static KyuubiAuthenticationFactory$ MODULE$;
    private final String HS2_PROXY_USER;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KyuubiAuthenticationFactory$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public boolean $lessinit$greater$default$2() {
        return true;
    }

    public String HS2_PROXY_USER() {
        return this.HS2_PROXY_USER;
    }

    public void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, Configuration hadoopConf) throws KyuubiSQLException {
        try {
            UserGroupInformation sessionUgi;
            UserGroupInformation userGroupInformation;
            if (UserGroupInformation.isSecurityEnabled()) {
                KerberosName kerbName = new KerberosName(realUser);
                userGroupInformation = UserGroupInformation.createProxyUser((String)kerbName.getServiceName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            } else {
                userGroupInformation = sessionUgi = UserGroupInformation.createRemoteUser((String)realUser);
            }
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)hadoopConf);
                ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)sessionUgi), (String)ipAddress);
            }
        }
        catch (IOException e) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(43).append("Failed to validate proxy privilege of ").append(realUser).append(" for ").append(proxyUser).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
    }

    public Enumeration.Value getValidPasswordAuthMethod(Set<Enumeration.Value> authTypes) {
        Set<Enumeration.Value> set = authTypes;
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{AuthTypes$.MODULE$.NOSASL()}));
        if (!(set != null ? !set.equals((Object)genTraversable) : genTraversable != null)) {
            return AuthMethods$.MODULE$.NONE();
        }
        if (authTypes.contains((Object)AuthTypes$.MODULE$.NONE())) {
            return AuthMethods$.MODULE$.NONE();
        }
        if (authTypes.contains((Object)AuthTypes$.MODULE$.LDAP())) {
            return AuthMethods$.MODULE$.LDAP();
        }
        if (authTypes.contains((Object)AuthTypes$.MODULE$.JDBC())) {
            return AuthMethods$.MODULE$.JDBC();
        }
        if (authTypes.contains((Object)AuthTypes$.MODULE$.CUSTOM())) {
            return AuthMethods$.MODULE$.CUSTOM();
        }
        throw new IllegalArgumentException("No valid Password Auth detected");
    }

    private KyuubiAuthenticationFactory$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.HS2_PROXY_USER = "hive.server2.proxy.user";
    }
}

