/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Base64;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.client.KyuubiSyncThriftClient$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.command.RunnableCommand;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.thrift.transport.TTransportException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001B!C\u0001-C\u0011\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U/\t\u0013\u0001\u0004!\u0011!Q\u0001\n\u0005t\u0007\"C8\u0001\u0005\u0003\u0005\u000b\u0011B1q\u0011%\t\bA!A!\u0002\u0013\t'\u000fC\u0005t\u0001\t\u0005\t\u0015!\u0003uo\"I\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010 \u0005\t{\u0002\u0011\t\u0011)A\u0005}\"Q\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0003\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !I\u00111\u0007\u0001C\u0002\u0013\u0005\u0013Q\u0007\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u00028!Q\u0011q\u000b\u0001C\u0002\u0013\u0005A)!\u0017\t\u000f\u0005m\u0003\u0001)A\u0005i\"Q\u0011Q\f\u0001\t\u0006\u0004%I!a\u0018\t\u0015\u0005\u0005\u0004\u0001#b\u0001\n\u0003\t\u0019\u0007\u0003\u0006\u0002p\u0001\u0011\r\u0011\"\u0001E\u0003cB\u0001\"a \u0001A\u0003%\u00111\u000f\u0005\u000b\u0003\u0003\u0003\u0001R1A\u0005\n\u0005}\u0003\"CAB\u0001\t\u0007I\u0011BAC\u0011!\t\u0019\n\u0001Q\u0001\n\u0005\u001d\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003C\u0003A\u0011IAR\u0011-\tY\u000b\u0001a\u0001\u0002\u0004%I!!,\t\u0017\u0005m\u0006\u00011AA\u0002\u0013%\u0011Q\u0018\u0005\f\u0003\u0007\u0004\u0001\u0019!A!B\u0013\ty\u000bC\u0004\u00026\u0002!\t!!,\t\u0017\u0005\u0015\u0007\u00011AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003\u001f\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u000eC\u0006\u0002V\u0002\u0001\r\u0011!Q!\n\u0005%\u0007\"CAl\u0001\u0001\u0007I\u0011BAm\u0011%\ty\u000f\u0001a\u0001\n\u0013\t\t\u0010\u0003\u0005\u0002v\u0002\u0001\u000b\u0015BAn\u0011\u001d\t9\u0010\u0001C!\u0003GC\u0001\"!?\u0001\t\u0003!\u00151 \u0005\u000b\u0005\u001f\u0001\u0011\u0013!C\u0001\t\nE\u0001b\u0002B\u0014\u0001\u0011E#\u0011\u0006\u0005\n\u0005g\u0001\u0001\u0019!C\u0005\u0005kA\u0011B!\u0010\u0001\u0001\u0004%IAa\u0010\t\u0011\t\r\u0003\u0001)Q\u0005\u0005oAqA!\u0014\u0001\t\u0013\t\u0019\u000bC\u0004\u0003P\u0001!IA!\u0015\t\u000f\tM\u0003\u0001\"\u0011\u0002$\"9!Q\u000b\u0001\u0005B\t]\u0003b\u0002B5\u0001\u0011\u0005#1\u000e\u0005\f\u0005\u0007\u0003\u0001\u0019!a\u0001\n\u0013\u0011)\tC\u0006\u0003\b\u0002\u0001\r\u00111A\u0005\n\t%\u0005b\u0003BG\u0001\u0001\u0007\t\u0011)Q\u0005\u0005{B\u0011B!%\u0001\u0005\u0004%\tA!\"\t\u0011\tM\u0005\u0001)A\u0005\u0005{B\u0011B!&\u0001\u0005\u0004%\tA!\u000e\t\u0011\t]\u0005\u0001)A\u0005\u0005oA\u0011B!'\u0001\u0001\u0004%\tAa'\t\u0013\t\r\u0006\u00011A\u0005\u0002\t\u0015\u0006\u0002\u0003BU\u0001\u0001\u0006KA!(\t\u0013\t-\u0006\u00011A\u0005\u0002\tm\u0005\"\u0003BW\u0001\u0001\u0007I\u0011\u0001BX\u0011!\u0011\u0019\f\u0001Q!\n\tu\u0005b\u0002B[\u0001\u0011\u0005!q\u0017\u0005\u000e\u0005s\u0003\u0001\u0013aA\u0001\u0002\u0013%\u0011q\f8\t\u001d\tm\u0006\u0001%A\u0002\u0002\u0003%I!a)\u0003>\"i!q\u0018\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003BrDQB!3\u0001!\u0003\r\t\u0011!C\u0005\u0003?\u0002\b\"\u0004Bf\u0001A\u0005\u0019\u0011!A\u0005\n\t5W\f\u0003\b\u0003P\u0002\u0001\n1!A\u0001\n\u0013\u0011\tNa7\u0003#-KX/\u001e2j'\u0016\u001c8/[8o\u00136\u0004HN\u0003\u0002D\t\u000691/Z:tS>t'BA#G\u0003\u0019Y\u00170^;cS*\u0011q\tS\u0001\u0007CB\f7\r[3\u000b\u0003%\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001'\u0011\u00055sU\"\u0001\"\n\u0005=\u0013%!D&zkV\u0014\u0017nU3tg&|g.\u0001\u0005qe>$xnY8m!\t\u00116,D\u0001T\u0015\t!V+\u0001\u0004uQJLg\r\u001e\u0006\u0003-^\u000b1A\u001d9d\u0015\tA\u0016,A\u0004tKJ4\u0018nY3\u000b\u0005i3\u0015\u0001\u00025jm\u0016L!\u0001X*\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0017B\u0001)_\u0013\ty&IA\bBEN$(/Y2u'\u0016\u001c8/[8o\u0003\u0011)8/\u001a:\u0011\u0005\t\\gBA2j!\t!w-D\u0001f\u0015\t1'*\u0001\u0004=e>|GO\u0010\u0006\u0002Q\u0006)1oY1mC&\u0011!nZ\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002kO&\u0011\u0001MX\u0001\ta\u0006\u001c8o^8sI&\u0011qNX\u0001\nSB\fE\r\u001a:fgNL!!\u001d0\u0002\t\r|gN\u001a\t\u0005EV\f\u0017-\u0003\u0002w[\n\u0019Q*\u00199\n\u0005Mt\u0016AD:fgNLwN\\'b]\u0006<WM\u001d\t\u0003\u001bjL!a\u001f\"\u0003)-KX/\u001e2j'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0013\tAh,A\u0006tKN\u001c\u0018n\u001c8D_:4\u0007cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007!\u0015AB2p]\u001aLw-\u0003\u0003\u0002\b\u0005\u0005!AC&zkV\u0014\u0017nQ8oM\u00061\u0001/\u0019:tKJ\u0004B!!\u0004\u0002\u001a5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004tKJ4XM\u001d\u0006\u0005\u0003\u0013\t)BC\u0002\u0002\u0018\u0011\u000b1a]9m\u0013\u0011\tY\"a\u0004\u0003\u0019-KX/\u001e2j!\u0006\u00148/\u001a:\u0002\rqJg.\u001b;?)I\t\t#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u0011\u00055\u0003\u0001\"\u0002)\n\u0001\u0004\t\u0006\"\u00021\n\u0001\u0004\t\u0007\"B8\n\u0001\u0004\t\u0007\"B9\n\u0001\u0004\t\u0007\"B:\n\u0001\u0004!\b\"\u0002=\n\u0001\u0004I\b\"B?\n\u0001\u0004q\bbBA\u0005\u0013\u0001\u0007\u00111B\u0001\fg\u0016\u001c8/[8o)f\u0004X-\u0006\u0002\u00028A!\u0011\u0011HA(\u001d\u0011\tY$a\u0013\u000f\t\u0005u\u0012\u0011\n\b\u0005\u0003\u007f\t9E\u0004\u0003\u0002B\u0005\u0015cb\u00013\u0002D%\t\u0011*\u0003\u0002H\u0011&\u0011QIR\u0005\u0003\u0007\u0012K1!!\u0014C\u0003-\u0019Vm]:j_:$\u0016\u0010]3\n\t\u0005E\u00131\u000b\u0002\f'\u0016\u001c8/[8o)f\u0004XMC\u0002\u0002N\t\u000bAb]3tg&|g\u000eV=qK\u0002\nQb\u001c9uS6L'0\u001a3D_:4W#\u0001;\u0002\u001d=\u0004H/[7ju\u0016$7i\u001c8gA\u0005\tRM\\4j]\u0016\u001c%/\u001a3f]RL\u0017\r\\:\u0016\u0003\u0005\fa!\u001a8hS:,WCAA3!\u0011\t9'a\u001b\u000e\u0005\u0005%$bAA1\t&!\u0011QNA5\u0005%)enZ5oKJ+g-\u0001\bmCVt7\r[#oO&tWm\u00149\u0016\u0005\u0005M\u0004\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005eD)A\u0005pa\u0016\u0014\u0018\r^5p]&!\u0011QPA<\u0005%y\u0005/\u001a:bi&|g.A\bmCVt7\r[#oO&tWm\u00149!\u0003U\u0019Xm]:j_:,6/\u001a:TS\u001et')Y:fmQ\nAb]3tg&|g.\u0012<f]R,\"!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$E\u0003\u0019)g/\u001a8ug&!\u0011\u0011SAF\u0005IY\u00150^;cSN+7o]5p]\u00163XM\u001c;\u0002\u001bM,7o]5p]\u00163XM\u001c;!\u0003=9W\r^*fgNLwN\\#wK:$XCAAM!\u0019\tY*!(\u0002\b6\tq-C\u0002\u0002 \u001e\u0014aa\u00149uS>t\u0017AG2iK\u000e\\7+Z:tS>t\u0017iY2fgN\u0004\u0016\r\u001e5V%&\u001bHCAAS!\u0011\tY*a*\n\u0007\u0005%vM\u0001\u0003V]&$\u0018aB0dY&,g\u000e^\u000b\u0003\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k#\u0015AB2mS\u0016tG/\u0003\u0003\u0002:\u0006M&AF&zkV\u0014\u0017nU=oGRC'/\u001b4u\u00072LWM\u001c;\u0002\u0017}\u001bG.[3oi~#S-\u001d\u000b\u0005\u0003K\u000by\fC\u0005\u0002Bb\t\t\u00111\u0001\u00020\u0006\u0019\u0001\u0010J\u0019\u0002\u0011}\u001bG.[3oi\u0002\nAcX3oO&tWmU3tg&|g\u000eS1oI2,WCAAe!\ri\u00151Z\u0005\u0004\u0003\u001b\u0014%!D*fgNLwN\u001c%b]\u0012dW-\u0001\r`K:<\u0017N\\3TKN\u001c\u0018n\u001c8IC:$G.Z0%KF$B!!*\u0002T\"I\u0011\u0011\u0019\u000f\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0016?\u0016tw-\u001b8f'\u0016\u001c8/[8o\u0011\u0006tG\r\\3!\u0003Ay\u0007/\u001a8TKN\u001c\u0018n\u001c8FeJ|'/\u0006\u0002\u0002\\B1\u00111TAO\u0003;\u0004B!a8\u0002j:!\u0011\u0011]As\u001d\r!\u00171]\u0005\u0002Q&\u0019\u0011q]4\u0002\u000fA\f7m[1hK&!\u00111^Aw\u0005%!\u0006N]8xC\ndWMC\u0002\u0002h\u001e\fAc\u001c9f]N+7o]5p]\u0016\u0013(o\u001c:`I\u0015\fH\u0003BAS\u0003gD\u0011\"!1 \u0003\u0003\u0005\r!a7\u0002#=\u0004XM\\*fgNLwN\\#se>\u0014\b%\u0001\u0003pa\u0016t\u0017!E8qK:,enZ5oKN+7o]5p]R!\u0011QUA\u007f\u0011%\tyP\tI\u0001\u0002\u0004\u0011\t!\u0001\bfqR\u0014\u0018-\u00128hS:,Gj\\4\u0011\r\u0005m\u0015Q\u0014B\u0002!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003o\n1\u0001\\8h\u0013\u0011\u0011iAa\u0002\u0003\u0019=\u0003XM]1uS>tGj\\4\u00027=\u0004XM\\#oO&tWmU3tg&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019B\u000b\u0003\u0003\u0002\tU1F\u0001B\f!\u0011\u0011IBa\t\u000e\u0005\tm!\u0002\u0002B\u000f\u0005?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005r-\u0001\u0006b]:|G/\u0019;j_:LAA!\n\u0003\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019I,hn\u00149fe\u0006$\u0018n\u001c8\u0015\t\t-\"\u0011\u0007\t\u0005\u0003k\u0012i#\u0003\u0003\u00030\u0005]$aD(qKJ\fG/[8o\u0011\u0006tG\r\\3\t\u000f\u0005eD\u00051\u0001\u0002t\u0005qQM\\4j]\u0016d\u0015-\u001e8dQ\u0016$WC\u0001B\u001c!\u0011\tYJ!\u000f\n\u0007\tmrMA\u0004C_>dW-\u00198\u0002%\u0015tw-\u001b8f\u0019\u0006,hn\u00195fI~#S-\u001d\u000b\u0005\u0003K\u0013\t\u0005C\u0005\u0002B\u001a\n\t\u00111\u0001\u00038\u0005yQM\\4j]\u0016d\u0015-\u001e8dQ\u0016$\u0007\u0005K\u0002(\u0005\u000f\u0002B!a'\u0003J%\u0019!1J4\u0003\u0011Y|G.\u0019;jY\u0016\fQc^1ji\u001a{'/\u00128hS:,G*Y;oG\",G-\u0001\fsK:,w/\u00128hS:,7I]3eK:$\u0018.\u00197t)\u0005\t\u0017!B2m_N,\u0017aB4fi&sgm\u001c\u000b\u0005\u00053\u0012y\u0006E\u0002S\u00057J1A!\u0018T\u00055!v)\u001a;J]\u001a|g+\u00197vK\"9!\u0011M\u0016A\u0002\t\r\u0014\u0001C5oM>$\u0016\u0010]3\u0011\u0007I\u0013)'C\u0002\u0003hM\u0013A\u0002V$fi&sgm\u001c+za\u0016\f\u0001#\u001a=fGV$Xm\u0015;bi\u0016lWM\u001c;\u0015\u0015\t-\"Q\u000eB9\u0005k\u0012I\b\u0003\u0004\u0003p1\u0002\r!Y\u0001\ngR\fG/Z7f]RDaAa\u001d-\u0001\u0004!\u0018aC2p]\u001a|e/\u001a:mCfDqAa\u001e-\u0001\u0004\u00119$\u0001\u0005sk:\f5/\u001f8d\u0011\u001d\u0011Y\b\fa\u0001\u0005{\nA\"];fef$\u0016.\\3pkR\u0004B!a'\u0003\u0000%\u0019!\u0011Q4\u0003\t1{gnZ\u0001\u0010K:<\u0017N\\3MCN$\u0018\t\\5wKV\u0011!QP\u0001\u0014K:<\u0017N\\3MCN$\u0018\t\\5wK~#S-\u001d\u000b\u0005\u0003K\u0013Y\tC\u0005\u0002B:\n\t\u00111\u0001\u0003~\u0005\u0001RM\\4j]\u0016d\u0015m\u001d;BY&4X\r\t\u0015\u0004_\t\u001d\u0013AE3oO&tW-\u00117jm\u0016$\u0016.\\3pkR\f1#\u001a8hS:,\u0017\t\\5wKRKW.Z8vi\u0002\n\u0011#\u00197jm\u0016\u0004&o\u001c2f\u000b:\f'\r\\3e\u0003I\tG.\u001b<f!J|'-Z#oC\ndW\r\u001a\u0011\u0002/\u0015tw-\u001b8f\u00032Lg/Z'bq\u001a\u000b\u0017\u000e\\\"pk:$XC\u0001BO!\u0011\tYJa(\n\u0007\t\u0005vMA\u0002J]R\f1$\u001a8hS:,\u0017\t\\5wK6\u000b\u0007PR1jY\u000e{WO\u001c;`I\u0015\fH\u0003BAS\u0005OC\u0011\"!16\u0003\u0003\u0005\rA!(\u00021\u0015tw-\u001b8f\u00032Lg/Z'bq\u001a\u000b\u0017\u000e\\\"pk:$\b%\u0001\u000bf]\u001eLg.Z!mSZ,g)Y5m\u0007>,h\u000e^\u0001\u0019K:<\u0017N\\3BY&4XMR1jY\u000e{WO\u001c;`I\u0015\fH\u0003BAS\u0005cC\u0011\"!19\u0003\u0003\u0005\rA!(\u0002+\u0015tw-\u001b8f\u00032Lg/\u001a$bS2\u001cu.\u001e8uA\u0005Q2\r[3dW\u0016sw-\u001b8f\u0007>tg.Z2uS>t\u0017\t\\5wKR\u0011!qG\u0001\u000bgV\u0004XM\u001d\u0013vg\u0016\u0014\u0018AC:va\u0016\u0014He\u001c9f]&\u0019\u0011q\u001f0\u0002)M,\b/\u001a:%g\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s+\t\u0011\u0019\rE\u0002N\u0005\u000bL1Aa2C\u00059\u0019Vm]:j_:l\u0015M\\1hKJ\fab];qKJ$\u0003/Y:to>\u0014H-\u0001\btkB,'\u000f\n9s_R|7m\u001c7\u0016\u0003E\u000bac];qKJ$S\r_3dkR,7\u000b^1uK6,g\u000e\u001e\u000b\u000b\u0005W\u0011\u0019N!6\u0003X\ne\u0007B\u0002B8\u0001\u0002\u0007\u0011\r\u0003\u0004\u0003t\u0001\u0003\r\u0001\u001e\u0005\b\u0005o\u0002\u0005\u0019\u0001B\u001c\u0011\u001d\u0011Y\b\u0011a\u0001\u0005{J1A!\u001b_\u0001")
public class KyuubiSessionImpl
extends KyuubiSession {
    private String engineCredentials;
    private EngineRef engine;
    private String sessionUserSignBase64;
    private final KyuubiConf sessionConf;
    private final KyuubiParser parser;
    private final Enumeration.Value sessionType;
    private final scala.collection.immutable.Map<String, String> optimizedConf;
    private final Operation launchEngineOp;
    private final KyuubiSessionEvent sessionEvent;
    private KyuubiSyncThriftClient _client;
    private SessionHandle _engineSessionHandle;
    private Option<Throwable> openSessionError;
    private volatile boolean engineLaunched;
    private volatile long engineLastAlive;
    private final long engineAliveTimeout;
    private final boolean aliveProbeEnabled;
    private int engineAliveMaxFailCount;
    private int engineAliveFailCount;
    private volatile byte bitmap$0;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ void super$open() {
        super.open();
    }

    private /* synthetic */ SessionManager super$sessionManager() {
        return super.sessionManager();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    private /* synthetic */ OperationHandle super$executeStatement(String statement, scala.collection.immutable.Map confOverlay, boolean runAsync, long queryTimeout) {
        return super.executeStatement(statement, confOverlay, runAsync, queryTimeout);
    }

    @Override
    public Enumeration.Value sessionType() {
        return this.sessionType;
    }

    public scala.collection.immutable.Map<String, String> optimizedConf() {
        return this.optimizedConf;
    }

    private String engineCredentials$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineCredentials = this.renewEngineCredentials();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineCredentials;
    }

    private String engineCredentials() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineCredentials$lzycompute();
        }
        return this.engineCredentials;
    }

    private EngineRef engine$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engine = new EngineRef(this.sessionConf, super.user(), ((KyuubiSessionManager)super.sessionManager()).groupProvider(), this.handle().identifier().toString(), ((KyuubiSessionManager)super.sessionManager()).applicationManager(), ((KyuubiSessionManager)super.sessionManager()).engineStartupProcessSemaphore());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engine;
    }

    public EngineRef engine() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engine$lzycompute();
        }
        return this.engine;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    private String sessionUserSignBase64$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionUserSignBase64 = SignUtils$.MODULE$.signWithPrivateKey(super.user(), ((KyuubiSessionManager)super.sessionManager()).signingPrivateKey(), SignUtils$.MODULE$.signWithPrivateKey$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionUserSignBase64;
    }

    private String sessionUserSignBase64() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionUserSignBase64$lzycompute();
        }
        return this.sessionUserSignBase64;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public Option<KyuubiSessionEvent> getSessionEvent() {
        return Option$.MODULE$.apply((Object)this.sessionEvent());
    }

    @Override
    public void checkSessionAccessPathURIs() {
        KyuubiApplicationManager$.MODULE$.checkApplicationAccessPaths((String)this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()), (scala.collection.immutable.Map<String, String>)this.sessionConf.getAll(), ((KyuubiSessionManager)super.sessionManager()).getConf());
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    private Option<Throwable> openSessionError() {
        return this.openSessionError;
    }

    private void openSessionError_$eq(Option<Throwable> x$1) {
        this.openSessionError = x$1;
    }

    public void open() {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.traceMetricsOnOpen();
            this.checkSessionAccessPathURIs();
            this.super$open();
            this.runOperation(this.launchEngineOp());
            this.engineLastAlive_$eq(System.currentTimeMillis());
        });
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DiscoveryClientProvider$.MODULE$.withDiscoveryClient($this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$2(this, extraEngineLog, discoveryClient);
            return BoxedUnit.UNIT;
        }));
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block2: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block2;
            try {
                this.waitForEngineLaunched();
            }
            catch (Throwable t) {
                operation.close();
                throw t;
            }
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private boolean engineLaunched() {
        return this.engineLaunched;
    }

    private void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private void waitForEngineLaunched() {
        if (!this.engineLaunched()) {
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String renewEngineCredentials() {
        String string;
        try {
            string = ((KyuubiSessionManager)super.sessionManager()).credentialsManager().renewCredentials(this.engine().appUser());
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to renew engine credentials for ").append(this.handle()).toString(), e);
            string = "";
        }
        return string;
    }

    public void close() {
        super.close();
        ((KyuubiSessionManager)super.sessionManager()).credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            if (this._client() != null) {
                this._client().closeSession();
            }
        }
        finally {
            this.openSessionError().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                KyuubiSessionImpl.$anonfun$close$1(this, x$3);
                return BoxedUnit.UNIT;
            });
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
            this.traceMetricsOnClose();
        }
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        String string = (String)this.sessionConf.get(KyuubiConf$.MODULE$.SERVER_INFO_PROVIDER());
        if ("SERVER".equals(string)) {
            return super.getInfo(infoType);
        }
        if ("ENGINE".equals(string)) {
            return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
                this.waitForEngineLaunched();
                return this.client().getInfo(infoType).getInfoValue();
            });
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unknown server info provider ").append(string).toString());
    }

    public OperationHandle executeStatement(String statement, scala.collection.immutable.Map<String, String> confOverlay, boolean runAsync, long queryTimeout) {
        return (OperationHandle)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiTreeNode kyuubiNode = $this.parser.parsePlan(statement);
            KyuubiTreeNode kyuubiTreeNode = kyuubiNode;
            if (kyuubiTreeNode instanceof RunnableCommand) {
                RunnableCommand runnableCommand = (RunnableCommand)kyuubiTreeNode;
                Operation operation = ((KyuubiSessionManager)this.super$sessionManager()).operationManager().newExecuteOnServerOperation(this, runAsync, runnableCommand);
                return this.runOperation(operation);
            }
            return this.super$executeStatement(statement, confOverlay, runAsync, queryTimeout);
        });
    }

    private long engineLastAlive() {
        return this.engineLastAlive;
    }

    private void engineLastAlive_$eq(long x$1) {
        this.engineLastAlive = x$1;
    }

    public long engineAliveTimeout() {
        return this.engineAliveTimeout;
    }

    public boolean aliveProbeEnabled() {
        return this.aliveProbeEnabled;
    }

    public int engineAliveMaxFailCount() {
        return this.engineAliveMaxFailCount;
    }

    public void engineAliveMaxFailCount_$eq(int x$1) {
        this.engineAliveMaxFailCount = x$1;
    }

    public int engineAliveFailCount() {
        return this.engineAliveFailCount;
    }

    public void engineAliveFailCount_$eq(int x$1) {
        this.engineAliveFailCount = x$1;
    }

    public boolean checkEngineConnectionAlive() {
        boolean bl;
        block5: {
            try {
                if (Option$.MODULE$.apply((Object)this.client()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.engineConnectionClosed()))) {
                    return false;
                }
                if (!this.aliveProbeEnabled()) {
                    return true;
                }
                this.getInfo(TGetInfoType.CLI_DBMS_VER);
                this.engineLastAlive_$eq(System.currentTimeMillis());
                this.engineAliveFailCount_$eq(0);
                bl = true;
            }
            catch (Throwable e) {
                long now = System.currentTimeMillis();
                this.engineAliveFailCount_$eq(this.engineAliveFailCount() + 1);
                if (now - this.engineLastAlive() > this.engineAliveTimeout() && this.engineAliveFailCount() >= this.engineAliveMaxFailCount()) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(229).append("The engineRef[").append(this.engine().getEngineRefId()).append("] is marked as not alive ").append("due to a lack of recent successful alive probes. ").append("The time since last successful probe: ").append(now - this.engineLastAlive()).append(" ms exceeds the timeout of ").append(this.engineAliveTimeout()).append(" ms. ").append("The engine has failed ").append(this.engineAliveFailCount()).append(" times, ").append("surpassing the maximum failure count of ").append(this.engineAliveMaxFailCount()).append(".").toString());
                    bl = false;
                    break block5;
                }
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("The engineRef[").append(this.engine().getEngineRefId()).append("] alive probe fails, ").append(now - this.engineLastAlive()).append(" ms exceeds timeout ").append(this.engineAliveTimeout()).append(" ms, ").append("and has failed ").append(this.engineAliveFailCount()).append(" times.").toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$9(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineId_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$2(KyuubiSessionImpl $this, Option extraEngineLog$1, DiscoveryClient discoveryClient) {
        scala.collection.immutable.Map openEngineSessionConf = $this.optimizedConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.handle"), (Object)$this.handle().identifier().toString())})));
        if (new StringOps(Predef$.MODULE$.augmentString($this.engineCredentials())).nonEmpty()) {
            $this.sessionConf.set("kyuubi.engine.credentials", $this.engineCredentials());
            openEngineSessionConf = openEngineSessionConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.engine.credentials"), (Object)$this.engineCredentials())})));
        }
        if (BoxesRunTime.unboxToBoolean((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()))) {
            openEngineSessionConf = openEngineSessionConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()), (Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()).toString())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.sign.publickey"), (Object)Base64.getEncoder().encodeToString(((KyuubiSessionManager)$this.super$sessionManager()).signingPublicKey().getEncoded()))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.user.sign"), (Object)$this.sessionUserSignBase64()));
        }
        int maxAttempts = BoxesRunTime.unboxToInt((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_MAX_ATTEMPTS()));
        long retryWait = BoxesRunTime.unboxToLong((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_RETRY_WAIT()));
        IntRef attempt = IntRef.create((int)0);
        boolean shouldRetry = true;
        while (attempt.elem <= maxAttempts && shouldRetry) {
            Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(discoveryClient, (Option<OperationLog>)extraEngineLog$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            try {
                try {
                    String passwd = BoxesRunTime.unboxToBoolean((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? InternalSecurityAccessor$.MODULE$.get().issueToken() : (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
                    $this._client_$eq(KyuubiSyncThriftClient$.MODULE$.createClient($this.super$user(), passwd, host2, port2, $this.sessionConf));
                    $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (scala.collection.immutable.Map<String, String>)openEngineSessionConf));
                    $this.logSessionInfo(new StringBuilder(33).append("Connected to engine [").append(host2).append(":").append(port2).append("]/[").append($this.client().engineId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("]").append(" with ").append($this._engineSessionHandle()).append("]").toString());
                    shouldRetry = false;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof TTransportException) {
                        TTransportException tTransportException = (TTransportException)throwable2;
                        if (attempt.elem < maxAttempts && tTransportException.getCause() instanceof ConnectException && tTransportException.getCause().getMessage().contains("Connection refused")) {
                            $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to open [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("] after").append(" ").append(attempt$1.elem).append("/").append(maxAttempts).append(" times, retrying").toString(), tTransportException.getCause());
                            Thread.sleep(retryWait);
                            shouldRetry = true;
                            continue;
                        }
                    }
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Opening engine [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").append(" for ").append($this.super$user()).append(" session failed").toString(), throwable3);
                        $this.openSessionError_$eq((Option<Throwable>)new Some((Object)throwable3));
                        throw throwable3;
                    }
                    throw throwable;
                }
            }
            finally {
                ++attempt.elem;
                if (!shouldRetry || $this._client() == null) continue;
                try {
                    $this._client().closeSession();
                }
                catch (Throwable e2) {
                    $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error on closing broken client of engine ").append("[").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").toString(), e2);
                }
            }
        }
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this._client().engineId().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$9($this, e);
            return BoxedUnit.UNIT;
        });
        EventBus$.MODULE$.post((KyuubiEvent)$this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(28).append("Failed to launch engine for ").append($this.handle()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$close$1(KyuubiSessionImpl $this, Throwable x$3) {
        if ($this.engine() != null) {
            $this.engine().close();
            return;
        }
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf, KyuubiParser parser) {
        scala.collection.immutable.Map map;
        this.sessionConf = sessionConf;
        this.parser = parser;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.sessionType = SessionType$.MODULE$.INTERACTIVE();
        java.util.Map confOverlay = ((KyuubiSessionManager)super.sessionManager()).sessionConfAdvisor().getConfOverlay(super.user(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.normalizedConf()).asJava());
        if (confOverlay != null) {
            map = this.normalizedConf().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(confOverlay).asScala());
        } else {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("the server plugin return null value for user: ").append(this.super$user()).append(", ignore it").toString());
            map = this.normalizedConf();
        }
        this.optimizedConf = map;
        this.optimizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = package$.MODULE$.USE_CATALOG();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string4 = package$.MODULE$.USE_DATABASE();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.sessionConf.set(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        this.launchEngineOp = ((KyuubiSessionManager)super.sessionManager()).operationManager().newLaunchEngineOperation(this, BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC())));
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        this.openSessionError = None$.MODULE$;
        this.engineLaunched = false;
        this.engineAliveTimeout = BoxesRunTime.unboxToLong((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_TIMEOUT()));
        this.aliveProbeEnabled = BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_ENABLED()));
        this.engineAliveMaxFailCount = 3;
        this.engineAliveFailCount = 0;
    }
}

