/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.apache.kyuubi.plugin.PluginLoader$;
import org.apache.kyuubi.plugin.SessionConfAdvisor;
import org.apache.kyuubi.server.metadata.MetadataManager;
import org.apache.kyuubi.server.metadata.MetadataRequestsRetryRef;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rUe\u0001B\u001e=\u0001\u0015C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u00061\u0002!I!\u0017\u0005\u00061\u0002!\t\u0001\u0018\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019A\u0007\u0001)A\u0005?\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0007BB9\u0001A\u0003%1\u000eC\u0004s\u0001\t\u0007I\u0011A:\t\ri\u0004\u0001\u0015!\u0003u\u0011\u001dY\bA1A\u0005\u0002qDq!a\u0002\u0001A\u0003%Q\u0010\u0003\u0006\u0002\n\u0001A)\u0019!C\u0001\u0003\u0017A!\"a\t\u0001\u0011\u000b\u0007I\u0011AA\u0013\u0011)\t\u0019\u0004\u0001EC\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007fA\u0011\"!\u0013\u0001\u0001\u0004%I!a\u0013\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003\u0003B\u0011\"!\u0017\u0001\u0001\u0004%I!a\u0010\t\u0013\u0005m\u0003\u00011A\u0005\n\u0005u\u0003\u0002CA1\u0001\u0001\u0006K!!\u0011\t\u0019\u0005U\u0003\u0001%A\t\b\u0004&I!a\u0019\t\u0015\u0005\u0005\u0005\u0001#b\u0001\n\u0003\t\u0019\t\u0003\u0006\u0002\u0006\u0002A)\u0019!C\u0001\u0003\u000fC\u0011\"!#\u0001\u0001\u0004%\t!a#\t\u0013\u0005}\u0005\u00011A\u0005\u0002\u0005\u0005\u0006\u0002CAS\u0001\u0001\u0006K!!$\t\u0013\u0005\u001d\u0006A1A\u0005\n\u0005%\u0006\u0002CAY\u0001\u0001\u0006I!a+\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011q\u0019\u0001\u0005R\u0005%\u0007b\u0002B\u0001\u0001\u0011\u0005#1\u0001\u0005\b\u0005+\u0001A\u0011\tB\f\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?A\u0011B!\u001d\u0001#\u0003%\tAa\u001d\t\u0011\t%\u0005\u0001\"\u0001?\u0005\u0017CqA!#\u0001\t\u0003\u0011\t\nC\u0004\u00034\u0002!\tA!.\t\u000f\t}\u0006\u0001\"\u0001\u0003B\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bg\u0001\u0011\u0005!q\u001a\u0005\b\u0005'\u0004A\u0011\u0001Bk\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005KDqA!;\u0001\t\u0003\u0011Y\u000fC\u0004\u0003z\u0002!\tAa?\t\u000f\r]\u0001\u0001\"\u0001\u0004\u001a!91Q\u0004\u0001\u0005\u0002\r}\u0001bBB\u001f\u0001\u0011\u00053q\b\u0005\b\u0007\u0003\u0002A\u0011AB\"\u0011\u001d\u0019Y\u0005\u0001C\u0001\u0007\u001bBqaa\u0015\u0001\t#\u001a)\u0006C\u0004\u0004X\u0001!Ia!\u0017\t\u0011\ru\u0003\u0001\"\u0001?\u0007?B\u0001ba\u001a\u0001\t\u0003q4\u0011\u000e\u0005\t\u0007[\u0002A\u0011\u0001 \u0004`!A1q\u000e\u0001\u0005\u0002y\u001a\t\bC\u0004\u0004v\u0001!Iaa\u001e\t\u000f\r5\u0005\u0001\"\u0003\u0004@!91q\u0012\u0001\u0005\n\rE%\u0001F&zkV\u0014\u0017nU3tg&|g.T1oC\u001e,'O\u0003\u0002>}\u000591/Z:tS>t'BA A\u0003\u0019Y\u00170^;cS*\u0011\u0011IQ\u0001\u0007CB\f7\r[3\u000b\u0003\r\u000b1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001$\u0011\u0005\u001dCU\"\u0001\u001f\n\u0005%c$AD*fgNLwN\\'b]\u0006<WM]\u0001\u0005]\u0006lW\r\u0005\u0002M+:\u0011Qj\u0015\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\u000ba\u0001\u0010:p_Rt$\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b\u0016A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V)\u0002\rqJg.\u001b;?)\tQ6\f\u0005\u0002H\u0001!)!J\u0001a\u0001\u0017R\t!,\u0001\u0004qCJ\u001cXM]\u000b\u0002?B\u0011\u0001MZ\u0007\u0002C*\u0011!mY\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005u#'BA3?\u0003\r\u0019\u0018\u000f\\\u0005\u0003O\u0006\u0014AbS=vk\nL\u0007+\u0019:tKJ\fq\u0001]1sg\u0016\u0014\b%\u0001\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4feV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o}\u0005Iq\u000e]3sCRLwN\\\u0005\u0003a6\u0014acS=vk\nLw\n]3sCRLwN\\'b]\u0006<WM]\u0001\u0012_B,'/\u0019;j_:l\u0015M\\1hKJ\u0004\u0013AE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003oz\n1b\u0019:fI\u0016tG/[1mg&\u0011\u0011P\u001e\u0002\u0019\u0011\u0006$wn\u001c9De\u0016$WM\u001c;jC2\u001cX*\u00198bO\u0016\u0014\u0018aE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ\u0004\u0013AE1qa2L7-\u0019;j_:l\u0015M\\1hKJ,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005a(\u0001\u0004f]\u001eLg.Z\u0005\u0004\u0003\u000by(\u0001G&zkV\u0014\u0017.\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe\u0006\u0019\u0012\r\u001d9mS\u000e\fG/[8o\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\u000eA1\u0011qBA\t\u0003+i\u0011!U\u0005\u0004\u0003'\t&AB(qi&|g\u000e\u0005\u0003\u0002\u0018\u0005}QBAA\r\u0015\u0011\tY\"!\b\u0002\u00115,G/\u00193bi\u0006T!A\u0019 \n\t\u0005\u0005\u0012\u0011\u0004\u0002\u0010\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006\u00112/Z:tS>t7i\u001c8g\u0003\u00124\u0018n]8s+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCP\u0001\u0007a2,x-\u001b8\n\t\u0005E\u00121\u0006\u0002\u0013'\u0016\u001c8/[8o\u0007>tg-\u00113wSN|'/A\u0007he>,\b\u000f\u0015:pm&$WM]\u000b\u0003\u0003o\u0001B!!\u000b\u0002:%!\u00111HA\u0016\u000559%o\\;q!J|g/\u001b3fe\u00069A.[7ji\u0016\u0014XCAA!!\u0019\ty!!\u0005\u0002DA\u0019q)!\u0012\n\u0007\u0005\u001dCH\u0001\bTKN\u001c\u0018n\u001c8MS6LG/\u001a:\u0002\u00171LW.\u001b;fe~#S-\u001d\u000b\u0005\u0003\u001b\n\u0019\u0006\u0005\u0003\u0002\u0010\u0005=\u0013bAA)#\n!QK\\5u\u0011%\t)\u0006EA\u0001\u0002\u0004\t\t%A\u0002yIE\n\u0001\u0002\\5nSR,'\u000fI\u0001\rE\u0006$8\r\u001b'j[&$XM]\u0001\u0011E\u0006$8\r\u001b'j[&$XM]0%KF$B!!\u0014\u0002`!I\u0011QK\n\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u000eE\u0006$8\r\u001b'j[&$XM\u001d\u0011\u0016\u0005\u0005\u0015\u0004\u0003CA\b\u0003O\nY'a\u001f\n\u0007\u0005%\u0014K\u0001\u0004UkBdWM\r\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003!\u0019XmY;sSRL(BAA;\u0003\u0011Q\u0017M^1\n\t\u0005e\u0014q\u000e\u0002\u000b!JLg/\u0019;f\u0017\u0016L\b\u0003BA7\u0003{JA!a \u0002p\tI\u0001+\u001e2mS\u000e\\U-_\u0001\u0012g&<g.\u001b8h!JLg/\u0019;f\u0017\u0016LXCAA6\u0003A\u0019\u0018n\u001a8j]\u001e\u0004VO\u00197jG.+\u00170\u0006\u0002\u0002|\u0005iRM\\4j]\u0016\u001cF/\u0019:ukB\u0004&o\\2fgN\u001cV-\\1qQ>\u0014X-\u0006\u0002\u0002\u000eB1\u0011qBA\t\u0003\u001f\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0006d_:\u001cWO\u001d:f]RTA!!'\u0002t\u0005!Q\u000f^5m\u0013\u0011\ti*a%\u0003\u0013M+W.\u00199i_J,\u0017!I3oO&tWm\u0015;beR,\b\u000f\u0015:pG\u0016\u001c8oU3nCBDwN]3`I\u0015\fH\u0003BA'\u0003GC\u0011\"!\u0016\u001a\u0003\u0003\u0005\r!!$\u0002=\u0015tw-\u001b8f'R\f'\u000f^;q!J|7-Z:t'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013\u0001H3oO&tWmQ8o]\u0016\u001cG/[8o\u00032Lg/Z\"iK\u000e\\WM]\u000b\u0003\u0003W\u0003B!!%\u0002.&!\u0011qVAJ\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u001eK:<\u0017N\\3D_:tWm\u0019;j_:\fE.\u001b<f\u0007\",7m[3sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\t\u00055\u0013q\u0017\u0005\b\u0003sk\u0002\u0019AA^\u0003\u0011\u0019wN\u001c4\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fS1!!1?\u0003\u0019\u0019wN\u001c4jO&!\u0011QYA`\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u000eGJ,\u0017\r^3TKN\u001c\u0018n\u001c8\u0015\u0019\u0005-\u0017\u0011[Aw\u0003c\f)0!?\u0011\u0007\u001d\u000bi-C\u0002\u0002Pr\u0012qaU3tg&|g\u000eC\u0004\u0002Tz\u0001\r!!6\u0002\u0011A\u0014x\u000e^8d_2\u0004B!a6\u0002j6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.\u0001\u0004uQJLg\r\u001e\u0006\u0005\u0003?\f\t/A\u0002sa\u000eTA!a9\u0002f\u000691/\u001a:wS\u000e,'bAAt\u0001\u0006!\u0001.\u001b<f\u0013\u0011\tY/!7\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0007BBAx=\u0001\u00071*\u0001\u0003vg\u0016\u0014\bBBAz=\u0001\u00071*\u0001\u0005qCN\u001cxo\u001c:e\u0011\u0019\t9P\ba\u0001\u0017\u0006I\u0011\u000e]!eIJ,7o\u001d\u0005\b\u0003ss\u0002\u0019AA~!\u0015a\u0015Q`&L\u0013\r\typ\u0016\u0002\u0004\u001b\u0006\u0004\u0018aC8qK:\u001cVm]:j_:$BB!\u0002\u0003\f\t5!q\u0002B\t\u0005'\u00012a\u0012B\u0004\u0013\r\u0011I\u0001\u0010\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000f\u0005Mw\u00041\u0001\u0002V\"1\u0011q^\u0010A\u0002-Ca!a= \u0001\u0004Y\u0005BBA|?\u0001\u00071\nC\u0004\u0002:~\u0001\r!a?\u0002\u0019\rdwn]3TKN\u001c\u0018n\u001c8\u0015\t\u00055#\u0011\u0004\u0005\b\u00057\u0001\u0003\u0019\u0001B\u0003\u00035\u0019Xm]:j_:D\u0015M\u001c3mK\u0006\u00112M]3bi\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8o)a\u0011\tCa\n\u0003*\t-\"Q\u0006B\u0018\u0005g\u0011ID!\u0010\u0003B\t]#q\r\t\u0004\u000f\n\r\u0012b\u0001B\u0013y\t\u00112*_;vE&\u0014\u0015\r^2i'\u0016\u001c8/[8o\u0011\u0019\ty/\ta\u0001\u0017\"1\u00111_\u0011A\u0002-Ca!a>\"\u0001\u0004Y\u0005bBA]C\u0001\u0007\u00111 \u0005\u0007\u0005c\t\u0003\u0019A&\u0002\u0013\t\fGo\u00195UsB,\u0007b\u0002B\u001bC\u0001\u0007!qG\u0001\nE\u0006$8\r\u001b(b[\u0016\u0004R!a\u0004\u0002\u0012-CaAa\u000f\"\u0001\u0004Y\u0015\u0001\u0003:fg>,(oY3\t\r\t}\u0012\u00051\u0001L\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0004\u0003D\u0005\u0002\rA!\u0012\u0002\u0013\t\fGo\u00195Be\u001e\u001c\b#\u0002B$\u0005#Ze\u0002\u0002B%\u0005\u001br1A\u0014B&\u0013\u0005\u0011\u0016b\u0001B(#\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B*\u0005+\u00121aU3r\u0015\r\u0011y%\u0015\u0005\n\u00037\t\u0003\u0013!a\u0001\u00053\u0002b!a\u0004\u0002\u0012\tm\u0003\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\t\t\u0005\u0014\u0011D\u0001\u0004CBL\u0017\u0002\u0002B3\u0005?\u0012\u0001\"T3uC\u0012\fG/\u0019\u0005\b\u0005S\n\u0003\u0019\u0001B6\u000311'o\\7SK\u000e|g/\u001a:z!\u0011\tyA!\u001c\n\u0007\t=\u0014KA\u0004C_>dW-\u00198\u0002;\r\u0014X-\u0019;f\u0005\u0006$8\r[*fgNLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%cA*\"A!\u001e+\t\te#qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u0019!1Q)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\nu$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001r\u000e]3o\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u0005\u0005\u000b\u0011i\tC\u0004\u0003\u0010\u000e\u0002\rA!\t\u0002\u0019\t\fGo\u00195TKN\u001c\u0018n\u001c8\u0015\u0015\t\u0015!1\u0013BK\u0005/\u0013I\n\u0003\u0004\u0002p\u0012\u0002\ra\u0013\u0005\u0007\u0003g$\u0003\u0019A&\t\r\u0005]H\u00051\u0001L\u0011\u001d\u0011Y\n\na\u0001\u0005;\u000bABY1uG\"\u0014V-];fgR\u0004BAa(\u000306\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013)+A\u0002ei>TAAa*\u0003*\u0006\u0011a/\r\u0006\u0005\u0005C\u0012YKC\u0002\u0003.z\naa\u00197jK:$\u0018\u0002\u0002BY\u0005C\u0013ABQ1uG\"\u0014V-];fgR\fA#\u001b8ji&\fG.\u001b>f\u0005\u0006$8\r[*uCR,G#C&\u00038\ne&1\u0018B_\u0011\u0019\ty/\na\u0001\u0017\"1\u0011q_\u0013A\u0002-Cq!!/&\u0001\u0004\tY\u0010C\u0004\u0003\u001c\u0016\u0002\rA!(\u0002\u001f\u001d,GOQ1uG\"\u001cVm]:j_:$BAa1\u0003FB1\u0011qBA\t\u0005CAqAa\u0007'\u0001\u0004\u0011)!\u0001\bj]N,'\u000f^'fi\u0006$\u0017\r^1\u0015\t\u00055#1\u001a\u0005\b\u000379\u0003\u0019\u0001B.\u00039)\b\u000fZ1uK6+G/\u00193bi\u0006$B!!\u0014\u0003R\"9\u00111\u0004\u0015A\u0002\tm\u0013aG4fi6+G/\u00193bi\u0006\u0014V-];fgR\u001c(+\u001a;ssJ+g\r\u0006\u0003\u0003X\n}\u0007CBA\b\u0003#\u0011I\u000e\u0005\u0003\u0002\u0018\tm\u0017\u0002\u0002Bo\u00033\u0011\u0001$T3uC\u0012\fG/\u0019*fcV,7\u000f^:SKR\u0014\u0018PU3g\u0011\u0019\u0011\t/\u000ba\u0001\u0017\u0006Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0002E\u0011,'+Z4jgR,'/T3uC\u0012\fG/\u0019*fcV,7\u000f^:SKR\u0014\u0018PU3g)\u0011\tiEa:\t\r\t\u0005(\u00061\u0001L\u0003e9W\r\u001e\"bi\u000eDgI]8n\u001b\u0016$\u0018\rZ1uCN#xN]3\u0015\t\t5(Q\u001f\t\u0007\u0003\u001f\t\tBa<\u0011\t\t}%\u0011_\u0005\u0005\u0005g\u0014\tKA\u0003CCR\u001c\u0007\u000e\u0003\u0004\u0003x.\u0002\raS\u0001\bE\u0006$8\r[%e\u0003m9W\r\u001e\"bi\u000eDWm\u001d$s_6lU\r^1eCR\f7\u000b^8sKRA!Q B\u0000\u0007\u0013\u0019\u0019\u0002\u0005\u0004\u0003H\tE#q\u001e\u0005\b\u0007\u0003a\u0003\u0019AB\u0002\u0003\u00191\u0017\u000e\u001c;feB!!QLB\u0003\u0013\u0011\u00199Aa\u0018\u0003\u001d5+G/\u00193bi\u00064\u0015\u000e\u001c;fe\"911\u0002\u0017A\u0002\r5\u0011\u0001\u00024s_6\u0004B!a\u0004\u0004\u0010%\u00191\u0011C)\u0003\u0007%sG\u000fC\u0004\u0004\u00161\u0002\ra!\u0004\u0002\tML'0Z\u0001\u0011O\u0016$()\u0019;dQ6+G/\u00193bi\u0006$BA!\u0017\u0004\u001c!1!q_\u0017A\u0002-\u000bqb\u00197fC:,\b/T3uC\u0012\fG/\u0019\u000b\u0005\u0003\u001b\u001a\t\u0003\u0003\u0004\u0003b:\u0002\ra\u0013\u0015\u0004]\r\u0015\u0002\u0003BB\u0014\u0007si!a!\u000b\u000b\t\r-2QF\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u00040\rE\u0012AB2p[6|gN\u0003\u0003\u00044\rU\u0012AB4p_\u001edWM\u0003\u0002\u00048\u0005\u00191m\\7\n\t\rm2\u0011\u0006\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017!B:uCJ$HCAA'\u0003e9W\r\u001e\"bi\u000eD7+Z:tS>t7\u000fV8SK\u000e|g/\u001a:\u0015\t\r\u00153q\t\t\u0007\u0005\u000f\u0012\tF!\t\t\r\r%\u0003\u00071\u0001L\u00039Y\u00170^;cS&s7\u000f^1oG\u0016\f!eZ3u!\u0016,'/\u00138ti\u0006t7-Z\"m_N,GMQ1uG\"\u001cVm]:j_:\u001cH\u0003BB(\u0007#\u0002bAa\u0012\u0003R\tm\u0003BBB%c\u0001\u00071*\u0001\u0005jgN+'O^3s+\t\u0011Y'\u0001\nj]&$8+Z:tS>tG*[7ji\u0016\u0014H\u0003BA'\u00077Bq!!/4\u0001\u0004\tY,A\thKR,f\u000e\\5nSR,G-V:feN,\"a!\u0019\u0011\t1\u001b\u0019gS\u0005\u0004\u0007K:&aA*fi\u0006)\"/\u001a4sKNDWK\u001c7j[&$X\rZ+tKJ\u001cH\u0003BA'\u0007WBq!!/6\u0001\u0004\tY,\u0001\u0007hKR$UM\\=Vg\u0016\u00148/\u0001\tsK\u001a\u0014Xm\u001d5EK:LXk]3sgR!\u0011QJB:\u0011\u001d\tIl\u000ea\u0001\u0003w\u000b1#\u00199qYf\u001cVm]:j_:d\u0015.\\5uKJ$B\"!\u0011\u0004z\ru4\u0011QBC\u0007\u0013Cqaa\u001f9\u0001\u0004\u0019i!A\u0005vg\u0016\u0014H*[7ji\"91q\u0010\u001dA\u0002\r5\u0011AD5q\u0003\u0012$'/Z:t\u0019&l\u0017\u000e\u001e\u0005\b\u0007\u0007C\u0004\u0019AB\u0007\u0003I)8/\u001a:Ja\u0006#GM]3tg2KW.\u001b;\t\u000f\r\u001d\u0005\b1\u0001\u0004b\u0005\tRo]3s+:d\u0017.\\5uK\u0012d\u0015n\u001d;\t\u000f\r-\u0005\b1\u0001\u0004b\u0005aQo]3s\t\u0016t\u0017\u0010T5ti\u000692\u000f^1si\u0016sw-\u001b8f\u00032Lg/Z\"iK\u000e\\WM]\u0001\"S:LG/\u00128hS:,7\u000b^1siV\u0004\bK]8dKN\u001c8+Z7ba\"|'/\u001a\u000b\u0005\u0003\u001b\u001a\u0019\nC\u0004\u0002:j\u0002\r!a/")
public class KyuubiSessionManager
extends SessionManager {
    private Option<MetadataManager> metadataManager;
    private SessionConfAdvisor sessionConfAdvisor;
    private GroupProvider groupProvider;
    private Tuple2<PrivateKey, PublicKey> x$1;
    private PrivateKey signingPrivateKey;
    private PublicKey signingPublicKey;
    private final KyuubiParser parser = new KyuubiParser();
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();
    private final KyuubiApplicationManager applicationManager = new KyuubiApplicationManager();
    private Option<SessionLimiter> limiter = None$.MODULE$;
    private Option<SessionLimiter> batchLimiter = None$.MODULE$;
    private Option<Semaphore> engineStartupProcessSemaphore = None$.MODULE$;
    private final ScheduledExecutorService engineConnectionAliveChecker;
    private volatile byte bitmap$0;

    private KyuubiParser parser() {
        return this.parser;
    }

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public KyuubiApplicationManager applicationManager() {
        return this.applicationManager;
    }

    private Option<MetadataManager> metadataManager$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metadataManager = this.conf().isRESTEnabled() ? new Some((Object)new MetadataManager()) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metadataManager;
    }

    public Option<MetadataManager> metadataManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metadataManager$lzycompute();
        }
        return this.metadataManager;
    }

    private SessionConfAdvisor sessionConfAdvisor$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sessionConfAdvisor = PluginLoader$.MODULE$.loadSessionConfAdvisor(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sessionConfAdvisor;
    }

    public SessionConfAdvisor sessionConfAdvisor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sessionConfAdvisor$lzycompute();
        }
        return this.sessionConfAdvisor;
    }

    private GroupProvider groupProvider$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.groupProvider = PluginLoader$.MODULE$.loadGroupProvider(this.conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.groupProvider;
    }

    public GroupProvider groupProvider() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.groupProvider$lzycompute();
        }
        return this.groupProvider;
    }

    private Option<SessionLimiter> limiter() {
        return this.limiter;
    }

    private void limiter_$eq(Option<SessionLimiter> x$1) {
        this.limiter = x$1;
    }

    private Option<SessionLimiter> batchLimiter() {
        return this.batchLimiter;
    }

    private void batchLimiter_$eq(Option<SessionLimiter> x$1) {
        this.batchLimiter = x$1;
    }

    private Tuple2<PrivateKey, PublicKey> x$1$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Tuple2 tuple2 = SignUtils$.MODULE$.generateKeyPair(SignUtils$.MODULE$.generateKeyPair$default$1());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                PrivateKey signingPrivateKey = (PrivateKey)tuple2._1();
                PublicKey signingPublicKey = (PublicKey)tuple2._2();
                this.x$1 = new Tuple2((Object)signingPrivateKey, (Object)signingPublicKey);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private PrivateKey signingPrivateKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.signingPrivateKey = (PrivateKey)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.signingPrivateKey;
    }

    public PrivateKey signingPrivateKey() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.signingPrivateKey$lzycompute();
        }
        return this.signingPrivateKey;
    }

    private PublicKey signingPublicKey$lzycompute() {
        KyuubiSessionManager kyuubiSessionManager = this;
        synchronized (kyuubiSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.signingPublicKey = (PublicKey)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.signingPublicKey;
    }

    public PublicKey signingPublicKey() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.signingPublicKey$lzycompute();
        }
        return this.signingPublicKey;
    }

    public Option<Semaphore> engineStartupProcessSemaphore() {
        return this.engineStartupProcessSemaphore;
    }

    public void engineStartupProcessSemaphore_$eq(Option<Semaphore> x$1) {
        this.engineStartupProcessSemaphore = x$1;
    }

    private ScheduledExecutorService engineConnectionAliveChecker() {
        return this.engineConnectionAliveChecker;
    }

    public void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService((Service)this.applicationManager());
        this.addService((Service)this.credentialsManager());
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        this.initSessionLimiter(conf);
        this.initEngineStartupProcessSemaphore(conf);
        super.initialize(conf);
    }

    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        return new KyuubiSessionImpl(protocol, user, password, ipAddress, conf, this, this.getConf().getUserDefaults(user), this.parser());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.increment(new UserIpAddress(username, ipAddress));
            return BoxedUnit.UNIT;
        });
        try {
            sessionHandle = super.openSession(protocol, username, password, ipAddress, conf);
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        Session session = this.getSession(sessionHandle);
        try {
            super.closeSession(sessionHandle);
        }
        finally {
            Session session2 = session;
            if (session2 instanceof KyuubiBatchSession) {
                this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            } else {
                this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.decrement(new UserIpAddress(session.user(), session.ipAddress()));
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public KyuubiBatchSession createBatchSession(String user, String password, String ipAddress, Map<String, String> conf, String batchType, Option<String> batchName, String resource, String className, Seq<String> batchArgs, Option<Metadata> metadata, boolean fromRecovery) {
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$createBatchSession$1(x$6))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiConf sessionConf = this.getConf().getUserDefaults(user);
        return new KyuubiBatchSession(username, password, ipAddress, conf, this, sessionConf, batchType, batchName, resource, className, batchArgs, metadata, fromRecovery);
    }

    public Option<Metadata> createBatchSession$default$10() {
        return None$.MODULE$;
    }

    public SessionHandle openBatchSession(KyuubiBatchSession batchSession) {
        SessionHandle sessionHandle;
        String user = batchSession.user();
        String ipAddress = batchSession.ipAddress();
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.increment(new UserIpAddress(user, ipAddress));
            return BoxedUnit.UNIT;
        });
        SessionHandle handle = batchSession.handle();
        try {
            batchSession.open();
            this.setSession(handle, (Session)batchSession);
            this.logSessionCountInfo((Session)batchSession, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                batchSession.close();
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Error closing batch session[").append(handle).append("] for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openBatchSession$3(user, ms);
                return BoxedUnit.UNIT;
            });
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(54).append("Error opening batch session[").append(handle).append("] for ").append(user).append(" client ip ").append(ipAddress).append(",").append(" due to ").append(e.getMessage()).toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public SessionHandle openBatchSession(String user, String password, String ipAddress, BatchRequest batchRequest) {
        KyuubiBatchSession batchSession = this.createBatchSession(user, password, ipAddress, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(batchRequest.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), batchRequest.getBatchType(), (Option<String>)Option$.MODULE$.apply((Object)batchRequest.getName()), batchRequest.getResource(), batchRequest.getClassName(), (Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq(), (Option<Metadata>)None$.MODULE$, false);
        return this.openBatchSession(batchSession);
    }

    public String initializeBatchState(String user, String ipAddress, Map<String, String> conf, BatchRequest batchRequest) {
        String batchId;
        String realUser = (String)conf.getOrElse((Object)"kyuubi.session.real.user", (Function0 & Serializable & scala.Serializable)() -> user);
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initializeBatchState$2(x$8))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        String x$1 = batchId = (String)conf.apply((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        Enumeration.Value x$2 = SessionType$.MODULE$.BATCH();
        String x$3 = realUser;
        String x$4 = username;
        String x$5 = ipAddress;
        String x$6 = OperationState$.MODULE$.INITIALIZED().toString();
        String x$7 = batchRequest.getResource();
        String x$82 = batchRequest.getClassName();
        String x$92 = batchRequest.getName();
        Map<String, String> x$102 = conf;
        Seq x$11 = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(batchRequest.getArgs()).asScala()).toSeq();
        long x$12 = System.currentTimeMillis();
        String x$13 = batchRequest.getBatchType();
        int x$14 = BoxesRunTime.unboxToInt((Object)conf.get((Object)"kyuubi.batch.priority").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)KyuubiSessionManager.$anonfun$initializeBatchState$4(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 10));
        String x$15 = Metadata$.MODULE$.apply$default$6();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        boolean x$24 = Metadata$.MODULE$.apply$default$24();
        Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$15, x$6, x$7, x$82, x$92, x$102, (Seq<String>)x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$14, x$24);
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.insertMetadata(metadata, false);
            return BoxedUnit.UNIT;
        });
        return batchId;
    }

    public Option<KyuubiBatchSession> getBatchSession(SessionHandle sessionHandle) {
        return this.getSessionOption(sessionHandle).map((Function1 & Serializable & scala.Serializable)x$11 -> (KyuubiBatchSession)((Object)x$11));
    }

    public void insertMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.insertMetadata(metadata, x$12.insertMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void updateMetadata(Metadata metadata) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.updateMetadata(metadata, x$13.updateMetadata$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public Option<MetadataRequestsRetryRef> getMetadataRequestsRetryRef(String identifier) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> Option$.MODULE$.apply((Object)mm.getMetadataRequestsRetryRef(identifier)));
    }

    public void deRegisterMetadataRequestsRetryRef(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.deRegisterRequestsRetryRef(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Batch> getBatchFromMetadataStore(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)mm -> mm.getBatch(batchId));
    }

    public Seq<Batch> getBatchesFromMetadataStore(MetadataFilter filter, int from, int size) {
        return (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.getBatches(filter, from, size)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public Option<Metadata> getBatchMetadata(String batchId) {
        return this.metadataManager().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getBatchSessionMetadata(batchId));
    }

    @VisibleForTesting
    public void cleanupMetadata(String identifier) {
        this.metadataManager().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            x$17.cleanupMetadataById(identifier);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
        this.startEngineAliveChecker();
    }

    public Seq<KyuubiBatchSession> getBatchSessionsToRecover(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToRecover -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.getBatchesRecoveryMetadata(stateToRecover.toString(), kyuubiInstance, 0, Integer.MAX_VALUE).map((Function1 & Serializable & scala.Serializable)metadata -> this.createBatchSession(metadata.username(), "anonymous", metadata.ipAddress(), metadata.requestConf(), metadata.engineType(), (Option<String>)Option$.MODULE$.apply((Object)metadata.requestName()), metadata.resource(), metadata.className(), metadata.requestArgs(), (Option<Metadata>)new Some(metadata), true), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Metadata> getPeerInstanceClosedBatchSessions(String kyuubiInstance) {
        return (Seq)((TraversableLike)new .colon.colon((Object)OperationState$.MODULE$.PENDING(), (List)new .colon.colon((Object)OperationState$.MODULE$.RUNNING(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable & scala.Serializable)stateToKill -> (Seq)this.metadataManager().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getPeerInstanceClosedBatchesMetadata(stateToKill.toString(), kyuubiInstance, 0, Integer.MAX_VALUE)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public boolean isServer() {
        return true;
    }

    private void initSessionLimiter(KyuubiConf conf) {
        int userLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Set userUnlimitedList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$4(x$20)));
        Set userDenyList = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$initSessionLimiter$5(x$21)));
        this.limiter_$eq(this.applySessionLimiter(userLimit, ipAddressLimit, userIpAddressLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList));
        int userBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int ipAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int userIpAddressBatchLimit = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_BATCH_CONNECTIONS_PER_USER_IPADDRESS())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.batchLimiter_$eq(this.applySessionLimiter(userBatchLimit, ipAddressBatchLimit, userIpAddressBatchLimit, (Set<String>)userUnlimitedList, (Set<String>)userDenyList));
    }

    public Set<String> getUnlimitedUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getUnlimitedUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshUnlimitedUsers(KyuubiConf conf) {
        Set unlimitedUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_UNLIMITED_LIST())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshUnlimitedUsers$1(x$22)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$23 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$23, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            SessionLimiter$.MODULE$.resetUnlimitedUsers(x$24, (Set<String>)unlimitedUsers);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getDenyUsers() {
        return (Set)this.limiter().orElse((Function0 & Serializable & scala.Serializable)() -> this.batchLimiter()).map((Function1 & Serializable & scala.Serializable)limiter -> SessionLimiter$.MODULE$.getDenyUsers((SessionLimiter)limiter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
    }

    public void refreshDenyUsers(KyuubiConf conf) {
        Set denyUsers = (Set)((TraversableLike)conf.get(KyuubiConf$.MODULE$.SERVER_LIMIT_CONNECTIONS_USER_DENY_LIST())).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$refreshDenyUsers$1(x$25)));
        this.limiter().foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$26, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
        this.batchLimiter().foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
            SessionLimiter$.MODULE$.resetDenyUsers(x$27, (Set<String>)denyUsers);
            return BoxedUnit.UNIT;
        });
    }

    private Option<SessionLimiter> applySessionLimiter(int userLimit, int ipAddressLimit, int userIpAddressLimit, Set<String> userUnlimitedList, Set<String> userDenyList) {
        if (((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{userLimit, ipAddressLimit, userIpAddressLimit}))).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$28 -> x$28 > 0) || userDenyList.nonEmpty()) {
            return new Some((Object)SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, userUnlimitedList, userDenyList));
        }
        return None$.MODULE$;
    }

    private void startEngineAliveChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_ALIVE_PROBE_INTERVAL()));
        Runnable checkTask = () -> this.allSessions().foreach((Function1 & Serializable & scala.Serializable)session -> {
            KyuubiSessionManager.$anonfun$startEngineAliveChecker$2(this, session);
            return BoxedUnit.UNIT;
        });
        this.engineConnectionAliveChecker().scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void initEngineStartupProcessSemaphore(KyuubiConf conf) {
        Option engineCreationLimit = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_LIMIT_ENGINE_CREATION());
        engineCreationLimit.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$29 -> x$29 > 0).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)limit -> this.engineStartupProcessSemaphore_$eq((Option<Semaphore>)new Some((Object)new Semaphore(limit))));
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.INTERACTIVE().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$createBatchSession$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openBatchSession$3(String user$2, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$2}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{SessionType$.MODULE$.BATCH().toString()}));
    }

    public static final /* synthetic */ boolean $anonfun$initializeBatchState$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ int $anonfun$initializeBatchState$4(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getOpenSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_WORK_QUEUE_SIZE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getWorkQueueSize(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$4(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$initSessionLimiter$5(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshUnlimitedUsers$1(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$refreshDenyUsers$1(String x$25) {
        return new StringOps(Predef$.MODULE$.augmentString(x$25)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$startEngineAliveChecker$2(KyuubiSessionManager $this, Session session) {
        if (!((KyuubiSessionImpl)session).checkEngineConnectionAlive()) {
            try {
                $this.closeSession(session.handle());
                $this.logger().info(new StringBuilder(98).append("The session ").append(session.handle()).append(" has been closed ").append("due to engine unresponsiveness (checked by the engine alive checker).").toString());
            }
            catch (KyuubiSQLException e) {
                $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(session.handle()).toString(), e);
            }
            return;
        }
    }

    private KyuubiSessionManager(String name) {
        super(name);
        this.engineConnectionAliveChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(21).append(name).append("-engine-alive-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

