/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino.session;

import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import io.trino.client.OkHttpUtil;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoConf$;
import org.apache.kyuubi.engine.trino.TrinoContext;
import org.apache.kyuubi.engine.trino.TrinoContext$;
import org.apache.kyuubi.engine.trino.TrinoStatement;
import org.apache.kyuubi.engine.trino.TrinoStatement$;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent;
import org.apache.kyuubi.engine.trino.event.TrinoSessionEvent$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u0013&\u0001IB\u0011\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O#\t\u0013\u0019\u0003!\u0011!Q\u0001\n\u001d#\u0006\"C+\u0001\u0005\u0003\u0005\u000b\u0011B$W\u0011%9\u0006A!A!\u0002\u00139\u0005\fC\u0005Z\u0001\t\u0005\t\u0015!\u0003[;\"Ia\f\u0001B\u0001B\u0003%qL\u0019\u0005\u0006G\u0002!\t\u0001\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u0019)\b\u0001)A\u0005_\"9a\u000f\u0001b\u0001\n\u0003:\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B?\t\ry\u0004\u0001\u0015!\u0003H\u0011)y\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u0001\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001C\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\n\u0005\r\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u0011\u0011\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0011\u0011)\tY\u0004\u0001a\u0001\u0002\u0004%I! \u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0004\u0003\u0006\u0002D\u0001\u0001\r\u0011!Q!\n\u001dC!\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%I!!\u0013\t\u0015\u00055\u0003\u00011A\u0001B\u0003&q\tC\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011q\f\u0001!\u0002\u0013\t\u0019\u0006C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA=\u0001\u0011E\u00131\u0010\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u0019\t)\u000b\u0001C\u0005{\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAW\u0001\u0011\u0005\u00131\r\u0002\u0011)JLgn\\*fgNLwN\\%na2T!AJ\u0014\u0002\u000fM,7o]5p]*\u0011\u0001&K\u0001\u0006iJLgn\u001c\u0006\u0003U-\na!\u001a8hS:,'B\u0001\u0017.\u0003\u0019Y\u00170^;cS*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q2T\"A\u001b\u000b\u0005\u0019Z\u0013BA\u001c6\u0005=\t%m\u001d;sC\u000e$8+Z:tS>t\u0017\u0001\u00039s_R|7m\u001c7\u0011\u0005i\u001aU\"A\u001e\u000b\u0005qj\u0014A\u0002;ie&4GO\u0003\u0002?\u007f\u0005\u0019!\u000f]2\u000b\u0005\u0001\u000b\u0015aB:feZL7-\u001a\u0006\u0003\u00056\nA\u0001[5wK&\u0011Ai\u000f\u0002\u0011)B\u0013x\u000e^8d_24VM]:j_:L!\u0001\u000f\u001c\u0002\tU\u001cXM\u001d\t\u0003\u0011Fs!!S(\u0011\u0005)kU\"A&\u000b\u00051\u000b\u0014A\u0002\u001fs_>$hHC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001V*\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)N\u0013\t1e'\u0001\u0005qCN\u001cxo\u001c:e\u0013\t)f'A\u0005ja\u0006#GM]3tg&\u0011qKN\u0001\u0005G>tg\r\u0005\u0003I7\u001e;\u0015B\u0001/T\u0005\ri\u0015\r]\u0005\u00033Z\nab]3tg&|g.T1oC\u001e,'\u000f\u0005\u00025A&\u0011\u0011-\u000e\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0013\tqf'\u0001\u0004=S:LGO\u0010\u000b\bK\u001eD\u0017N[6m!\t1\u0007!D\u0001&\u0011\u0015At\u00011\u0001:\u0011\u00151u\u00011\u0001H\u0011\u0015)v\u00011\u0001H\u0011\u00159v\u00011\u0001H\u0011\u0015Iv\u00011\u0001[\u0011\u0015qv\u00011\u0001`\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A]\u0016\u0002\r\r|gNZ5h\u0013\t!\u0018O\u0001\u0006LsV,(-[\"p]\u001a\fAb]3tg&|gnQ8oM\u0002\na\u0001[1oI2,W#\u0001=\u0011\u0005QJ\u0018B\u0001>6\u00055\u0019Vm]:j_:D\u0015M\u001c3mK\u00069\u0001.\u00198eY\u0016\u0004\u0013\u0001C;tKJt\u0017-\\3\u0016\u0003\u001d\u000b\u0011\"^:fe:\fW.\u001a\u0011\u0002\u0019Q\u0014\u0018N\\8D_:$X\r\u001f;\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u000fi\u0011aJ\u0005\u0004\u0003\u00139#\u0001\u0004+sS:|7i\u001c8uKb$\u0018\u0001\u0005;sS:|7i\u001c8uKb$x\fJ3r)\u0011\ty!a\u0006\u0011\t\u0005E\u00111C\u0007\u0002\u001b&\u0019\u0011QC'\u0003\tUs\u0017\u000e\u001e\u0005\n\u00033y\u0011\u0011!a\u0001\u0003\u0007\t1\u0001\u001f\u00132\u00035!(/\u001b8p\u0007>tG/\u001a=uA\u0005i1\r\\5f]R\u001cVm]:j_:,\"!!\t\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!a\n\u0002*\u000511\r\\5f]RT1\u0001KA\u0016\u0015\t\ti#\u0001\u0002j_&!\u0011\u0011GA\u0013\u00055\u0019E.[3oiN+7o]5p]\u0006\t2\r\\5f]R\u001cVm]:j_:|F%Z9\u0015\t\u0005=\u0011q\u0007\u0005\n\u00033\u0011\u0012\u0011!a\u0001\u0003C\tab\u00197jK:$8+Z:tS>t\u0007%A\u0006dCR\fGn\\4OC6,\u0017aD2bi\u0006dwn\u001a(b[\u0016|F%Z9\u0015\t\u0005=\u0011\u0011\t\u0005\t\u00033)\u0012\u0011!a\u0001\u000f\u0006a1-\u0019;bY><g*Y7fA\u0005aA-\u0019;bE\u0006\u001cXMT1nK\u0006\u0001B-\u0019;bE\u0006\u001cXMT1nK~#S-\u001d\u000b\u0005\u0003\u001f\tY\u0005\u0003\u0005\u0002\u001aa\t\t\u00111\u0001H\u00035!\u0017\r^1cCN,g*Y7fA\u0005a1/Z:tS>tWI^3oiV\u0011\u00111\u000b\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011L\u0014\u0002\u000b\u00154XM\u001c;\n\t\u0005u\u0013q\u000b\u0002\u0012)JLgn\\*fgNLwN\\#wK:$\u0018!D:fgNLwN\\#wK:$\b%\u0001\u0003pa\u0016tGCAA\b\u0003M\u0019'/Z1uK\u000ec\u0017.\u001a8u'\u0016\u001c8/[8o)\t\t\t#\u0001\tde\u0016\fG/\u001a%uiB\u001cE.[3oiR\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0011\u00111O\u0001\b_.DG\u000f\u001e94\u0013\u0011\t9(!\u001d\u0003\u0019=[\u0007\n\u001e;q\u00072LWM\u001c;\u0002\u0019I,hn\u00149fe\u0006$\u0018n\u001c8\u0015\t\u0005u\u0014\u0011\u0012\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111Q\u0016\u0002\u0013=\u0004XM]1uS>t\u0017\u0002BAD\u0003\u0003\u0013qb\u00149fe\u0006$\u0018n\u001c8IC:$G.\u001a\u0005\b\u0003\u0007{\u0002\u0019AAF!\u0011\ty(!$\n\t\u0005=\u0015\u0011\u0011\u0002\n\u001fB,'/\u0019;j_:\fqaZ3u\u0013:4w\u000e\u0006\u0003\u0002\u0016\u0006m\u0005c\u0001\u001e\u0002\u0018&\u0019\u0011\u0011T\u001e\u0003\u001bQ;U\r^%oM>4\u0016\r\\;f\u0011\u001d\ti\n\ta\u0001\u0003?\u000b\u0001\"\u001b8g_RK\b/\u001a\t\u0004u\u0005\u0005\u0016bAARw\taAkR3u\u0013:4w\u000eV=qK\u0006)r-\u001a;Ue&twnU3sm\u0016\u0014h+\u001a:tS>t\u0017aE4fiR\u0013\u0018N\\8TKN\u001c\u0018n\u001c8D_:4Gc\u0001.\u0002,\")QN\ta\u0001_\u0006)1\r\\8tK\u0002")
public class TrinoSessionImpl
extends AbstractSession {
    private final KyuubiConf sessionConf = super.sessionManager().getConf();
    private final SessionHandle handle = (SessionHandle)super.conf().get((Object)"kyuubi.session.handle").map((Function1 & Serializable & scala.Serializable)uuid -> SessionHandle$.MODULE$.fromUUID(uuid)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionHandle$.MODULE$.apply());
    private final String username = (String)this.sessionConf().getOption("kyuubi.session.user").getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.currentUser());
    private TrinoContext trinoContext;
    private ClientSession clientSession;
    private String catalogName;
    private String databaseName;
    private final TrinoSessionEvent sessionEvent = TrinoSessionEvent$.MODULE$.apply(this);

    public KyuubiConf sessionConf() {
        return this.sessionConf;
    }

    public SessionHandle handle() {
        return this.handle;
    }

    private String username() {
        return this.username;
    }

    public TrinoContext trinoContext() {
        return this.trinoContext;
    }

    public void trinoContext_$eq(TrinoContext x$1) {
        this.trinoContext = x$1;
    }

    private ClientSession clientSession() {
        return this.clientSession;
    }

    private void clientSession_$eq(ClientSession x$1) {
        this.clientSession = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private String databaseName() {
        return this.databaseName;
    }

    private void databaseName_$eq(String x$1) {
        this.databaseName = x$1;
    }

    private TrinoSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    public void open() {
        Tuple2 tuple2 = this.normalizedConf().partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TrinoSessionImpl.$anonfun$open$1(x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map useCatalogAndDatabaseConf = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map useCatalogAndDatabaseConf2 = useCatalogAndDatabaseConf;
        useCatalogAndDatabaseConf2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TrinoSessionImpl.$anonfun$open$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        if (this.catalogName() == null) {
            this.catalogName_$eq((String)((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_CATALOG())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw KyuubiSQLException$.MODULE$.apply("Trino default catalog can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }));
        }
        this.clientSession_$eq(this.createClientSession());
        this.trinoContext_$eq(TrinoContext$.MODULE$.apply(this.createHttpClient(), this.clientSession()));
        super.open();
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
    }

    private ClientSession createClientSession() {
        String connectionUrl = (String)((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_URL())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply("Trino server url can not be null!", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
        long clientRequestTimeout = BoxesRunTime.unboxToLong((Object)this.sessionConf().get(TrinoConf$.MODULE$.CLIENT_REQUEST_TIMEOUT()));
        Map properties = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.getTrinoSessionConf(this.sessionConf())).asJava();
        return new ClientSession(URI.create(connectionUrl), this.username(), Optional.empty(), "kyuubi", Optional.empty(), Collections.emptySet(), null, this.catalogName(), this.databaseName(), null, ZoneId.systemDefault(), Locale.getDefault(), Collections.emptyMap(), properties, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), null, new Duration((double)clientRequestTimeout, TimeUnit.MILLISECONDS), true);
    }

    private OkHttpClient createHttpClient() {
        Option keystorePath = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_PATH());
        Option keystorePassword = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_PASSWORD());
        Option keystoreType = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_KEYSTORE_TYPE());
        Option truststorePath = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_PATH());
        Option truststorePassword = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_PASSWORD());
        Option truststoreType = (Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_TRUSTSTORE_TYPE());
        String serverScheme = this.clientSession().getServer().getScheme();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, Optional.ofNullable(keystorePath.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(keystorePassword.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(keystoreType.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststorePath.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststorePassword.orNull(Predef$.MODULE$.$conforms())), Optional.ofNullable(truststoreType.orNull(Predef$.MODULE$.$conforms())));
        ((Option)this.sessionConf().get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_TRINO_CONNECTION_PASSWORD())).foreach((Function1 & Serializable & scala.Serializable)password -> {
            Predef$.MODULE$.require(serverScheme.equalsIgnoreCase("https"), (Function0 & Serializable & scala.Serializable)() -> "Trino engine using username/password requires HTTPS to be enabled");
            return builder.addInterceptor(OkHttpUtil.basicAuth((String)this.username(), (String)password));
        });
        return builder.build();
    }

    public OperationHandle runOperation(Operation operation) {
        this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        return super.runOperation(operation);
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Trino");
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.getTrinoServerVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType) ? true : (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType) ? true : TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType))) {
                return TGetInfoValue.lenValue((long)0L);
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    private String getTrinoServerVersion() {
        TrinoStatement trinoStatement = TrinoStatement$.MODULE$.apply(this.trinoContext(), super.sessionManager().getConf(), "SELECT version()", TrinoStatement$.MODULE$.apply$default$4());
        Iterator<List<Object>> resultSet = trinoStatement.execute();
        Predef$.MODULE$.assert(resultSet.hasNext());
        return ((IterableLike)resultSet.next()).head().toString();
    }

    private scala.collection.immutable.Map<String, String> getTrinoSessionConf(KyuubiConf sessionConf) {
        scala.collection.immutable.Map trinoSessionConf = (scala.collection.immutable.Map)sessionConf.getAll().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("trino."))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(k)).stripPrefix("trino."), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        return trinoSessionConf.toMap(Predef$.MODULE$.$conforms());
    }

    public void close() {
        this.sessionEvent().endTime_$eq(System.currentTimeMillis());
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        super.close();
    }

    public static final /* synthetic */ boolean $anonfun$open$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{package$.MODULE$.USE_CATALOG(), package$.MODULE$.USE_DATABASE()})).contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$open$2(TrinoSessionImpl $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String catalog = (String)tuple2._2();
            String string2 = package$.MODULE$.USE_CATALOG();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                $this.catalogName_$eq(catalog);
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String database = (String)tuple2._2();
            String string4 = package$.MODULE$.USE_DATABASE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                $this.databaseName_$eq(database);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public TrinoSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
    }
}

