/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0011#\u0001-B\u0001B\r\u0001\u0003\u0006\u0004%\te\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!I1\u0005\u0001a\u0001\u0002\u0004%I!\u0010\u0005\n\t\u0002\u0001\r\u00111A\u0005\n\u0015C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015\u0002 \t\u000f=\u0003!\u0019!C\u0005!\"1Q\f\u0001Q\u0001\nECQA\u0018\u0001\u0005\n}Ca\u0001\u001b\u0001\u0005\u0002\u0011J\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\t\u0011]\u0004\u0001R1A\u0005\u0002aD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011BA\u0006\u0011-\t\u0019\u0002\u0001EC\u0002\u0013\u0005A%!\u0006\t\u0015\u0005u\u0001\u0001#b\u0001\n\u0013\ty\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!1\u0011\u0011\t\u0001\u0005BaDq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002H\u0001!I!!\u0012\t\u000f\u0005%\u0003\u0001\"\u0003\u0002F!A\u00111\n\u0001\u0005\u0002\u0011\n)\u0005C\u0004\u0002h\u0001!\t%!\u0012\t\u000f\u0005%\u0004\u0001\"\u0011\u0002F!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003_\u0002A\u0011AA<\u0011\u0019\t\u0019\t\u0001C\u0001q\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005\"CAJ\u0001\t\u0007I\u0011IAK\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005]%!G&zkV\u0014\u0017NU3ti\u001a\u0013xN\u001c;f]\u0012\u001cVM\u001d<jG\u0016T!a\t\u0013\u0002\rM,'O^3s\u0015\t)c%\u0001\u0004lsV,(-\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0003CA\u00171\u001b\u0005q#BA\u0018%\u0003\u001d\u0019XM\u001d<jG\u0016L!!\r\u0018\u0003/\u0005\u00137\u000f\u001e:bGR4%o\u001c8uK:$7+\u001a:wS\u000e,\u0017AC:feZ,'/\u00192mKV\tA\u0007\u0005\u0002.k%\u0011aG\f\u0002\u000b'\u0016\u0014h/\u001a:bE2,\u0017aC:feZ,'/\u00192mK\u0002\na\u0001P5oSRtDC\u0001\u001e=!\tY\u0004!D\u0001#\u0011\u0015\u00114\u00011\u00015+\u0005q\u0004CA C\u001b\u0005\u0001%BA!#\u0003\t)\u0018.\u0003\u0002D\u0001\nY!*\u001a;usN+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013A!\u00168ji\"9Q*BA\u0001\u0002\u0004q\u0014a\u0001=%c\u000591/\u001a:wKJ\u0004\u0013!C5t'R\f'\u000f^3e+\u0005\t\u0006C\u0001*\\\u001b\u0005\u0019&B\u0001+V\u0003\u0019\tGo\\7jG*\u0011akV\u0001\u000bG>t7-\u001e:sK:$(B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011Al\u0015\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c8\u000b^1si\u0016$\u0007%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a,\u0012\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\fAaY8oM*\u0011QMJ\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u001d\u0014'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\btKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c\u0013\u0002\u000fM,7o]5p]&\u0011q\u000e\u001c\u0002\u0015\u0017f,XOY5TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\u0019\t\fGo\u00195DQ\u0016\u001c7.\u001a:\u0016\u0003I\u0004\"a\u001d;\u000e\u0003UK!!^+\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-A\u0007cCR\u001c\u0007n\u00115fG.,'\u000fI\u0001\u0005Q>\u001cH/F\u0001z!\rQ\u00181\u0001\b\u0003w~\u0004\"\u0001 %\u000e\u0003uT!A \u0016\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\u0001S\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u0001*\u0001\u0003q_J$XCAA\u0007!\r9\u0015qB\u0005\u0004\u0003#A%aA%oi\u0006y1/Z2ve&$\u00180\u00128bE2,G-\u0006\u0002\u0002\u0018A\u0019q)!\u0007\n\u0007\u0005m\u0001JA\u0004C_>dW-\u00198\u0002\u001d\u0005$W.\u001b8jgR\u0014\u0018\r^8sgV\u0011\u0011\u0011\u0005\t\u0005u\u0006\r\u00120\u0003\u0003\u0002&\u0005\u001d!aA*fi\u0006y\u0011n]!e[&t\u0017n\u001d;sCR|'\u000f\u0006\u0003\u0002\u0018\u0005-\u0002BBA\u0017#\u0001\u0007\u00110\u0001\u0005vg\u0016\u0014h*Y7f\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0004\r\u0006M\u0002BB2\u0013\u0001\u0004\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004J\u0001\u0007G>tg-[4\n\t\u0005}\u0012\u0011\b\u0002\u000b\u0017f,XOY5D_:4\u0017!D2p]:,7\r^5p]V\u0013H.A\u0007ti\u0006\u0014H/\u00138uKJt\u0017\r\u001c\u000b\u0002\r\u0006a\u0011N\\:uC2dw+\u001a2V\u0013\u0006\t2\u000f^1si\n\u000bGo\u00195DQ\u0016\u001c7.\u001a:\u0002)I,7m\u001c<fe\n\u000bGo\u00195TKN\u001c\u0018n\u001c8tQ\r9\u0012q\n\t\u0005\u0003#\n\u0019'\u0004\u0002\u0002T)!\u0011QKA,\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005e\u00131L\u0001\u0007G>lWn\u001c8\u000b\t\u0005u\u0013qL\u0001\u0007O>|w\r\\3\u000b\u0005\u0005\u0005\u0014aA2p[&!\u0011QMA*\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/A\u0006hKR\u0014V-\u00197Vg\u0016\u0014H#A=\u0002\u001d\u001d,GoU3tg&|g.V:feR\u0019\u00110a\u001d\t\r\u0005U4\u00041\u0001z\u00031A7O\r)s_bLXk]3s)\rI\u0018\u0011\u0010\u0005\b\u0003wb\u0002\u0019AA?\u0003-\u0019Xm]:j_:\u001cuN\u001c4\u0011\u000bi\fy(_=\n\t\u0005\u0005\u0015q\u0001\u0002\u0004\u001b\u0006\u0004\u0018\u0001D4fi&\u0003\u0018\t\u001a3sKN\u001c\u0018\u0001D4fiB\u0013x\u000e_=Vg\u0016\u0014HcB=\u0002\n\u0006-\u0015q\u0012\u0005\b\u0003wr\u0002\u0019AA?\u0011\u0019\tiI\ba\u0001s\u0006I\u0011\u000e]!eIJ,7o\u001d\u0005\u0007\u0003#s\u0002\u0019A=\u0002\u0011I,\u0017\r\\+tKJ\f\u0001\u0003Z5tG>4XM]=TKJ4\u0018nY3\u0016\u0005\u0005]\u0005#B$\u0002\u001a\u0006u\u0015bAAN\u0011\n1q\n\u001d;j_:\u00042!LAP\u0013\r\t\tK\f\u0002\b'\u0016\u0014h/[2f\u0003E!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW\r\t")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (Utils$.MODULE$.isWindows() || Utils$.MODULE$.isMac()) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return Utils$.MODULE$.findLocalInetAddress().getCanonicalHostName();
                    }
                    return Utils$.MODULE$.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Seq authTypes = (Seq)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
                this.securityEnabled = AuthUtils$.MODULE$.kerberosEnabled(authTypes) || !AuthUtils$.MODULE$.effectivePlainAuthType(authTypes).contains((Object)AuthTypes$.MODULE$.NONE());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.securityEnabled;
    }

    public boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS())), BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_JETTY_STOP_TIMEOUT()))));
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler));
        this.installWebUI();
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.batchChecker(), task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.startInternal();
                while (true) {
                    String string = this.server().getState();
                    String string2 = "STARTED";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break;
                    this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
                    Thread.sleep(1000L);
                }
                this.recoverBatchSessions();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String hs2ProxyUser) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)hs2ProxyUser).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AuthUtils$.MODULE$.HS2_PROXY_USER()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.METHOD_NOT_ALLOWED);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        if (sessionConf == null) {
            return realUser;
        }
        return (String)sessionConf.get((Object)AuthUtils$.MODULE$.HS2_PROXY_USER()).map((Function1 & Serializable & scala.Serializable)proxyUser -> {
            block0: {
                if (this.isAdministrator(realUser)) break block0;
                AuthUtils$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
            }
            return proxyUser;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> realUser);
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

