/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResourceMetricSourceFluent<A extends ResourceMetricSourceFluent<A>>
extends BaseFluent<A> {
    private String name;
    private Integer targetAverageUtilization;
    private Quantity targetAverageValue;
    private Map<String, Object> additionalProperties;

    public ResourceMetricSourceFluent() {
    }

    public ResourceMetricSourceFluent(ResourceMetricSource instance) {
        ResourceMetricSource resourceMetricSource = instance = instance != null ? instance : new ResourceMetricSource();
        if (instance != null) {
            this.withName(instance.getName());
            this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
            this.withTargetAverageValue(instance.getTargetAverageValue());
            this.withName(instance.getName());
            this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
            this.withTargetAverageValue(instance.getTargetAverageValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    public A withTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
        return (A)((Object)this);
    }

    public boolean hasTargetAverageUtilization() {
        return this.targetAverageUtilization != null;
    }

    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)((Object)this);
    }

    public boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceFluent that = (ResourceMetricSourceFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.targetAverageUtilization, that.targetAverageUtilization)) {
            return false;
        }
        if (!Objects.equals(this.targetAverageValue, that.targetAverageValue)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetAverageUtilization, this.targetAverageValue, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.targetAverageUtilization != null) {
            sb.append("targetAverageUtilization:");
            sb.append(this.targetAverageUtilization + ",");
        }
        if (this.targetAverageValue != null) {
            sb.append("targetAverageValue:");
            sb.append(this.targetAverageValue + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

