/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo$;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ProcBuilder$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.KubernetesUtils$;
import org.apache.kyuubi.util.Validator$;
import org.apache.kyuubi.util.command.CommandLineUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r}c\u0001\u0002/^\u0001!D\u0001b\u001e\u0001\u0003\u0006\u0004%\t\u0005\u001f\u0005\n\u0003\u0013\u0001!\u0011!Q\u0001\neD!\"a\u0003\u0001\u0005\u000b\u0007I\u0011IA\u0007\u0011)\tY\u0002\u0001B\u0001B\u0003%\u0011q\u0002\u0005\n\u0003;\u0001!Q1A\u0005\u0002aD\u0011\"a\b\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0015\u0005\u0005\u0002A!b\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003KAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002>\u0001!\t!!\u0014\t\u0013\u00055\u0004A1A\u0005\u0002\u0005D\bbBA8\u0001\u0001\u0006I!\u001f\u0005\t\u0003c\u0002!\u0019!C)q\"9\u00111\u000f\u0001!\u0002\u0013I\bBBA;\u0001\u0011\u0005\u0003\u0010C\u0004\u0002x\u0001!\t&!\u001f\t\u000f\u0005\r\u0005\u0001\"\u0005\u0002\u0006\"A\u00111\u0012\u0001\u0005\u0002\u0005\fi\t\u0003\u0005\u0002&\u0002\u0011\r\u0011\"\u0015y\u0011\u001d\t9\u000b\u0001Q\u0001\neD!\"!+\u0001\u0011\u000b\u0007I\u0011KAV\u0011-\ti\f\u0001EC\u0002\u0013E\u0013-a0\t\r\u0005\u0005\u0007\u0001\"\u0015y\u0011\u001d\t\u0019\r\u0001C\t\u0003\u000bDq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002b\u0002!I!a9\t\r\u0005=\b\u0001\"\u0011y\u0011)\t\t\u0010\u0001EC\u0002\u0013E\u00111\u001f\u0005\b\u0003k\u0004A\u0011IA|\u0011%\ty\u0010\u0001b\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011\u0002B\u0002\u0011%\u0011Y\u0001\u0001b\u0001\n\u0013\u0011\t\u0001\u0003\u0005\u0003\u000e\u0001\u0001\u000b\u0011\u0002B\u0002\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003\u001c\u0001!\t%!8\t\u000f\tu\u0001\u0001\"\u0001\u0002^\"9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\u0012\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005K\u0001A\u0011AAo\u0011\u001d\u00119\u0003\u0001C!\u0005SAqAa\u000b\u0001\t\u0003\u0011i\u0003\u0003\u0005\u00036\u0001!\t!\u0018B\u001c\u000f\u001d\u0011I$\u0018E\u0001\u0005w1a\u0001X/\t\u0002\tu\u0002bBA\u001f[\u0011\u0005!q\b\u0005\n\u0005\u0003j#\u0019!C\u0003\u0005\u0007B\u0001Ba\u0013.A\u00035!Q\t\u0005\n\u0005\u001bj#\u0019!C\u0003\u0005\u001fB\u0001Ba\u0016.A\u00035!\u0011\u000b\u0005\n\u00053j#\u0019!C\u0003\u00057B\u0001Ba\u0019.A\u00035!Q\f\u0005\n\u0005Kj#\u0019!C\u0003\u0005OB\u0001Ba\u001c.A\u00035!\u0011\u000e\u0005\n\u0005cj#\u0019!C\u0003\u0005gB\u0001Ba\u001f.A\u00035!Q\u000f\u0005\n\u0005{j#\u0019!C\u0003\u0005\u007fB\u0001Ba\".A\u00035!\u0011\u0011\u0005\n\u0005\u0013k#\u0019!C\u0003\u0005\u0017C\u0001Ba%.A\u00035!Q\u0012\u0005\n\u0005+k#\u0019!C\u0003\u0005/C\u0001Ba(.A\u00035!\u0011\u0014\u0005\n\u0005Ck#\u0019!C\u0003\u0005GC\u0001Ba+.A\u00035!Q\u0015\u0005\n\u0005[k#\u0019!C\u0003\u0005_C\u0001Ba..A\u00035!\u0011\u0017\u0005\n\u0005sk#\u0019!C\u0003\u0005wC\u0001Ba4.A\u00035!Q\u0018\u0005\u000b\u0005#l#\u0019!C\u0003;\nM\u0007\u0002\u0003Bn[\u0001\u0006iA!6\t\u0015\tuWF1A\u0005\u0006u\u0013y\u000e\u0003\u0005\u0003h6\u0002\u000bQ\u0002Bq\u0011)\u0011I/\fb\u0001\n\u000bi&1\u001e\u0005\t\u0005gl\u0003\u0015!\u0004\u0003n\"Q!Q_\u0017C\u0002\u0013\u0015QLa>\t\u0011\t}X\u0006)A\u0007\u0005sD!b!\u0001.\u0005\u0004%)!XB\u0002\u0011!\u0019Y!\fQ\u0001\u000e\r\u0015\u0001\"CB\u0007[\t\u0007IQBB\b\u0011!\u0019\t\"\fQ\u0001\u000e\t\u0015\u0007\"CB\n[\t\u0007IQBB\u000b\u0011!\u0019Y\"\fQ\u0001\u000e\r]\u0001\"CB\u000f[\t\u0007IQBB\u0010\u0011!\u00199#\fQ\u0001\u000e\r\u0005\u0002BCB\u0015[\t\u0007IQA1\u0004,!A1QH\u0017!\u0002\u001b\u0019i\u0003\u0003\u0006\u0004@5\u0012\r\u0011\"\u0002b\u0007WA\u0001b!\u0011.A\u000351Q\u0006\u0005\u000b\u0007\u0007j#\u0019!C\u0003C\u000e-\u0002\u0002CB#[\u0001\u0006ia!\f\t\u0013\r\u001dS&%A\u0005\u0002\r%#aE*qCJ\\\u0007K]8dKN\u001c()^5mI\u0016\u0014(B\u00010`\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0017-\u0001\u0004f]\u001eLg.\u001a\u0006\u0003E\u000e\faa[=vk\nL'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001S>\u001c\bC\u00016n\u001b\u0005Y'\"\u00017\u0002\u000bM\u001c\u0017\r\\1\n\u00059\\'AB!osJ+g\r\u0005\u0002qc6\tq,\u0003\u0002s?\nY\u0001K]8d\u0005VLG\u000eZ3s!\t!X/D\u0001b\u0013\t1\u0018MA\u0004M_\u001e<\u0017N\\4\u0002\u0013A\u0014x\u000e_=Vg\u0016\u0014X#A=\u0011\u0007i\f\u0019A\u0004\u0002|\u007fB\u0011Ap[\u0007\u0002{*\u0011apZ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u00051.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003Y\u0017A\u00039s_bLXk]3sA\u0005!1m\u001c8g+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\"Y\u0001\u0007G>tg-[4\n\t\u0005e\u00111\u0003\u0002\u000b\u0017f,XOY5D_:4\u0017!B2p]\u001a\u0004\u0013aC3oO&tWMU3g\u0013\u0012\fA\"\u001a8hS:,'+\u001a4JI\u0002\na\"\u001a=ue\u0006,enZ5oK2{w-\u0006\u0002\u0002&A)!.a\n\u0002,%\u0019\u0011\u0011F6\u0003\r=\u0003H/[8o!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t1\u0001\\8h\u0015\r\t)$Y\u0001\n_B,'/\u0019;j_:LA!!\u000f\u00020\taq\n]3sCRLwN\u001c'pO\u0006yQ\r\u001f;sC\u0016sw-\u001b8f\u0019><\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0003\n)%a\u0012\u0002J\u0005-\u0003cAA\"\u00015\tQ\fC\u0003x\u0013\u0001\u0007\u0011\u0010C\u0004\u0002\f%\u0001\r!a\u0004\t\r\u0005u\u0011\u00021\u0001z\u0011%\t\t#\u0003I\u0001\u0002\u0004\t)\u0003\u0006\u0004\u0002B\u0005=\u0013\u0011\u000b\u0005\u0006o*\u0001\r!\u001f\u0005\b\u0003\u0017Q\u0001\u0019AA\bQ\rQ\u0011Q\u000b\t\u0005\u0003/\nI'\u0004\u0002\u0002Z)!\u00111LA/\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005}\u0013\u0011M\u0001\u0007G>lWn\u001c8\u000b\t\u0005\r\u0014QM\u0001\u0007O>|w\r\\3\u000b\u0005\u0005\u001d\u0014aA2p[&!\u00111NA-\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\ngB\f'o\u001b%p[\u0016\f!b\u001d9be.Du.\\3!\u0003))\u00070Z2vi\u0006\u0014G.Z\u0001\fKb,7-\u001e;bE2,\u0007%A\u0005nC&t7\t\\1tg\u0006\t2m\\7qY\u0016$X-T1ti\u0016\u0014XK\u001d7\u0015\t\u0005m\u0014\u0011\u0011\t\u0004U\u0006u\u0014bAA@W\n!QK\\5u\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u001f\t\u0001cY8om\u0016\u0014HoQ8oM&<7*Z=\u0015\u0007e\f9\t\u0003\u0004\u0002\nF\u0001\r!_\u0001\u0004W\u0016L\u0018\u0001H3yiJ\f7\r^*qCJ\\7i\u001c:f'\u000e\fG.\u0019,feNLwN\u001c\u000b\u0004s\u0006=\u0005bBAI%\u0001\u0007\u00111S\u0001\nM&dWMT1nKN\u0004R!!&\u0002 ftA!a&\u0002\u001c:\u0019A0!'\n\u00031L1!!(l\u0003\u001d\u0001\u0018mY6bO\u0016LA!!)\u0002$\nA\u0011\n^3sC\ndWMC\u0002\u0002\u001e.\f\u0001$\u001a8hS:,7kY1mC\nKg.\u0019:z-\u0016\u00148/[8o\u0003e)gnZ5oKN\u001b\u0017\r\\1CS:\f'/\u001f,feNLwN\u001c\u0011\u0002'\u0015tw-\u001b8f\u0011>lW\rR5s\r&dG/\u001a:\u0016\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\u0003S>T!!a.\u0002\t)\fg/Y\u0005\u0005\u0003w\u000b\tL\u0001\u0006GS2,g)\u001b7uKJ\f\u0001bY8n[\u0006tGm]\u000b\u0003\u0003'\u000ba!\\8ek2,\u0017!D:fiV\u00048*\u001a:cKJ|7\u000f\u0006\u0003\u0002|\u0005\u001d\u0007bBAe1\u0001\u0007\u00111Z\u0001\u0007EV4g-\u001a:\u0011\u000b\u00055\u0017q[=\u000e\u0005\u0005='\u0002BAi\u0003'\fq!\\;uC\ndWMC\u0002\u0002V.\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI.a4\u0003\r\t+hMZ3s\u0003%!(/_&fsR\f'\r\u0006\u0002\u0002`B!!.a\nz\u0003QQ8.Q;uQ.+\u0017\u0010^1c\r&dWmQ8oMR!\u0011Q]Av!\u0015Q\u0018q]=z\u0013\u0011\tI/a\u0002\u0003\u00075\u000b\u0007\u000fC\u0004\u0002nj\u0001\r!!:\u0002\u0013M\u0004\u0018M]6D_:4\u0017!C:i_J$h*Y7f\u00031!WMZ1vYR\u001c8i\u001c8g+\t\t)/\u0001\u0006baBluM]%oM>$\"!!?\u0011\u0007A\fY0C\u0002\u0002~~\u0013a#\u00119qY&\u001c\u0017\r^5p]6\u000bg.Y4fe&sgm\\\u0001\u001dM>\u00148-\u001b2msJ+wO]5uK\u0012\u0013\u0018N^3s!>$g*Y7f+\t\u0011\u0019\u0001E\u0002k\u0005\u000bI1Aa\u0002l\u0005\u001d\u0011un\u001c7fC:\fQDZ8sG&\u0014G.\u001f*foJLG/\u001a#sSZ,'\u000fU8e\u001d\u0006lW\rI\u0001!M>\u00148-\u001b2msJ+wO]5uK\u0016CXm\u0019)pI:\u000bW.\u001a)sK\u001aL\u00070A\u0011g_J\u001c\u0017N\u00197z%\u0016<(/\u001b;f\u000bb,7\rU8e\u001d\u0006lW\r\u0015:fM&D\b%A\tbaB,g\u000e\u001a)pI:\u000bW.Z\"p]\u001a$B!!:\u0003\u0014!9\u00111\u0002\u0012A\u0002\u0005\u0015\u0018!D3yiJ\f\u0017,\u0019:o\u0007>tg\r\u0006\u0003\u0002f\ne\u0001bBA\u0006G\u0001\u0007\u0011Q]\u0001\u000fG2,8\u000f^3s\u001b\u0006t\u0017mZ3s\u0003)!W\r\u001d7ps6{G-Z\u0001\u000eSN\u001cE.^:uKJlu\u000eZ3\u0015\u0005\t\r\u0011!E6vE\u0016\u0014h.\u001a;fg\u000e{g\u000e^3yi\u0006\u00192.\u001e2fe:,G/Z:OC6,7\u000f]1dK\u0006aa/\u00197jI\u0006$XmQ8oMR\u0011\u00111P\u0001\u0011g\u0016$8\u000b]1sWV\u001bXM\u001d(b[\u0016$b!a\u001f\u00030\tM\u0002B\u0002B\u0019U\u0001\u0007\u00110\u0001\u0005vg\u0016\u0014h*Y7f\u0011\u001d\tIM\u000ba\u0001\u0003\u0017\f\u0011#\u001a8hS:,Gj\\4QCRD7i\u001c8g)\t\t)/A\nTa\u0006\u00148\u000e\u0015:pG\u0016\u001c8OQ;jY\u0012,'\u000fE\u0002\u0002D5\u001a\"!L5\u0015\u0005\tm\u0012aB!Q!~[U)W\u000b\u0003\u0005\u000bz!Aa\u0012\"\u0005\t%\u0013AD:qCJ\\g&\u00199q]9\fW.Z\u0001\t\u0003B\u0003vlS#ZA\u00059A+Q$`\u0017\u0016KVC\u0001B)\u001f\t\u0011\u0019&\t\u0002\u0003V\u0005y1\u000f]1sW:J\u0018M\u001d8/i\u0006<7/\u0001\u0005U\u0003\u001e{6*R-!\u0003)i\u0015i\u0015+F%~[U)W\u000b\u0003\u0005;z!Aa\u0018\"\u0005\t\u0005\u0014\u0001D:qCJ\\g&\\1ti\u0016\u0014\u0018aC'B'R+%kX&F3\u0002\nq\u0002R#Q\u0019>Kv,T(E\u000b~[U)W\u000b\u0003\u0005Sz!Aa\u001b\"\u0005\t5\u0014aF:qCJ\\gf];c[&$h\u0006Z3qY>LXj\u001c3f\u0003A!U\t\u0015'P3~ku\nR#`\u0017\u0016K\u0006%\u0001\fL+\n+%KT#U\u000bN{6i\u0014(U\u000bb#vlS#Z+\t\u0011)h\u0004\u0002\u0003x\u0005\u0012!\u0011P\u0001\u0019gB\f'o\u001b\u0018lk\n,'O\\3uKNt3m\u001c8uKb$\u0018aF&V\u0005\u0016\u0013f*\u0012+F'~\u001buJ\u0014+F1R{6*R-!\u0003aYUKQ#S\u001d\u0016#ViU0O\u00036+5\u000bU!D\u000b~[U)W\u000b\u0003\u0005\u0003{!Aa!\"\u0005\t\u0015\u0015AG:qCJ\\gf[;cKJtW\r^3t]9\fW.Z:qC\u000e,\u0017!G&V\u0005\u0016\u0013f*\u0012+F'~s\u0015)T#T!\u0006\u001bUiX&F3\u0002\n!dS+C\u000bJsU\tV#T?\u0012\u0013\u0016JV#S?B{Ei\u0018(B\u001b\u0016+\"A!$\u0010\u0005\t=\u0015E\u0001BI\u0003\u0001\u001a\b/\u0019:l]-,(-\u001a:oKR,7O\f3sSZ,'O\f9pI:r\u0017-\\3\u00027-+&)\u0012*O\u000bR+5k\u0018#S\u0013Z+%k\u0018)P\t~s\u0015)T#!\u0003\rZUKQ#S\u001d\u0016#ViU0F1\u0016\u001bU\u000bV(S?B{Ei\u0018(B\u001b\u0016{\u0006KU#G\u0013b+\"A!'\u0010\u0005\tm\u0015E\u0001BO\u0003\u001d\u001a\b/\u0019:l]-,(-\u001a:oKR,7OL3yK\u000e,Ho\u001c:/a>$g*Y7f!J,g-\u001b=\u0002I-+&)\u0012*O\u000bR+5kX#Y\u000b\u000e+Fk\u0014*`!>#uLT!N\u000b~\u0003&+\u0012$J1\u0002\n\u0011$W!S\u001d~k\u0015\tW0B!B{\u0016\t\u0016+F\u001bB#6kX&F3V\u0011!QU\b\u0003\u0005O\u000b#A!+\u00023M\u0004\u0018M]6/s\u0006\u0014hNL7bq\u0006\u0003\b/\u0011;uK6\u0004Ho]\u0001\u001b3\u0006\u0013fjX'B1~\u000b\u0005\u000bU0B)R+U\n\u0015+T?.+\u0015\fI\u0001\u0012\u0013:#VI\u0015(B\u0019~\u0013ViU(V%\u000e+UC\u0001BY\u001f\t\u0011\u0019,\t\u0002\u00036\u0006q1\u000f]1sW6Jg\u000e^3s]\u0006d\u0017AE%O)\u0016\u0013f*\u0011'`%\u0016\u001bv*\u0016*D\u000b\u0002\nA\u0002U!U\u0011~\u001buJ\u0014$J\u000fN+\"A!0\u0011\r\t}&\u0011\u0019Bc\u001b\t\t\u0019.\u0003\u0003\u0003D\u0006M'aA*fcB!!q\u0019Bg\u001b\t\u0011IM\u0003\u0003\u0003L\u0006U\u0016\u0001\u00027b]\u001eLA!!\u0002\u0003J\u0006i\u0001+\u0011+I?\u000e{eJR%H'\u0002\nQa\u0011'B'N+\"A!6\u0010\u0005\t]\u0017E\u0001Bm\u0003\u001diSf\u00197bgN\faa\u0011'B'N\u0003\u0013A\u0003)S\u001fbKv,V*F%V\u0011!\u0011]\b\u0003\u0005G\f#A!:\u0002\u00195j\u0003O]8ys6*8/\u001a:\u0002\u0017A\u0013v\nW-`+N+%\u000bI\u0001\f'B\u000b%kS0G\u00132+5+\u0006\u0002\u0003n>\u0011!q^\u0011\u0003\u0005c\f1b\u001d9be.tc-\u001b7fg\u0006a1\u000bU!S\u0017~3\u0015\nT#TA\u0005I\u0001KU%O\u0007&\u0003\u0016\tT\u000b\u0003\u0005s|!Aa?\"\u0005\tu\u0018\u0001G:qCJ\\gf[3sE\u0016\u0014xn\u001d\u0018qe&t7-\u001b9bY\u0006Q\u0001KU%O\u0007&\u0003\u0016\t\u0014\u0011\u0002\r-+\u0015\fV!C+\t\u0019)a\u0004\u0002\u0004\b\u0005\u00121\u0011B\u0001\u0016gB\f'o\u001b\u0018lKJ\u0014WM]8t]-,\u0017\u0010^1c\u0003\u001dYU)\u0017+B\u0005\u0002\n\u0011c\u0015)B%.{6+\u0016\"N\u0013R{f)\u0013'F+\t\u0011)-\u0001\nT!\u0006\u00136jX*V\u00056KEk\u0018$J\u0019\u0016\u0003\u0013AD*Q\u0003J[ulQ(O\r~#\u0015JU\u000b\u0003\u0007/y!a!\u0007\"\u0005\rM\u0011aD*Q\u0003J[ulQ(O\r~#\u0015J\u0015\u0011\u0002)M\u0003\u0016IU&`\u0007>sei\u0018$J\u0019\u0016{f*Q'F+\t\u0019\tc\u0004\u0002\u0004$\u0005\u00121QE\u0001\u0014gB\f'o[\u0017eK\u001a\fW\u000f\u001c;t]\r|gNZ\u0001\u0016'B\u000b%kS0D\u001f:3uLR%M\u000b~s\u0015)T#!\u0003y\u0019\u0006+\u0011*L?\u000e{%+R0T\u0007\u0006c\u0015i\u0018,F%NKuJT0S\u000b\u001e+\u0005,\u0006\u0002\u0004.A!1qFB\u001d\u001b\t\u0019\tD\u0003\u0003\u00044\rU\u0012\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\r]2.\u0001\u0003vi&d\u0017\u0002BB\u001e\u0007c\u0011QAU3hKb\fqd\u0015)B%.{6i\u0014*F?N\u001b\u0015\tT!`-\u0016\u00136+S(O?J+u)\u0012-!\u0003i\u0019\u0006+\u0011*L?\"{U*R0S\u000b\u001e+\u0005lX*D\u00032\u000buLM\u00193\u0003m\u0019\u0006+\u0011*L?\"{U*R0S\u000b\u001e+\u0005lX*D\u00032\u000buLM\u00193A\u0005Q2\u000bU!S\u0017~Cu*T#`%\u0016;U\tW0T\u0007\u0006c\u0015i\u0018\u001a2g\u0005Y2\u000bU!S\u0017~Cu*T#`%\u0016;U\tW0T\u0007\u0006c\u0015i\u0018\u001a2g\u0001\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAB&U\u0011\t)c!\u0014,\u0005\r=\u0003\u0003BB)\u00077j!aa\u0015\u000b\t\rU3qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0017l\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007;\u001a\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class SparkProcessBuilder
implements ProcBuilder,
Logging {
    private FileFilter engineHomeDirFilter;
    private Iterable<String> commands;
    private Map<String, String> defaultsConf;
    private final String proxyUser;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final Option<OperationLog> extraEngineLog;
    private final String sparkHome;
    private final String executable;
    private final String engineScalaBinaryVersion;
    private final boolean forciblyRewriteDriverPodName;
    private final boolean forciblyRewriteExecPodNamePrefix;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final Path workingDir;
    private ProcessBuilder processBuilder;
    private volatile Throwable org$apache$kyuubi$engine$ProcBuilder$$error;
    private final int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    private final long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    private final EvictingQueue<String> lastRowsOfLog;
    private volatile boolean logCaptureThreadReleased;
    private Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    private volatile Process process;
    private volatile boolean processLaunched;
    private File engineLog;
    private volatile byte bitmap$0;

    public static Option<OperationLog> $lessinit$greater$default$4() {
        return SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<String> PATH_CONFIGS() {
        return SparkProcessBuilder$.MODULE$.PATH_CONFIGS();
    }

    public static String INTERNAL_RESOURCE() {
        return SparkProcessBuilder$.MODULE$.INTERNAL_RESOURCE();
    }

    public static String YARN_MAX_APP_ATTEMPTS_KEY() {
        return SparkProcessBuilder$.MODULE$.YARN_MAX_APP_ATTEMPTS_KEY();
    }

    public static String KUBERNETES_EXECUTOR_POD_NAME_PREFIX() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX();
    }

    public static String KUBERNETES_DRIVER_POD_NAME() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_DRIVER_POD_NAME();
    }

    public static String KUBERNETES_NAMESPACE_KEY() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_NAMESPACE_KEY();
    }

    public static String KUBERNETES_CONTEXT_KEY() {
        return SparkProcessBuilder$.MODULE$.KUBERNETES_CONTEXT_KEY();
    }

    public static String DEPLOY_MODE_KEY() {
        return SparkProcessBuilder$.MODULE$.DEPLOY_MODE_KEY();
    }

    public static String MASTER_KEY() {
        return SparkProcessBuilder$.MODULE$.MASTER_KEY();
    }

    public static String TAG_KEY() {
        return SparkProcessBuilder$.MODULE$.TAG_KEY();
    }

    public static String APP_KEY() {
        return SparkProcessBuilder$.MODULE$.APP_KEY();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public /* synthetic */ String org$apache$kyuubi$engine$ProcBuilder$$super$toString() {
        return super.toString();
    }

    @Override
    public Option<String> mainResource() {
        return ProcBuilder.mainResource$(this);
    }

    @Override
    public Map<String, String> env() {
        return ProcBuilder.env$(this);
    }

    @Override
    public final Process start() {
        return ProcBuilder.start$(this);
    }

    @Override
    public void close(boolean destroyProcess) {
        ProcBuilder.close$(this, destroyProcess);
    }

    @Override
    public Throwable getError() {
        return ProcBuilder.getError$(this);
    }

    @Override
    public String toString() {
        return ProcBuilder.toString$(this);
    }

    @Override
    public String getEngineHome(String shortName) {
        return ProcBuilder.getEngineHome$(this, shortName);
    }

    @Override
    public Throwable validateEnv(String requiredEnv) {
        return ProcBuilder.validateEnv$(this, requiredEnv);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public Path workingDir() {
        return this.workingDir;
    }

    private ProcessBuilder processBuilder$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.processBuilder = ProcBuilder.processBuilder$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.processBuilder;
    }

    @Override
    public final ProcessBuilder processBuilder() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.processBuilder$lzycompute();
        }
        return this.processBuilder;
    }

    @Override
    public Throwable org$apache$kyuubi$engine$ProcBuilder$$error() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$error;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$error_$eq(Throwable x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$error = x$1;
    }

    @Override
    public int org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines;
    }

    @Override
    public long org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout;
    }

    @Override
    public EvictingQueue<String> lastRowsOfLog() {
        return this.lastRowsOfLog;
    }

    @Override
    public boolean logCaptureThreadReleased() {
        return this.logCaptureThreadReleased;
    }

    @Override
    public void logCaptureThreadReleased_$eq(boolean x$1) {
        this.logCaptureThreadReleased = x$1;
    }

    @Override
    public Thread org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread() {
        return this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread_$eq(Thread x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$logCaptureThread = x$1;
    }

    @Override
    public Process process() {
        return this.process;
    }

    @Override
    public void process_$eq(Process x$1) {
        this.process = x$1;
    }

    @Override
    public boolean processLaunched() {
        return this.processLaunched;
    }

    @Override
    public void processLaunched_$eq(boolean x$1) {
        this.processLaunched = x$1;
    }

    private File engineLog$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.engineLog = ProcBuilder.engineLog$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.engineLog;
    }

    @Override
    public File engineLog() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.engineLog$lzycompute();
        }
        return this.engineLog;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$engineScalaBinaryVersion_$eq(String x$1) {
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$workingDir_$eq(Path x$1) {
        this.workingDir = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines_$eq(int x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineLogMaxLines = x$1;
    }

    @Override
    public final void org$apache$kyuubi$engine$ProcBuilder$_setter_$org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout_$eq(long x$1) {
        this.org$apache$kyuubi$engine$ProcBuilder$$engineStartupDestroyTimeout = x$1;
    }

    @Override
    public void org$apache$kyuubi$engine$ProcBuilder$_setter_$lastRowsOfLog_$eq(EvictingQueue<String> x$1) {
        this.lastRowsOfLog = x$1;
    }

    @Override
    public String proxyUser() {
        return this.proxyUser;
    }

    @Override
    public KyuubiConf conf() {
        return this.conf;
    }

    public String engineRefId() {
        return this.engineRefId;
    }

    @Override
    public Option<OperationLog> extraEngineLog() {
        return this.extraEngineLog;
    }

    public String sparkHome() {
        return this.sparkHome;
    }

    @Override
    public String executable() {
        return this.executable;
    }

    @Override
    public String mainClass() {
        return "org.apache.kyuubi.engine.spark.SparkSQLEngine";
    }

    @Override
    public void completeMasterUrl(KyuubiConf conf) {
        block4: {
            try {
                Tuple3 tuple3 = new Tuple3(this.clusterManager(), (Object)scala.sys.package$.MODULE$.env().get((Object)KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_HOST()), (Object)scala.sys.package$.MODULE$.env().get((Object)KubernetesApplicationOperation$.MODULE$.KUBERNETES_SERVICE_PORT()));
                if (tuple3 == null) break block4;
                Option option = (Option)tuple3._1();
                Option option2 = (Option)tuple3._2();
                Option option3 = (Option)tuple3._3();
                if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                    Some some = (Some)option2;
                    String kubernetesServiceHost = (String)some.value();
                    if (option3 instanceof Some) {
                        Some some2 = (Some)option3;
                        String kubernetesServicePort = (String)some2.value();
                        String masterURL = new StringBuilder(15).append("k8s://https://").append(kubernetesServiceHost).append(":").append(kubernetesServicePort).toString();
                        conf.set("spark.master", masterURL);
                    }
                }
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed when setting up spark.master with kubernetes environment automatically.", e);
            }
        }
    }

    public String convertConfigKey(String key) {
        if (key.startsWith("spark.")) {
            return key;
        }
        if (key.startsWith("hadoop.")) {
            return new StringBuilder(13).append("spark.hadoop.").append(key).toString();
        }
        return new StringBuilder(6).append("spark.").append(key).toString();
    }

    public String extractSparkCoreScalaVersion(Iterable<String> fileNames) {
        return (String)fileNames.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = SparkProcessBuilder$.MODULE$.SPARK_CORE_SCALA_VERSION_REGEX().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String scalaVersion = (String)((LinearSeqOptimized)option.get()).apply(0);
                    return (B1)scalaVersion;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = SparkProcessBuilder$.MODULE$.SPARK_CORE_SCALA_VERSION_REGEX().unapplySeq((CharSequence)string);
                return !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KyuubiException("Failed to extract Scala version from spark-core jar", KyuubiException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    @Override
    public String engineScalaBinaryVersion() {
        return this.engineScalaBinaryVersion;
    }

    private FileFilter engineHomeDirFilter$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineHomeDirFilter = file -> {
                    Regex regex;
                    String string = package$.MODULE$.SCALA_COMPILE_VERSION();
                    if ("2.12".equals(string)) {
                        regex = SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_212();
                    } else if ("2.13".equals(string)) {
                        regex = SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_213();
                    } else {
                        throw new MatchError((Object)string);
                    }
                    Regex r = regex;
                    return file.isDirectory() && r.findFirstMatchIn((CharSequence)file.getName()).isDefined();
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineHomeDirFilter;
    }

    @Override
    public FileFilter engineHomeDirFilter() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineHomeDirFilter$lzycompute();
        }
        return this.engineHomeDirFilter;
    }

    /*
     * WARNING - void declaration
     */
    private Iterable<String> commands$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                this.completeMasterUrl(this.conf());
                KyuubiApplicationManager$.MODULE$.tagApplication(this.engineRefId(), this.shortName(), this.clusterManager(), this.conf());
                ListBuffer buffer = new ListBuffer();
                buffer.$plus$eq((Object)this.executable());
                buffer.$plus$eq((Object)"--class");
                buffer.$plus$eq((Object)this.mainClass());
                Map allConf = this.conf().getAll();
                Enumeration.Value value = AuthTypes$.MODULE$.withName((String)this.conf().get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_AUTH_TYPE()));
                Enumeration.Value value2 = AuthTypes$.MODULE$.KERBEROS();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    allConf = allConf.$plus$plus(this.zkAuthKeytabFileConf((Map<String, String>)allConf));
                }
                allConf.$plus$plus(this.engineLogPathConf()).$plus$plus(this.extraYarnConf((Map<String, String>)allConf)).$plus$plus(this.appendPodNameConf((Map<String, String>)allConf)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValue(this.convertConfigKey(k), v, CommandLineUtils$.MODULE$.confKeyValue$default$3()));
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.setupKerberos((Buffer<String>)buffer);
                this.mainResource().foreach((Function1 & Serializable & scala.Serializable)r -> buffer.$plus$eq(r));
                this.commands = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commands;
    }

    @Override
    public Iterable<String> commands() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commands$lzycompute();
        }
        return this.commands;
    }

    @Override
    public String module() {
        return "kyuubi-spark-sql-engine";
    }

    public void setupKerberos(Buffer<String> buffer) {
        Option<String> option = this.tryKeytab();
        if (None$.MODULE$.equals(option)) {
            this.setSparkUserName(this.proxyUser(), buffer);
            buffer.$plus$eq((Object)"--proxy-user");
            buffer.$plus$eq((Object)this.proxyUser());
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            this.setSparkUserName(name, buffer);
            return;
        }
        throw new MatchError(option);
    }

    private Option<String> tryKeytab() {
        None$ none$;
        block4: {
            Option principal = this.conf().getOption("spark.kerberos.principal");
            Option keytab = this.conf().getOption("spark.kerberos.keytab");
            if (principal.isEmpty() || keytab.isEmpty()) {
                return None$.MODULE$;
            }
            try {
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)((String)principal.get()), (String)((String)keytab.get()));
                String string = ugi.getShortUserName();
                String string2 = this.proxyUser();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("The session proxy user: ").append(this.proxyUser()).append(" is not same with ").append("spark principal: ").append(ugi.getShortUserName()).append(", so we can't support use keytab. ").append("Fallback to use proxy user.").toString());
                    none$ = None$.MODULE$;
                    break block4;
                }
                none$ = new Some((Object)ugi.getShortUserName());
            }
            catch (IOException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Failed to login for ").append(principal.get()).toString(), e);
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private Map<String, String> zkAuthKeytabFileConf(Map<String, String> sparkConf) {
        Option zkAuthKeytab = (Option)this.conf().get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB());
        if (zkAuthKeytab.isDefined()) {
            Option option = sparkConf.get((Object)"spark.files");
            if (option instanceof Some) {
                Some some = (Some)option;
                String files = (String)some.value();
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.files"), (Object)new StringBuilder(1).append(files).append(",").append(zkAuthKeytab.get()).toString())}));
            }
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.files"), zkAuthKeytab.get())}));
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    @Override
    public String shortName() {
        return "spark";
    }

    private Map<String, String> defaultsConf$lzycompute() {
        SparkProcessBuilder sparkProcessBuilder = this;
        synchronized (sparkProcessBuilder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String confDir = (String)this.env().getOrElse((Object)"SPARK_CONF_DIR", (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(this.sparkHome()).append(File.separator).append("conf").toString());
                this.defaultsConf = this.liftedTree1$1(confDir);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultsConf;
    }

    public Map<String, String> defaultsConf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.defaultsConf$lzycompute();
        }
        return this.defaultsConf;
    }

    @Override
    public ApplicationManagerInfo appMgrInfo() {
        return ApplicationManagerInfo$.MODULE$.apply(this.clusterManager(), this.kubernetesContext(), this.kubernetesNamespace());
    }

    private boolean forciblyRewriteDriverPodName() {
        return this.forciblyRewriteDriverPodName;
    }

    private boolean forciblyRewriteExecPodNamePrefix() {
        return this.forciblyRewriteExecPodNamePrefix;
    }

    public Map<String, String> appendPodNameConf(Map<String, String> conf) {
        BoxedUnit boxedUnit;
        String appName = (String)conf.getOrElse((Object)"spark.app.name", (Function0 & Serializable & scala.Serializable)() -> "spark");
        Builder map = Map$.MODULE$.newBuilder();
        if (this.clusterManager().exists((Function1 & Serializable & scala.Serializable)cm -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$appendPodNameConf$2(cm)))) {
            BoxedUnit boxedUnit2;
            if (!conf.contains((Object)"spark.kubernetes.executor.podNamePrefix")) {
                String prefix = KubernetesUtils$.MODULE$.generateExecutorPodNamePrefix(appName, this.engineRefId(), this.forciblyRewriteExecPodNamePrefix());
                boxedUnit2 = map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.executor.podNamePrefix"), (Object)prefix));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.deployMode().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$appendPodNameConf$3(x$1)))) {
                if (!conf.contains((Object)"spark.kubernetes.driver.pod.name")) {
                    String name = KubernetesUtils$.MODULE$.generateDriverPodName(appName, this.engineRefId(), this.forciblyRewriteDriverPodName());
                    boxedUnit = map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.driver.pod.name"), (Object)name));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((TraversableOnce)map.result()).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> extraYarnConf(Map<String, String> conf) {
        Builder map = Map$.MODULE$.newBuilder();
        Object object = this.clusterManager().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$extraYarnConf$1(x$2))) ? (!conf.contains((Object)"spark.yarn.maxAppAttempts") ? map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.maxAppAttempts"), (Object)"1")) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        return ((TraversableOnce)map.result()).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<String> clusterManager() {
        return this.conf().getOption("spark.master").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.master"));
    }

    public Option<String> deployMode() {
        return this.conf().getOption("spark.submit.deployMode").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.submit.deployMode"));
    }

    @Override
    public boolean isClusterMode() {
        Some some;
        String m;
        Option option = this.clusterManager().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(Locale.ROOT));
        if (option instanceof Some && ((m = (String)(some = (Some)option).value()).startsWith("yarn") || m.startsWith("k8s"))) {
            return this.deployMode().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$isClusterMode$2(x$4)));
        }
        return false;
    }

    public Option<String> kubernetesContext() {
        return this.conf().getOption("spark.kubernetes.context").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.kubernetes.context"));
    }

    public Option<String> kubernetesNamespace() {
        return this.conf().getOption("spark.kubernetes.namespace").orElse((Function0 & Serializable & scala.Serializable)() -> this.defaultsConf().get((Object)"spark.kubernetes.namespace"));
    }

    @Override
    public void validateConf() {
        Validator$.MODULE$.validateConf(this.conf());
    }

    public void setSparkUserName(String userName, Buffer<String> buffer) {
        this.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            if (cm.toUpperCase().startsWith("K8S")) {
                buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValue("spark.kubernetes.driverEnv.SPARK_USER_NAME", userName, CommandLineUtils$.MODULE$.confKeyValue$default$3()));
                return buffer.$plus$plus$eq((TraversableOnce)CommandLineUtils$.MODULE$.confKeyValue("spark.executorEnv.SPARK_USER_NAME", userName, CommandLineUtils$.MODULE$.confKeyValue$default$3()));
            }
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, String> engineLogPathConf() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ProcBuilder$.MODULE$.KYUUBI_ENGINE_LOG_PATH_KEY()), (Object)this.engineLog().getAbsolutePath())}));
    }

    public static final /* synthetic */ boolean $anonfun$engineScalaBinaryVersion$1(CharSequence x$1) {
        return StringUtils.isNotBlank((CharSequence)x$1);
    }

    private final /* synthetic */ Map liftedTree1$1(String confDir$1) {
        Map map;
        block3: {
            try {
                File confFile = new File(new StringBuilder(19).append(confDir$1).append(File.separator).append("spark-defaults.conf").toString());
                if (confFile.exists()) {
                    map = Utils$.MODULE$.getPropertiesFromFile((Option)new Some((Object)confFile));
                    break block3;
                }
                map = Predef$.MODULE$.Map().empty();
            }
            catch (Exception exception) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to load spark configurations from ").append(confDir$1).toString());
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    public static final /* synthetic */ boolean $anonfun$appendPodNameConf$2(String cm) {
        return cm.toLowerCase(Locale.ROOT).startsWith("k8s");
    }

    public static final /* synthetic */ boolean $anonfun$appendPodNameConf$3(String x$1) {
        String string = x$1.toLowerCase(Locale.ROOT);
        String string2 = "cluster";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extraYarnConf$1(String x$2) {
        return x$2.toLowerCase(Locale.ROOT).startsWith("yarn");
    }

    public static final /* synthetic */ boolean $anonfun$isClusterMode$2(String x$4) {
        String string = x$4.toLowerCase(Locale.ROOT);
        String string2 = "cluster";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SparkProcessBuilder(String proxyUser, KyuubiConf conf, String engineRefId, Option<OperationLog> extraEngineLog) {
        this.proxyUser = proxyUser;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.extraEngineLog = extraEngineLog;
        ProcBuilder.$init$(this);
        Logging.$init$((Logging)this);
        this.sparkHome = this.getEngineHome(this.shortName());
        this.executable = Paths.get(this.sparkHome(), "bin", SparkProcessBuilder$.MODULE$.org$apache$kyuubi$engine$spark$SparkProcessBuilder$$SPARK_SUBMIT_FILE()).toFile().getCanonicalPath();
        this.engineScalaBinaryVersion = (String)this.env().get((Object)"SPARK_SCALA_VERSION").filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProcessBuilder.$anonfun$engineScalaBinaryVersion$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.extractSparkCoreScalaVersion((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Paths.get(this.sparkHome(), "jars").toFile().list())));
        this.forciblyRewriteDriverPodName = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.KUBERNETES_FORCIBLY_REWRITE_DRIVER_POD_NAME()));
        this.forciblyRewriteExecPodNamePrefix = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.KUBERNETES_FORCIBLY_REWRITE_EXEC_POD_NAME_PREFIX()));
    }

    @VisibleForTesting
    public SparkProcessBuilder(String proxyUser, KyuubiConf conf) {
        this(proxyUser, conf, "", SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
    }
}

