/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    public FlowableOnBackpressureLatest(Publisher<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new BackpressureLatestSubscriber<T>(s));
    }

    static final class BackpressureLatestSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 163080509307634843L;
        final Subscriber<? super T> actual;
        Subscription s;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<T> current = new AtomicReference();

        BackpressureLatestSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.current.lazySet(t);
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (this.getAndIncrement() == 0) {
                    this.current.lazySet(null);
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super T> a = this.actual;
            int missed = 1;
            AtomicLong r = this.requested;
            AtomicReference<T> q = this.current;
            do {
                long e;
                for (e = 0L; e != r.get(); ++e) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = q.getAndSet(null);
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                }
                if (e == r.get() && this.checkTerminated(this.done, q.get() == null, a, q)) {
                    return;
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(r, e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, AtomicReference<T> q) {
            if (this.cancelled) {
                q.lazySet(null);
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    q.lazySet(null);
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

