/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.Count;
import org.apache.kyuubi.client.api.v1.dto.Engine;
import org.apache.kyuubi.client.api.v1.dto.OperationData;
import org.apache.kyuubi.client.api.v1.dto.ServerData;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationHandle$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.ApiUtils$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.SessionHandle$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Tag(name="Admin")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rma!B\t\u0013\u0001Iq\u0002\"B\u0017\u0001\t\u0003y\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"B8\u0001\t\u0003\u0019\u0004\"\u0002=\u0001\t\u0003\u0019\u0004BBA\u0002\u0001\u0011\u00051\u0007\u0003\u0004\u0002\u0016\u0001!\ta\r\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!4\u0001\t\u0003\ty\rC\u0004\u0002z\u0002!\t!a?\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0005kCqA!/\u0001\t\u0003\u0011YLA\u0007BI6LgNU3t_V\u00148-\u001a\u0006\u0003'Q\t!A^\u0019\u000b\u0005U1\u0012aA1qS*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005eQ\u0012AB6zkV\u0014\u0017N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0003\u0002\u0001 K%\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005!\u0012B\u0001\u0015\u0015\u0005E\t\u0005/\u001b*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0003U-j\u0011\u0001G\u0005\u0003Ya\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005\u0011\u0012!\u0007:fMJ,7\u000f\u001b$s_:$XM\u001c3IC\u0012|w\u000e]\"p]\u001a$\u0012\u0001\u000e\t\u0003kyj\u0011A\u000e\u0006\u0003oa\nAaY8sK*\u0011\u0011HO\u0001\u0003eNT!a\u000f\u001f\u0002\u0005]\u001c(\"A\u001f\u0002\u000b)\fg/\u0019=\n\u0005}2$\u0001\u0003*fgB|gn]3)\t\t\tUI\u0012\t\u0003\u0005\u000ek\u0011\u0001O\u0005\u0003\tb\u0012A\u0001U1uQ\u0006)a/\u00197vK\u0006\nq)A\nsK\u001a\u0014Xm\u001d50Q\u0006$wn\u001c9`G>tg\r\u000b\u0002\u0003\u0013B\u0011!IS\u0005\u0003\u0017b\u0012A\u0001U(T)\"B!!T/_A\u0006dW\u000e\u0005\u0002O76\tqJ\u0003\u0002Q#\u0006I!/Z:q_:\u001cXm\u001d\u0006\u0003%N\u000b1\"\u00198o_R\fG/[8og*\u0011A+V\u0001\u0004_\u0006\u001c(B\u0001,X\u0003\t18G\u0003\u0002Y3\u000691o^1hO\u0016\u0014(\"\u0001.\u0002\u0005%|\u0017B\u0001/P\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0003}\u000b1A\r\u00191\u0003\u001d\u0019wN\u001c;f]Rd\u0013AY\u0016\u0004G&T\u0007C\u00013h\u001b\u0005)'B\u00014R\u0003\u0015iW\rZ5b\u0013\tAWMA\u0004D_:$XM\u001c;\u0002\u00135,G-[1UsB,\u0017%A6\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013A\\\u0001ae\u00164'/Z:iAQDW\rI&zkV\u0014\u0017\u000eI:feZ,'\u000f\t5bI>|\u0007\u000fI2p]\u001ad\u0003E\\8uK\u0002\"\b.\u0019;-A%$\be\u001c8ms\u0002\"\u0018m[3tA\u00054g-Z2uA\u0019|'\u000f\t4s_:$XM\u001c3!g\u0016\u0014h/[2fg\u0002rwn^\u0001\u0018e\u00164'/Z:i+N,'\u000fR3gCVdGo]\"p]\u001aDCaA!Fc\u0006\n!/\u0001\u000esK\u001a\u0014Xm\u001d50kN,'o\u00183fM\u0006,H\u000e^:`G>tg\r\u000b\u0002\u0004\u0013\"B1!T/_AVdg\u000fL\u0001cC\u00059\u0018!\t:fMJ,7\u000f\u001b\u0011uQ\u0016\u0004So]3sA\u0011,g-Y;miN\u00043m\u001c8gS\u001e\u001c\u0018!\u0006:fMJ,7\u000f[&vE\u0016\u0014h.\u001a;fg\u000e{gN\u001a\u0015\u0005\t\u0005+%0I\u0001|\u0003]\u0011XM\u001a:fg\"|3.\u001e2fe:,G/Z:`G>tg\r\u000b\u0002\u0005\u0013\"BA!T/_Azdw\u0010L\u0001cC\t\t\t!\u0001\u0010sK\u001a\u0014Xm\u001d5!i\",\u0007e[;cKJtW\r^3tA\r|gNZ5hg\u0006!\"/\u001a4sKNDWK\u001c7j[&$X\rZ+tKJDS!B!F\u0003\u000f\t#!!\u0003\u0002/I,gM]3tQ>*h\u000e\\5nSR,GmX;tKJ\u001c\bFA\u0003JQ))Q*\u00180a\u0003\u001fa\u0017\u0011\u0003\u0017\u0002E\u0006\u0012\u00111C\u0001\u001ce\u00164'/Z:iAQDW\rI;oY&l\u0017\u000e^3eAU\u001cXM]:\u0002\u001fI,gM]3tQ\u0012+g._+tKJDSAB!F\u00033\t#!a\u0007\u0002%I,gM]3tQ>\"WM\\=`kN,'o\u001d\u0015\u0003\r%C#BB'^=\u0002\f\t\u0003\\A\u0012Y\u0005\u0011\u0017EAA\u0013\u0003Y\u0011XM\u001a:fg\"\u0004C\u000f[3!I\u0016t\u0017\u0010I;tKJ\u001c\u0018\u0001C:fgNLwN\\:\u0015\t\u0005-\u0012q\u000b\t\u0007\u0003[\ti$a\u0011\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013bAA\u001eC\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u00121aU3r\u0015\r\tY$\t\t\u0005\u0003\u000b\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\r!Go\u001c\u0006\u0004'\u00055#bA\u000b\u0002P)\u0019\u0011\u0011\u000b\r\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t)&a\u0012\u0003\u0017M+7o]5p]\u0012\u000bG/\u0019\u0005\b\u00033:\u0001\u0019AA.\u0003\u0015)8/\u001a:t!\u0011\ti&!\u001a\u000f\t\u0005}\u0013\u0011\r\t\u0004\u0003c\t\u0013bAA2C\u00051\u0001K]3eK\u001aLA!a\u001a\u0002j\t11\u000b\u001e:j]\u001eT1!a\u0019\"Q\u001d\t9&!\u001cF\u0003g\u00022AQA8\u0013\r\t\t\b\u000f\u0002\u000b#V,'/\u001f)be\u0006l\u0017EAA-Q\u00159\u0011)RA<C\t\t9\u0003K\u0002\b\u0003w\u00022AQA?\u0013\r\ty\b\u000f\u0002\u0004\u000f\u0016#\u0006FC\u0004N;z\u0003\u00171\u00117\u0002 2\u0012\u0011QQ\u0016\bG&T\u0017qQAE\u0003\u0015\t'O]1zW\u0019\tY)!%\u0002\u0014B\u0019A-!$\n\u0007\u0005=UMA\u0006BeJ\f\u0017pU2iK6\f\u0017AB:dQ\u0016l\u0017m\u000b\u0004\u0002\u0016\u0006m\u0015Q\u0014\t\u0004I\u0006]\u0015bAAMK\n11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gn\t\u0002\u0002D\u0005\u0012\u0011\u0011U\u0001\"O\u0016$\b\u0005\u001e5fA1L7\u000f\u001e\u0011pM\u0002\nG\u000e\u001c\u0011mSZ,\u0007e]3tg&|gn]\u0001\rG2|7/Z*fgNLwN\u001c\u000b\u0004i\u0005\u001d\u0006bBAU\u0011\u0001\u0007\u00111L\u0001\u0011g\u0016\u001c8/[8o\u0011\u0006tG\r\\3TiJDs!a*\u0002.\u0016\u000b\u0019\fE\u0002C\u0003_K1!!-9\u0005%\u0001\u0016\r\u001e5QCJ\fW.\t\u0002\u00026\u0006i1/Z:tS>t\u0007*\u00198eY\u0016DS\u0001C!F\u0003s\u000b#!a/\u00021M,7o]5p]N|3p]3tg&|g\u000eS1oI2,W\u0010K\u0002\t\u0003\u007f\u00032AQAa\u0013\r\t\u0019\r\u000f\u0002\u0007\t\u0016cU\tV#)\u0015!iUL\u00181\u0002H2\fI\rL\u0001cC\t\tY-A\bDY>\u001cX\rI1!g\u0016\u001c8/[8o\u00039a\u0017n\u001d;Pa\u0016\u0014\u0018\r^5p]N$b!!5\u0002Z\u0006u\u0007CBA\u0017\u0003{\t\u0019\u000e\u0005\u0003\u0002F\u0005U\u0017\u0002BAl\u0003\u000f\u0012Qb\u00149fe\u0006$\u0018n\u001c8ECR\f\u0007bBA-\u0013\u0001\u0007\u00111\f\u0015\b\u00033\fi'RA:\u0011\u001d\t),\u0003a\u0001\u00037Bs!!8\u0002n\u0015\u000b\u0019\fK\u0003\n\u0003\u0016\u000b\u0019/\t\u0002\u0002f\u0006Qq\u000e]3sCRLwN\\:)\u0007%\tY\b\u000b\u0006\n\u001bvs\u0006-a;m\u0003kd#!!<,\u000f\rL'.a\"\u0002p.2\u00111RAI\u0003c\\c!!&\u0002\u001c\u0006M8EAAjC\t\t90A\u0013hKR\u0004C\u000f[3!Y&\u001cH\u000fI8gA\u0005dG\u000eI1di&4X\rI8qKJ\fG/[8og\u0006q1\r\\8tK>\u0003XM]1uS>tGc\u0001\u001b\u0002~\"9\u0011q \u0006A\u0002\u0005m\u0013AE8qKJ\fG/[8o\u0011\u0006tG\r\\3TiJDs!!@\u0002.\u0016\u0013\u0019!\t\u0002\u0003\u0006\u0005yq\u000e]3sCRLwN\u001c%b]\u0012dW\rK\u0003\u000b\u0003\u0016\u0013I!\t\u0002\u0003\f\u0005ar\u000e]3sCRLwN\\:0w>\u0004XM]1uS>t\u0007*\u00198eY\u0016l\bf\u0001\u0006\u0002@\"R!\"T/_A\nEANa\u0005-\u0003\t\f#A!\u0006\u0002%\rdwn]3!C:\u0004s\u000e]3sCRLwN\\\u0001\rI\u0016dW\r^3F]\u001eLg.\u001a\u000b\fi\tm!Q\u0005B\u0018\u0005o\u0011\t\u0005C\u0004\u0003\u001e-\u0001\r!a\u0017\u0002\u0015\u0015tw-\u001b8f)f\u0004X\rK\u0004\u0003\u001c\u00055TI!\t\"\u0005\t\r\u0012\u0001\u0002;za\u0016DqAa\n\f\u0001\u0004\tY&\u0001\u0006tQ\u0006\u0014X\rT3wK2DsA!\n\u0002n\u0015\u0013Y#\t\u0002\u0003.\u0005Q1\u000f[1sK2,g/\u001a7\t\u000f\tE2\u00021\u0001\u0002\\\u0005I1/\u001e2e_6\f\u0017N\u001c\u0015\b\u0005_\ti'\u0012B\u001bC\t\u0011\t\u0004C\u0004\u0003:-\u0001\r!a\u0017\u0002\u001f-LX/\u001e2j!J|\u00070_+tKJDsAa\u000e\u0002n\u0015\u0013i$\t\u0002\u0003@\u0005I\u0001O]8ysV\u001bXM\u001d\u0005\b\u0005\u0007Z\u0001\u0019AA.\u00031A7O\r)s_bLXk]3sQ\u001d\u0011\t%!\u001cF\u0005\u000f\n#A!\u0013\u0002/!Lg/\u001a\u0018tKJ4XM\u001d\u001a/aJ|\u00070\u001f\u0018vg\u0016\u0014\b&B\u0006B\u000b\n5\u0013E\u0001B(\u0003\u0019)gnZ5oK\"\u001a1\"a0)\u0015-iUL\u00181\u0003V1\u00149\u0006L\u0001cC\t\u0011I&\u0001\u000beK2,G/\u001a\u0011lsV,(-\u001b\u0011f]\u001eLg.Z\u0001\fY&\u001cH/\u00128hS:,7\u000f\u0006\u0007\u0003`\t\u001d$1\u000eB8\u0005g\u00129\b\u0005\u0004\u0002.\u0005u\"\u0011\r\t\u0005\u0003\u000b\u0012\u0019'\u0003\u0003\u0003f\u0005\u001d#AB#oO&tW\rC\u0004\u0003\u001e1\u0001\r!a\u0017)\u000f\t\u001d\u0014QN#\u0003\"!9!q\u0005\u0007A\u0002\u0005m\u0003f\u0002B6\u0003[*%1\u0006\u0005\b\u0005ca\u0001\u0019AA.Q\u001d\u0011y'!\u001cF\u0005kAqA!\u000f\r\u0001\u0004\tY\u0006K\u0004\u0003t\u00055TI!\u0010\t\u000f\t\rC\u00021\u0001\u0002\\!:!qOA7\u000b\n\u001d\u0003&\u0002\u0007B\u000b\n5\u0003f\u0001\u0007\u0002|!RA\"T/_A\n\u0005ENa!-\u0003\t\f#A!\"\u0002'1L7\u000f\u001e\u0011lsV,(-\u001b\u0011f]\u001eLg.Z:\u0002\u00171L7\u000f^*feZ,'o\u001d\u000b\u0003\u0005\u0017\u0003b!!\f\u0002>\t5\u0005\u0003BA#\u0005\u001fKAA!%\u0002H\tQ1+\u001a:wKJ$\u0015\r^1)\u000b5\tUI!&\"\u0003]A3!DA>Q)iQ*\u00180a\u00057c'Q\u0014\u0017\u0003\u0003[\f#Aa(\u000291L7\u000f\u001e\u0011bY2\u0004C.\u001b<fA-LX/\u001e2jAM,'O^3sg\u0006\u0019bn\u001c:nC2L'0Z#oO&tW-\u00138g_Ra!\u0011\rBS\u0005S\u0013YK!,\u00030\"9!q\u0015\bA\u0002\u0005m\u0013\u0001C;tKJt\u0015-\\3\t\u000f\tua\u00021\u0001\u0002\\!9!q\u0005\bA\u0002\u0005m\u0003b\u0002B\u0019\u001d\u0001\u0007\u00111\f\u0005\b\u0005cs\u0001\u0019AA.\u0003A\u0019XO\u00193p[\u0006Lg\u000eR3gCVdG/\u0001\u000bdC2\u001cW\u000f\\1uK\u0016sw-\u001b8f'B\f7-\u001a\u000b\u0005\u00037\u00129\fC\u0004\u0003P=\u0001\rA!\u0019\u0002\u0015\r|WO\u001c;CCR\u001c\u0007\u000e\u0006\u0005\u0003>\n\r'q\u001bBp!\u0011\t)Ea0\n\t\t\u0005\u0017q\t\u0002\u0006\u0007>,h\u000e\u001e\u0005\b\u0005\u000b\u0004\u0002\u0019AA.\u0003%\u0011\u0017\r^2i)f\u0004X\rK\u0004\u0003D\n%WIa4\u0011\u0007\t\u0013Y-C\u0002\u0003Nb\u0012A\u0002R3gCVdGOV1mk\u0016\f#A!5\u0002\u000bM\u0003\u0016IU&)\u000f\t\r\u0017QN#\u0003V\u0006\u0012!Q\u0019\u0005\b\u00053\u0004\u0002\u0019AA.\u0003%\u0011\u0017\r^2i+N,'\u000fK\u0004\u0003X\u00065TI!8\"\u0005\te\u0007b\u0002Bq!\u0001\u0007\u00111L\u0001\u000bE\u0006$8\r[*uCR,\u0007f\u0002Bp\u0003[*%Q]\u0011\u0003\u0005CDS\u0001E!F\u0005S\f#Aa;\u0002\u0017\t\fGo\u001950G>,h\u000e\u001e\u0015\u0004!\u0005m\u0004F\u0003\tN;z\u0003'\u0011\u001f7\u0003z2\u0012!1_\u0016\bG&T\u0017\u0011\u0013B{W\u0019\t)*a'\u0003x\u000e\u0012!QX\u0011\u0003\u0005w\f1cZ3uAQDW\r\t2bi\u000eD\u0007eY8v]RDc\u0001\u0001B\u0000\u000b\u000e\u0015\u0001c\u0001\"\u0004\u0002%\u001911\u0001\u001d\u0003\u0011A\u0013x\u000eZ;dKNd\u0013A\u001b\u0015\b\u0001\r%1QCB\f!\u0011\u0019Ya!\u0005\u000e\u0005\r5!bAB\b#\u0006!A/Y4t\u0013\u0011\u0019\u0019b!\u0004\u0003\u0007Q\u000bw-\u0001\u0003oC6,\u0017EAB\r\u0003\u0015\tE-\\5o\u0001")
public class AdminResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private Option<KyuubiBatchService> batchService;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        AdminResource adminResource = this;
        synchronized (adminResource) {
            if (!this.bitmap$0) {
                this.batchService = ApiRequestContext.batchService$(this);
                this.bitmap$0 = true;
            }
        }
        return this.batchService;
    }

    @Override
    public Option<KyuubiBatchService> batchService() {
        if (!this.bitmap$0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the Kyuubi server hadoop conf, note that, it only takes affect for frontend services now")
    @POST
    @Path(value="refresh/hadoop_conf")
    public Response refreshFrontendHadoopConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Receive refresh Kyuubi server hadoop conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(56).append(userName).append(" is not allowed to refresh the Kyuubi server hadoop conf").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading the Kyuubi server hadoop conf");
        KyuubiServer$.MODULE$.reloadHadoopConf();
        return Response.ok((Object)new StringBuilder(42).append("Refresh the hadoop conf for ").append(this.fe().connectionUrl()).append(" successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the user defaults configs")
    @POST
    @Path(value="refresh/user_defaults_conf")
    public Response refreshUserDefaultsConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Receive refresh user defaults conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(49).append(userName).append(" is not allowed to refresh the user defaults conf").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading user defaults conf");
        KyuubiServer$.MODULE$.refreshUserDefaultsConf();
        return Response.ok((Object)"Refresh the user defaults conf successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the kubernetes configs")
    @POST
    @Path(value="refresh/kubernetes_conf")
    public Response refreshKubernetesConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Receive refresh kubernetes conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(46).append(userName).append(" is not allowed to refresh the kubernetes conf").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading kubernetes conf");
        KyuubiServer$.MODULE$.refreshKubernetesConf();
        return Response.ok((Object)"Refresh the kubernetes conf successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the unlimited users")
    @POST
    @Path(value="refresh/unlimited_users")
    public Response refreshUnlimitedUser() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Receive refresh unlimited users request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(46).append(userName).append(" is not allowed to refresh the unlimited users").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading unlimited users");
        KyuubiServer$.MODULE$.refreshUnlimitedUsers();
        return Response.ok((Object)"Refresh the unlimited users successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the deny users")
    @POST
    @Path(value="refresh/deny_users")
    public Response refreshDenyUser() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Receive refresh deny users request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(41).append(userName).append(" is not allowed to refresh the deny users").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading deny users");
        KyuubiServer$.MODULE$.refreshDenyUsers();
        return Response.ok((Object)"Refresh the deny users successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    @Path(value="sessions")
    public Seq<SessionData> sessions(@QueryParam(value="users") String users) {
        Iterable sessions;
        block1: {
            String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
            String ipAddress = this.fe().getIpAddress();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Received listing all live sessions request from ").append(userName).append("/").append(ipAddress).toString());
            if (!this.fe().isAdministrator(userName)) {
                throw new NotAllowedException(new StringBuilder(41).append(userName).append(" is not allowed to list all live sessions").toString(), new String[0]);
            }
            sessions = this.fe().be().sessionManager().allSessions();
            if (!StringUtils.isNotBlank((CharSequence)users)) break block1;
            Set usersSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])users.split(","))).toSet();
            sessions = (Iterable)sessions.filter((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)usersSet.contains((Object)session.user())));
        }
        return ((TraversableOnce)sessions.map((Function1 & Serializable & scala.Serializable)session -> ApiUtils$.MODULE$.sessionData((KyuubiSession)((Object)session)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="sessions/{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Received closing a session request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(37).append(userName).append(" is not allowed to close the session ").append(sessionHandleStr).toString(), new String[0]);
        }
        this.fe().be().closeSession(SessionHandle$.MODULE$.fromUUID(sessionHandleStr));
        return Response.ok((Object)new StringBuilder(32).append("Session ").append(sessionHandleStr).append(" is closed successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OperationData.class)))}, description="get the list of all active operations")
    @GET
    @Path(value="operations")
    public Seq<OperationData> listOperations(@QueryParam(value="users") String users, @QueryParam(value="sessionHandle") String sessionHandle) {
        Iterable operations;
        block2: {
            String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
            String ipAddress = this.fe().getIpAddress();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Received listing all of the active operations request from ").append(userName).append("/").append(ipAddress).toString());
            if (!this.fe().isAdministrator(userName)) {
                throw new NotAllowedException(new StringBuilder(42).append(userName).append(" is not allowed to list all the operations").toString(), new String[0]);
            }
            operations = this.fe().be().sessionManager().operationManager().allOperations();
            if (StringUtils.isNotBlank((CharSequence)users)) {
                Set usersSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])users.split(","))).toSet();
                operations = (Iterable)operations.filter((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)usersSet.contains((Object)operation.getSession().user())));
            }
            if (!StringUtils.isNotBlank((CharSequence)sessionHandle)) break block2;
            operations = (Iterable)operations.filter((Function1 & Serializable & scala.Serializable)operation -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$listOperations$3(sessionHandle, operation)));
        }
        return ((TraversableOnce)operations.map((Function1 & Serializable & scala.Serializable)operation -> ApiUtils$.MODULE$.operationData((KyuubiOperation)((Object)operation)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="close an operation")
    @DELETE
    @Path(value="operations/{operationHandle}")
    public Response closeOperation(@PathParam(value="operationHandle") String operationHandleStr) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Received close an operation request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(39).append(userName).append(" is not allowed to close the operation ").append(operationHandleStr).toString(), new String[0]);
        }
        OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
        this.fe().be().closeOperation(operationHandle);
        return Response.ok((Object)new StringBuilder(34).append("Operation ").append(operationHandleStr).append(" is closed successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="delete kyuubi engine")
    @DELETE
    @Path(value="engine")
    public Response deleteEngine(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="proxyUser") String kyuubiProxyUser, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        String activeProxyUser = (String)Option$.MODULE$.apply((Object)kyuubiProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> hs2ProxyUser);
        String userName = this.fe().isAdministrator(this.fe().getRealUser()) ? (String)Option$.MODULE$.apply((Object)activeProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fe().getRealUser()) : this.fe().getSessionUser(activeProxyUser);
        Engine engine = this.normalizeEngineInfo(userName, engineType, shareLevel, subdomain, "default");
        String engineSpace = this.calculateEngineSpace(engine);
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            AdminResource.$anonfun$deleteEngine$3(this, engineSpace, discoveryClient);
            return BoxedUnit.UNIT;
        });
        return Response.ok((Object)new StringBuilder(32).append("Engine ").append(engineSpace).append(" is deleted successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="list kyuubi engines")
    @GET
    @Path(value="engine")
    public Seq<Engine> listEngines(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="proxyUser") String kyuubiProxyUser, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        String activeProxyUser = (String)Option$.MODULE$.apply((Object)kyuubiProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> hs2ProxyUser);
        String userName = this.fe().isAdministrator(this.fe().getRealUser()) ? (String)Option$.MODULE$.apply((Object)activeProxyUser).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fe().getRealUser()) : this.fe().getSessionUser(activeProxyUser);
        Engine engine = this.normalizeEngineInfo(userName, engineType, shareLevel, subdomain, "");
        String engineSpace = this.calculateEngineSpace(engine);
        ListBuffer engineNodes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            boolean bl = false;
            Option option = null;
            Option option2 = Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$listEngines$4(x$1)));
            if (option2 instanceof Some) {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Listing engine nodes under ").append(engineSpace).toString());
                return engineNodes.$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(engineSpace, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
            }
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (discoveryClient.pathNonExists(engineSpace)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Path ").append(engineSpace).append(" does not exist. user: ").append(userName).append(", engine type: ").append(engineType).append(", ").append("share level: ").append(shareLevel).append(", subdomain: ").append(subdomain).toString());
                    return BoxedUnit.UNIT;
                }
            }
            if (bl) {
                return discoveryClient.getChildren(engineSpace).map((Function1 & Serializable & scala.Serializable)child -> {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Listing engine nodes under ").append(engineSpace).append("/").append((String)child).toString());
                    return engineNodes.$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(new StringBuilder(1).append(engineSpace).append("/").append((String)child).toString(), discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)option2);
        });
        return ((ListBuffer)engineNodes.map((Function1 & Serializable & scala.Serializable)node -> new Engine(engine.getVersion(), engine.getUser(), engine.getEngineType(), engine.getSharelevel(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])node.namespace().split("/"))).last(), node.instance(), node.namespace(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)node.attributes()).asJava()), ListBuffer$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OperationData.class)))}, description="list all live kyuubi servers")
    @GET
    @Path(value="server")
    public Seq<ServerData> listServers() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Received list all live kyuubi servers request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(47).append(userName).append(" is not allowed to list all live kyuubi servers").toString(), new String[0]);
        }
        KyuubiConf kyuubiConf = this.fe().getConf();
        ListBuffer servers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String serverSpec = DiscoveryPaths$.MODULE$.makePath(null, (String)kyuubiConf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(kyuubiConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> (Seq)discoveryClient.getServiceNodesInfo(serverSpec, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()).map((Function1 & Serializable & scala.Serializable)nodeInfo -> servers.$plus$eq((Object)ApiUtils$.MODULE$.serverData((ServiceNodeInfo)nodeInfo)), Seq$.MODULE$.canBuildFrom()));
        return servers.toSeq();
    }

    private Engine normalizeEngineInfo(String userName, String engineType, String shareLevel, String subdomain, String subdomainDefault) {
        KyuubiConf clonedConf = this.fe().getConf().clone();
        Option$.MODULE$.apply((Object)engineType).foreach((Function1 & Serializable & scala.Serializable)x$2 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_TYPE(), x$2));
        Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$normalizeEngineInfo$2(x$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN(), (Object)Option$.MODULE$.apply((Object)subdomain)));
        Option$.MODULE$.apply((Object)shareLevel).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$normalizeEngineInfo$4(x$5))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL(), x$6));
        String serverSpace = (String)clonedConf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        String normalizedEngineType = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE());
        String engineSubdomain = (String)((Option)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN())).getOrElse((Function0 & Serializable & scala.Serializable)() -> subdomainDefault);
        String engineShareLevel = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL());
        return new Engine(package$.MODULE$.KYUUBI_VERSION(), userName, normalizedEngineType, engineShareLevel, engineSubdomain, null, serverSpace, Collections.emptyMap());
    }

    private String calculateEngineSpace(Engine engine) {
        String string = engine.getSharelevel();
        String userOrGroup = "GROUP".equals(string) ? this.fe().sessionManager().groupProvider().primaryGroup(engine.getUser(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.fe().getConf().getAll()).asJava()) : engine.getUser();
        String engineSpace = new StringBuilder(3).append(engine.getNamespace()).append("_").append(engine.getVersion()).append("_").append(engine.getSharelevel()).append("_").append(engine.getEngineType()).toString();
        return DiscoveryPaths$.MODULE$.makePath(engineSpace, userOrGroup, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{engine.getSubdomain()}));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Count.class))}, description="get the batch count")
    @GET
    @Path(value="batch/count")
    public Count countBatch(@QueryParam(value="batchType") @DefaultValue(value="SPARK") String batchType, @QueryParam(value="batchUser") String batchUser, @QueryParam(value="batchState") String batchState) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Received counting batches request from ").append(userName).append("/").append(ipAddress).toString());
        if (!this.fe().isAdministrator(userName)) {
            throw new NotAllowedException(new StringBuilder(36).append(userName).append(" is not allowed to count the batches").toString(), new String[0]);
        }
        int batchCount = BoxesRunTime.unboxToInt((Object)this.batchService().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.countBatch(batchType, (Option<String>)Option$.MODULE$.apply((Object)batchUser), (Option<String>)Option$.MODULE$.apply((Object)batchState), x$7.countBatch$default$4()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return new Count(Predef$.MODULE$.int2Integer(batchCount));
    }

    public static final /* synthetic */ boolean $anonfun$listOperations$3(String sessionHandle$1, Operation operation) {
        return operation.getSession().handle().equals((Object)SessionHandle$.MODULE$.fromUUID(sessionHandle$1));
    }

    public static final /* synthetic */ void $anonfun$deleteEngine$4(AdminResource $this, String engineSpace$1, DiscoveryClient discoveryClient$1, String node) {
        String nodePath = new StringBuilder(1).append(engineSpace$1).append("/").append(node).toString();
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting engine node:").append(nodePath).toString());
        try {
            discoveryClient$1.delete(nodePath, discoveryClient$1.delete$default$2());
        }
        catch (Exception e) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Failed to delete engine node:").append(nodePath).toString(), e);
            throw new NotFoundException(new StringBuilder(30).append("Failed to delete engine node:").append(nodePath).append(",").append(e.getMessage()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$deleteEngine$3(AdminResource $this, String engineSpace$1, DiscoveryClient discoveryClient) {
        List engineNodes = discoveryClient.getChildren(engineSpace$1);
        engineNodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminResource.$anonfun$deleteEngine$4($this, engineSpace$1, discoveryClient, node);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listEngines$4(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$normalizeEngineInfo$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$normalizeEngineInfo$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public AdminResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

