/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorJob {
    public static JobControl createValueAggregatorJobs(String[] args, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        JobControl theControl = new JobControl("ValueAggregatorJobs");
        ArrayList<ControlledJob> dependingJobs = new ArrayList<ControlledJob>();
        Configuration conf = new Configuration();
        if (descriptors != null) {
            conf = ValueAggregatorJob.setAggregatorDescriptors(descriptors);
        }
        Job job = ValueAggregatorJob.createValueAggregatorJob(conf, args);
        ControlledJob cjob = new ControlledJob(job, dependingJobs);
        theControl.addJob(cjob);
        return theControl;
    }

    public static JobControl createValueAggregatorJobs(String[] args) throws IOException {
        return ValueAggregatorJob.createValueAggregatorJobs(args, null);
    }

    public static Job createValueAggregatorJob(Configuration conf, String[] args) throws IOException {
        String userJarFile;
        GenericOptionsParser genericParser = new GenericOptionsParser(conf, args);
        if ((args = genericParser.getRemainingArgs()).length < 2) {
            System.out.println("usage: inputDirs outDir [numOfReducer [textinputformat|seq [specfile [jobName]]]]");
            GenericOptionsParser.printGenericCommandUsage(System.out);
            System.exit(2);
        }
        String inputDir = args[0];
        String outputDir = args[1];
        int numOfReducers = 1;
        if (args.length > 2) {
            numOfReducers = Integer.parseInt(args[2]);
        }
        Class theInputFormat = null;
        theInputFormat = args.length > 3 && args[3].compareToIgnoreCase("textinputformat") == 0 ? TextInputFormat.class : SequenceFileInputFormat.class;
        Path specFile = null;
        if (args.length > 4) {
            specFile = new Path(args[4]);
        }
        String jobName = "";
        if (args.length > 5) {
            jobName = args[5];
        }
        if (specFile != null) {
            conf.addResource(specFile);
        }
        if ((userJarFile = conf.get("mapreduce.aggregate.user.jar.file")) != null) {
            conf.set("mapreduce.job.jar", userJarFile);
        }
        Job theJob = Job.getInstance(conf);
        if (userJarFile == null) {
            theJob.setJarByClass(ValueAggregator.class);
        }
        theJob.setJobName("ValueAggregatorJob: " + jobName);
        FileInputFormat.addInputPaths(theJob, inputDir);
        theJob.setInputFormatClass(theInputFormat);
        theJob.setMapperClass(ValueAggregatorMapper.class);
        FileOutputFormat.setOutputPath(theJob, new Path(outputDir));
        theJob.setOutputFormatClass(TextOutputFormat.class);
        theJob.setMapOutputKeyClass(Text.class);
        theJob.setMapOutputValueClass(Text.class);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(ValueAggregatorReducer.class);
        theJob.setCombinerClass(ValueAggregatorCombiner.class);
        theJob.setNumReduceTasks(numOfReducers);
        return theJob;
    }

    public static Job createValueAggregatorJob(String[] args, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        return ValueAggregatorJob.createValueAggregatorJob(ValueAggregatorJob.setAggregatorDescriptors(descriptors), args);
    }

    public static Configuration setAggregatorDescriptors(Class<? extends ValueAggregatorDescriptor>[] descriptors) {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.aggregate.descriptor.num", descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            conf.set("mapreduce.aggregate.descriptor" + i, "UserDefined," + descriptors[i].getName());
        }
        return conf;
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = ValueAggregatorJob.createValueAggregatorJob(new Configuration(), args);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        System.exit(ret);
    }
}

