/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import org.apache.kyuubi.server.http.authentication.KerberosUtil;
import org.apache.kyuubi.server.http.authentication.KerberosUtil$DER$;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class KerberosUtil$ {
    public static KerberosUtil$ MODULE$;
    private final Oid GSS_SPNEGO_MECH_OID;
    private final Oid GSS_KRB5_MECH_OID;
    private final Oid NT_GSS_KRB5_PRINCIPAL_OID;

    static {
        new KerberosUtil$();
    }

    public Oid GSS_SPNEGO_MECH_OID() {
        return this.GSS_SPNEGO_MECH_OID;
    }

    public Oid GSS_KRB5_MECH_OID() {
        return this.GSS_KRB5_MECH_OID;
    }

    public Oid NT_GSS_KRB5_PRINCIPAL_OID() {
        return this.NT_GSS_KRB5_PRINCIPAL_OID;
    }

    private Oid getNumericOidInstance(String oidName) {
        Oid oid;
        try {
            oid = new Oid(oidName);
        }
        catch (GSSException ex) {
            throw new IllegalArgumentException(ex);
        }
        return oid;
    }

    public String getTokenServerName(byte[] rawToken) {
        KerberosUtil.DER token = new KerberosUtil.DER(rawToken);
        KerberosUtil.DER oid = token.next();
        if (oid.equals(KerberosUtil$DER$.MODULE$.SPNEGO_MECH_OID())) {
            token = token.next().get((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{160, 48, 162, 4})).next();
            oid = token.next();
        }
        if (!oid.equals(KerberosUtil$DER$.MODULE$.KRB5_MECH_OID())) {
            throw new IllegalArgumentException("Malformed gss token");
        }
        if (token.next().getTag() != 1) {
            throw new IllegalArgumentException("Not an AP-REQ token");
        }
        KerberosUtil.DER ticket = token.next().get((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{110, 48, 163, 97, 48}));
        String realm = ticket.get((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{161, 27})).getAsString();
        KerberosUtil.DER names = ticket.get((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{162, 48, 161, 48}));
        StringBuilder sb = new StringBuilder();
        while (names.hasNext()) {
            Object object = sb.nonEmpty() ? sb.append('/') : BoxedUnit.UNIT;
            sb.append(names.next().getAsString());
        }
        return sb.append('@').append(realm).toString();
    }

    private KerberosUtil$() {
        MODULE$ = this;
        this.GSS_SPNEGO_MECH_OID = this.getNumericOidInstance("1.3.6.1.5.5.2");
        this.GSS_KRB5_MECH_OID = this.getNumericOidInstance("1.2.840.113554.1.2.2");
        this.NT_GSS_KRB5_PRINCIPAL_OID = this.getNumericOidInstance("1.2.840.113554.1.2.2.1");
    }
}

