/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.trino.api.v1;

import io.airlift.units.Duration;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.trino.client.QueryResults;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiTrinoFrontendService;
import org.apache.kyuubi.server.trino.api.ApiRequestContext;
import org.apache.kyuubi.server.trino.api.KyuubiTrinoOperationTranslator;
import org.apache.kyuubi.server.trino.api.Query;
import org.apache.kyuubi.server.trino.api.Query$;
import org.apache.kyuubi.server.trino.api.QueryId;
import org.apache.kyuubi.server.trino.api.QueryId$;
import org.apache.kyuubi.server.trino.api.Slug$Context$;
import org.apache.kyuubi.server.trino.api.TrinoContext;
import org.apache.kyuubi.server.trino.api.TrinoContext$;
import org.apache.kyuubi.server.trino.api.v1.dto.Ok;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.sql.parser.trino.KyuubiTrinoFeParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.trino.Deallocate;
import org.apache.kyuubi.sql.plan.trino.ExecuteForPreparing;
import org.apache.kyuubi.sql.plan.trino.Prepare;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Tag(name="Statement")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\tug!\u0002\u0007\u000e\u00015Y\u0002\"\u0002\u0016\u0001\t\u0003a\u0003\u0002C\u0018\u0001\u0011\u000b\u0007I\u0011\u0001\u0019\t\u0011Q\u0002\u0001R1A\u0005\u0002UBQA\u0010\u0001\u0005\u0002}BQ\u0001\u001f\u0001\u0005\u0002eDq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002Z\u0002!\t!a7\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B&\u0001\u0011%!Q\n\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0005E\u0019F/\u0019;f[\u0016tGOU3t_V\u00148-\u001a\u0006\u0003\u001d=\t!A^\u0019\u000b\u0005A\t\u0012aA1qS*\u0011!cE\u0001\u0006iJLgn\u001c\u0006\u0003)U\taa]3sm\u0016\u0014(B\u0001\f\u0018\u0003\u0019Y\u00170^;cS*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h'\u0011\u0001AD\t\u0014\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u0010\u0013\t)sBA\tBa&\u0014V-];fgR\u001cuN\u001c;fqR\u0004\"a\n\u0015\u000e\u0003UI!!K\u000b\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001.!\tq\u0003!D\u0001\u000e\u0003)!(/\u00198tY\u0006$xN]\u000b\u0002cA\u00111EM\u0005\u0003g=\u0011adS=vk\nLGK]5o_>\u0003XM]1uS>tGK]1og2\fGo\u001c:\u0002\rA\f'o]3s+\u00051\u0004CA\u001c=\u001b\u0005A$B\u0001\n:\u0015\t!$H\u0003\u0002<+\u0005\u00191/\u001d7\n\u0005uB$aE&zkV\u0014\u0017\u000e\u0016:j]>4U\rU1sg\u0016\u0014\u0018\u0001\u0002;fgR$\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u00076\t1\u0001\u001a;p\u0013\t)%I\u0001\u0002PW\"\"AaR)S!\tAu*D\u0001J\u0015\tQ5*\u0001\u0002sg*\u0011A*T\u0001\u0003oNT\u0011AT\u0001\u0006U\u00064\u0018\r_\u0005\u0003!&\u0013A\u0001U1uQ\u0006)a/\u00197vK\u0006\na\b\u000b\u0002\u0005)B\u0011\u0001*V\u0005\u0003-&\u00131aR#UQ!!\u0001\f[5lY^\u0014\u0006CA-g\u001b\u0005Q&BA.]\u0003%\u0011Xm\u001d9p]N,7O\u0003\u0002^=\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\ty\u0006-A\u0002pCNT!!\u00192\u0002\u0005Y\u001c$BA2e\u0003\u001d\u0019x/Y4hKJT\u0011!Z\u0001\u0003S>L!a\u001a.\u0003\u0017\u0005\u0003\u0018NU3ta>t7/Z\u0001\re\u0016\u001c\bo\u001c8tK\u000e{G-Z\u0011\u0002U\u0006\u0019!\u0007\r\u0019\u0002\u000f\r|g\u000e^3oi2\nQnK\u0002oiV\u0004\"a\u001c:\u000e\u0003AT!!\u001d/\u0002\u000b5,G-[1\n\u0005M\u0004(aB\"p]R,g\u000e^\u0001\n[\u0016$\u0017.\u0019+za\u0016\f\u0013A^\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006)\u0011/^3ssR9!0!\u0001\u0002\u001c\u00055\u0002CA>\u007f\u001b\u0005a(BA?J\u0003\u0011\u0019wN]3\n\u0005}d(\u0001\u0003*fgB|gn]3\t\u000f\u0005\rQ\u00011\u0001\u0002\u0006\u0005I1\u000f^1uK6,g\u000e\u001e\t\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005E\u0001cAA\u0006=5\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fY\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0014y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\n=!9\u0011QD\u0003A\u0002\u0005}\u0011a\u00025fC\u0012,'o\u001d\t\u0004w\u0006\u0005\u0012bAA\u0012y\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:tQ\u0011\tY\"a\n\u0011\u0007m\fI#C\u0002\u0002,q\u0014qaQ8oi\u0016DH\u000fC\u0004\u00020\u0015\u0001\r!!\r\u0002\u000fU\u0014\u0018.\u00138g_B\u001910a\r\n\u0007\u0005UBPA\u0004Ve&LeNZ8)\t\u00055\u0012q\u0005\u0015\u0007\u000b\u0005m\u0012+!\u0011\u0011\u0007!\u000bi$C\u0002\u0002@%\u0013\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003\u0007\n#!!\u0012\u0002\u0015Q,\u0007\u0010^\u0018qY\u0006Lg\u000eK\u0003\u0006\u000fF\u000bI%\t\u0002\u0002L\u0005\tq\u0006K\u0002\u0006\u0003\u001f\u00022\u0001SA)\u0013\r\t\u0019&\u0013\u0002\u0005!>\u001bF\u000b\u000b\u0006\u00061\"L7.a\u0016x\u0003ob#!!\u0017,\u000f9$X/a\u0017\u0002^\u000511o\u00195f[\u0006\\c!a\u0018\u0002f\u0005\u001d\u0004cA8\u0002b%\u0019\u00111\r9\u0003\rM\u001b\u0007.Z7b\u00039IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u001c#!!\u001b\u0011\t\u0005-\u00141O\u0007\u0003\u0003[RA!a\u001c\u0002r\u000511\r\\5f]RT!A\u00053\n\t\u0005U\u0014Q\u000e\u0002\r#V,'/\u001f*fgVdGo]\u0011\u0003\u0003s\nab\u0011:fCR,\u0007%\u0019\u0011rk\u0016\u0014\u00180\u0001\rhKR\fV/Z;fIN#\u0018\r^3nK:$8\u000b^1ukN$RB_A@\u0003\u001b\u000b)*a)\u0002B\u0006\u0015\u0007bBAA\r\u0001\u0007\u0011QA\u0001\bcV,'/_%eQ\u001d\ty(!\"R\u0003\u0017\u00032\u0001SAD\u0013\r\tI)\u0013\u0002\n!\u0006$\b\u000eU1sC6\f#!!!\t\u000f\u0005=e\u00011\u0001\u0002\u0006\u0005!1\u000f\\;hQ\u001d\ti)!\"R\u0003'\u000b#!a$\t\u000f\u0005]e\u00011\u0001\u0002\u001a\u0006)Ao\\6f]B\u0019Q$a'\n\u0007\u0005ueD\u0001\u0003M_:<\u0007fBAK\u0003\u000b\u000b\u0016\u0011U\u0011\u0003\u0003/Cq!!*\u0007\u0001\u0004\t9+A\u0004nCb<\u0016-\u001b;\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006)QO\\5ug*\u0019\u0011\u0011\u00173\u0002\u000f\u0005L'\u000f\\5gi&!\u0011QWAV\u0005!!UO]1uS>t\u0007fBAR\u0003s\u000b\u0016q\u0018\t\u0004\u0011\u0006m\u0016bAA_\u0013\nQ\u0011+^3ssB\u000b'/Y7\"\u0005\u0005\u0015\u0006bBA\u000f\r\u0001\u0007\u0011q\u0004\u0015\u0005\u0003\u0003\f9\u0003C\u0004\u00020\u0019\u0001\r!!\r)\t\u0005\u0015\u0017q\u0005\u0015\u0006\r\u001d\u000b\u00161Z\u0011\u0003\u0003\u001b\f\u0001eL9vKV,GmL>rk\u0016\u0014\u00180\u00133~_m\u001cH.^4~_m$xn[3o{\"\u0012a\u0001\u0016\u0015\u000b\raC\u0017n[Ajo\u0006UG&A7\"\u0005\u0005]\u0017aG$fi\u0002\nX/Z;fI\u0002\u001aH/\u0019;f[\u0016tG\u000fI:uCR,8/A\u000ehKR,\u00050Z2vi&twm\u0015;bi\u0016lWM\u001c;Ti\u0006$Xo\u001d\u000b\u000eu\u0006u\u0017\u0011]As\u0003S\fi/!=\t\u000f\u0005\u0005u\u00011\u0001\u0002\u0006!:\u0011Q\\AC#\u0006-\u0005bBAH\u000f\u0001\u0007\u0011Q\u0001\u0015\b\u0003C\f))UAJ\u0011\u001d\t9j\u0002a\u0001\u00033Cs!!:\u0002\u0006F\u000b\t\u000bC\u0004\u0002&\u001e\u0001\r!a*)\u000f\u0005%\u0018\u0011X)\u0002@\"9\u0011QD\u0004A\u0002\u0005}\u0001\u0006BAw\u0003OAq!a\f\b\u0001\u0004\t\t\u0004\u000b\u0003\u0002r\u0006\u001d\u0002&B\u0004H#\u0006]\u0018EAA}\u0003\rzS\r_3dkRLgnZ\u0018|cV,'/_%e{>Z8\u000f\\;h{>ZHo\\6f]vD#a\u0002+)\u0015\u001dA\u0006.[6\u0002\u0000^\u0014\t\u0001L\u0001nC\t\u0011\u0019!\u0001\u0010HKR\u0004S\r_3dkRLgn\u001a\u0011ti\u0006$X-\\3oi\u0002\u001aH/\u0019;vg\u0006)2-\u00198dK2\fV/Z;fIN#\u0018\r^3nK:$H#\u0003>\u0003\n\t5!\u0011\u0003B\u000b\u0011\u001d\t\t\t\u0003a\u0001\u0003\u000bAsA!\u0003\u0002\u0006F\u000bY\tC\u0004\u0002\u0010\"\u0001\r!!\u0002)\u000f\t5\u0011QQ)\u0002\u0014\"9\u0011q\u0013\u0005A\u0002\u0005e\u0005f\u0002B\t\u0003\u000b\u000b\u0016\u0011\u0015\u0005\b\u0003;A\u0001\u0019AA\u0010Q\u0011\u0011)\"a\n)\u000b!9\u0015+a3)\u0007!\u0011i\u0002E\u0002I\u0005?I1A!\tJ\u0005\u0019!U\tT#U\u000b\"R\u0001\u0002\u00175jW\n\u0015rOa\n-\u00035\f#A!\u000b\u0002/\r\u000bgnY3mAE,X-^3eAM$\u0018\r^3nK:$\u0018AH2b]\u000e,G.\u0012=fGV$\u0018N\\4Ti\u0006$X-\\3oiN#\u0018\r^;t)%Q(q\u0006B\u001a\u0005o\u0011Y\u0004C\u0004\u0002\u0002&\u0001\r!!\u0002)\u000f\t=\u0012QQ)\u0002\f\"9\u0011qR\u0005A\u0002\u0005\u0015\u0001f\u0002B\u001a\u0003\u000b\u000b\u00161\u0013\u0005\b\u0003/K\u0001\u0019AAMQ\u001d\u00119$!\"R\u0003CCq!!\b\n\u0001\u0004\ty\u0002\u000b\u0003\u0003<\u0005\u001d\u0002&B\u0005H#\u0006]\bfA\u0005\u0003\u001e!R\u0011\u0002\u00175jW\n\u0015sOa\u0012-\u00035\f#A!\u0013\u00025\r\u000bgnY3mA\u0015DXmY;uS:<\u0007e\u001d;bi\u0016lWM\u001c;\u0002\u0011\u001d,G/U;fef$bBa\u0014\u0003b\tE$1\u0010BB\u0005\u000b\u00139\t\u0005\u0004\u0003R\t]#1L\u0007\u0003\u0005'R1A!\u0016\u001f\u0003\u0011)H/\u001b7\n\t\te#1\u000b\u0002\u0004)JL\bcA\u0012\u0003^%\u0019!qL\b\u0003\u000bE+XM]=\t\u000f\t\r$\u00021\u0001\u0003f\u0005\u0011!-\u001a\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)\u0019!1N\u000b\u0002\u000fM,'O^5dK&!!q\u000eB5\u00059\u0011\u0015mY6f]\u0012\u001cVM\u001d<jG\u0016DqAa\u001d\u000b\u0001\u0004\u0011)(A\u0004d_:$X\r\u001f;\u0011\u0007\r\u00129(C\u0002\u0003z=\u0011A\u0002\u0016:j]>\u001cuN\u001c;fqRDq!!!\u000b\u0001\u0004\u0011i\bE\u0002$\u0005\u007fJ1A!!\u0010\u0005\u001d\tV/\u001a:z\u0013\u0012Dq!a$\u000b\u0001\u0004\t)\u0001C\u0004\u0002\u0018*\u0001\r!!'\t\u000f\t%%\u00021\u0001\u0003\f\u0006Y1\u000f\\;h\u0007>tG/\u001a=u!\u0011\u0011iIa'\u000f\t\t=%Q\u0013\b\u0004G\tE\u0015b\u0001BJ\u001f\u0005!1\u000b\\;h\u0013\u0011\u00119J!'\u0002\u000f\r{g\u000e^3yi*\u0019!1S\b\n\t\u0005-\"Q\u0014\u0006\u0005\u0005/\u0013I*\u0001\u0006cC\u0012\u0014V-];fgR$bAa)\u0003*\nm\u0006c\u0001%\u0003&&\u0019!qU%\u0003/]+'-\u00119qY&\u001c\u0017\r^5p]\u0016C8-\u001a9uS>t\u0007b\u0002BV\u0017\u0001\u0007!QV\u0001\u0007gR\fG/^:\u0011\t\t=&Q\u0017\b\u0004w\nE\u0016b\u0001BZy\u0006A!+Z:q_:\u001cX-\u0003\u0003\u00038\ne&AB*uCR,8OC\u0002\u00034rDqA!0\f\u0001\u0004\t)!A\u0004nKN\u001c\u0018mZ3)\r\u0001\u0011\t-\u0015Bd!\rA%1Y\u0005\u0004\u0005\u000bL%\u0001\u0003)s_\u0012,8-Z:-\u0003UDs\u0001\u0001Bf\u0005/\u0014I\u000e\u0005\u0003\u0003N\nMWB\u0001Bh\u0015\r\u0011\t\u000eX\u0001\u0005i\u0006<7/\u0003\u0003\u0003V\n='a\u0001+bO\u0006!a.Y7fC\t\u0011Y.A\u0005Ti\u0006$X-\\3oi\u0002")
public class StatementResource
implements ApiRequestContext,
Logging {
    private KyuubiTrinoOperationTranslator translator;
    private KyuubiTrinoFeParser parser;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private volatile byte bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiTrinoFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private KyuubiTrinoOperationTranslator translator$lzycompute() {
        StatementResource statementResource = this;
        synchronized (statementResource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.translator = new KyuubiTrinoOperationTranslator(this.fe().be());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.translator;
    }

    public KyuubiTrinoOperationTranslator translator() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.translator$lzycompute();
        }
        return this.translator;
    }

    private KyuubiTrinoFeParser parser$lzycompute() {
        StatementResource statementResource = this;
        synchronized (statementResource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.parser = new KyuubiTrinoFeParser();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.parser;
    }

    public KyuubiTrinoFeParser parser() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="test")
    @GET
    @Path(value="test")
    public Ok test() {
        return new Ok("trino server is running");
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryResults.class))}, description="Create a query")
    @POST
    @Path(value="/")
    @Consumes(value={"text/plain"})
    public Response query(String statement, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response response;
        if (statement == null || statement.isEmpty()) {
            throw this.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.BAD_REQUEST, "SQL statement is empty");
        }
        Option remoteAddr = Option$.MODULE$.apply((Object)this.httpRequest().getRemoteAddr());
        TrinoContext trinoContext = TrinoContext$.MODULE$.apply(headers, (Option<String>)remoteAddr);
        try {
            KyuubiTreeNode kyuubiTreeNode = this.parser().parsePlan(statement);
            if (kyuubiTreeNode instanceof Prepare) {
                Prepare prepare = (Prepare)kyuubiTreeNode;
                String statementId = prepare.statementId();
                Query query = Query$.MODULE$.apply(statementId, statement.split(new StringBuilder(5).append(statementId).append(" FROM").toString())[1], trinoContext, this.fe().be());
                QueryResults qr = query.getPrepareQueryResults(query.getLastToken(), uriInfo, query.getPrepareQueryResults$default$3());
                response = TrinoContext$.MODULE$.buildTrinoResponse(qr, query.context());
            } else if (kyuubiTreeNode instanceof ExecuteForPreparing) {
                ExecuteForPreparing executeForPreparing = (ExecuteForPreparing)kyuubiTreeNode;
                String statementId = executeForPreparing.statementId();
                List<String> parameters = executeForPreparing.parameters();
                HashMap parametersMap = new HashMap();
                parameters.indices().foreach((Function1 & Serializable & scala.Serializable)i -> StatementResource.$anonfun$query$1(parametersMap, parameters, BoxesRunTime.unboxToInt((Object)i)));
                response = (Response)trinoContext.preparedStatement().get((Object)statementId).map((Function1 & Serializable & scala.Serializable)originSql -> {
                    String realSql = Utils.updateSql((String)originSql, (HashMap)parametersMap);
                    Query query = Query$.MODULE$.apply(realSql, trinoContext, this.translator(), this.fe().be(), Query$.MODULE$.apply$default$5());
                    QueryResults qr = query.getQueryResults(query.getLastToken(), uriInfo, query.getQueryResults$default$3());
                    return TrinoContext$.MODULE$.buildTrinoResponse(qr, query.context());
                }).get();
            } else if (kyuubiTreeNode instanceof Deallocate) {
                Deallocate deallocate = (Deallocate)kyuubiTreeNode;
                String statementId = deallocate.statementId();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("DEALLOCATE PREPARE ").append(statementId).toString());
                Query query = new Query(new QueryId(new OperationHandle(UUID.randomUUID())), trinoContext, this.fe().be());
                QueryResults qr = query.getPrepareQueryResults(query.getLastToken(), uriInfo, query.getPrepareQueryResults$default$3());
                response = TrinoContext$.MODULE$.buildTrinoResponse(qr, query.context());
            } else {
                Query query = Query$.MODULE$.apply(statement, trinoContext, this.translator(), this.fe().be(), Query$.MODULE$.apply$default$5());
                QueryResults qr = query.getQueryResults(query.getLastToken(), uriInfo, query.getQueryResults$default$3());
                response = TrinoContext$.MODULE$.buildTrinoResponse(qr, query.context());
            }
        }
        catch (Exception e) {
            String errorMsg = "Error submitting sql";
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
            throw this.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.BAD_REQUEST, new StringBuilder(1).append(errorMsg).append("\n").append(e.getMessage()).toString());
        }
        return response;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get queued statement status")
    @GET
    @Path(value="/queued/{queryId}/{slug}/{token}")
    public Response getQueuedStatementStatus(@PathParam(value="queryId") String queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token, @QueryParam(value="maxWait") Duration maxWait, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Option remoteAddr = Option$.MODULE$.apply((Object)this.httpRequest().getRemoteAddr());
        TrinoContext trinoContext = TrinoContext$.MODULE$.apply(headers, (Option<String>)remoteAddr);
        long waitTime = maxWait == null ? 0L : maxWait.toMillis();
        return (Response)this.getQuery(this.fe().be(), trinoContext, QueryId$.MODULE$.apply(queryId), slug, token, Slug$Context$.MODULE$.QUEUED_QUERY()).flatMap((Function1 & Serializable & scala.Serializable)query -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TrinoContext$.MODULE$.buildTrinoResponse(query.getQueryResults(token, uriInfo, waitTime), query.context()))).recover((PartialFunction)new scala.Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatementResource $outer;
            private final String queryId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(29).append("Error executing for query id ").append(this.queryId$1).toString();
                    this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw this.$outer.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.NOT_FOUND, "Query not found");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryId$1 = queryId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String )}, serializedLambda);
            }
        }).get();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get executing statement status")
    @GET
    @Path(value="/executing/{queryId}/{slug}/{token}")
    public Response getExecutingStatementStatus(@PathParam(value="queryId") String queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token, @QueryParam(value="maxWait") Duration maxWait, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Option remoteAddr = Option$.MODULE$.apply((Object)this.httpRequest().getRemoteAddr());
        TrinoContext trinoContext = TrinoContext$.MODULE$.apply(headers, (Option<String>)remoteAddr);
        long waitTime = maxWait == null ? 0L : maxWait.toMillis();
        return (Response)this.getQuery(this.fe().be(), trinoContext, QueryId$.MODULE$.apply(queryId), slug, token, Slug$Context$.MODULE$.EXECUTING_QUERY()).flatMap((Function1 & Serializable & scala.Serializable)query -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TrinoContext$.MODULE$.buildTrinoResponse(query.getQueryResults(token, uriInfo, waitTime), query.context()))).recover((PartialFunction)new scala.Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatementResource $outer;
            private final String queryId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(29).append("Error executing for query id ").append(this.queryId$2).toString();
                    this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw this.$outer.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.NOT_FOUND, "Query not found");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryId$2 = queryId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(java.lang.String )}, serializedLambda);
            }
        }).get();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Cancel queued statement")
    @DELETE
    @Path(value="/queued/{queryId}/{slug}/{token}")
    public Response cancelQueuedStatement(@PathParam(value="queryId") String queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token, @Context HttpHeaders headers) {
        Option remoteAddr = Option$.MODULE$.apply((Object)this.httpRequest().getRemoteAddr());
        TrinoContext trinoContext = TrinoContext$.MODULE$.apply(headers, (Option<String>)remoteAddr);
        this.getQuery(this.fe().be(), trinoContext, QueryId$.MODULE$.apply(queryId), slug, token, Slug$Context$.MODULE$.QUEUED_QUERY()).flatMap((Function1 & Serializable & scala.Serializable)query -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.cancel())).recover((PartialFunction)new scala.Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatementResource $outer;
            private final String queryId$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(29).append("Error executing for query id ").append(this.queryId$3).toString();
                    this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw this.$outer.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.NOT_FOUND, "Query not found");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryId$3 = queryId$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(java.lang.String )}, serializedLambda);
            }
        }).get();
        return Response.noContent().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Cancel executing statement")
    @DELETE
    @Path(value="/executing/{queryId}/{slug}/{token}")
    public Response cancelExecutingStatementStatus(@PathParam(value="queryId") String queryId, @PathParam(value="slug") String slug, @PathParam(value="token") long token, @Context HttpHeaders headers) {
        Option remoteAddr = Option$.MODULE$.apply((Object)this.httpRequest().getRemoteAddr());
        TrinoContext trinoContext = TrinoContext$.MODULE$.apply(headers, (Option<String>)remoteAddr);
        this.getQuery(this.fe().be(), trinoContext, QueryId$.MODULE$.apply(queryId), slug, token, Slug$Context$.MODULE$.EXECUTING_QUERY()).flatMap((Function1 & Serializable & scala.Serializable)query -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.cancel())).recover((PartialFunction)new scala.Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatementResource $outer;
            private final String queryId$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(29).append("Error executing for query id ").append(this.queryId$4).toString();
                    this.$outer.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw this.$outer.org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status.NOT_FOUND, "Query not found");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queryId$4 = queryId$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(java.lang.String )}, serializedLambda);
            }
        }).get();
        return Response.noContent().build();
    }

    private Try<Query> getQuery(BackendService be, TrinoContext context, QueryId queryId, String slug, long token, Enumeration.Value slugContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> be.sessionManager().operationManager().getOperation(queryId.operationHandle())).map((Function1 & Serializable & scala.Serializable)op -> {
            Map sessionWithId;
            Map x$1 = sessionWithId = context.session().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Query$.MODULE$.KYUUBI_SESSION_ID()), (Object)op.getSession().handle().identifier().toString())})));
            String x$2 = context.copy$default$1();
            Option<String> x$3 = context.copy$default$2();
            Option<String> x$4 = context.copy$default$3();
            Option<String> x$5 = context.copy$default$4();
            Option<String> x$6 = context.copy$default$5();
            Option<String> x$7 = context.copy$default$6();
            Option<String> x$8 = context.copy$default$7();
            Option<String> x$9 = context.copy$default$8();
            Option<String> x$10 = context.copy$default$9();
            Option<String> x$11 = context.copy$default$10();
            Set<String> x$12 = context.copy$default$11();
            Map<String, String> x$13 = context.copy$default$13();
            return new Query(queryId, context.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13), be);
        }).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StatementResource.$anonfun$getQuery$3(slugContext, slug, token, x$1)));
    }

    public WebApplicationException org$apache$kyuubi$server$trino$api$v1$StatementResource$$badRequest(Response.Status status, String message) {
        return new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    public static final /* synthetic */ String $anonfun$query$1(HashMap parametersMap$1, List parameters$1, int i) {
        return (String)parametersMap$1.put(Predef$.MODULE$.int2Integer(i + 1), parameters$1.apply(i));
    }

    public static final /* synthetic */ boolean $anonfun$getQuery$3(Enumeration.Value slugContext$1, String slug$1, long token$3, Query x$1) {
        return x$1.getSlug().isValid(slugContext$1, slug$1, token$3);
    }

    public StatementResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

