/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.cli;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kyuubi.jdbc.hive.cli.ColumnBuffer;
import org.apache.kyuubi.jdbc.hive.cli.RowSet;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shaded.thrift.TException;
import org.apache.kyuubi.shaded.thrift.protocol.TCompactProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocol;
import org.apache.kyuubi.shaded.thrift.transport.TIOStreamTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnBasedSet
implements RowSet {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnBasedSet.class);
    private long startOffset;
    private final List<ColumnBuffer> columns;

    public ColumnBasedSet(TRowSet tRowSet) throws TException {
        this.columns = new ArrayList<ColumnBuffer>();
        if (tRowSet.isSetBinaryColumns()) {
            TCompactProtocol protocol = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)new ByteArrayInputStream(tRowSet.getBinaryColumns())));
            for (int i = 0; i < tRowSet.getColumnCount(); ++i) {
                TColumn tvalue = new TColumn();
                try {
                    tvalue.read((TProtocol)protocol);
                }
                catch (TException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new TException("Error reading column value from the row set blob", (Throwable)e);
                }
                this.columns.add(new ColumnBuffer(tvalue));
            }
        } else if (tRowSet.getColumns() != null) {
            for (TColumn tvalue : tRowSet.getColumns()) {
                this.columns.add(new ColumnBuffer(tvalue));
            }
        }
        this.startOffset = tRowSet.getStartRowOffset();
    }

    private ColumnBasedSet(List<ColumnBuffer> columns, long startOffset) {
        this.columns = columns;
        this.startOffset = startOffset;
    }

    @Override
    public ColumnBasedSet extractSubset(int maxRows) {
        int numRows = Math.min(this.numRows(), maxRows);
        ArrayList<ColumnBuffer> subset = new ArrayList<ColumnBuffer>();
        for (ColumnBuffer column : this.columns) {
            subset.add(column.extractSubset(numRows));
        }
        ColumnBasedSet result = new ColumnBasedSet(subset, this.startOffset);
        this.startOffset += (long)numRows;
        return result;
    }

    @Override
    public int numColumns() {
        return this.columns.size();
    }

    @Override
    public int numRows() {
        return this.columns.isEmpty() ? 0 : this.columns.get(0).size();
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new Iterator<Object[]>(){
            private int index;
            private final Object[] convey;
            {
                this.convey = new Object[ColumnBasedSet.this.numColumns()];
            }

            @Override
            public boolean hasNext() {
                return this.index < ColumnBasedSet.this.numRows();
            }

            @Override
            public Object[] next() {
                for (int i = 0; i < ColumnBasedSet.this.columns.size(); ++i) {
                    this.convey[i] = ((ColumnBuffer)ColumnBasedSet.this.columns.get(i)).get(this.index);
                }
                ++this.index;
                return this.convey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

