/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.support;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kyuubi.shade.com.google.protobuf.ByteString;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.DeleteRangeRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.PutRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.RangeRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.DeleteOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.GetOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.OptionsUtil;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.PutOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Util;

public final class Requests {
    private Requests() {
    }

    public static RangeRequest mapRangeRequest(ByteSequence key, GetOption option, ByteSequence namespace) {
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(Util.prefixNamespace(key, namespace)).setCountOnly(option.isCountOnly()).setLimit(option.getLimit()).setRevision(option.getRevision()).setKeysOnly(option.isKeysOnly()).setSerializable(option.isSerializable()).setSortOrder(OptionsUtil.toRangeRequestSortOrder(option.getSortOrder())).setSortTarget(OptionsUtil.toRangeRequestSortTarget(option.getSortField())).setMinCreateRevision(option.getMinCreateRevision()).setMaxCreateRevision(option.getMaxCreateRevision()).setMinModRevision(option.getMinModRevision()).setMaxModRevision(option.getMaxModRevision());
        Requests.defineRangeRequestEnd(key, option.getEndKey(), option.isPrefix(), namespace, builder::setRangeEnd);
        return builder.build();
    }

    public static PutRequest mapPutRequest(ByteSequence key, ByteSequence value, PutOption option, ByteSequence namespace) {
        return PutRequest.newBuilder().setKey(Util.prefixNamespace(key, namespace)).setValue(ByteString.copyFrom(value.getBytes())).setLease(option.getLeaseId()).setPrevKv(option.getPrevKV()).build();
    }

    public static DeleteRangeRequest mapDeleteRequest(ByteSequence key, DeleteOption option, ByteSequence namespace) {
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(Util.prefixNamespace(key, namespace)).setPrevKv(option.isPrevKV());
        Requests.defineRangeRequestEnd(key, option.getEndKey(), option.isPrefix(), namespace, builder::setRangeEnd);
        return builder.build();
    }

    private static void defineRangeRequestEnd(ByteSequence key, Optional<ByteSequence> endKeyOptional, boolean hasPrefix, ByteSequence namespace, Consumer<ByteString> setRangeEndConsumer) {
        if (endKeyOptional.isPresent()) {
            setRangeEndConsumer.accept(Util.prefixNamespaceToRangeEnd(ByteString.copyFrom(endKeyOptional.get().getBytes()), namespace));
        } else if (hasPrefix) {
            ByteSequence endKey = OptionsUtil.prefixEndOf(key);
            setRangeEndConsumer.accept(Util.prefixNamespaceToRangeEnd(ByteString.copyFrom(endKey.getBytes()), namespace));
        }
    }
}

