/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http.impl;

import java.util.function.Function;
import org.apache.kyuubi.shade.io.netty.buffer.ByteBuf;
import org.apache.kyuubi.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.kyuubi.shade.io.netty.handler.codec.compression.CompressionOptions;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Exception;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Flags;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2FrameLogger;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Headers;
import org.apache.kyuubi.shade.io.netty.handler.logging.LogLevel;
import org.apache.kyuubi.shade.io.vertx.core.http.Http2Settings;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.Http2ConnectionBase;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.HttpUtils;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;

class VertxHttp2ConnectionHandlerBuilder<C extends Http2ConnectionBase>
extends AbstractHttp2ConnectionHandlerBuilder<VertxHttp2ConnectionHandler<C>, VertxHttp2ConnectionHandlerBuilder<C>> {
    private boolean useDecompression;
    private CompressionOptions[] compressionOptions;
    private Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory;
    private boolean logEnabled;

    VertxHttp2ConnectionHandlerBuilder() {
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> server(boolean isServer) {
        return (VertxHttp2ConnectionHandlerBuilder)super.server(isServer);
    }

    VertxHttp2ConnectionHandlerBuilder<C> initialSettings(Http2Settings settings) {
        HttpUtils.fromVertxInitialSettings(this.isServer(), settings, this.initialSettings());
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> useCompression(CompressionOptions[] compressionOptions) {
        this.compressionOptions = compressionOptions;
        return this;
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> decoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        return (VertxHttp2ConnectionHandlerBuilder)super.decoderEnforceMaxRstFramesPerWindow(maxRstFramesPerWindow, secondsPerWindow);
    }

    @Override
    protected VertxHttp2ConnectionHandlerBuilder<C> gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        return (VertxHttp2ConnectionHandlerBuilder)super.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
    }

    VertxHttp2ConnectionHandlerBuilder<C> useDecompression(boolean useDecompression) {
        this.useDecompression = useDecompression;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> connectionFactory(Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    VertxHttp2ConnectionHandlerBuilder<C> logEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    @Override
    protected VertxHttp2ConnectionHandler<C> build() {
        if (this.logEnabled) {
            this.frameLogger(new Http2FrameLogger(LogLevel.DEBUG));
        }
        this.frameListener(new Http2FrameListener(){

            @Override
            public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onSettingsRead(ChannelHandlerContext ctx, org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Settings settings) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPingRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPingAckRead(ChannelHandlerContext channelHandlerContext, long l) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
                throw new UnsupportedOperationException();
            }
        });
        return (VertxHttp2ConnectionHandler)super.build();
    }

    @Override
    protected VertxHttp2ConnectionHandler<C> build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Settings initialSettings) throws Exception {
        if (this.isServer()) {
            if (this.compressionOptions != null) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, this.compressionOptions);
            }
            VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
            decoder.frameListener(handler);
            return handler;
        }
        VertxHttp2ConnectionHandler<C> handler = new VertxHttp2ConnectionHandler<C>(this.connectionFactory, this.useDecompression, decoder, encoder, initialSettings);
        decoder.frameListener(handler);
        return handler;
    }
}

