/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public final class JdbcUtils$
implements Logging {
    public static JdbcUtils$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new JdbcUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public void close(AutoCloseable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Error on closing", t);
                }
                throw throwable;
            }
            return;
        }
    }

    public <R, C extends AutoCloseable> R withCloseable(C c, Function1<C, R> block) {
        R r;
        try {
            r = block.apply(c);
        }
        finally {
            this.close(c);
        }
        return r;
    }

    public <R> R withConnection(Function1<Connection, R> block, DataSource ds) {
        return this.withCloseable(ds.getConnection(), block);
    }

    public boolean execute(String sqlTemplate, Function1<PreparedStatement, BoxedUnit> setParameters, DataSource ds) {
        return BoxesRunTime.unboxToBoolean(this.withConnection((Function1<Connection, Object> & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean(JdbcUtils$.$anonfun$execute$1(sqlTemplate, setParameters, conn)), ds));
    }

    public Function1<PreparedStatement, BoxedUnit> execute$default$2(String sqlTemplate) {
        return (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)x$1 -> {
            JdbcUtils$.$anonfun$execute$default$2$1(x$1);
            return BoxedUnit.UNIT;
        };
    }

    public int executeUpdate(String sqlTemplate, Function1<PreparedStatement, BoxedUnit> setParameters, DataSource ds) {
        return BoxesRunTime.unboxToInt(this.withConnection((Function1<Connection, Object> & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToInteger(JdbcUtils$.$anonfun$executeUpdate$1(sqlTemplate, setParameters, conn)), ds));
    }

    public Function1<PreparedStatement, BoxedUnit> executeUpdate$default$2(String sqlTemplate) {
        return (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)x$2 -> {
            JdbcUtils$.$anonfun$executeUpdate$default$2$1(x$2);
            return BoxedUnit.UNIT;
        };
    }

    public <R> R executeQuery(String sqlTemplate, Function1<PreparedStatement, BoxedUnit> setParameters, Function1<ResultSet, R> processResultSet, DataSource ds) {
        return this.withConnection((Function1<Connection, Object> & Serializable & scala.Serializable)conn -> MODULE$.withCloseable(conn.prepareStatement(sqlTemplate), (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)pStmt -> {
            setParameters.apply((PreparedStatement)pStmt);
            return MODULE$.withCloseable(pStmt.executeQuery(), (Function1<ResultSet, Object> & Serializable & scala.Serializable)rs -> processResultSet.apply((ResultSet)rs));
        }), ds);
    }

    public <R> Function1<PreparedStatement, BoxedUnit> executeQuery$default$2(String sqlTemplate) {
        return (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)x$3 -> {
            JdbcUtils$.$anonfun$executeQuery$default$2$1(x$3);
            return BoxedUnit.UNIT;
        };
    }

    public <R> Seq<R> executeQueryWithRowMapper(String sqlTemplate, Function1<PreparedStatement, BoxedUnit> setParameters, Function1<ResultSet, R> rowMapper, DataSource ds) {
        return (Seq)this.withConnection((Function1<Connection, Seq> & Serializable & scala.Serializable)conn -> (Seq)MODULE$.withCloseable(conn.prepareStatement(sqlTemplate), (Function1<PreparedStatement, Seq> & Serializable & scala.Serializable)pStmt -> {
            setParameters.apply((PreparedStatement)pStmt);
            return (Seq)MODULE$.withCloseable(pStmt.executeQuery(), (Function1<ResultSet, Seq> & Serializable & scala.Serializable)rs -> {
                Builder builder = Seq$.MODULE$.newBuilder();
                while (rs.next()) {
                    builder.$plus$eq(rowMapper.apply((ResultSet)rs));
                }
                return builder.result();
            });
        }), ds);
    }

    public <R> Function1<PreparedStatement, BoxedUnit> executeQueryWithRowMapper$default$2(String sqlTemplate) {
        return (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)x$4 -> {
            JdbcUtils$.$anonfun$executeQueryWithRowMapper$default$2$1(x$4);
            return BoxedUnit.UNIT;
        };
    }

    public <R> Seq<R> mapResultSet(ResultSet rs, Function1<ResultSet, R> rowMapper) {
        Builder builder = Seq$.MODULE$.newBuilder();
        while (rs.next()) {
            builder.$plus$eq(rowMapper.apply(rs));
        }
        return builder.result();
    }

    public String redactPassword(Option<String> password) {
        Some some;
        String s;
        Option<String> option = password;
        if (option instanceof Some && StringUtils.isNotBlank((CharSequence)(s = (String)(some = (Some)option).value()))) {
            return new StringBuilder(9).append(new StringOps(Predef$.MODULE$.augmentString("*")).$times(s.length())).append("(length:").append(s.length()).append(")").toString();
        }
        return "(empty)";
    }

    public boolean isDuplicatedKeyDBErr(Throwable cause) {
        Seq duplicatedKeyKeywords = new $colon$colon<Nothing$>((Nothing$)((Object)"Duplicate entry"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"duplicate key value violates unique constraint"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"A UNIQUE constraint failed"), Nil$.MODULE$)));
        String string = cause.getMessage();
        return duplicatedKeyKeywords.exists((Function1<CharSequence, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(string.contains(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(Function1 setParameters$1, PreparedStatement pStmt) {
        setParameters$1.apply(pStmt);
        return pStmt.execute();
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(String sqlTemplate$1, Function1 setParameters$1, Connection conn) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withCloseable(conn.prepareStatement(sqlTemplate$1), (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)pStmt -> BoxesRunTime.boxToBoolean(JdbcUtils$.$anonfun$execute$2(setParameters$1, pStmt))));
    }

    public static final /* synthetic */ void $anonfun$execute$default$2$1(PreparedStatement x$1) {
    }

    public static final /* synthetic */ int $anonfun$executeUpdate$2(Function1 setParameters$2, PreparedStatement pStmt) {
        setParameters$2.apply(pStmt);
        return pStmt.executeUpdate();
    }

    public static final /* synthetic */ int $anonfun$executeUpdate$1(String sqlTemplate$2, Function1 setParameters$2, Connection conn) {
        return BoxesRunTime.unboxToInt(MODULE$.withCloseable(conn.prepareStatement(sqlTemplate$2), (Function1<PreparedStatement, Object> & Serializable & scala.Serializable)pStmt -> BoxesRunTime.boxToInteger(JdbcUtils$.$anonfun$executeUpdate$2(setParameters$2, pStmt))));
    }

    public static final /* synthetic */ void $anonfun$executeUpdate$default$2$1(PreparedStatement x$2) {
    }

    public static final /* synthetic */ void $anonfun$executeQuery$default$2$1(PreparedStatement x$3) {
    }

    public static final /* synthetic */ void $anonfun$executeQueryWithRowMapper$default$2$1(PreparedStatement x$4) {
    }

    private JdbcUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

