/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.internal;

import org.apache.kyuubi.shade.dev.failsafe.RetryPolicy;
import org.apache.kyuubi.shade.dev.failsafe.RetryPolicyConfig;
import org.apache.kyuubi.shade.dev.failsafe.function.CheckedBiPredicate;
import org.apache.kyuubi.shade.dev.failsafe.internal.RetryPolicyExecutor;
import org.apache.kyuubi.shade.dev.failsafe.spi.DelayablePolicy;
import org.apache.kyuubi.shade.dev.failsafe.spi.FailurePolicy;
import org.apache.kyuubi.shade.dev.failsafe.spi.PolicyExecutor;

public class RetryPolicyImpl<R>
implements RetryPolicy<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final RetryPolicyConfig<R> config;

    public RetryPolicyImpl(RetryPolicyConfig<R> config) {
        this.config = config;
    }

    @Override
    public RetryPolicyConfig<R> getConfig() {
        return this.config;
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (CheckedBiPredicate<R, Throwable> predicate : this.config.getAbortConditions()) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RetryPolicyExecutor(this, policyIndex);
    }
}

