/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lease;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.LeaseGrantRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.LeaseKeepAliveRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.LeaseKeepAliveResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.LeaseRevokeRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.LeaseTimeToLiveRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.VertxLeaseGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.Service;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.exception.ClosedClientException;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.exception.ErrorCode;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.ClientConnectionManager;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.Impl;
import org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseGrantResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseRevokeResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.LeaseOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.CloseableClient;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Util;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.vertx.core.streams.WriteStream;

final class LeaseImpl
extends Impl
implements Lease {
    private static final int DEFAULT_FIRST_KEEPALIVE_TIMEOUT_MS = 5000;
    private final VertxLeaseGrpc.LeaseVertxStub stub = this.connectionManager().newStub(VertxLeaseGrpc::newVertxStub);
    private final VertxLeaseGrpc.LeaseVertxStub leaseStub = Util.applyRequireLeader(true, this.connectionManager().newStub(VertxLeaseGrpc::newVertxStub));
    private final Map<Long, KeepAliveObserver> keepAlives = new ConcurrentHashMap<Long, KeepAliveObserver>();
    private final KeepAlive keepAlive = new KeepAlive();
    private final DeadLine deadLine = new DeadLine();
    private volatile boolean closed;

    LeaseImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public CompletableFuture<LeaseGrantResponse> grant(long ttl) {
        return this.execute(() -> this.stub.leaseGrant(LeaseGrantRequest.newBuilder().setTTL(ttl).build()), LeaseGrantResponse::new);
    }

    @Override
    public CompletableFuture<LeaseGrantResponse> grant(long ttl, long timeout, TimeUnit unit) {
        return this.execute(() -> ((VertxLeaseGrpc.LeaseVertxStub)this.stub.withDeadlineAfter(timeout, unit)).leaseGrant(LeaseGrantRequest.newBuilder().setTTL(ttl).build()), LeaseGrantResponse::new);
    }

    @Override
    public CompletableFuture<LeaseRevokeResponse> revoke(long leaseId) {
        return this.execute(() -> this.stub.leaseRevoke(LeaseRevokeRequest.newBuilder().setID(leaseId).build()), LeaseRevokeResponse::new);
    }

    @Override
    public CompletableFuture<LeaseTimeToLiveResponse> timeToLive(long leaseId, LeaseOption option) {
        Objects.requireNonNull(option, "LeaseOption should not be null");
        LeaseTimeToLiveRequest leaseTimeToLiveRequest = LeaseTimeToLiveRequest.newBuilder().setID(leaseId).setKeys(option.isAttachedKeys()).build();
        return this.execute(() -> this.stub.leaseTimeToLive(leaseTimeToLiveRequest), LeaseTimeToLiveResponse::new);
    }

    @Override
    public synchronized CloseableClient keepAlive(long leaseId, final StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer) {
        if (this.closed) {
            throw EtcdExceptionFactory.newClosedLeaseClientException();
        }
        final KeepAliveObserver keepAlive = this.keepAlives.computeIfAbsent(leaseId, x$0 -> new KeepAliveObserver((long)x$0));
        keepAlive.addObserver(observer);
        this.keepAlive.start();
        this.deadLine.start();
        return new CloseableClient(){

            @Override
            public void close() {
                keepAlive.removeObserver(observer);
            }
        };
    }

    @Override
    public CompletableFuture<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> keepAliveOnce(long leaseId) {
        AtomicReference ref = new AtomicReference();
        CompletableFuture future = new CompletableFuture();
        LeaseKeepAliveRequest req = LeaseKeepAliveRequest.newBuilder().setID(leaseId).build();
        this.leaseStub.leaseKeepAlive(s -> {
            ref.set(s);
            s.write(req);
        }).handler(r -> {
            if (r.getTTL() != 0L) {
                future.complete(new org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse((LeaseKeepAliveResponse)r));
            } else {
                future.completeExceptionally(EtcdExceptionFactory.newEtcdException(ErrorCode.NOT_FOUND, "etcdserver: requested lease not found"));
            }
        }).exceptionHandler(future::completeExceptionally);
        return future.whenComplete((r, t) -> ((WriteStream)ref.get()).end(req));
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.keepAlive.close();
        this.deadLine.close();
        ClosedClientException errResp = EtcdExceptionFactory.newClosedLeaseClientException();
        this.keepAlives.values().forEach(v -> v.onError(errResp));
        this.keepAlives.clear();
    }

    private final class KeepAlive
    extends Service {
        private volatile Long task;
        private volatile Long restart;
        private volatile WriteStream<LeaseKeepAliveRequest> requestStream;

        @Override
        public void doStart() {
            LeaseImpl.this.leaseStub.leaseKeepAlive(this::writeHandler).handler(this::handleResponse).exceptionHandler(this::handleException);
        }

        @Override
        public void doStop() {
            if (this.requestStream != null) {
                this.requestStream.end();
            }
            if (this.restart != null) {
                LeaseImpl.this.connectionManager().vertx().cancelTimer(this.restart);
            }
            if (this.task != null) {
                LeaseImpl.this.connectionManager().vertx().cancelTimer(this.task);
            }
        }

        @Override
        public void close() {
            super.close();
            this.task = null;
            this.restart = null;
        }

        private void writeHandler(WriteStream<LeaseKeepAliveRequest> stream) {
            this.requestStream = stream;
            this.task = LeaseImpl.this.connectionManager().vertx().setPeriodic(0L, 500L, l -> LeaseImpl.this.keepAlives.values().forEach(element -> this.sendKeepAlive((KeepAliveObserver)element, stream)));
        }

        private void sendKeepAlive(KeepAliveObserver observer, WriteStream<LeaseKeepAliveRequest> stream) {
            if (observer.getNextKeepAlive() < System.currentTimeMillis()) {
                stream.write(LeaseKeepAliveRequest.newBuilder().setID(observer.getLeaseId()).build());
            }
        }

        private synchronized void handleResponse(LeaseKeepAliveResponse leaseKeepAliveResponse) {
            if (!this.isRunning()) {
                return;
            }
            long leaseID = leaseKeepAliveResponse.getID();
            long ttl = leaseKeepAliveResponse.getTTL();
            KeepAliveObserver ka = (KeepAliveObserver)LeaseImpl.this.keepAlives.get(leaseID);
            if (ka == null) {
                return;
            }
            if (ttl > 0L) {
                long nextKeepAlive = System.currentTimeMillis() + ttl * 1000L / 3L;
                ka.setNextKeepAlive(nextKeepAlive);
                ka.setDeadLine(System.currentTimeMillis() + ttl * 1000L);
                ka.onNext(leaseKeepAliveResponse);
            } else {
                LeaseImpl.this.keepAlives.remove(leaseID);
                ka.onError(EtcdExceptionFactory.newEtcdException(ErrorCode.NOT_FOUND, "etcdserver: requested lease not found"));
            }
        }

        private synchronized void handleException(Throwable unused) {
            if (!this.isRunning()) {
                return;
            }
            this.restart = LeaseImpl.this.connectionManager().vertx().setTimer(500L, l -> {
                if (this.isRunning()) {
                    this.restart();
                }
            });
        }
    }

    private class DeadLine
    extends Service {
        private volatile Long task;

        @Override
        public void doStart() {
            this.task = LeaseImpl.this.connectionManager().vertx().setPeriodic(0L, 1000L, l -> {
                long now = System.currentTimeMillis();
                LeaseImpl.this.keepAlives.values().removeIf(ka -> {
                    if (ka.getDeadLine() < now) {
                        ka.onCompleted();
                        return true;
                    }
                    return false;
                });
            });
        }

        @Override
        public void doStop() {
            if (this.task != null) {
                LeaseImpl.this.connectionManager().vertx().cancelTimer(this.task);
            }
        }
    }

    private final class KeepAliveObserver
    implements StreamObserver<LeaseKeepAliveResponse> {
        private final List<StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse>> observers;
        private final long leaseId;
        private long deadLine;
        private long nextKeepAlive = System.currentTimeMillis();

        public KeepAliveObserver(long leaseId) {
            this(leaseId, Collections.emptyList());
        }

        public KeepAliveObserver(long leaseId, Collection<StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse>> observers) {
            int initialKeepAliveTimeoutMs = LeaseImpl.this.connectionManager().builder().keepaliveTimeout() != null ? Math.toIntExact(LeaseImpl.this.connectionManager().builder().keepaliveTimeout().toMillis()) : 5000;
            this.deadLine = this.nextKeepAlive + (long)initialKeepAliveTimeoutMs;
            this.observers = new CopyOnWriteArrayList<StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse>>(observers);
            this.leaseId = leaseId;
        }

        public long getLeaseId() {
            return this.leaseId;
        }

        public long getDeadLine() {
            return this.deadLine;
        }

        public void setDeadLine(long deadLine) {
            this.deadLine = deadLine;
        }

        public void addObserver(StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer) {
            this.observers.add(observer);
        }

        public void removeObserver(StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> listener) {
            this.observers.remove(listener);
            if (this.observers.isEmpty()) {
                LeaseImpl.this.keepAlives.remove(this.leaseId);
            }
        }

        public long getNextKeepAlive() {
            return this.nextKeepAlive;
        }

        public void setNextKeepAlive(long nextKeepAlive) {
            this.nextKeepAlive = nextKeepAlive;
        }

        @Override
        public void onNext(LeaseKeepAliveResponse response) {
            for (StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer : this.observers) {
                observer.onNext(new org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse(response));
            }
        }

        @Override
        public void onError(Throwable throwable) {
            for (StreamObserver<org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer : this.observers) {
                observer.onError(EtcdExceptionFactory.toEtcdException(throwable));
            }
        }

        @Override
        public void onCompleted() {
            this.observers.forEach(StreamObserver::onCompleted);
            this.observers.clear();
        }
    }
}

