/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class Warning {
    private final Code warningCode;
    private final String message;

    @JsonCreator
    public Warning(@JsonProperty(value="warningCode") Code warningCode, @JsonProperty(value="message") String message) {
        this.warningCode = Objects.requireNonNull(warningCode, "warningCode is null");
        this.message = Objects.requireNonNull(message, "message is null");
    }

    @JsonProperty
    public Code getWarningCode() {
        return this.warningCode;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Warning that = (Warning)obj;
        return Objects.equals(this.warningCode, that.warningCode) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.warningCode, this.message);
    }

    public String toString() {
        return this.warningCode + ", " + this.message;
    }

    public static final class Code {
        private final int code;
        private final String name;

        @JsonCreator
        public Code(@JsonProperty(value="code") int code, @JsonProperty(value="name") String name) {
            this.code = code;
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @JsonProperty
        public int getCode() {
            return this.code;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Code other = (Code)obj;
            return this.code == other.code && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.name);
        }

        public String toString() {
            return this.name + ":" + this.code;
        }
    }
}

