/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class PluginClassLoaderFactory {
    private final ClassLoader pluginClassLoader = PluginClassLoaderFactory.create(new File(SettingsManager.getInstance().getSettingsDirectory() + File.separator + "plugins"));
    private static final PluginClassLoaderFactory instance = new PluginClassLoaderFactory();

    private PluginClassLoaderFactory() {
    }

    public static PluginClassLoaderFactory getInstance() {
        return instance;
    }

    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    private static final ClassLoader create(File pluginDirectory) {
        if (pluginDirectory == null || !pluginDirectory.exists() || !pluginDirectory.canRead()) {
            return PluginClassLoaderFactory.class.getClassLoader();
        }
        String[] strings = pluginDirectory.list((dir, name) -> name.toUpperCase().endsWith(".JAR"));
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            list.add(pluginDirectory.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (strings != null) {
            for (String name2 : strings) {
                File file = new File(pluginDirectory, name2);
                try {
                    list.add(file.toURI().toURL());
                    System.out.println("Added " + file.getAbsolutePath() + " to Plugin class loader list");
                }
                catch (Exception e) {
                    System.err.println("Failed to retrieve the URL for file: " + file.getAbsolutePath());
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        ClassLoader parent = PluginClassLoaderFactory.class.getClassLoader();
        URL[] urls = list.toArray(new URL[list.size()]);
        return new URLClassLoader(urls, parent);
    }
}

