/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;

public class ReflectionRewritePolicy
implements RewritePolicy {
    @Override
    public LoggingEvent rewrite(LoggingEvent source) {
        Object msg = source.getMessage();
        if (!(msg instanceof String)) {
            Object newMsg = msg;
            HashMap<String, Object> rewriteProps = new HashMap<String, Object>(source.getProperties());
            try {
                PropertyDescriptor[] props = Introspector.getBeanInfo(msg.getClass(), Object.class).getPropertyDescriptors();
                if (props.length > 0) {
                    for (PropertyDescriptor prop : props) {
                        try {
                            Object propertyValue = prop.getReadMethod().invoke(msg, (Object[])null);
                            if ("message".equalsIgnoreCase(prop.getName())) {
                                newMsg = propertyValue;
                                continue;
                            }
                            rewriteProps.put(prop.getName(), propertyValue);
                        }
                        catch (Exception e) {
                            LogLog.warn((String)("Unable to evaluate property " + prop.getName()), (Throwable)e);
                        }
                    }
                    return new LoggingEvent(source.getFQNOfLoggerClass(), (Category)(source.getLogger() != null ? source.getLogger() : Logger.getLogger((String)source.getLoggerName())), source.getTimeStamp(), source.getLevel(), newMsg, source.getThreadName(), source.getThrowableInformation(), source.getNDC(), source.getLocationInformation(), rewriteProps);
                }
            }
            catch (Exception e) {
                LogLog.warn((String)"Unable to get property descriptors", (Throwable)e);
            }
        }
        return source;
    }
}

