/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.service;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.catalog.jpa.dao.ConstraintRepository;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.apache.logging.log4j.catalog.jpa.service.ConstraintService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Repository
@Transactional
public class ConstraintServiceImpl
implements ConstraintService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Autowired
    private ConstraintRepository constraintRepository;

    @Override
    public Set<String> getConstraintTypes() {
        return ConstraintPlugins.getInstance().getConstraintMap().keySet();
    }

    @Override
    public List<ConstraintModel> getConstraints() {
        return this.constraintRepository.findAll();
    }

    @Override
    public Optional<ConstraintModel> getConstraint(Long constraintId) {
        return this.constraintRepository.findOne(constraintId);
    }

    @Override
    public ConstraintModel saveConstraint(ConstraintModel constraint) {
        return this.constraintRepository.save(constraint);
    }

    @Override
    public void deleteConstraint(Long constraintId) {
        this.constraintRepository.deleteById(constraintId);
    }
}

